/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.templates;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.core.common.ICOBOLTemplateSupport;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.templates.COBOLTemplate;
import org.eclipse.cobol.ui.templates.COBOLTemplateException;
import org.eclipse.cobol.ui.templates.Category;
import org.eclipse.cobol.ui.templates.OSTemplateSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class COBOLTemplateManager
implements IPropertyChangeListener {
    public static final String TEMPLATE_FILE = "templates.xml";
    private static final String ROOT_TAG = "syntaxtemplate";
    private static final String CATEGORY_TAG = "category";
    private static final String TEMPLATE_TAG = "template";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String KEYWORD_ATTRIBUTE = "keyword";
    private static final String EXPANDED_ATTRIBUTE = "expanded";
    private static final String TEXT_TAG = "#text";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static COBOLTemplateManager fTemplateManager = null;
    private ArrayList<Template> fAllTemplates = null;
    private ArrayList<Template> fSpecificTemplates = null;
    private ArrayList fVenoderTemplateList = new ArrayList(10);
    private String currentDivisionInRecursive = "";
    private boolean startAdd = false;
    private static final String REFERENCE = "Reference";

    private COBOLTemplateManager() {
    }

    public static COBOLTemplateManager getInstance() {
        try {
            if (fTemplateManager == null) {
                fTemplateManager = new COBOLTemplateManager();
                fTemplateManager.create();
                CorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)fTemplateManager);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return fTemplateManager;
    }

    public void create() {
        CBDTUiPlugin.logTraceMessage("starting create template manager");
        try {
            ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            OSTemplateSupport oSTemplateSupport = new OSTemplateSupport();
            if (iCOBOLContributor != null) {
                CBDTUiPlugin.logTraceMessage("default contributor is not null");
                ICOBOLTemplateSupport iCOBOLTemplateSupport = iCOBOLContributor.getCOBOLTemplateSupport();
                if (iCOBOLTemplateSupport != null && this.getVendorTemplateList(iCOBOLContributor) == null) {
                    inputStream2 = iCOBOLTemplateSupport.getTemplateInputStream();
                    fTemplateManager.addFromStream(inputStream2);
                }
            } else {
                inputStream = oSTemplateSupport.getTemplateInputStream();
                fTemplateManager.addFromStream(inputStream);
            }
            if (iCOBOLContributor != null) {
                fTemplateManager.save();
            } else {
                fTemplateManager.saveToFile(oSTemplateSupport.getTemplateOutputStream());
            }
        }
        catch (COBOLTemplateException cOBOLTemplateException) {
            CBDTUiPlugin.logError(cOBOLTemplateException);
            MessageDialog.openError(null, (String)Messages.getString((String)"COBOLTemplateManager.error.title"), (String)cOBOLTemplateException.getMessage());
            fTemplateManager.clear(Category.getRootCategoryInstance());
        }
    }

    public void addFromStream(InputStream inputStream) throws COBOLTemplateException {
        try {
            try {
                Object object;
                Object object2;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(inputStream));
                Category category = Category.getRootCategoryInstance();
                Node node = document.getElementsByTagName(ROOT_TAG).item(0);
                NamedNodeMap namedNodeMap = node.getAttributes();
                try {
                    if (namedNodeMap != null && (object2 = namedNodeMap.getNamedItem(EXPANDED_ATTRIBUTE)) != null && (object = object2.getNodeValue()) != null) {
                        object = ((String)object).trim();
                        category.setExpandedState(((String)object).equalsIgnoreCase(TRUE));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
                object2 = document.getElementsByTagName(ROOT_TAG).item(0).getChildNodes();
                object = new Stack();
                ((Stack)object).push(category);
                ((Stack)object).push(object2);
                this.populateTreeModel((Stack)object);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new COBOLTemplateException(parserConfigurationException.getMessage());
            }
            catch (IOException iOException) {
                throw new COBOLTemplateException(iOException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new COBOLTemplateException(sAXException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new COBOLTemplateException(Messages.getString((String)"COBOLTemplateManager.error.message1"));
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
        }
    }

    public void saveToFile(OutputStream outputStream) throws COBOLTemplateException {
        try {
            try {
                this.saveToStream(outputStream);
            }
            catch (Exception exception) {
                throw new COBOLTemplateException(exception.getMessage());
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
        }
    }

    public void saveToFile(File file) throws COBOLTemplateException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                this.saveToStream(fileOutputStream);
            }
            catch (Exception exception) {
                throw new COBOLTemplateException(exception.getMessage());
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
        }
    }

    public void saveToStream(OutputStream outputStream) throws COBOLTemplateException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(ROOT_TAG);
            document.appendChild(element);
            NamedNodeMap namedNodeMap = element.getAttributes();
            Attr attr = document.createAttribute(EXPANDED_ATTRIBUTE);
            if (Category.getRootCategoryInstance().isExpandedState()) {
                attr.setValue(TRUE);
            } else {
                attr.setValue(FALSE);
            }
            namedNodeMap.setNamedItem(attr);
            Category category = Category.getRootCategoryInstance();
            Stack<Object> stack = new Stack<Object>();
            stack.push(category);
            stack.push(element);
            this.populateXML(stack, document);
            try {
                StreamResult streamResult = new StreamResult(outputStream);
                DOMSource dOMSource = new DOMSource(document);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw (IOException)new IOException().initCause(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                throw (IOException)new IOException().initCause(transformerException);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new COBOLTemplateException(parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new COBOLTemplateException(iOException.getMessage());
        }
    }

    public void save() throws COBOLTemplateException {
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor != null) {
            ICOBOLTemplateSupport iCOBOLTemplateSupport = iCOBOLContributor.getCOBOLTemplateSupport();
            if (iCOBOLTemplateSupport != null) {
                this.saveToFile(iCOBOLTemplateSupport.getTemplateOutputStream());
            }
        } else {
            OSTemplateSupport oSTemplateSupport = new OSTemplateSupport();
            this.saveToFile(oSTemplateSupport.getTemplateOutputStream());
        }
    }

    private Category getExistingCategory(String string, Category category) {
        Category[] categoryArray = category.getCategoryChildren();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase(categoryArray[n2].getName())) {
                return categoryArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private void populateTreeModel(Stack stack) throws COBOLTemplateException {
        String string = "";
        String string2 = "";
        Category category = null;
        NodeList nodeList = null;
        while (!stack.empty()) {
            nodeList = (NodeList)stack.pop();
            category = (Category)stack.pop();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 != n) {
                NamedNodeMap namedNodeMap;
                Node node = nodeList.item(n2);
                if (!node.getNodeName().equals(TEXT_TAG) && (namedNodeMap = node.getAttributes()) != null) {
                    Object object;
                    string = namedNodeMap.getNamedItem(NAME_ATTRIBUTE).getNodeValue();
                    string2 = namedNodeMap.getNamedItem(DESCRIPTION_ATTRIBUTE).getNodeValue();
                    if (node.getNodeName().equals(CATEGORY_TAG)) {
                        object = null;
                        object = this.getExistingCategory(string, category);
                        if (object == null) {
                            object = new Category(string, string2, category);
                            category.addCategoryChild((Category)object);
                        } else {
                            ((Category)object).setDescription(string2);
                        }
                        try {
                            String string3 = namedNodeMap.getNamedItem(EXPANDED_ATTRIBUTE).getNodeValue();
                            if (string3 != null) {
                                string3 = string3.trim();
                                ((Category)object).setExpandedState(string3.equalsIgnoreCase(TRUE));
                            }
                        }
                        catch (NullPointerException nullPointerException) {}
                        stack.push(object);
                        stack.push(node.getChildNodes());
                    } else if (node.getNodeName().equals(TEMPLATE_TAG)) {
                        object = null;
                        String string4 = namedNodeMap.getNamedItem(KEYWORD_ATTRIBUTE).getNodeValue();
                        NodeList nodeList2 = node.getChildNodes();
                        String string5 = "";
                        if (nodeList2.getLength() != 0) {
                            string5 = nodeList2.item(0).getNodeValue();
                        }
                        object = new COBOLTemplate(string, string2, string4, string5, category);
                        category.addTemplateChild((COBOLTemplate)object);
                    }
                }
                ++n2;
            }
        }
        this.addToVendorList(Category.getRootCategoryInstance().getCategoryChildren(), Category.getRootCategoryInstance().getTemplateChildren());
    }

    private void populateXML(Stack stack, Document document) throws COBOLTemplateException {
        Node node = null;
        Category category = null;
        while (!stack.empty()) {
            node = (Node)stack.pop();
            category = (Category)stack.pop();
            Category[] categoryArray = category.getCategoryChildren();
            COBOLTemplate[] cOBOLTemplateArray = category.getTemplateChildren();
            int n = 0;
            while (n < categoryArray.length) {
                Node node2 = this.createCategoryNode(categoryArray[n], node, document);
                stack.push(categoryArray[n]);
                stack.push(node2);
                ++n;
            }
            n = 0;
            while (n < cOBOLTemplateArray.length) {
                this.createTemplateNode(cOBOLTemplateArray[n], node, document);
                ++n;
            }
        }
    }

    public void exportTemplates(File file, Category[] categoryArray, COBOLTemplate[] cOBOLTemplateArray) throws COBOLTemplateException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                Object object;
                int n;
                fileOutputStream = new FileOutputStream(file);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElement(ROOT_TAG);
                document.appendChild(element);
                Stack<Object> stack = new Stack<Object>();
                if (categoryArray != null) {
                    n = 0;
                    while (n < categoryArray.length) {
                        object = this.createCategoryNode(categoryArray[n], element, document);
                        stack.push(categoryArray[n]);
                        stack.push(object);
                        this.populateXML(stack, document);
                        ++n;
                    }
                }
                if (cOBOLTemplateArray != null && cOBOLTemplateArray.length > 0) {
                    n = 0;
                    while (n < cOBOLTemplateArray.length) {
                        this.createTemplateNode(cOBOLTemplateArray[n], element, document);
                        ++n;
                    }
                }
                try {
                    StreamResult streamResult = new StreamResult(fileOutputStream);
                    object = new DOMSource(document);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.transform((Source)object, streamResult);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw (IOException)new IOException().initCause(transformerConfigurationException);
                }
                catch (TransformerException transformerException) {
                    throw (IOException)new IOException().initCause(transformerException);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new COBOLTemplateException(parserConfigurationException.getMessage());
            }
            catch (IOException iOException) {
                throw new COBOLTemplateException(iOException.getMessage());
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
        }
    }

    private Node createCategoryNode(Category category, Node node, Document document) {
        Element element = document.createElement(CATEGORY_TAG);
        node.appendChild(element);
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = document.createAttribute(NAME_ATTRIBUTE);
        attr.setValue(category.getName());
        namedNodeMap.setNamedItem(attr);
        Attr attr2 = document.createAttribute(DESCRIPTION_ATTRIBUTE);
        attr2.setValue(category.getDescription());
        namedNodeMap.setNamedItem(attr2);
        Attr attr3 = document.createAttribute(EXPANDED_ATTRIBUTE);
        if (category.isExpandedState()) {
            attr3.setValue(TRUE);
        } else {
            attr3.setValue(FALSE);
        }
        namedNodeMap.setNamedItem(attr3);
        return element;
    }

    private Node createTemplateNode(COBOLTemplate cOBOLTemplate, Node node, Document document) {
        Element element = document.createElement(TEMPLATE_TAG);
        node.appendChild(element);
        NamedNodeMap namedNodeMap = element.getAttributes();
        Attr attr = document.createAttribute(DESCRIPTION_ATTRIBUTE);
        attr.setValue(cOBOLTemplate.getDescription());
        namedNodeMap.setNamedItem(attr);
        Attr attr2 = document.createAttribute(KEYWORD_ATTRIBUTE);
        attr2.setValue(cOBOLTemplate.getKeyword());
        namedNodeMap.setNamedItem(attr2);
        Attr attr3 = document.createAttribute(NAME_ATTRIBUTE);
        attr3.setValue(cOBOLTemplate.getName());
        namedNodeMap.setNamedItem(attr3);
        Text text = document.createTextNode(cOBOLTemplate.getPattern());
        element.appendChild(text);
        return element;
    }

    public void importTemplate(Category category, File file) throws COBOLTemplateException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(fileInputStream));
            NodeList nodeList = document.getElementsByTagName(ROOT_TAG).item(0).getChildNodes();
            Stack<Object> stack = new Stack<Object>();
            stack.push(category);
            stack.push(nodeList);
            this.populateTreeModel(stack);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new COBOLTemplateException(parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new COBOLTemplateException(iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new COBOLTemplateException(sAXException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new COBOLTemplateException(Messages.getString((String)"COBOLTemplateManager.error.message1"));
        }
    }

    public void reset() throws COBOLTemplateException {
        this.clear(Category.getRootCategoryInstance());
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor != null) {
            ICOBOLTemplateSupport iCOBOLTemplateSupport = iCOBOLContributor.getCOBOLTemplateSupport();
            if (iCOBOLTemplateSupport != null) {
                fTemplateManager.addFromStream(iCOBOLTemplateSupport.getTemplateInputStream());
            }
        } else {
            fTemplateManager.addFromStream(new OSTemplateSupport().getTemplateInputStream());
        }
    }

    public void restoreDefaults() throws COBOLTemplateException {
        ICOBOLTemplateSupport iCOBOLTemplateSupport;
        this.clear(Category.getRootCategoryInstance());
        InputStream inputStream = null;
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor != null && (iCOBOLTemplateSupport = iCOBOLContributor.getCOBOLTemplateSupport()) != null) {
            inputStream = iCOBOLTemplateSupport.getDefaultsInputStream();
        }
        if (inputStream != null) {
            COBOLTemplateManager.getInstance().addFromStream(inputStream);
        } else {
            COBOLTemplateManager.getInstance().addFromStream(new OSTemplateSupport().getDefaultsInputStream());
        }
    }

    public void clear(Category category) {
        category.clearChildren();
        category = null;
    }

    public ArrayList getAllTemplates() {
        this.fAllTemplates = null;
        Category category = Category.getRootCategoryInstance();
        this.fAllTemplates = new ArrayList();
        this.populateTemplateList(category);
        return this.fAllTemplates;
    }

    public List<Template> getTemplateByName(String string) {
        this.fSpecificTemplates = new ArrayList(15);
        Category category = Category.getRootCategoryInstance();
        List<Template> list = this.populateRequestedList(category, string);
        HashSet<Template> hashSet = new HashSet<Template>(list);
        ArrayList<Template> arrayList = new ArrayList<Template>(hashSet);
        Collections.sort(arrayList, new COBOLTemplate());
        return arrayList;
    }

    private List<Template> populateRequestedList(Category category, String string) {
        Object[] objectArray;
        String string2 = string;
        if (category.getName().equals(string2)) {
            this.startAdd = true;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (category != null) {
            Category[] categoryArray;
            objectArray = category.getTemplateChildren();
            int n = objectArray.length;
            if (objectArray != null && n > 0 && this.startAdd) {
                int n2 = 0;
                while (n2 < n) {
                    arrayList.add(objectArray[n2]);
                    ++n2;
                }
                this.startAdd = false;
            }
            if ((categoryArray = category.getCategoryChildren()) != null) {
                int n3 = categoryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    if (categoryArray[n4].getName().contains("DIVISION")) {
                        this.currentDivisionInRecursive = categoryArray[n4].getName();
                    }
                    if (categoryArray[n4].getName().equalsIgnoreCase(REFERENCE)) {
                        this.populateRequestedList(categoryArray[n4], string);
                    }
                    if (this.currentDivisionInRecursive.equals(string2)) {
                        this.startAdd = true;
                        this.populateRequestedList(categoryArray[n4], string);
                    }
                    ++n4;
                }
            }
        }
        objectArray = null;
        COBOLTemplate cOBOLTemplate = null;
        int n = 0;
        while (n < arrayList.size()) {
            cOBOLTemplate = (COBOLTemplate)arrayList.get(n);
            objectArray = new String[]{cOBOLTemplate.getName(), cOBOLTemplate.getKeyword(), cOBOLTemplate.getDescription(), cOBOLTemplate.getPattern()};
            this.fSpecificTemplates.add(cOBOLTemplate);
            ++n;
        }
        return this.fSpecificTemplates;
    }

    private void populateTemplateList(Category category) {
        Object[] objectArray;
        ArrayList<COBOLTemplate> arrayList = new ArrayList<COBOLTemplate>();
        if (category != null) {
            Category[] categoryArray;
            objectArray = category.getTemplateChildren();
            int n = objectArray.length;
            if (objectArray != null && n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    arrayList.add(objectArray[n2]);
                    ++n2;
                }
            }
            if ((categoryArray = category.getCategoryChildren()) != null) {
                int n3 = categoryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    this.populateTemplateList(categoryArray[n4]);
                    ++n4;
                }
            }
        }
        objectArray = null;
        COBOLTemplate cOBOLTemplate = null;
        int n = 0;
        while (n < arrayList.size()) {
            cOBOLTemplate = (COBOLTemplate)arrayList.get(n);
            objectArray = new String[]{cOBOLTemplate.getName(), cOBOLTemplate.getKeyword(), cOBOLTemplate.getDescription(), cOBOLTemplate.getPattern()};
            this.fAllTemplates.add(cOBOLTemplate);
            ++n;
        }
    }

    public void getExpandedElements(Category category, ArrayList arrayList) {
        if (category.isExpandedState()) {
            category.setExpandedState(false);
            arrayList.add(category);
            Category[] categoryArray = category.getCategoryChildren();
            int n = 0;
            while (n < categoryArray.length) {
                this.getExpandedElements(categoryArray[n], arrayList);
                ++n;
            }
        }
    }

    public void addToVendorList(Category[] categoryArray, COBOLTemplate[] cOBOLTemplateArray) {
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor != null && this.getVendorTemplateList(iCOBOLContributor) == null) {
            this.fVenoderTemplateList.add(new VendorTemplateList(iCOBOLContributor, categoryArray, cOBOLTemplateArray));
        }
    }

    public void changeTemplates() {
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        Category.getRootCategoryInstance().clearChildren();
        VendorTemplateList vendorTemplateList = null;
        if (iCOBOLContributor != null && (vendorTemplateList = this.getVendorTemplateList(iCOBOLContributor)) != null) {
            int n = 0;
            while (n < vendorTemplateList.getCategoryList().length) {
                Category.getRootCategoryInstance().addCategoryChild(vendorTemplateList.getCategoryList()[n]);
                ++n;
            }
            n = 0;
            while (n < vendorTemplateList.getTemplateList().length) {
                Category.getRootCategoryInstance().addTemplateChild(vendorTemplateList.getTemplateList()[n]);
                ++n;
            }
        }
    }

    private VendorTemplateList getVendorTemplateList(ICOBOLContributor iCOBOLContributor) {
        int n = 0;
        while (n < this.fVenoderTemplateList.size()) {
            VendorTemplateList vendorTemplateList = (VendorTemplateList)this.fVenoderTemplateList.get(n);
            if (vendorTemplateList.getContributor().equals(iCOBOLContributor)) {
                return vendorTemplateList;
            }
            ++n;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.create();
        this.changeTemplates();
    }

    class VendorTemplateList {
        private ICOBOLContributor contributor = null;
        private Category[] categories = null;
        private COBOLTemplate[] templates = null;

        public VendorTemplateList(ICOBOLContributor iCOBOLContributor, Category[] categoryArray, COBOLTemplate[] cOBOLTemplateArray) {
            this.contributor = iCOBOLContributor;
            this.categories = categoryArray;
            this.templates = cOBOLTemplateArray;
        }

        public Category[] getCategoryList() {
            if (this.categories != null) {
                return this.categories;
            }
            return new Category[0];
        }

        public COBOLTemplate[] getTemplateList() {
            if (this.templates != null) {
                return this.templates;
            }
            return new COBOLTemplate[0];
        }

        public ICOBOLContributor getContributor() {
            return this.contributor;
        }
    }
}

