/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.rulers;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class COBOLHorizontalRuler
extends Composite {
    private StyledText fStyledText;
    private COBOLEditor fEditor;
    private ISourceViewer fSourceViewer;
    private String fDisplayText;
    private ISelectionChangedListener fSelectionChangeListener = null;
    private FocusAdapter fFocusListener = null;
    private VerifyListener fVerifyListener = null;
    private VerifyKeyListener fVerifyKeyListener = null;
    private SelectionAdapter fSelectionAdapter = null;
    private MouseAdapter fMouseAdapter = null;
    private int fWidth;
    private static final char TAB = '\t';
    private static final String BLANK = "";
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char STAR = '*';
    private static final char AREA_A = 'A';
    private static final char AREA_B = 'B';
    private static final char PID_AREA = 'I';
    private static final int START_AREA_B = 12;
    private static final int VARIABLE_FORMAT_END_AREA_B = 251;
    private static final int START_PID_AREA = 73;
    private static final int END_OF_PID_AREA = 80;
    private String fRefFormat;
    private Color fFontColor = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private int avgCharWidth;

    public COBOLHorizontalRuler(Composite composite, COBOLEditor cOBOLEditor) {
        super(composite, 262144);
        this.fEditor = cOBOLEditor;
    }

    public void setSourceViewer(ISourceViewer iSourceViewer) {
        this.fSourceViewer = iSourceViewer;
        this.fStyledText = this.fSourceViewer.getTextWidget();
        this.addListeners();
    }

    private void paintComponent(GC gC) {
        if (this.isDisposed()) {
            return;
        }
        Point point = this.getSize();
        if (this.fWidth != point.x) {
            this.fWidth = point.x;
        }
        this.avgCharWidth = gC.getFontMetrics().getAverageCharWidth();
        int n = this.fWidth / this.avgCharWidth;
        int n2 = point.y;
        gC.fillRectangle(0, 0, this.fWidth, n2);
        gC.setBackground(this.getBackground());
        n2 -= this.fEditor.GAP_SIZE;
        int n3 = 0;
        if (this.fEditor.isOverviewRulerVisible()) {
            n3 = this.fEditor.getOverviewRuler().getWidth() + this.fEditor.GAP_SIZE;
        }
        gC.fillRectangle(0, 0, this.fWidth - this.fStyledText.getVerticalBar().getSize().x - n3, n2);
        gC.setClipping(0, 0, this.fWidth - this.fStyledText.getVerticalBar().getSize().x - n3, n2);
        if (this.fFontColor != null && !this.fFontColor.isDisposed()) {
            gC.setForeground(this.fFontColor);
        }
        this.fDisplayText = this.ruler(n, this.fStyledText.getHorizontalPixel());
        int n4 = this.getCurrentColumn();
        int n5 = this.fStyledText.getHorizontalPixel();
        int n6 = n5 % this.avgCharWidth;
        int n7 = ((n4 -= (n5 /= this.avgCharWidth)) - 1) * gC.getFontMetrics().getAverageCharWidth() - n6;
        if (this.fFontColor != null && !this.fFontColor.isDisposed()) {
            gC.setBackground(this.fFontColor);
        }
        gC.drawString(this.fDisplayText, 0 - n6, 0, true);
        if (this.fFontColor != null && !this.fFontColor.isDisposed()) {
            gC.setBackground(this.fFontColor);
        }
        gC.fillRectangle(n7, 0, gC.getFontMetrics().getAverageCharWidth(), n2);
        gC.setForeground(this.getBackground());
        char c = '\u0000';
        int n8 = 0;
        n8 = n4 - 1;
        c = n8 < 0 || n8 >= this.fDisplayText.length() ? (char)' ' : this.fDisplayText.charAt(n8);
        gC.drawString(String.valueOf(c), n7, 0, true);
    }

    private String ruler(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(BLANK);
        int n3 = 0;
        n3 = 0;
        int n4 = n3 + (n2 /= this.avgCharWidth);
        while (n4 <= n + n2) {
            if ((n4 + 1) % 10 == 0) {
                stringBuffer.append((n4 + 1) / 10 % 10);
            } else if ((n4 + 1) % 5 == 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public final void setMode(String string) {
        this.fRefFormat = string;
    }

    private int getCurrentColumn() {
        int n = 0;
        int n2 = -1;
        try {
            int n3 = this.fSourceViewer.getVisibleRegion().getOffset();
            int n4 = n3 + this.fStyledText.getCaretOffset();
            IDocument iDocument = this.fSourceViewer.getDocument();
            if (iDocument == null) {
                return n;
            }
            n2 = iDocument.getLineOfOffset(n4);
            int n5 = iDocument.getLineOffset(n2);
            int n6 = this.fStyledText.getTabs();
            int n7 = 1;
            int n8 = 0;
            int n9 = n5;
            while (n9 < n4) {
                if ('\t' == iDocument.getChar(n9)) {
                    while ((n + n7 + n8) % n6 != 0) {
                        ++n7;
                    }
                    n += n7;
                    n7 = 1;
                } else {
                    char[] cArray = new char[]{iDocument.getChar(n9)};
                    byte[] byArray = new String(cArray).getBytes();
                    n += byArray.length;
                }
                ++n9;
            }
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
            n = 0;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            n = 0;
        }
        return ++n;
    }

    private void addListeners() {
        if (this.fSourceViewer != null) {
            this.fSelectionChangeListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    if (COBOLHorizontalRuler.this.fSourceViewer.getTextWidget().getSelectionCount() > 0) {
                        COBOLHorizontalRuler.this.redraw();
                    }
                }
            };
            this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(this.fSelectionChangeListener);
            PaintListener paintListener = new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    COBOLHorizontalRuler.this.paintComponent(paintEvent.gc);
                }
            };
            this.addPaintListener(paintListener);
            this.fFocusListener = new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    if (!COBOLHorizontalRuler.this.fStyledText.isDisposed()) {
                        COBOLHorizontalRuler.this.redraw();
                    }
                }
            };
            this.fStyledText.addFocusListener((FocusListener)this.fFocusListener);
            this.fVerifyListener = new VerifyListener(){

                public void verifyText(VerifyEvent verifyEvent) {
                    if (!COBOLHorizontalRuler.this.fStyledText.isDisposed()) {
                        COBOLHorizontalRuler.this.redraw();
                    }
                }
            };
            this.fStyledText.addVerifyListener(this.fVerifyListener);
            this.fVerifyKeyListener = new VerifyKeyListener(){

                public void verifyKey(VerifyEvent verifyEvent) {
                    if (!COBOLHorizontalRuler.this.fStyledText.isDisposed()) {
                        COBOLHorizontalRuler.this.redraw();
                    }
                }
            };
            this.fStyledText.addVerifyKeyListener(this.fVerifyKeyListener);
            this.fSelectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (!COBOLHorizontalRuler.this.fStyledText.isDisposed()) {
                        COBOLHorizontalRuler.this.redraw();
                    }
                }
            };
            this.fStyledText.getHorizontalBar().addSelectionListener((SelectionListener)this.fSelectionAdapter);
            this.fMouseAdapter = new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                    if (!COBOLHorizontalRuler.this.fStyledText.isDisposed()) {
                        COBOLHorizontalRuler.this.redraw();
                    }
                }

                public void mouseDown(MouseEvent mouseEvent) {
                    if (!COBOLHorizontalRuler.this.fStyledText.isDisposed()) {
                        COBOLHorizontalRuler.this.redraw();
                    }
                }
            };
            this.fStyledText.addMouseListener((MouseListener)this.fMouseAdapter);
        }
    }

    public void handleDispose() {
        try {
            this.removeListeners();
            this.fStyledText = null;
            this.fSourceViewer = null;
            this.fDisplayText = null;
            if (this.fFontColor != null) {
                this.fFontColor.dispose();
                this.fFontColor = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private void removeListeners() {
        if (this.fSelectionChangeListener != null) {
            this.fSourceViewer.getSelectionProvider().removeSelectionChangedListener(this.fSelectionChangeListener);
            this.fSelectionChangeListener = null;
        }
        if (this.fFocusListener != null) {
            if (!this.fStyledText.isDisposed()) {
                this.fStyledText.removeFocusListener((FocusListener)this.fFocusListener);
            }
            this.fFocusListener = null;
        }
        if (this.fVerifyListener != null) {
            if (!this.fStyledText.isDisposed()) {
                this.fStyledText.removeVerifyListener(this.fVerifyListener);
            }
            this.fVerifyListener = null;
        }
        if (this.fVerifyKeyListener != null) {
            if (!this.fStyledText.isDisposed()) {
                this.fStyledText.removeVerifyKeyListener(this.fVerifyKeyListener);
            }
            this.fVerifyKeyListener = null;
        }
        if (this.fSelectionAdapter != null) {
            if (!this.fStyledText.isDisposed()) {
                this.fStyledText.getHorizontalBar().removeSelectionListener((SelectionListener)this.fSelectionAdapter);
            }
            this.fSelectionAdapter = null;
        }
        if (this.fMouseAdapter != null) {
            if (!this.fStyledText.isDisposed()) {
                this.fStyledText.removeMouseListener((MouseListener)this.fMouseAdapter);
            }
            this.fMouseAdapter = null;
        }
    }

    public Color getBackground() {
        this.checkWidget();
        return this.getDisplay().getSystemColor(25);
    }
}

