/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.preferences;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.preferences.ConfigureCOBOLRulesConstants;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConfigureCOBOLRules
extends PreferencePage
implements IWorkbenchPreferencePage {
    Map<Button, Combo> ruleMap = new HashMap<Button, Combo>(ConfigureCOBOLRulesConstants.RULES.length);
    private Combo priority = null;
    private Button ruleButton = null;
    private Text indentSpaces = null;
    boolean someRuleisSet = false;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 2);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)gridLayout);
        int n = 0;
        while (n < ConfigureCOBOLRulesConstants.RULES.length) {
            this.ruleButton = new Button(composite2, 32);
            this.ruleButton.setText(ConfigureCOBOLRulesConstants.RULES[n]);
            this.ruleButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Combo combo = ConfigureCOBOLRules.this.ruleMap.get(selectionEvent.widget);
                    if (((Button)selectionEvent.widget).getSelection()) {
                        combo.setEnabled(true);
                    } else {
                        combo.setEnabled(false);
                    }
                    combo.select(0);
                    if (((Button)selectionEvent.widget).getText().equals("Indentation Issues")) {
                        ConfigureCOBOLRules.this.indentSpaces.setEnabled(((Button)selectionEvent.widget).getSelection());
                        ConfigureCOBOLRules.this.indentSpaces.setText("1");
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            this.priority = new Combo(composite2, 0);
            this.priority.setItems(ConfigureCOBOLRulesConstants.PRIORITIES);
            this.priority.setEnabled(false);
            this.priority.setToolTipText("Priority\n1. High\n2. Medium\n3. Low");
            this.ruleMap.put(this.ruleButton, this.priority);
            if (ConfigureCOBOLRulesConstants.RULES[n].equalsIgnoreCase("Indentation Issues")) {
                Label label = new Label(composite2, 0);
                label.setFont(composite2.getFont());
                label.setText("     Number of Spaces");
                this.indentSpaces = new Text(composite2, 2048);
                this.indentSpaces.setFont(composite2.getFont());
                this.indentSpaces.setTextLimit(1);
                this.indentSpaces.setEnabled(false);
                this.indentSpaces.setText("1");
                this.indentSpaces.setToolTipText("Only Numbers from 1 to 9 are allowed");
                this.indentSpaces.addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent verifyEvent) {
                        String string = verifyEvent.text;
                        char[] cArray = new char[string.length()];
                        string.getChars(0, cArray.length, cArray, 0);
                        int n = 0;
                        while (n < cArray.length) {
                            if ('1' > cArray[n] || cArray[n] > '9') {
                                verifyEvent.doit = false;
                                return;
                            }
                            ++n;
                        }
                    }
                });
            }
            ++n;
        }
        this.enableSelectedItems();
        return composite;
    }

    private void enableSelectedItems() {
        try {
            IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
            String string = iPreferenceStore.getString("COBOLSYNTAXRULES");
            if (!string.equalsIgnoreCase("NONE")) {
                HashMap<String, String> hashMap = null;
                hashMap = new HashMap<String, String>();
                this.someRuleisSet = false;
                int n = 0;
                while (n < ConfigureCOBOLRulesConstants.RULES.length) {
                    if (!iPreferenceStore.getString(ConfigureCOBOLRulesConstants.RULES[n]).equals("") && !iPreferenceStore.getString(ConfigureCOBOLRulesConstants.RULES[n]).equals("0")) {
                        hashMap.put(ConfigureCOBOLRulesConstants.RULES[n], iPreferenceStore.getString(ConfigureCOBOLRulesConstants.RULES[n]));
                        this.someRuleisSet = true;
                    }
                    ++n;
                }
                if (this.someRuleisSet) {
                    this.setValues(hashMap, false);
                } else {
                    this.setValues(ConfigureCOBOLRulesConstants.DEFAULTRULEMAP, true);
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError("ConfigureCOBOLRules -- Exception in enableSelectedItems() : " + exception.getLocalizedMessage().toString(), exception);
        }
    }

    public boolean performOk() {
        this.getPageValuesToStore();
        return super.performOk();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performApply() {
        this.getPageValuesToStore();
        super.performApply();
    }

    public void performDefaults() {
        this.setValues(ConfigureCOBOLRulesConstants.DEFAULTRULEMAP, true);
        this.getPageValuesToStore();
    }

    private void setValues(Map<String, String> map, boolean bl) {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        try {
            Set<String> set = map.keySet();
            for (Map.Entry<Button, Combo> entry : this.ruleMap.entrySet()) {
                String string = entry.getKey().getText();
                if (!set.contains(string)) continue;
                entry.getKey().setSelection(true);
                entry.getValue().setEnabled(true);
                entry.getValue().select(entry.getValue().indexOf(map.get(string)));
                if (!string.equalsIgnoreCase("Indentation Issues")) continue;
                this.indentSpaces.setEnabled(true);
                if (bl) {
                    this.indentSpaces.setText("1");
                    continue;
                }
                this.indentSpaces.setText(iPreferenceStore.getString("Indent Spaces"));
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError("ConfigureCOBOLRules -- Exception in setValues() : " + exception.getLocalizedMessage().toString(), exception);
        }
    }

    private void getPageValuesToStore() {
        try {
            this.someRuleisSet = false;
            IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
            for (Map.Entry<Button, Combo> entry : this.ruleMap.entrySet()) {
                Button button = entry.getKey();
                Combo combo = entry.getValue();
                if (button.getSelection()) {
                    if (button.getText().equalsIgnoreCase("Indentation Issues")) {
                        iPreferenceStore.setValue(button.getText(), combo.getText());
                        iPreferenceStore.setValue("Indent Spaces", this.indentSpaces.getText());
                        this.someRuleisSet = true;
                        continue;
                    }
                    iPreferenceStore.setValue(button.getText(), combo.getText());
                    this.someRuleisSet = true;
                    continue;
                }
                iPreferenceStore.setValue(button.getText(), "0");
            }
            if (!this.someRuleisSet) {
                iPreferenceStore.setValue("COBOLSYNTAXRULES", "NONE");
            } else {
                iPreferenceStore.setValue("COBOLSYNTAXRULES", "");
            }
            if (iPreferenceStore.needsSaving()) {
                try {
                    ((IPersistentPreferenceStore)iPreferenceStore).save();
                }
                catch (IOException iOException) {
                    CBDTUiPlugin.logError("ConfigureCOBOLRules -- Exception in getPageValuetoStore() : " + iOException.getLocalizedMessage().toString(), iOException);
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError("ConfigureCOBOLRules -- Exception in getPageValuetoStore() : " + exception.getLocalizedMessage().toString(), exception);
        }
    }

    public void init(IWorkbench iWorkbench) {
    }
}

