/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.preferences;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.ICOBOLHelpContextId;
import org.eclipse.cobol.ui.dialogs.AddTemplateDialog;
import org.eclipse.cobol.ui.templates.COBOLTemplate;
import org.eclipse.cobol.ui.templates.COBOLTemplateException;
import org.eclipse.cobol.ui.templates.COBOLTemplateManager;
import org.eclipse.cobol.ui.templates.COBOLTemplateTreeContentProvider;
import org.eclipse.cobol.ui.templates.COBOLTemplateTreeLabelProvider;
import org.eclipse.cobol.ui.templates.Category;
import org.eclipse.cobol.ui.views.templates.COBOLTemplateViewPart;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class COBOLTemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final int ADD = 1;
    public static final int EDIT_CATEGORY = 2;
    public static final int EDIT_TEMPLATE = 3;
    private TreeViewer fTreeViewer;
    private Tree tvTree;
    private SourceViewer fPatternViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fImportButton;
    private Button fExportButton;
    private Button fExportAllButton;
    private COBOLTemplateManager fCOBOLTemplateManager;
    private Category fRootCategory;
    private Text fDescriptionText;
    private Text fKeywordText;

    public COBOLTemplatePreferencePage() {
        try {
            this.fCOBOLTemplateManager = COBOLTemplateManager.getInstance();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.numColumns = 1;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(1808);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)this.getFontMetrics((Control)composite), (int)20);
        composite3.setLayoutData((Object)gridData);
        composite3.setFont(composite.getFont());
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        gridLayout3.numColumns = 1;
        composite4.setLayout((Layout)gridLayout3);
        GridData gridData2 = new GridData(1040);
        composite4.setLayoutData((Object)gridData2);
        composite4.setFont(composite.getFont());
        Composite composite5 = new Composite(composite, 0);
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.marginHeight = 0;
        gridLayout4.marginWidth = 0;
        gridLayout4.numColumns = 1;
        composite5.setLayout((Layout)gridLayout4);
        GridData gridData3 = new GridData(1808);
        gridData3.verticalAlignment = 4;
        gridData3.horizontalAlignment = 4;
        composite5.setLayoutData((Object)gridData3);
        composite5.setFont(composite.getFont());
        this.createFirstColumn(composite3);
        this.createButtonComposite(composite4);
        this.createBodyColumn(composite5);
        this.fRootCategory = Category.getRootCategoryInstance();
        this.fTreeViewer.setInput((Object)this.fRootCategory.getParent());
        Category[] categoryArray = this.fRootCategory.getCategoryChildren();
        if (categoryArray.length != 0) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)categoryArray[0]));
            this.fDescriptionText.setText(categoryArray[0].getDescription());
            this.clearTemplateText();
        } else {
            COBOLTemplate[] cOBOLTemplateArray = this.fRootCategory.getTemplateChildren();
            if (cOBOLTemplateArray.length != 0) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)cOBOLTemplateArray[0]));
                this.fDescriptionText.setText(cOBOLTemplateArray[0].getDescription());
                this.fKeywordText.setText(cOBOLTemplateArray[0].getKeyword());
                this.fPatternViewer.getTextWidget().setText(cOBOLTemplateArray[0].getPattern());
            } else {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.fRootCategory));
            }
        }
        this.updateButtons();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, ICOBOLHelpContextId.COBOL_TEMPLATE_PREF_PAGE);
        return composite2;
    }

    private FontMetrics getFontMetrics(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return fontMetrics;
    }

    private void createFirstColumn(Composite composite) {
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(Messages.getString((String)"COBOLTemplatePreferencePage.label.category"));
        this.fTreeViewer = new TreeViewer(composite, 2818);
        this.fTreeViewer.getControl().setFont(composite.getFont());
        this.tvTree = this.fTreeViewer.getTree();
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tvTree.setLayoutData((Object)gridData);
        this.fTreeViewer.setContentProvider((IContentProvider)new COBOLTemplateTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new COBOLTemplateTreeLabelProvider());
    }

    private void createBodyColumn(Composite composite) {
        this.createTextComposite(composite);
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(Messages.getString((String)"COBOLTemplatePreferencePage.label.preview"));
        this.fPatternViewer = this.createSourceViewer(composite);
        this.fPatternViewer.setEditable(false);
        this.tvTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)COBOLTemplatePreferencePage.this.fTreeViewer.getSelection();
                Object[] objectArray = iStructuredSelection.toArray();
                if (objectArray.length == 0 || objectArray.length > 1 || objectArray[0] == COBOLTemplatePreferencePage.this.fRootCategory) {
                    COBOLTemplatePreferencePage.this.clearAllTexts();
                    COBOLTemplatePreferencePage.this.updateButtons();
                    return;
                }
                if (objectArray[0] instanceof Category) {
                    COBOLTemplatePreferencePage.this.fDescriptionText.setText(((Category)objectArray[0]).getDescription());
                    COBOLTemplatePreferencePage.this.clearTemplateText();
                } else if (objectArray[0] instanceof COBOLTemplate) {
                    COBOLTemplate cOBOLTemplate = (COBOLTemplate)objectArray[0];
                    COBOLTemplatePreferencePage.this.fDescriptionText.setText(cOBOLTemplate.getDescription());
                    COBOLTemplatePreferencePage.this.fKeywordText.setText(cOBOLTemplate.getKeyword());
                    COBOLTemplatePreferencePage.this.fPatternViewer.getTextWidget().setText(cOBOLTemplate.getPattern());
                }
                COBOLTemplatePreferencePage.this.updateButtons();
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)COBOLTemplatePreferencePage.this.fTreeViewer.getSelection();
                Object[] objectArray = iStructuredSelection.toArray();
                if (objectArray[0] instanceof Category) {
                    if (COBOLTemplatePreferencePage.this.fTreeViewer.getExpandedState(objectArray[0])) {
                        COBOLTemplatePreferencePage.this.fTreeViewer.collapseToLevel(objectArray[0], 1);
                    } else {
                        COBOLTemplatePreferencePage.this.fTreeViewer.expandToLevel(objectArray[0], 1);
                    }
                    COBOLTemplatePreferencePage.this.fDescriptionText.setText(((Category)objectArray[0]).getDescription());
                    COBOLTemplatePreferencePage.this.clearTemplateText();
                } else if (objectArray[0] instanceof COBOLTemplate) {
                    COBOLTemplate cOBOLTemplate = (COBOLTemplate)objectArray[0];
                    COBOLTemplatePreferencePage.this.fDescriptionText.setText(cOBOLTemplate.getDescription());
                    COBOLTemplatePreferencePage.this.fKeywordText.setText(cOBOLTemplate.getKeyword());
                    COBOLTemplatePreferencePage.this.fPatternViewer.getTextWidget().setText(cOBOLTemplate.getPattern());
                }
                COBOLTemplatePreferencePage.this.updateButtons();
            }
        });
    }

    private void createTextComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setFont(composite.getFont());
        label.setText(Messages.getString((String)"COBOLTemplatePreferencePage.label.description"));
        this.fDescriptionText = this.createTextControl(composite2);
        this.fDescriptionText.setEditable(false);
        Label label2 = new Label(composite2, 0);
        label2.setFont(composite.getFont());
        label2.setText(Messages.getString((String)"COBOLTemplatePreferencePage.label.keyword"));
        this.fKeywordText = this.createTextControl(composite2);
        this.fKeywordText.setEditable(false);
    }

    private void createButtonComposite(Composite composite) {
        new Label(composite, 0);
        this.fAddButton = this.createPushButton(composite, Messages.getString((String)"COBOLTemplatePreferencePage.button.new"));
        this.fEditButton = this.createPushButton(composite, Messages.getString((String)"COBOLTemplatePreferencePage.button.edit"));
        this.fRemoveButton = this.createPushButton(composite, Messages.getString((String)"COBOLTemplatePreferencePage.button.remove"));
        this.fImportButton = this.createPushButton(composite, Messages.getString((String)"COBOLTemplatePreferencePage.button.import"));
        this.fExportButton = this.createPushButton(composite, Messages.getString((String)"COBOLTemplatePreferencePage.button.export"));
        this.fExportAllButton = this.createPushButton(composite, Messages.getString((String)"COBOLTemplatePreferencePage.button.exportAll"));
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLTemplatePreferencePage.this.add();
            }
        });
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLTemplatePreferencePage.this.edit();
            }
        });
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLTemplatePreferencePage.this.remove();
            }
        });
        this.fImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLTemplatePreferencePage.this.import_templates();
            }
        });
        this.fExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLTemplatePreferencePage.this.export();
            }
        });
        this.fExportAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLTemplatePreferencePage.this.exportAll();
            }
        });
    }

    private void updateButtons() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        int n = iStructuredSelection.size();
        int n2 = this.fTreeViewer.getTree().getItemCount();
        if (n2 > 0 && n == 1 && objectArray[0] != this.fRootCategory) {
            this.fEditButton.setEnabled(true);
        } else {
            this.fEditButton.setEnabled(false);
        }
        this.fAddButton.setEnabled(n == 1);
        this.fExportButton.setEnabled(n > 0);
        this.fImportButton.setEnabled(n == 1 && !(objectArray[0] instanceof COBOLTemplate));
        this.fRemoveButton.setEnabled(n2 > 0 && n > 0 && objectArray[0] != this.fRootCategory);
        this.fExportAllButton.setEnabled(n2 > 0);
    }

    private Text createTextControl(Composite composite) {
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)gridData);
        text.setFont(composite.getFont());
        return text;
    }

    private Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        GridData gridData = new GridData(4);
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        button.setFont(composite.getFont());
        return button;
    }

    private SourceViewer createSourceViewer(Composite composite) {
        SourceViewer sourceViewer = new SourceViewer(composite, null, 2816);
        sourceViewer.setEditable(false);
        sourceViewer.setDocument((IDocument)new Document());
        sourceViewer.getTextWidget().setBackground(this.getShell().getDisplay().getSystemColor(22));
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        sourceViewer.getTextWidget().setFont(font);
        sourceViewer.getTextWidget().setForeground(new Color((Device)this.getShell().getDisplay(), 127, 0, 85));
        Control control = sourceViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
        control.setFont(composite.getFont());
        return sourceViewer;
    }

    private void add() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        if (objectArray.length == 0) {
            Display.getDefault().beep();
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.dialog.title"), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.message1"));
            return;
        }
        AddTemplateDialog addTemplateDialog = null;
        if (objectArray[0] instanceof COBOLTemplate) {
            addTemplateDialog = new AddTemplateDialog(this.getShell(), ((COBOLTemplate)objectArray[0]).getParent(), 1);
        } else if (objectArray[0] instanceof Category) {
            addTemplateDialog = new AddTemplateDialog(this.getShell(), (Category)objectArray[0], 1);
        }
        if (addTemplateDialog.open() == 0) {
            this.fTreeViewer.refresh();
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)addTemplateDialog.getCategory()));
            this.fDescriptionText.setText(addTemplateDialog.getCategory().getDescription());
            this.clearTemplateText();
            if (addTemplateDialog.getTemplate() != null) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)addTemplateDialog.getTemplate()));
                this.fDescriptionText.setText(addTemplateDialog.getTemplate().getDescription());
                this.fKeywordText.setText(addTemplateDialog.getTemplate().getKeyword());
                this.fPatternViewer.getTextWidget().setText(addTemplateDialog.getTemplate().getPattern());
            }
        }
        this.updateButtons();
    }

    private void edit() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        if (objectArray.length == 0) {
            Display.getDefault().beep();
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.dialog.title"), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.message2"));
            return;
        }
        AddTemplateDialog addTemplateDialog = null;
        if (objectArray[0] instanceof Category) {
            addTemplateDialog = new AddTemplateDialog(this.getShell(), (Category)objectArray[0], 2);
            if (addTemplateDialog.open() == 0) {
                this.fTreeViewer.refresh();
                this.fDescriptionText.setText(addTemplateDialog.getCategory().getDescription());
                this.clearTemplateText();
            }
        } else if (objectArray[0] instanceof COBOLTemplate && (addTemplateDialog = new AddTemplateDialog(this.getShell(), (COBOLTemplate)objectArray[0], 3)).open() == 0) {
            this.fTreeViewer.refresh();
            this.fDescriptionText.setText(addTemplateDialog.getTemplate().getDescription());
            this.fKeywordText.setText(addTemplateDialog.getTemplate().getKeyword());
            this.fPatternViewer.getTextWidget().setText(addTemplateDialog.getTemplate().getPattern());
        }
    }

    private void remove() {
        Category category = null;
        COBOLTemplate cOBOLTemplate = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        if (objectArray.length == 0) {
            Display.getDefault().beep();
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.dialog.title"), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.message2"));
            return;
        }
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.delete.dialog.title"), (String)Messages.getString((String)"COBOLTemplatePreferencePage.message.delete"))) {
            Category category2 = null;
            int n = objectArray.length - 1;
            while (n >= 0) {
                if (objectArray[n] instanceof Category) {
                    category = (Category)objectArray[n];
                    category2 = category.getParent();
                    category2.removeCategory(category);
                } else if (objectArray[n] instanceof COBOLTemplate) {
                    cOBOLTemplate = (COBOLTemplate)objectArray[n];
                    category2 = cOBOLTemplate.getParent();
                    category2.removeTemplate(cOBOLTemplate);
                }
                --n;
            }
            this.fTreeViewer.refresh();
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(category2));
            if (category2 instanceof Category) {
                this.fDescriptionText.setText(category2.getDescription());
                this.clearTemplateText();
            }
            if (this.fTreeViewer.getTree().getItemCount() == 0) {
                this.clearAllTexts();
            }
        }
        this.updateButtons();
    }

    public void export() {
        try {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
            Object[] objectArray = iStructuredSelection.toArray();
            Category[] categoryArray = null;
            COBOLTemplate[] cOBOLTemplateArray = null;
            if (objectArray.length == 0) {
                Display.getDefault().beep();
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.dialog.title"), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.message2"));
                return;
            }
            if (!this.fRootCategory.hasChildren()) {
                Display.getDefault().beep();
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.dialog.title"), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.message3"));
                return;
            }
            if (objectArray[0] == this.fRootCategory) {
                this.exportAll();
                return;
            }
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            fileDialog.setText(Messages.getString((String)"COBOLTemplatePreferencePage.export.title"));
            fileDialog.setFilterExtensions(new String[]{Messages.getString((String)"COBOLTemplatePreferencePage.export.extension")});
            fileDialog.setFileName(Messages.getString((String)"COBOLTemplatePreferencePage.export.filename"));
            String string = fileDialog.open();
            if (string == null || string.length() == 0) {
                return;
            }
            Path path = new Path(string);
            File file = path.toFile();
            if (file != null && file.exists()) {
                String string2 = MessageFormat.format(Messages.getString((String)"COBOLTemplatePreferencePage.confirm.dialog.message"), path.toOSString());
                if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"COBOLTemplatePreferencePage.export.title"), (String)string2)) {
                    return;
                }
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3] instanceof COBOLTemplate) {
                    ++n2;
                } else if (objectArray[n3] instanceof Category) {
                    ++n;
                }
                ++n3;
            }
            categoryArray = new Category[n];
            cOBOLTemplateArray = new COBOLTemplate[n2];
            n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < objectArray.length) {
                if (objectArray[n5] instanceof COBOLTemplate) {
                    cOBOLTemplateArray[n3++] = (COBOLTemplate)objectArray[n5];
                } else if (objectArray[n5] instanceof Category) {
                    categoryArray[n4++] = (Category)objectArray[n5];
                }
                ++n5;
            }
            this.fCOBOLTemplateManager.exportTemplates(new File(string), categoryArray, cOBOLTemplateArray);
        }
        catch (COBOLTemplateException cOBOLTemplateException) {
            CBDTUiPlugin.logError(cOBOLTemplateException);
            Display.getDefault().beep();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.write.title"), (String)cOBOLTemplateException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private void import_templates() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        if (objectArray.length == 0) {
            Display.getDefault().beep();
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.dialog.title"), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.message1"));
            return;
        }
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(Messages.getString((String)"COBOLTemplatePreferencePage.import.title"));
        fileDialog.setFilterExtensions(new String[]{Messages.getString((String)"COBOLTemplatePreferencePage.import.extension")});
        String string = fileDialog.open();
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            this.fCOBOLTemplateManager.importTemplate((Category)objectArray[0], new File(string));
            this.fTreeViewer.refresh();
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)((Category)objectArray[0])));
        }
        catch (COBOLTemplateException cOBOLTemplateException) {
            CBDTUiPlugin.logError(cOBOLTemplateException);
            Display.getDefault().beep();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.read.title"), (String)cOBOLTemplateException.getMessage());
        }
    }

    private void exportAll() {
        if (!this.fRootCategory.hasChildren()) {
            Display.getDefault().beep();
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.dialog.title"), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.message3"));
            return;
        }
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText(Messages.getString((String)"COBOLTemplatePreferencePage.export.title"));
        fileDialog.setFilterExtensions(new String[]{Messages.getString((String)"COBOLTemplatePreferencePage.export.extension")});
        fileDialog.setFileName(Messages.getString((String)"COBOLTemplatePreferencePage.export.filename"));
        String string = fileDialog.open();
        if (string == null || string.length() == 0) {
            return;
        }
        Path path = new Path(string);
        File file = path.toFile();
        if (file != null && file.exists()) {
            String string2 = MessageFormat.format(Messages.getString((String)"COBOLTemplatePreferencePage.confirm.dialog.message"), path.toOSString());
            if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"COBOLTemplatePreferencePage.export.title"), (String)string2)) {
                return;
            }
        }
        try {
            this.fCOBOLTemplateManager.saveToFile(new File(string));
        }
        catch (COBOLTemplateException cOBOLTemplateException) {
            CBDTUiPlugin.logError(cOBOLTemplateException);
            Display.getDefault().beep();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.write.title"), (String)cOBOLTemplateException.getMessage());
        }
    }

    private void clearAllTexts() {
        this.fDescriptionText.setText("");
        this.fKeywordText.setText("");
        this.fPatternViewer.getTextWidget().setText("");
    }

    private void clearTemplateText() {
        this.fKeywordText.setText("");
        this.fPatternViewer.getTextWidget().setText("");
    }

    public boolean performOk() {
        try {
            this.fCOBOLTemplateManager.save();
            IViewPart iViewPart = CBDTUiPlugin.getActivePage().findView("org.eclipse.cobol.ui.views.templates.COBOLTemplateViewPart");
            if (iViewPart != null) {
                COBOLTemplateViewPart cOBOLTemplateViewPart = (COBOLTemplateViewPart)iViewPart;
                cOBOLTemplateViewPart.refresh();
            }
        }
        catch (COBOLTemplateException cOBOLTemplateException) {
            CBDTUiPlugin.logError(cOBOLTemplateException);
            Display.getDefault().beep();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.write.title"), (String)cOBOLTemplateException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return super.performOk();
    }

    public boolean performCancel() {
        try {
            this.fCOBOLTemplateManager.reset();
        }
        catch (COBOLTemplateException cOBOLTemplateException) {
            CBDTUiPlugin.logError(cOBOLTemplateException);
            Display.getDefault().beep();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.read.title"), (String)cOBOLTemplateException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return super.performCancel();
    }

    protected void performDefaults() {
        try {
            this.fCOBOLTemplateManager.restoreDefaults();
            this.fTreeViewer.setInput((Object)this.fRootCategory.getParent());
            Category[] categoryArray = this.fRootCategory.getCategoryChildren();
            if (categoryArray.length != 0) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)categoryArray[0]));
                this.fDescriptionText.setText(categoryArray[0].getDescription());
                this.clearTemplateText();
            } else {
                COBOLTemplate[] cOBOLTemplateArray = this.fRootCategory.getTemplateChildren();
                if (cOBOLTemplateArray.length != 0) {
                    this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)cOBOLTemplateArray[0]));
                    this.fDescriptionText.setText(cOBOLTemplateArray[0].getDescription());
                    this.fKeywordText.setText(cOBOLTemplateArray[0].getKeyword());
                    this.fPatternViewer.getTextWidget().setText(cOBOLTemplateArray[0].getPattern());
                }
            }
            this.updateButtons();
        }
        catch (COBOLTemplateException cOBOLTemplateException) {
            CBDTUiPlugin.logError(cOBOLTemplateException);
            Display.getDefault().beep();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"COBOLTemplatePreferencePage.error.read.title"), (String)cOBOLTemplateException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public String getErrorMessage() {
        this.fTreeViewer.refresh();
        return super.getErrorMessage();
    }
}

