/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.preferences;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.ICOBOLHelpContextId;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferenceColorBlock;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferenceFormatBlock;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferenceGeneralBlock;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditorPreferenceConstants;

public class COBOLEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private COBOLEditorPreferenceGeneralBlock generalBlock;
    private COBOLEditorPreferenceColorBlock colorBlock;
    private COBOLEditorPreferenceFormatBlock formatBlock;

    public int convertHeightInCharsToPixels(int n) {
        return super.convertHeightInCharsToPixels(n);
    }

    public int convertWidthInCharsToPixels(int n) {
        return super.convertWidthInCharsToPixels(n);
    }

    public COBOLEditorPreferencePage() {
        try {
            this.setPreferenceStore(CBDTUiPlugin.getDefault().getPreferenceStore());
            this.setDescription(Messages.getString((String)"Title"));
            this.generalBlock = new COBOLEditorPreferenceGeneralBlock(this);
            this.colorBlock = new COBOLEditorPreferenceColorBlock(this);
            this.formatBlock = new COBOLEditorPreferenceFormatBlock(this);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        IPreferenceStore iPreferenceStore = null;
        try {
            iPreferenceStore = CBDTUiPlugin.getDefault().getPreferenceStore();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return iPreferenceStore;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setFont(composite.getFont());
        tabFolder.setLayout((Layout)new TabLayout());
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString((String)"tab.General"));
        tabItem.setControl(this.generalBlock.createBlock((Composite)tabFolder));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(tabItem.getControl(), ICOBOLHelpContextId.COBOL_GEN_PREF_PAGE);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString((String)"tab.Colors"));
        tabItem.setControl(this.colorBlock.createBlock((Composite)tabFolder));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(tabItem.getControl(), ICOBOLHelpContextId.COBOL_COLOR_PREF_PAGE);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString((String)"tab.ReferenceFormat"));
        tabItem.setControl(this.formatBlock.createBlock((Composite)tabFolder));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(tabItem.getControl(), ICOBOLHelpContextId.COBOL_FORMAT_PREF_PAGE);
        this.initialize();
        return tabFolder;
    }

    private void initialize() {
        try {
            this.generalBlock.initialize();
            this.colorBlock.initialize();
            this.formatBlock.initialize();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public boolean performOk() {
        block7: {
            block6: {
                block5: {
                    if (this.generalBlock.isPerformOk()) break block5;
                    return false;
                }
                if (this.colorBlock.isPerformOk()) break block6;
                return false;
            }
            if (this.formatBlock.isPerformOk()) break block7;
            return false;
        }
        try {
            this.generalBlock.performOk();
            this.colorBlock.performOk();
            this.formatBlock.performOk();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        CommonBuildUtil.generateAntScriptForAllProjects();
        return true;
    }

    protected void performDefaults() {
        try {
            this.generalBlock.performDefaults();
            this.colorBlock.performDefaults();
            this.formatBlock.performDefaults();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        super.performDefaults();
    }

    public void dispose() {
        this.generalBlock.dispose();
        this.colorBlock.dispose();
        this.formatBlock.dispose();
        super.dispose();
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        TextEditorPreferenceConstants.initializeDefaultValues((IPreferenceStore)iPreferenceStore);
        COBOLEditorPreferenceGeneralBlock.initDefaults(iPreferenceStore);
        COBOLEditorPreferenceColorBlock.initDefaults(iPreferenceStore);
        COBOLEditorPreferenceFormatBlock.initDefaults(iPreferenceStore);
    }

    private class TabLayout
    extends Layout {
        private TabLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Control[] controlArray = composite.getChildren();
            int n3 = controlArray.length;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                Control control = controlArray[n6];
                Point point = control.computeSize(-1, -1, bl);
                n4 = Math.max(n4, point.x);
                n5 = Math.max(n5, point.y);
                ++n6;
            }
            if (n != -1) {
                n4 = n;
            }
            if (n2 != -1) {
                n5 = n2;
            }
            return new Point(n4, n5);
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].setBounds(rectangle);
                ++n;
            }
        }
    }
}

