/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.preferences;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.core.common.ICOBOLLanguageModel;
import org.eclipse.cobol.ui.common.COBOLLanguageModel;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferenceBaseBlock;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class COBOLEditorPreferenceFormatBlock
extends COBOLEditorPreferenceBaseBlock {
    public static final String TAG_73_80 = "Tag-73-80";
    public static final String TAG_1_6 = "Tag-1-6";
    public static final String TagAutoDefault = "AutoTagDefault";
    public static final String INITIAL_VALUE_KEY = "Initial Value";
    public static final String INCREMENTAL_VALUE_KEY = "Incremental Value";
    public static final String REFERENCE_FORMAT = "Reference Format";
    public static final String RESERVED_WORD = "Reserved Word";
    public static final String TABWIDTH_VALUE_KEY = "Tab Width";
    public static final String USE_SPACES_FOR_TABS = "Use Spaces for TABS";
    private static final String MIN_TAB_WIDTH = "4";
    private static final String MAX_TAB_WIDTH = "8";
    private static final int TEXT_WIDTH = 40;
    private Combo fReseredWord;
    private ArrayList fTextControls = new ArrayList();
    private Button fUseSpaces;
    private Text fcolumnTabWidth;
    public static final String COLUMN_TABWIDTH_VALUE_KEY = "Column Tab Width";
    private static final String DEFAULT_TAB_WIDTH = "7,8,12,16,20,73";
    private Text tag16;
    private Button defaultToAutoTag;

    public COBOLEditorPreferenceFormatBlock(COBOLEditorPreferencePage cOBOLEditorPreferencePage) {
        super(cOBOLEditorPreferencePage);
    }

    public Control createBlock(Composite composite) {
        String string;
        String[] stringArray;
        Object object;
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData();
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        GridData gridData2 = new GridData(256);
        gridData2.heightHint = this.page.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData2);
        composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData();
        composite3.setLayoutData((Object)gridData);
        label = new Label(composite3, 16384);
        label.setFont(composite3.getFont());
        label.setText(Messages.getString((String)"labelForReservedWord"));
        gridData2 = new GridData();
        label.setLayoutData((Object)gridData2);
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor != null) {
            object = iCOBOLContributor.getCOBOLLanguageModel();
            stringArray = object.getReservedSets();
            string = object.getCurrentReservedSet();
        } else {
            object = new COBOLLanguageModel();
            stringArray = ((COBOLLanguageModel)object).getReservedSets();
            string = ((COBOLLanguageModel)object).getCurrentReservedSet();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n < stringArray[n2].length()) {
                n = stringArray[n2].length();
            }
            ++n2;
        }
        this.fReseredWord = new Combo(composite3, 12);
        this.fReseredWord.setFont(composite3.getFont());
        gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.widthHint = this.page.convertWidthInCharsToPixels(n + 2) * 3 / 2 + this.page.convertHeightInCharsToPixels(1);
        this.fReseredWord.setLayoutData((Object)gridData2);
        n2 = 0;
        while (n2 < stringArray.length) {
            this.fReseredWord.add(stringArray[n2]);
            if (stringArray[n2].equals(string)) {
                this.fReseredWord.select(n2);
            }
            ++n2;
        }
        label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        gridData2 = new GridData(256);
        gridData2.heightHint = this.page.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData2);
        gridLayout = new GridLayout();
        gridData = new GridData(768);
        composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData();
        composite3.setLayoutData((Object)gridData);
        label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        gridData2 = new GridData(256);
        gridData2.heightHint = this.page.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData2);
        Group group = new Group(composite2, 0);
        group.setFont(composite2.getFont());
        group.setText(Messages.getString((String)"labelForTabWidth"));
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(832);
        group.setLayoutData((Object)gridData);
        composite3 = new Composite((Composite)group, 0);
        composite3.setFont(group.getFont());
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData();
        composite3.setLayoutData((Object)gridData);
        this.fcolumnTabWidth = this.addTabWidthTextControl(composite3, Messages.getString((String)"LabelForTabWidthValue"), COLUMN_TABWIDTH_VALUE_KEY);
        this.fcolumnTabWidth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                boolean bl = COBOLEditorPreferenceFormatBlock.this.validateInput(COBOLEditorPreferenceFormatBlock.this.fcolumnTabWidth);
                COBOLEditorPreferenceFormatBlock.this.page.setValid(bl);
                if (bl) {
                    COBOLEditorPreferenceFormatBlock.this.setErrorMessage(null);
                }
            }
        });
        Group group2 = new Group(composite2, 0);
        group2.setFont(composite2.getFont());
        group2.setText("Settings for AutoTag");
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        group2.setLayoutData((Object)gridData);
        Composite composite4 = this.makeGroup((Composite)group2);
        this.tag16 = this.addTextControl(composite4, "Tag in Columns &1-6", TAG_1_6);
        Composite composite5 = this.makeGroup((Composite)group2);
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 1;
        this.defaultToAutoTag = new Button(composite5, 32);
        this.defaultToAutoTag.setData((Object)TagAutoDefault);
        this.defaultToAutoTag.setText("Default to Auto Tagging");
        String string2 = this.page.getPreferenceStore().getString(TagAutoDefault);
        boolean bl = Boolean.parseBoolean(string2);
        this.defaultToAutoTag.setSelection(bl);
        this.tag16.setTextLimit(6);
        String string3 = this.tag16.getText();
        if (string3.trim().length() == 0) {
            this.defaultToAutoTag.setSelection(false);
            this.defaultToAutoTag.setEnabled(false);
        }
        this.tag16.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                verifyEvent.text = verifyEvent.text.toUpperCase();
            }
        });
        this.tag16.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = COBOLEditorPreferenceFormatBlock.this.tag16.getText();
                if (string.trim().length() == 0) {
                    COBOLEditorPreferenceFormatBlock.this.defaultToAutoTag.setSelection(false);
                    COBOLEditorPreferenceFormatBlock.this.defaultToAutoTag.setEnabled(false);
                } else {
                    COBOLEditorPreferenceFormatBlock.this.defaultToAutoTag.setEnabled(true);
                }
            }
        });
        return composite2;
    }

    Composite makeGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    public boolean validateInput(Text text) {
        String string = text.getText();
        if (string.trim().equals("") || string.charAt(0) <= '/' || string.charAt(0) >= ':' || string.charAt(string.length() - 1) <= '/' || string.charAt(string.length() - 1) >= ':' || string.contains(" ") || string.contains(",,")) {
            this.setErrorMessage(Messages.getString((String)"TabWidthInvalidInut"));
            return false;
        }
        if (!string.trim().equals("")) {
            String[] stringArray = new String[string.length()];
            stringArray = string.split(",");
            int n = 0;
            while (n < stringArray.length) {
                if (!this.isNumber(stringArray[n].trim())) {
                    return false;
                }
                if (Integer.parseInt(stringArray[n]) > 80) {
                    this.setErrorMessage(Messages.getString((String)"MaximumTabWidth"));
                    return false;
                }
                if (n > 0 && Integer.parseInt(stringArray[n]) <= Integer.parseInt(stringArray[n - 1])) {
                    this.setErrorMessage(Messages.getString((String)"TabWidthAscend"));
                    return false;
                }
                ++n;
            }
        } else {
            this.setErrorMessage(null);
        }
        return true;
    }

    private Text addTextControl(Composite composite, String string, String string2) {
        GridData gridData = new GridData(256);
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(string);
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite, 2048);
        text.setFont(composite.getFont());
        text.setText(this.page.getPreferenceStore().getString(string2));
        text.setData((Object)string2);
        gridData = new GridData();
        gridData.widthHint = 40;
        text.setLayoutData((Object)gridData);
        text.setTextLimit(6);
        this.fTextControls.add(text);
        return text;
    }

    private Text addTabWidthTextControl(Composite composite, String string, String string2) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(string);
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite, 2048);
        text.setFont(composite.getFont());
        text.setText(MIN_TAB_WIDTH);
        text.setData((Object)string2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        text.setTextLimit(200);
        this.fTextControls.add(text);
        return text;
    }

    public void initialize() {
        IPreferenceStore iPreferenceStore = this.page.getPreferenceStore();
        int n = this.fTextControls.size();
        int n2 = 0;
        while (n2 < n) {
            Text text = (Text)this.fTextControls.get(n2);
            String string = (String)text.getData();
            text.setText(iPreferenceStore.getString(string));
            ++n2;
        }
    }

    public void performDefaults() {
        String[] stringArray;
        Text text;
        IPreferenceStore iPreferenceStore = this.page.getPreferenceStore();
        int n = this.fTextControls.size();
        int n2 = 0;
        while (n2 < n) {
            text = (Text)this.fTextControls.get(n2);
            stringArray = (String[])text.getData();
            text.setText(iPreferenceStore.getDefaultString((String)stringArray));
            ++n2;
        }
        String string = iPreferenceStore.getString(RESERVED_WORD);
        if (string == null || string.length() <= 0) {
            this.fReseredWord.select(0);
        } else {
            Object object;
            text = CorePlugin.getDefault().getDefaultCOBOLContributor();
            if (text != null) {
                object = text.getCOBOLLanguageModel();
                stringArray = object.getReservedSets();
            } else {
                object = new COBOLLanguageModel();
                stringArray = ((COBOLLanguageModel)object).getReservedSets();
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals(string)) {
                    this.fReseredWord.select(n3);
                    break;
                }
                ++n3;
            }
        }
    }

    private boolean isNumber(String string) throws NumberFormatException {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.getString((String)"TabWidthInvalidInut"));
            return false;
        }
        return true;
    }

    private void setErrorMessage(String string) {
        this.fcolumnTabWidth.setFocus();
        this.page.setErrorMessage(string);
        if (string != null) {
            Display.getDefault().beep();
        }
    }

    public boolean isPerformOk() {
        return true;
    }

    public void performOk() {
        String string;
        IPreferenceStore iPreferenceStore = this.page.getPreferenceStore();
        int n = this.fTextControls.size();
        int n2 = 0;
        while (n2 < n) {
            Text text = (Text)this.fTextControls.get(n2);
            string = (String)text.getData();
            if (string.equals(COLUMN_TABWIDTH_VALUE_KEY)) {
                iPreferenceStore.setValue(COLUMN_TABWIDTH_VALUE_KEY, text.getText());
                iPreferenceStore.setValue(TABWIDTH_VALUE_KEY, MIN_TAB_WIDTH);
            } else {
                iPreferenceStore.setValue(string, text.getText());
            }
            ++n2;
        }
        iPreferenceStore.setValue((String)this.tag16.getData(), this.tag16.getText());
        String string2 = this.tag16.getText();
        if (string2.trim().length() == 0) {
            this.defaultToAutoTag.setSelection(false);
        }
        iPreferenceStore.setValue((String)this.defaultToAutoTag.getData(), this.defaultToAutoTag.getSelection());
        int n3 = this.fReseredWord.getSelectionIndex();
        if (n3 >= 0) {
            string = this.fReseredWord.getItem(this.fReseredWord.getSelectionIndex());
            ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
            if (iCOBOLContributor != null) {
                ICOBOLLanguageModel iCOBOLLanguageModel = iCOBOLContributor.getCOBOLLanguageModel();
                iCOBOLLanguageModel.setReservedSet(string);
            } else {
                COBOLLanguageModel cOBOLLanguageModel = new COBOLLanguageModel();
                cOBOLLanguageModel.setReservedSet(string);
            }
            iPreferenceStore.setValue(RESERVED_WORD, string);
        }
    }

    public void dispose() {
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(REFERENCE_FORMAT, Messages.getString((String)"InitialReferenceFormat"));
        iPreferenceStore.setDefault(INITIAL_VALUE_KEY, Messages.getString((String)"InitialValue"));
        iPreferenceStore.setDefault(INCREMENTAL_VALUE_KEY, Messages.getString((String)"IncrementalValue"));
        iPreferenceStore.setDefault(RESERVED_WORD, "");
        iPreferenceStore.setDefault(TABWIDTH_VALUE_KEY, MIN_TAB_WIDTH);
        iPreferenceStore.setDefault(USE_SPACES_FOR_TABS, "TRUE");
        iPreferenceStore.setDefault(COLUMN_TABWIDTH_VALUE_KEY, DEFAULT_TAB_WIDTH);
    }
}

