/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.preferences;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.text.COBOLTextFactory;
import org.eclipse.cobol.ui.freeformat.COBOLFreeFormatSourceViewerConfiguration;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferenceBaseBlock;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferencePage;
import org.eclipse.cobol.ui.preferences.ColorEditor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class COBOLEditorPreferenceColorBlock
extends COBOLEditorPreferenceBaseBlock {
    private static final int COBOL_COMMENT_RED = 63;
    private static final int COBOL_COMMENT_GREEN = 127;
    private static final int COBOL_COMMENT_BLUE = 95;
    private static final int COBOL_IN_LINE_COMMENT_RED = 63;
    private static final int COBOL_IN_LINE_COMMENT_GREEN = 127;
    private static final int COBOL_IN_LINE_COMMENT_BLUE = 95;
    private static final int COBOL_RESERVED_WORD_RED = 23;
    private static final int COBOL_RESERVED_WORD_GREEN = 122;
    private static final int COBOL_RESERVED_WORD_BLUE = 170;
    private static final int COBOL_STRING_RED = 0;
    private static final int COBOL_STRING_GREEN = 0;
    private static final int COBOL_STRING_BLUE = 164;
    private static final int COBOL_DEFAULT_RED = 0;
    private static final int COBOL_DEFAULT_GREEN = 0;
    private static final int COBOL_DEFAULT_BLUE = 0;
    private static final int COBOL_FIGURATIVE_CONSTANT_RED = 128;
    private static final int COBOL_FIGURATIVE_CONSTANT_GREEN = 128;
    private static final int COBOL_FIGURATIVE_CONSTANT_BLUE = 64;
    private static final int COBOL_SPECIAL_REGISTER_RED = 255;
    private static final int COBOL_SPECIAL_REGISTER_GREEN = 0;
    private static final int COBOL_SPECIAL_REGISTER_BLUE = 128;
    private static final int COBOL_DATA_DICT_VARS_RED = 142;
    private static final int COBOL_DATA_DICT_VARS_GREEN = 78;
    private static final int COBOL_DATA_DICT_VARS_BLUE = 55;
    private static final int COBOL_SECTIONS_RED = 128;
    private static final int COBOL_SECTIONS_GREEN = 0;
    private static final int COBOL_SECTIONS_BLUE = 64;
    private static final int COBOL_PARAGRAPHS_RED = 215;
    private static final int COBOL_PARAGRAPHS_GREEN = 0;
    private static final int COBOL_PARAGRAPHS_BLUE = 0;
    private static final int WS_VARS_RED = 198;
    private static final int WS_VARS_GREEN = 136;
    private static final int WS_VARS_BLUE = 6;
    private Font fFont;
    private List fList;
    private static final int MARGIN_WIDTH = 15;
    private static final int STYLE_V_SPACING = 10;
    private static final int WIDTH_PIXELS = 65;
    private static final String STYLE = "_bold";
    private ColorEditor fColorEditor;
    private Button fBoldCheckBox;
    private COBOLTextFactory fCOBOLTextFactory;
    private PreferenceStore fColorStore = new PreferenceStore();
    private SourceViewer fPreviewViewer;
    private static String[][] fListModel;

    public COBOLEditorPreferenceColorBlock(COBOLEditorPreferencePage cOBOLEditorPreferencePage) {
        super(cOBOLEditorPreferencePage);
        try {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String string = iWorkspaceRoot.getPersistentProperty(OS2200ArchitectureConstant.DD_Plugin);
            fListModel = string != null && string.equals("True") ? this.setFListModelWithDD() : this.setFListModel();
        }
        catch (CoreException coreException) {
            fListModel = this.setFListModel();
            CBDTUiPlugin.logError(coreException.getMessage(), (Exception)((Object)coreException));
        }
    }

    private String[][] setFListModelWithDD() {
        return new String[][]{{Messages.getString((String)"listElement.LineComment"), "cobol_comment"}, {Messages.getString((String)"listElement.In-line_comment"), "cobol_in_line_comment"}, {Messages.getString((String)"listElement.Reserved_words"), "cobol_reserved_word"}, {Messages.getString((String)"listElement.Figurative_constants"), "cobol_figurative_constant"}, {Messages.getString((String)"listElement.Special_Register"), "cobol_special_register"}, {Messages.getString((String)"listElement.Strings"), "cobol_string"}, {Messages.getString((String)"listElement.Sections"), "cobol_sections"}, {Messages.getString((String)"listElement.Paragraphs"), "cobol_paragraphs"}, {Messages.getString((String)"listElement.Data-Dictionary_Vars"), "cobol_data_dict_vars"}, {Messages.getString((String)"listElement.WS_Vars"), "ws_vars"}, {Messages.getString((String)"listElement.Unreferenced_WS_Vars"), "unreferenced_ws_vars"}, {Messages.getString((String)"listElement.Others"), "cobol_default"}};
    }

    private String[][] setFListModel() {
        return new String[][]{{Messages.getString((String)"listElement.LineComment"), "cobol_comment"}, {Messages.getString((String)"listElement.In-line_comment"), "cobol_in_line_comment"}, {Messages.getString((String)"listElement.Reserved_words"), "cobol_reserved_word"}, {Messages.getString((String)"listElement.Figurative_constants"), "cobol_figurative_constant"}, {Messages.getString((String)"listElement.Special_Register"), "cobol_special_register"}, {Messages.getString((String)"listElement.Strings"), "cobol_string"}, {Messages.getString((String)"listElement.Sections"), "cobol_sections"}, {Messages.getString((String)"listElement.Paragraphs"), "cobol_paragraphs"}, {Messages.getString((String)"listElement.WS_Vars"), "ws_vars"}, {Messages.getString((String)"listElement.Unreferenced_WS_Vars"), "unreferenced_ws_vars"}, {Messages.getString((String)"listElement.Others"), "cobol_default"}};
    }

    public void dispose() {
        if (this.fCOBOLTextFactory != null) {
            this.fCOBOLTextFactory = null;
        }
    }

    public Control createBlock(Composite composite) {
        this.loadStore();
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(Messages.getString((String)"label.Colors"));
        label.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite3.setLayoutData((Object)gridData);
        this.fList = new List(composite3, 2564);
        this.fList.setFont(composite3.getFont());
        gridData = new GridData(1808);
        this.fList.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        composite4.setFont(composite3.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 1;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(1808));
        Composite composite5 = new Composite(composite4, 0);
        composite5.setFont(composite4.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        composite5.setLayout((Layout)gridLayout);
        label = new Label(composite5, 16384);
        label.setFont(composite5.getFont());
        label.setText(Messages.getString((String)"label.Foreground"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.fColorEditor = new ColorEditor(composite5);
        Button button = this.fColorEditor.getButton();
        button.setFont(composite5.getFont());
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        button.setLayoutData((Object)gridData);
        this.fBoldCheckBox = new Button(composite4, 32);
        this.fBoldCheckBox.setFont(composite4.getFont());
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        this.fBoldCheckBox.setText(Messages.getString((String)"label.Bold"));
        this.fBoldCheckBox.setLayoutData((Object)gridData);
        label = new Label(composite2, 16384);
        label.setFont(composite4.getFont());
        label.setText(Messages.getString((String)"label.Preview"));
        label.setLayoutData((Object)new GridData(768));
        Control control = this.createPreviewer(composite2);
        gridData = new GridData(1808);
        gridData.widthHint = this.page.convertWidthInCharsToPixels(65);
        gridData.heightHint = this.page.convertHeightInCharsToPixels(8);
        control.setLayoutData((Object)gridData);
        this.fList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLEditorPreferenceColorBlock.this.handleListSelection((IPreferenceStore)COBOLEditorPreferenceColorBlock.this.fColorStore);
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = COBOLEditorPreferenceColorBlock.this.fList.getSelectionIndex();
                String string = fListModel[n][1];
                PreferenceConverter.setValue((IPreferenceStore)COBOLEditorPreferenceColorBlock.this.fColorStore, (String)string, (RGB)COBOLEditorPreferenceColorBlock.this.fColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = COBOLEditorPreferenceColorBlock.this.fList.getSelectionIndex();
                String string = fListModel[n][1];
                COBOLEditorPreferenceColorBlock.this.fColorStore.setValue(String.valueOf(string) + COBOLEditorPreferenceColorBlock.STYLE, COBOLEditorPreferenceColorBlock.this.fBoldCheckBox.getSelection());
            }
        });
        return composite2;
    }

    private Control createPreviewer(Composite composite) {
        this.fCOBOLTextFactory = new COBOLTextFactory((IPreferenceStore)this.fColorStore);
        this.fCOBOLTextFactory.setFormat("FREE");
        this.fPreviewViewer = new SourceViewer(composite, null, 2816);
        this.fPreviewViewer.configure((SourceViewerConfiguration)new COBOLFreeFormatSourceViewerConfiguration(this.fCOBOLTextFactory, null));
        this.fPreviewViewer.setEditable(false);
        String string = this.loadPreviewContentFromFile(Messages.getString((String)"fileName"));
        Document document = new Document(string);
        this.fPreviewViewer.setDocument((IDocument)document);
        this.fColorStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                COBOLEditorPreferenceColorBlock.this.fCOBOLTextFactory.adaptToPreferenceChange(propertyChangeEvent);
                COBOLEditorPreferenceColorBlock.this.fPreviewViewer.invalidateTextPresentation();
            }
        });
        this.setViewerFont((ISourceViewer)this.fPreviewViewer);
        return this.fPreviewViewer.getControl();
    }

    private void handleListSelection(IPreferenceStore iPreferenceStore) {
        int n = this.fList.getSelectionIndex();
        String string = fListModel[n][1];
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        this.fColorEditor.setColorValue(rGB);
        this.fBoldCheckBox.setSelection(iPreferenceStore.getBoolean(String.valueOf(string) + STYLE));
    }

    private void setViewerFont(ISourceViewer iSourceViewer) {
        IPreferenceStore iPreferenceStore = CBDTUiPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore != null) {
            FontData fontData = null;
            fontData = iPreferenceStore.contains("org.eclipse.jface.textfont") && !iPreferenceStore.isDefault("org.eclipse.jface.textfont") ? PreferenceConverter.getFontData((IPreferenceStore)iPreferenceStore, (String)"org.eclipse.jface.textfont") : PreferenceConverter.getDefaultFontData((IPreferenceStore)iPreferenceStore, (String)"org.eclipse.jface.textfont");
            if (fontData != null) {
                Font font = new Font((Device)this.page.getShell().getDisplay(), fontData);
                if (iSourceViewer.getTextWidget() != null) {
                    try {
                        iSourceViewer.getTextWidget().setFont(font);
                        if (this.fFont != null) {
                            this.fFont.dispose();
                            this.fFont = null;
                        }
                        this.fFont = font;
                    }
                    catch (Exception exception) {
                        exception.getMessage();
                        return;
                    }
                }
                return;
            }
        }
        iSourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
    }

    private String loadPreviewContentFromFile(String string) {
        StringBuffer stringBuffer;
        block15: {
            String string2 = "";
            String string3 = System.getProperty("line.separator");
            stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(string)));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string2);
                        stringBuffer.append(string3);
                    }
                }
                catch (IOException iOException) {
                    CBDTUiPlugin.logError(iOException);
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {
                            CBDTUiPlugin.logError(iOException2);
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        CBDTUiPlugin.logError(iOException);
                    }
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    CBDTUiPlugin.logError(iOException);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void loadStore() {
        IPreferenceStore iPreferenceStore = this.page.getPreferenceStore();
        int n = 0;
        while (n < fListModel.length) {
            PreferenceConverter.setValue((IPreferenceStore)this.fColorStore, (String)fListModel[n][1], (RGB)PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)fListModel[n][1]));
            PreferenceConverter.setDefault((IPreferenceStore)this.fColorStore, (String)fListModel[n][1], (RGB)PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)fListModel[n][1]));
            this.fColorStore.setDefault(String.valueOf(fListModel[n][1]) + STYLE, iPreferenceStore.getDefaultBoolean(String.valueOf(fListModel[n][1]) + STYLE));
            this.fColorStore.setValue(String.valueOf(fListModel[n][1]) + STYLE, iPreferenceStore.getBoolean(String.valueOf(fListModel[n][1]) + STYLE));
            ++n;
        }
    }

    public void initialize() {
        int n = 0;
        n = fListModel.length;
        int n2 = 0;
        while (n2 < n) {
            this.fList.add(fListModel[n2][0]);
            ++n2;
        }
        this.fList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                COBOLEditorPreferenceColorBlock.this.fList.select(0);
                COBOLEditorPreferenceColorBlock.this.handleListSelection((IPreferenceStore)COBOLEditorPreferenceColorBlock.this.fColorStore);
            }
        });
    }

    public void performDefaults() {
        int n = fListModel.length;
        int n2 = 0;
        while (n2 < n) {
            this.fColorStore.setToDefault(fListModel[n2][1]);
            this.fColorStore.setToDefault(String.valueOf(fListModel[n2][1]) + STYLE);
            ++n2;
        }
        this.fList.select(0);
        this.handleListSelection((IPreferenceStore)this.fColorStore);
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public boolean isPerformOk() {
        return true;
    }

    public void performOk() {
        IPreferenceStore iPreferenceStore = this.page.getPreferenceStore();
        int n = 0;
        while (n < fListModel.length) {
            if (this.fColorStore.isDefault(fListModel[n][1])) {
                if (!iPreferenceStore.isDefault(fListModel[n][1])) {
                    iPreferenceStore.setToDefault(fListModel[n][1]);
                }
            } else {
                PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)fListModel[n][1], (RGB)PreferenceConverter.getColor((IPreferenceStore)this.fColorStore, (String)fListModel[n][1]));
            }
            if (this.fColorStore.isDefault(String.valueOf(fListModel[n][1]) + STYLE)) {
                if (!iPreferenceStore.isDefault(String.valueOf(fListModel[n][1]) + STYLE)) {
                    iPreferenceStore.setToDefault(String.valueOf(fListModel[n][1]) + STYLE);
                }
            } else {
                iPreferenceStore.setValue(String.valueOf(fListModel[n][1]) + STYLE, this.fColorStore.getBoolean(String.valueOf(fListModel[n][1]) + STYLE));
            }
            ++n;
        }
        this.setViewerFont((ISourceViewer)this.fPreviewViewer);
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_comment", (RGB)new RGB(63, 127, 95));
        iPreferenceStore.setDefault("cobol_comment_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_in_line_comment", (RGB)new RGB(63, 127, 95));
        iPreferenceStore.setDefault("cobol_in_line_comment_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_reserved_word", (RGB)new RGB(23, 122, 170));
        iPreferenceStore.setDefault("cobol_reserved_word_bold", true);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_string", (RGB)new RGB(0, 0, 164));
        iPreferenceStore.setDefault("cobol_string_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_default", (RGB)new RGB(0, 0, 0));
        iPreferenceStore.setDefault("cobol_default_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_figurative_constant", (RGB)new RGB(128, 128, 64));
        iPreferenceStore.setDefault("cobol_figurative_constant_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_special_register", (RGB)new RGB(255, 0, 128));
        iPreferenceStore.setDefault("cobol_special_register_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_data_dict_vars", (RGB)new RGB(142, 78, 55));
        iPreferenceStore.setDefault("cobol_data_dict_vars_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_sections", (RGB)new RGB(128, 0, 64));
        iPreferenceStore.setDefault("cobol_sections_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"cobol_paragraphs", (RGB)new RGB(215, 0, 0));
        iPreferenceStore.setDefault("cobol_paragraphs_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"ws_vars", (RGB)new RGB(198, 136, 6));
        iPreferenceStore.setDefault("ws_vars_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"unreferenced_ws_vars", (RGB)new RGB(198, 136, 6));
        iPreferenceStore.setDefault("unreferenced_ws_vars_bold", true);
    }
}

