/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.preferences;

import com.unisys.os2200.i18nSupport.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.ant.AntScriptGenerator;
import org.eclipse.cobol.core.registry.internal.ICOBOLContributorDescriptor;
import org.eclipse.cobol.core.registry.internal.ICOBOLContributorRegistry;
import org.eclipse.cobol.core.util.CoreCommonUtility;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class COBOLBasePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer fTableViewer;
    private Contributor[] fContributors;

    public COBOLBasePreferencePage() {
        super(1);
        this.setPreferenceStore(CBDTUiPlugin.getDefault().getPreferenceStore());
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault("COBOL_PLUGIN_EXAMPLE", true);
        String string = "";
        ICOBOLContributorRegistry iCOBOLContributorRegistry = CorePlugin.getDefault().getCOBOLContributorRegistry();
        ICOBOLContributorDescriptor[] iCOBOLContributorDescriptorArray = iCOBOLContributorRegistry.getCOBOLContributors();
        if (iCOBOLContributorDescriptorArray != null && iCOBOLContributorDescriptorArray.length != 0) {
            string = iCOBOLContributorDescriptorArray[iCOBOLContributorDescriptorArray.length - 1].getProviderID();
        }
        iPreferenceStore.setDefault("COBOLContributor", string);
        CorePlugin.getDefault().getPreferenceStore().setDefault("COBOLContributor", string);
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        this.noDefaultAndApplyButton();
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setFont(composite.getFont());
        label.setText(Messages.getString((String)"COBOLBasePreferencePage.table.lable"));
        label.setLayoutData((Object)new GridData(768));
        this.createCheckBoxTable(composite2);
        this.populateTable();
        return composite2;
    }

    private void createCheckBoxTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2816);
        this.fTableViewer.getControl().setFont(composite.getFont());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 350;
        gridData.heightHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)gridData);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((Contributor)object).getName();
            }
        });
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return (Contributor[])object;
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Contributor contributor = (Contributor)checkStateChangedEvent.getElement();
                COBOLBasePreferencePage.this.selectContributor(contributor.getId());
                COBOLBasePreferencePage.this.fTableViewer.setSelection((ISelection)new StructuredSelection(checkStateChangedEvent.getElement()));
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cobol.ui.vendor_selection_pref_page");
    }

    private void populateTable() {
        Contributor[] contributorArray = this.getContributors();
        if (contributorArray != null) {
            this.fTableViewer.setInput((Object)contributorArray);
            String string = this.getPreferenceStore().getString("COBOLContributor");
            if (string == null || string != null && string.length() == 0) {
                string = contributorArray[contributorArray.length - 1].id;
                this.getPreferenceStore().setValue("COBOLContributor", string);
            }
            this.selectContributor(string);
        }
    }

    private Contributor[] getContributors() {
        ICOBOLContributorDescriptor[] iCOBOLContributorDescriptorArray;
        ICOBOLContributorRegistry iCOBOLContributorRegistry;
        if (this.fContributors == null && (iCOBOLContributorRegistry = CorePlugin.getDefault().getCOBOLContributorRegistry()) != null && (iCOBOLContributorDescriptorArray = iCOBOLContributorRegistry.getCOBOLContributors()) != null && iCOBOLContributorDescriptorArray.length > 0) {
            this.fContributors = new Contributor[iCOBOLContributorDescriptorArray.length];
            int n = 0;
            while (n < iCOBOLContributorDescriptorArray.length) {
                Contributor contributor;
                ICOBOLContributorDescriptor iCOBOLContributorDescriptor = iCOBOLContributorDescriptorArray[n];
                String string = iCOBOLContributorDescriptor.getId();
                String string2 = iCOBOLContributorDescriptor.getLabel();
                this.fContributors[n] = contributor = new Contributor(string, string2);
                ++n;
            }
        }
        return this.fContributors;
    }

    private void selectContributor(String string) {
        if (this.fContributors != null) {
            int n = 0;
            while (n < this.fContributors.length) {
                Contributor contributor = this.fContributors[n];
                if (contributor.getId().equals(string)) {
                    this.fTableViewer.setChecked((Object)contributor, true);
                } else {
                    this.fTableViewer.setChecked((Object)contributor, false);
                }
                ++n;
            }
        }
    }

    protected void performDefaults() {
        String string = this.getPreferenceStore().getDefaultString("COBOLContributor");
        this.selectContributor(string);
    }

    public boolean performOk() {
        Object object;
        int n = this.fTableViewer.getCheckedElements().length;
        if (n != 0) {
            object = this.fTableViewer.getCheckedElements();
            int n2 = 0;
            while (n2 < n) {
                Contributor contributor = (Contributor)object[n2];
                if (this.fTableViewer.getChecked((Object)contributor)) {
                    this.getPreferenceStore().setValue("COBOLContributor", contributor.getId());
                    CorePlugin.getDefault().getPreferenceStore().setValue("COBOLContributor", contributor.getId());
                }
                ++n2;
            }
        }
        object = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
                boolean bl = iWorkspaceDescription.isAutoBuilding();
                if (bl) {
                    iWorkspaceDescription.setAutoBuilding(false);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
                    }
                    catch (CoreException coreException) {
                        CBDTUiPlugin.logError((Exception)((Object)coreException));
                    }
                }
                COBOLBasePreferencePage.this.updateProjectDescription();
                if (bl) {
                    iWorkspaceDescription.setAutoBuilding(true);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
                    }
                    catch (CoreException coreException) {
                        CBDTUiPlugin.logError((Exception)((Object)coreException));
                    }
                }
                try {
                    CBDTUiPlugin.getWorkspace().getRoot().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    CBDTUiPlugin.getWorkspace().getRoot().touch((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
            }
        };
        try {
            CBDTUiPlugin.getActiveWorkbenchWindow().run(false, false, (IRunnableWithProgress)object);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
        }
        return true;
    }

    private void updateProjectDescription() {
        IProject[] iProjectArray = CBDTUiPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            try {
                if (!iProjectArray[n].getDescription().hasNature(this.getContributorNatureId()) && iProjectArray[n].getDescription().hasNature("org.eclipse.cobol.core.COBOLNature")) {
                    String[] stringArray = new String[]{"org.eclipse.cobol.core.COBOLNature", this.getContributorNatureId()};
                    IProjectDescription iProjectDescription = iProjectArray[n].getDescription();
                    iProjectDescription.setNatureIds(stringArray);
                    CoreCommonUtility.setProjectId((String)this.getContributorTargettype());
                    iProjectArray[n].setDescription(iProjectDescription, null);
                    AntScriptGenerator antScriptGenerator = new AntScriptGenerator(iProjectArray[n]);
                    antScriptGenerator.run();
                }
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
            ++n;
        }
    }

    private String getContributorNatureId() {
        String string = CorePlugin.getDefault().getPreferenceStore().getString("COBOLContributor");
        ICOBOLContributorRegistry iCOBOLContributorRegistry = CorePlugin.getDefault().getCOBOLContributorRegistry();
        ICOBOLContributorDescriptor[] iCOBOLContributorDescriptorArray = iCOBOLContributorRegistry.getCOBOLContributors();
        int n = 0;
        while (iCOBOLContributorDescriptorArray != null && n < iCOBOLContributorDescriptorArray.length) {
            if (iCOBOLContributorDescriptorArray[n].getProviderID().equalsIgnoreCase(string)) {
                return iCOBOLContributorDescriptorArray[n].getConfigurationElement().getAttribute("nature");
            }
            ++n;
        }
        return null;
    }

    private String getContributorTargettype() {
        String string = CorePlugin.getDefault().getPreferenceStore().getString("COBOLContributor");
        ICOBOLContributorRegistry iCOBOLContributorRegistry = CorePlugin.getDefault().getCOBOLContributorRegistry();
        ICOBOLContributorDescriptor[] iCOBOLContributorDescriptorArray = iCOBOLContributorRegistry.getCOBOLContributors();
        int n = 0;
        while (iCOBOLContributorDescriptorArray != null && n < iCOBOLContributorDescriptorArray.length) {
            if (iCOBOLContributorDescriptorArray[n].getProviderID().equalsIgnoreCase(string)) {
                return iCOBOLContributorDescriptorArray[n].getConfigurationElement().getAttribute("targettype");
            }
            ++n;
        }
        return null;
    }

    protected void createFieldEditors() {
    }

    public class Contributor {
        String id;
        String name;

        public Contributor(String string, String string2) {
            this.id = string;
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }
}

