/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.freeformat;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.views.outlineview.COBOLContentOutlinePage;
import org.eclipse.cobol.ui.views.outlineview.Element;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class COBOLHyperLink
implements IHyperlink {
    private final IRegion fRegion;
    private final String fURLString;
    private boolean factivate;
    private COBOLEditor cblEdit = null;

    public COBOLHyperLink(IRegion iRegion, String string, boolean bl) {
        this.fRegion = iRegion;
        this.fURLString = string;
        this.factivate = bl;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return this.fURLString;
    }

    public void open() {
        if (this.isActivated()) {
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            this.cblEdit = (COBOLEditor)iWorkbenchPage.getActiveEditor();
            StyledText styledText = this.cblEdit.getCurrentSourceViewer().getTextWidget();
            if (this.cblEdit.isCopyProcDeclration(styledText)) {
                String string = this.cblEdit.getCursorString(styledText);
                if (string.endsWith(".")) {
                    string = string.substring(0, string.length() - 1);
                }
                this.cblEdit.openCopyProcs(string);
            } else {
                int n = this.getInfo(this.fURLString);
                this.cblEdit.processLineNo(n);
            }
        }
    }

    public int getInfo(String string) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.cblEdit = (COBOLEditor)iWorkbenchPage.getActiveEditor();
        COBOLContentOutlinePage cOBOLContentOutlinePage = this.cblEdit.getOutlinePage();
        String string2 = this.fURLString;
        if (string2 == null) {
            return -1;
        }
        if (cOBOLContentOutlinePage == null || this.cblEdit.isDirty()) {
            this.cblEdit.getAdapter(IContentOutlinePage.class);
            cOBOLContentOutlinePage = this.cblEdit.getOutlinePage();
        }
        if (cOBOLContentOutlinePage != null) {
            HashMap hashMap = cOBOLContentOutlinePage.getCOBOLParser().getElementLineMap();
            Set set = hashMap.entrySet();
            for (Map.Entry entry : set) {
                Element element = (Element)entry.getValue();
                if (!string2.equalsIgnoreCase(element.getData())) continue;
                Integer n = (Integer)entry.getKey();
                return n;
            }
        }
        return -1;
    }

    public boolean isActivated() {
        return this.factivate;
    }

    public void setActivated(boolean bl) {
        this.factivate = bl;
    }
}

