/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.freeformat;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.COBOLAbstractUndoManager;
import org.eclipse.cobol.ui.common.EventData;
import org.eclipse.cobol.ui.common.TextUtilities;
import org.eclipse.cobol.ui.editor.COBOLSourceViewer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.custom.StyledText;

public class COBOLFreeFormatUndoManager
extends COBOLAbstractUndoManager {
    private StringBuffer fTextBuffer = new StringBuffer();
    private StringBuffer fPreservedTextBuffer = new StringBuffer();
    private PretendedUndoManagerState fPretendedState = new PretendedUndoManagerState();
    private boolean fInserting = false;
    private boolean fDeleting = false;
    private boolean fOverwriting = false;
    private boolean fFoldingIntoCompoundChange = false;
    private TextCommand fCurrent;
    private TextCommand fPreviousDelete;
    private int fCommandCounter = -1;
    int start = -1;
    int fEndChar = -1;
    String deltaText = "";
    String oldText = "";

    public COBOLFreeFormatUndoManager(int n) {
        this.setMaximalUndoLevel(n);
        this.fCurrentFormat = "FREE";
    }

    @Override
    public void beginCompoundChange() {
        this.fFoldingIntoCompoundChange = true;
        this.commit();
    }

    @Override
    public void endCompoundChange() {
        this.fFoldingIntoCompoundChange = false;
        this.commit();
    }

    private void internalRedo() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            ++this.fCommandCounter;
            TextCommand textCommand = (TextCommand)this.fCommandStack.get(this.fCommandCounter);
            this.listenToTextChanges(false);
            this.setUndoing(true);
            textCommand.redo(styledText);
            this.setUndoing(false);
            this.listenToTextChanges(true);
            this.fCurrent = new TextCommand();
        }
    }

    private void internalUndo() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            TextCommand textCommand = (TextCommand)this.fCommandStack.get(this.fCommandCounter);
            --this.fCommandCounter;
            this.listenToTextChanges(false);
            this.setUndoing(true);
            textCommand.undo(styledText);
            this.setUndoing(false);
            this.listenToTextChanges(true);
            this.fCurrent = new TextCommand();
        }
    }

    private void setUndoing(boolean bl) {
        if (this.fTextViewer instanceof COBOLSourceViewer) {
            COBOLSourceViewer cOBOLSourceViewer = (COBOLSourceViewer)this.fTextViewer;
            cOBOLSourceViewer.setUndoing(bl);
        }
    }

    private boolean isWhitespaceText(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
        int n = TextUtilities.startsWith(stringArray, string);
        if (n > -1) {
            int n2 = string.length();
            int n3 = stringArray[n].length();
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c != ' ' && c != '\t') {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    private PretendedUndoManagerState pretendCommit() {
        if (this.fCurrent.fStart < 0) {
            this.fPretendedState.stackSize = this.fCommandStack.size();
            this.fPretendedState.cmdCounter = this.fCommandCounter;
        } else {
            int n = Math.max(this.fCommandCounter, 0) + 1;
            if (n > this.fUndoLevel) {
                n -= this.fUndoLevel;
            }
            this.fPretendedState.stackSize = n;
            this.fPretendedState.cmdCounter = n - 1;
        }
        return this.fPretendedState;
    }

    @Override
    protected void processTextEvent(TextEvent textEvent) {
        if (!this.fCurrentFormat.equals("FREE")) {
            return;
        }
        if (textEvent.getDocumentEvent() == null) {
            return;
        }
        this.start = textEvent.getOffset();
        int n = textEvent.getOffset() + textEvent.getLength();
        String string = textEvent.getText();
        this.oldText = textEvent.getReplacedText();
        this.deltaText = string;
        if (string == null) {
            string = "";
        }
        if (this.oldText == null) {
            this.oldText = "";
        }
        int n2 = string.length();
        if (this.start == n) {
            if (n2 == 1 || this.isWhitespaceText(string)) {
                if (!this.fInserting || this.start != this.fCurrent.fStart + this.fTextBuffer.length()) {
                    this.commit();
                    this.fInserting = true;
                }
                if (this.fCurrent.fStart < 0) {
                    this.fCurrent.fStart = this.fCurrent.fEnd = this.start;
                }
                if (n2 > 0) {
                    this.fTextBuffer.append(string);
                }
                this.updateInsertOperationType(string, n2);
            } else if (n2 > 0) {
                this.commit();
                this.fCurrent.fStart = this.fCurrent.fEnd = this.start;
                this.fTextBuffer.append(string);
                this.fOperationType = EventData.PASTE;
            }
        } else if (n2 == 0) {
            n2 = this.oldText.length();
            String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
            if (n2 == 1 || TextUtilities.equals(stringArray, this.oldText) > -1) {
                if (this.fPreviousDelete.fStart == this.start && this.fPreviousDelete.fEnd == n) {
                    if (this.fCurrent.fStart == n && this.fCurrent.fEnd == this.start) {
                        this.fCurrent.fStart = this.start;
                        this.fCurrent.fEnd = n;
                    }
                    this.fPreservedTextBuffer.append(this.oldText);
                    ++this.fCurrent.fEnd;
                } else if (this.fPreviousDelete.fStart == n) {
                    this.fPreservedTextBuffer.insert(0, this.oldText);
                    this.fCurrent.fStart = this.start;
                } else {
                    this.commit();
                    this.fDeleting = true;
                    this.fPreservedTextBuffer.append(this.oldText);
                    this.fCurrent.fStart = this.start;
                    this.fCurrent.fEnd = n;
                }
                this.fPreviousDelete.set(this.start, n);
                this.fOperationType = EventData.DELETE;
            } else if (n2 > 0) {
                this.commit();
                this.fCurrent.fStart = this.start;
                this.fCurrent.fEnd = n;
                this.fPreservedTextBuffer.append(this.oldText);
                this.fOperationType = EventData.SELECTDELETE;
            }
        } else {
            this.fOperationType = EventData.REPLACE;
            if (n2 == 1) {
                n2 = this.oldText.length();
                String[] stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters();
                if (n2 == 1 || TextUtilities.equals(stringArray, this.oldText) > -1) {
                    if (!this.fOverwriting || this.start != this.fCurrent.fEnd) {
                        this.commit();
                        this.fOverwriting = true;
                    }
                    if (this.fCurrent.fStart < 0) {
                        this.fCurrent.fStart = this.start;
                    }
                    this.fCurrent.fEnd = n;
                    this.fTextBuffer.append(string);
                    this.fPreservedTextBuffer.append(this.oldText);
                    super.processTextEvent(textEvent);
                    return;
                }
            }
            this.commit();
            this.fCurrent.fStart = this.start;
            this.fCurrent.fEnd = n;
            this.fTextBuffer.append(string);
            this.fPreservedTextBuffer.append(this.oldText);
        }
        this.fEndChar = n;
        super.processTextEvent(textEvent);
    }

    @Override
    public void connect(ITextViewer iTextViewer) {
        if (this.fTextViewer == null) {
            super.connect(iTextViewer);
            this.fCurrent = new TextCommand();
            this.fPreviousDelete = new TextCommand();
        }
    }

    @Override
    public void disconnect() {
        if (this.fTextViewer != null) {
            super.disconnect();
            this.fCurrent = null;
            this.fTextBuffer = null;
            this.fPreservedTextBuffer = null;
        }
    }

    @Override
    public void reset() {
        if (this.fCommandStack != null) {
            this.fCommandStack.clear();
        }
        this.fCommandCounter = -1;
        if (this.fCurrent != null) {
            this.fCurrent.reinitialize();
        }
        this.fFoldingIntoCompoundChange = false;
        this.fInserting = false;
        this.fDeleting = false;
        this.fOverwriting = false;
        if (this.fTextBuffer != null) {
            this.fTextBuffer.setLength(0);
        }
        this.fPreservedTextBuffer.setLength(0);
    }

    @Override
    public boolean redoable() {
        if (this.fCommandStack != null) {
            PretendedUndoManagerState pretendedUndoManagerState = this.pretendCommit();
            return pretendedUndoManagerState.cmdCounter + 1 >= 0 && pretendedUndoManagerState.cmdCounter + 1 < pretendedUndoManagerState.stackSize;
        }
        return false;
    }

    @Override
    public boolean undoable() {
        if (this.fCommandStack != null) {
            PretendedUndoManagerState pretendedUndoManagerState = this.pretendCommit();
            return pretendedUndoManagerState.cmdCounter >= 0 && pretendedUndoManagerState.cmdCounter < pretendedUndoManagerState.stackSize;
        }
        return false;
    }

    @Override
    public void redo() {
        if (this.redoable()) {
            this.commit();
            this.internalRedo();
        }
    }

    @Override
    public void undo() {
        if (this.undoable()) {
            this.commit();
            this.internalUndo();
        }
    }

    @Override
    public void commit() {
        try {
            this.fInserting = false;
            this.fDeleting = false;
            this.fOverwriting = false;
            this.fPreviousDelete.reinitialize();
            this.fCurrent.commit();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    @Override
    public String getCurrentText() {
        return this.fTextBuffer.toString();
    }

    @Override
    public int getEndPosition() {
        return this.fEndChar;
    }

    @Override
    public String getPrevText() {
        return this.oldText;
    }

    @Override
    public int getStartPosition() {
        return this.start;
    }

    @Override
    public String getDeltaText() {
        return this.deltaText;
    }

    class CompoundTextCommand
    extends TextCommand {
        private List fCommands;

        CompoundTextCommand() {
            this.fCommands = new ArrayList();
        }

        protected void add(TextCommand textCommand) {
            this.fCommands.add(textCommand);
        }

        @Override
        protected void undo(StyledText styledText) {
            ListIterator listIterator = this.fCommands.listIterator(this.fCommands.size());
            while (listIterator.hasPrevious()) {
                TextCommand textCommand = (TextCommand)listIterator.previous();
                textCommand.undo(styledText);
            }
        }

        @Override
        protected void redo(StyledText styledText) {
            ListIterator listIterator = this.fCommands.listIterator();
            while (listIterator.hasNext()) {
                TextCommand textCommand = (TextCommand)listIterator.next();
                textCommand.redo(styledText);
            }
        }

        @Override
        protected void updateCommandStack() {
            TextCommand textCommand = new TextCommand();
            textCommand.fStart = this.fStart;
            textCommand.fEnd = this.fEnd;
            textCommand.fText = this.fText;
            textCommand.fPreservedText = this.fPreservedText;
            this.add(textCommand);
            if (!COBOLFreeFormatUndoManager.this.fFoldingIntoCompoundChange) {
                super.updateCommandStack();
            }
        }

        @Override
        protected TextCommand createCurrent() {
            if (!COBOLFreeFormatUndoManager.this.fFoldingIntoCompoundChange) {
                return new TextCommand();
            }
            this.reinitialize();
            return this;
        }
    }

    class PretendedUndoManagerState {
        protected int cmdCounter = -1;
        protected int stackSize = -1;

        PretendedUndoManagerState() {
        }
    }

    class TextCommand {
        protected int fStart = -1;
        protected int fEnd = -1;
        protected String fText;
        protected String fPreservedText;

        TextCommand() {
        }

        protected void reinitialize() {
            this.fEnd = -1;
            this.fStart = -1;
            this.fPreservedText = null;
            this.fText = null;
        }

        protected void set(int n, int n2) {
            this.fStart = n;
            this.fEnd = n2;
            this.fText = null;
            this.fPreservedText = null;
        }

        protected void undo(StyledText styledText) {
            styledText.replaceTextRange(this.fStart, this.fText.length(), this.fPreservedText);
            int n = this.fPreservedText == null ? 0 : this.fPreservedText.length();
            styledText.setSelectionRange(this.fStart, n);
            styledText.showSelection();
            COBOLFreeFormatUndoManager.this.fTextViewer.setSelectedRange(this.fStart, n);
            COBOLFreeFormatUndoManager.this.start = this.fStart;
            COBOLFreeFormatUndoManager.this.fEndChar = this.fStart + this.fText.length();
            COBOLFreeFormatUndoManager.this.deltaText = this.fPreservedText;
            COBOLFreeFormatUndoManager.this.oldText = this.fText;
            COBOLFreeFormatUndoManager.this.fOperationType = EventData.UNDO;
            COBOLFreeFormatUndoManager.this.updateAllViews();
        }

        protected void redo(StyledText styledText) {
            styledText.replaceTextRange(this.fStart, this.fEnd - this.fStart, this.fText);
            int n = this.fText == null ? 0 : this.fText.length();
            styledText.setSelectionRange(this.fStart, n);
            styledText.showSelection();
            COBOLFreeFormatUndoManager.this.fTextViewer.setSelectedRange(this.fStart, n);
            COBOLFreeFormatUndoManager.this.start = this.fStart;
            COBOLFreeFormatUndoManager.this.fEndChar = this.fEnd;
            COBOLFreeFormatUndoManager.this.deltaText = this.fText;
            COBOLFreeFormatUndoManager.this.oldText = this.fPreservedText;
            COBOLFreeFormatUndoManager.this.fOperationType = EventData.REDO;
            COBOLFreeFormatUndoManager.this.updateAllViews();
        }

        protected void updateCommandStack() {
            int n = COBOLFreeFormatUndoManager.this.fCommandStack.size();
            int n2 = COBOLFreeFormatUndoManager.this.fCommandCounter + 1;
            while (n2 < n) {
                COBOLFreeFormatUndoManager.this.fCommandStack.remove(COBOLFreeFormatUndoManager.this.fCommandCounter + 1);
                ++n2;
            }
            COBOLFreeFormatUndoManager.this.fCommandStack.add(this);
            while (COBOLFreeFormatUndoManager.this.fCommandStack.size() > COBOLFreeFormatUndoManager.this.fUndoLevel) {
                COBOLFreeFormatUndoManager.this.fCommandStack.remove(0);
            }
            COBOLFreeFormatUndoManager.this.fCommandCounter = COBOLFreeFormatUndoManager.this.fCommandStack.size() - 1;
        }

        protected TextCommand createCurrent() {
            return COBOLFreeFormatUndoManager.this.fFoldingIntoCompoundChange ? new CompoundTextCommand() : new TextCommand();
        }

        protected void commit() {
            if (this.fStart < 0) {
                this.reinitialize();
            } else {
                this.fText = COBOLFreeFormatUndoManager.this.fTextBuffer.toString();
                COBOLFreeFormatUndoManager.this.fTextBuffer.setLength(0);
                this.fPreservedText = COBOLFreeFormatUndoManager.this.fPreservedTextBuffer.toString();
                COBOLFreeFormatUndoManager.this.fPreservedTextBuffer.setLength(0);
                this.updateCommandStack();
            }
            COBOLFreeFormatUndoManager.this.fCurrent = this.createCurrent();
        }
    }
}

