/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.freeformat;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.MemChecker;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200ProjectUpdate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.COBOLBaseDocumentProvider;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class COBOLFreeFormatDocumentProvider
extends COBOLBaseDocumentProvider {
    private String encode = null;
    private String fileNameforProgress;
    private IFile file = null;
    String path = null;
    private IEditorInput editorInput;
    private boolean readOnly;
    private static final String QUALIFIED_FILE_STATUS_RESTORE = "fileStatus";
    private static final String CHARSET_UTF_16 = "UTF-16";
    private static final String CHARSET_UTF_16LE = "UTF-16LE";
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String CR = "\r";
    private static final String TAB_CHAR = "\t";
    private static final String ONE_SPACE = " ";
    private static final String FOUR_SPACES = "    ";

    public void shutdown() {
        try {
            Iterator iterator = this.getConnectedElements();
            while (iterator.hasNext()) {
                this.disconnect(iterator.next());
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    ResourceStatus remakeStatus(ResourceStatus resourceStatus, IProject iProject) {
        int n;
        String string;
        String string2 = resourceStatus.getMessage();
        if (string2.indexOf("File not found") >= 0 && (string = this.getWorkFile(iProject)) != null && (n = string2.lastIndexOf("\\")) > 0) {
            String string3 = string2.substring(n + 1);
            if ((string3 = string3.trim()).endsWith(".")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string3 = string3.replace(".", "/");
            ResourceStatus resourceStatus2 = new ResourceStatus(271, "Cannot connect to element " + string3 + " in " + string);
            return resourceStatus2;
        }
        return resourceStatus;
    }

    String getWorkFile(IProject iProject) {
        if (iProject != null && iProject.isOpen()) {
            try {
                if (iProject.getNature("com.unisys.tde.core.OS2200") != null) {
                    String string;
                    Preferences preferences = Platform.getPreferencesService().getRootNode().node("project");
                    preferences = preferences.nodeExists(string = String.valueOf(iProject.getName()) + '/' + "org.eclipse.core.resources") ? preferences.node(string) : null;
                    preferences = preferences.node("workFile");
                    String string2 = preferences.get("<project>", null);
                    return string2;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
            catch (BackingStoreException backingStoreException) {
                return null;
            }
        }
        return null;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (object instanceof IFileEditorInput) {
            Object object2;
            IFile iFile;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            this.file = iFile = iFileEditorInput.getFile();
            IProject iProject = iFile.getProject();
            try {
                this.refreshFile(iFileEditorInput.getFile());
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, Messages.getString((String)"FileDocumentProvider_createElementInfo"));
            }
            IDocument iDocument = null;
            IStatus iStatus = null;
            try {
                if (((IFileEditorInput)object).exists()) {
                    iDocument = this.createDocument(object);
                }
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, Messages.getString((String)"FileDocumentProvider_createElementInfo"));
                iStatus = coreException.getStatus();
                if (iStatus instanceof ResourceStatus && iStatus.getCode() == 271) {
                    iStatus = this.remakeStatus((ResourceStatus)iStatus, iProject);
                }
                iDocument = this.createEmptyDocument();
            }
            if (iDocument instanceof IDocumentExtension4 && (object2 = this.getLineDelimiterPreference(iFileEditorInput.getFile())) != null) {
                ((IDocumentExtension4)iDocument).setInitialLineDelimiter((String)object2);
            }
            object2 = this.createAnnotationModel(object);
            FileDocumentProvider.FileSynchronizer fileSynchronizer = new FileDocumentProvider.FileSynchronizer((FileDocumentProvider)this, iFileEditorInput);
            fileSynchronizer.install();
            FileDocumentProvider.FileInfo fileInfo = new FileDocumentProvider.FileInfo((FileDocumentProvider)this, iDocument, object2, fileSynchronizer);
            fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFileEditorInput.getFile());
            fileInfo.fStatus = iStatus;
            fileInfo.fEncoding = this.getPersistedEncoding(object);
            this.cacheEncodingState(object);
            return fileInfo;
        }
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            this.file = null;
            this.path = ((OS2200FileEditorInput)object).getFileLocation().toUpperCase();
            IDocument iDocument = null;
            Object var4_9 = null;
            try {
                if (((OS2200FileEditorInput)object).exists()) {
                    iDocument = this.createDocument(object);
                }
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, "CoreException : while creating document");
                iDocument = this.createEmptyDocument();
            }
            IAnnotationModel iAnnotationModel = this.createAnnotationModel(object);
            FileDocumentProvider.FileInfo fileInfo = new FileDocumentProvider.FileInfo((FileDocumentProvider)this, iDocument, iAnnotationModel, null);
            fileInfo.fModificationStamp = this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
            fileInfo.fStatus = var4_9;
            fileInfo.fEncoding = ((OS2200FileEditorInput)object).getEncoding();
            this.cacheEncodingState(object);
            return fileInfo;
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            IDocument iDocument = null;
            Object var4_10 = null;
            this.file = null;
            this.path = fileStoreEditorInput.getURI().getPath().toUpperCase();
            try {
                if (((FileStoreEditorInput)object).exists()) {
                    iDocument = this.createDocument(object);
                }
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, "CoreException : while creating document");
                iDocument = this.createEmptyDocument();
            }
            IAnnotationModel iAnnotationModel = this.createAnnotationModel(object);
            FileDocumentProvider.FileInfo fileInfo = new FileDocumentProvider.FileInfo((FileDocumentProvider)this, iDocument, iAnnotationModel, null);
            File file = new File(fileStoreEditorInput.getURI().getPath());
            fileInfo.fModificationStamp = this.computeModificationStamp(file);
            fileInfo.fStatus = var4_10;
            fileInfo.fEncoding = this.getPersistedEncoding(object);
            this.cacheEncodingState(object);
            return fileInfo;
        }
        return super.createElementInfo(object);
    }

    public String getEncoding(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            return ((OS2200FileEditorInput)object).getEncoding();
        }
        return super.getEncoding(object);
    }

    protected String getPersistedEncoding(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            return ((OS2200FileEditorInput)object).getEncoding();
        }
        return super.getPersistedEncoding(object);
    }

    protected long computeModificationStamp(IResource iResource) {
        long l = iResource.getModificationStamp();
        IPath iPath = iResource.getLocation();
        if (iPath == null) {
            return l;
        }
        if (l != -1L) {
            l = iPath.toFile().lastModified();
        }
        return l;
    }

    private String getStringForMonitor(IFile iFile) {
        block10: {
            try {
                String[] stringArray = null;
                int n = 0;
                if (iFile == null) {
                    if (this.path == null) break block10;
                    try {
                        if (this.path.contains(":/")) {
                            stringArray = this.path.split("/");
                            n = stringArray.length - 1;
                            this.fileNameforProgress = "Reading contents of " + stringArray[n].toUpperCase() + " from local File-System.";
                        } else if (this.path.contains(":\\")) {
                            stringArray = this.path.split("\\\\");
                            n = stringArray.length - 1;
                            this.fileNameforProgress = "Reading contents of " + stringArray[n].toUpperCase() + " from local File-System.";
                        } else if (this.path.contains("\\")) {
                            stringArray = this.path.split("\\\\");
                            n = stringArray.length - 1;
                            this.fileNameforProgress = n == 5 ? "Reading contents of " + stringArray[n - 1] + "*" + stringArray[n] + "." : "Reading contents of " + stringArray[n] + " from " + stringArray[n - 2] + "*" + stringArray[n - 1] + ".";
                        }
                    }
                    catch (Exception exception) {}
                    return this.fileNameforProgress;
                }
                IProject iProject = iFile.getProject();
                Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                String string = properties.getProperty("workFile");
                String string2 = iFile.getName().replace('.', '/');
                return "Reading contents of " + string2 + " from " + string;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
            File file = new File(oS2200FileEditorInput.getPath().toOSString());
            this.path = file.getPath();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            try {
                this.setDocumentContent(iDocument, fileInputStream, string);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
            return true;
        }
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            File file = new File(fileEditorInput.getPath().toOSString());
            this.path = file.getPath();
            IFile iFile = fileEditorInput.getFile();
            if (OS2200ProjectUpdate.hasCharConversion((IFile)iFile)) {
                string = "LETSJ";
                PlatformUI.getPreferenceStore().setValue(iFile.getName(), "LETSJ");
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            try {
                this.setDocumentContent(iDocument, fileInputStream, string);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
            return true;
        }
        return super.setDocumentContent(iDocument, iEditorInput, string);
    }

    protected void setDocumentContent(final IDocument iDocument, InputStream inputStream, String string) throws CoreException {
        if (string == null) {
            string = this.getDefaultEncoding();
        }
        this.encode = string;
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        FileInputStream fileInputStream = (FileInputStream)inputStream;
        final FileChannel fileChannel = fileInputStream.getChannel();
        try {
            try {
                int n = (int)fileChannel.size();
                if (MemChecker.getInstance().isLargeFile((long)n)) {
                    Status status = new Status(4, "org.eclipse.cobol.ui", 0, "Not enough memory to open the editor.", null);
                    throw new CoreException((IStatus)status);
                }
                progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        try {
                            END_OF_LINE = "\n";
                            ByteBuffer byteBuffer = null;
                            CharBuffer charBuffer = null;
                            try {
                                int n = (int)fileChannel.size();
                                String string = COBOLFreeFormatDocumentProvider.this.getStringForMonitor(COBOLFreeFormatDocumentProvider.this.file);
                                iProgressMonitor.beginTask(string, 1);
                                iProgressMonitor.subTask(" Bytes to be read " + n);
                                byteBuffer = ByteBuffer.allocate(n);
                                fileChannel.read(byteBuffer);
                                byteBuffer.flip();
                                Charset charset = Charset.forName(COBOLFreeFormatDocumentProvider.this.encode);
                                charBuffer = charset.decode(byteBuffer);
                                String string2 = new String(charBuffer.array());
                                if (string2.contains(COBOLFreeFormatDocumentProvider.CR)) {
                                    string2 = string2.replace(COBOLFreeFormatDocumentProvider.CR, COBOLFreeFormatDocumentProvider.ONE_SPACE);
                                }
                                if (string2.contains(COBOLFreeFormatDocumentProvider.TAB_CHAR)) {
                                    string2 = string2.replace(COBOLFreeFormatDocumentProvider.TAB_CHAR, COBOLFreeFormatDocumentProvider.FOUR_SPACES);
                                }
                                iDocument.set(string2);
                                iProgressMonitor.worked(1);
                            }
                            catch (IOException iOException) {
                                String string = iOException.getMessage() == null ? "" : iOException.getMessage();
                                Status status = new Status(4, CBDTUiPlugin.getPluginId(), 0, string, (Throwable)iOException);
                                throw new CoreException((IStatus)status);
                            }
                        }
                        catch (CoreException coreException) {
                            throw new InvocationTargetException(coreException);
                        }
                        iProgressMonitor.done();
                    }
                });
            }
            catch (CoreException coreException) {
                throw coreException;
            }
            catch (Exception exception) {
                String string2 = exception.getMessage() == null ? "" : exception.getMessage();
                Status status = new Status(4, "org.eclipse.cobol.ui", 0, string2, (Throwable)exception);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {}
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        Object object2 = null;
        object2 = this.fExpandTabs ? this.expandDoc(iDocument) : iDocument;
        if (object instanceof OS2200FileEditorInput) {
            Object object3;
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            String string = null;
            FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            string = oS2200FileEditorInput.getEncoding();
            if (string == null) {
                string = this.getDefaultEncoding();
            }
            if (fileInfo != null && CHARSET_UTF_16.equals(string)) {
                string = CHARSET_UTF_16LE;
            }
            Charset charset = null;
            try {
                charset = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {}
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            InputStream inputStream = null;
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(iDocument.get()));
                if (byteBuffer.hasArray()) {
                    object3 = byteBuffer.array();
                } else {
                    object3 = new byte[byteBuffer.limit()];
                    byteBuffer.get((byte[])object3);
                }
                inputStream = new ByteArrayInputStream((byte[])object3, 0, byteBuffer.limit());
            }
            catch (CharacterCodingException characterCodingException) {
                Assert.isTrue((boolean)(characterCodingException instanceof UnmappableCharacterException));
            }
            if (fileInfo != null && CHARSET_UTF_8.equals(string)) {
                inputStream = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_8), inputStream);
            }
            if (fileInfo != null && CHARSET_UTF_16LE.equals(string)) {
                inputStream = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_16LE), inputStream);
            }
            if (oS2200FileEditorInput.getPath().toFile().exists()) {
                if (fileInfo != null && !bl) {
                    this.checkSynchronizationState(fileInfo.fModificationStamp, oS2200FileEditorInput.getPath().toFile());
                }
                this.fireElementStateChanging(object);
                try {
                    object3 = iDocument.get().getBytes();
                    new ByteArrayInputStream((byte[])object3);
                    int n = 0;
                    OutputStream outputStream = oS2200FileEditorInput.getfFile().openOutputStream(n, Policy.subMonitorFor((IProgressMonitor)iProgressMonitor, (int)0));
                    FileUtil.transferStreams((InputStream)inputStream, (OutputStream)outputStream, (String)oS2200FileEditorInput.getfFile().toString(), (IProgressMonitor)iProgressMonitor);
                }
                catch (CoreException coreException) {
                    this.fireElementStateChangeFailed(object);
                    throw coreException;
                }
                catch (RuntimeException runtimeException) {
                    this.fireElementStateChangeFailed(object);
                    throw runtimeException;
                }
                if (fileInfo != null) {
                    object3 = (ResourceMarkerAnnotationModel)fileInfo.fModel;
                    if (object3 != null) {
                        object3.updateMarkers(fileInfo.fDocument);
                    }
                    fileInfo.fModificationStamp = this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
                }
            }
        } else if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            File file = new File(fileStoreEditorInput.getURI().getPath());
            if (file.exists()) {
                Object object4;
                if (fileInfo != null && !bl) {
                    this.checkSynchronizationState(fileInfo.fModificationStamp, file);
                }
                this.fireElementStateChanging(object);
                try {
                    object4 = iDocument.get().getBytes();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object4);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    FileUtil.transferStreams((InputStream)byteArrayInputStream, (OutputStream)fileOutputStream, (String)file.getAbsolutePath(), (IProgressMonitor)iProgressMonitor);
                }
                catch (CoreException coreException) {
                    this.fireElementStateChangeFailed(object);
                    fileInfo.fModificationStamp = this.computeModificationStamp(file);
                    throw coreException;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (fileInfo != null) {
                    object4 = (ResourceMarkerAnnotationModel)fileInfo.fModel;
                    if (object4 != null) {
                        object4.updateMarkers(fileInfo.fDocument);
                    }
                    fileInfo.fModificationStamp = this.computeModificationStamp(file);
                }
            }
        }
        super.doSaveDocument(iProgressMonitor, object, object2, bl);
    }

    private void saveExternalFile(OS2200FileEditorInput oS2200FileEditorInput, IDocument iDocument) throws IOException {
        try (FileOutputStream fileOutputStream = null;){
            File file = oS2200FileEditorInput.getPath().toFile();
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = iDocument.get().getBytes();
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
    }

    @Override
    public boolean isModifiable(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            File file = oS2200FileEditorInput.getPath().toFile();
            return file.canWrite();
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            File file = new File(fileStoreEditorInput.getURI().getPath());
            return file.canWrite();
        }
        if (!this.isStateValidated(object) && object instanceof IFileEditorInput) {
            return true;
        }
        return super.isModifiable(object);
    }

    public boolean isSynchronized(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            if (this.getElementInfo(object) != null) {
                long l = this.getModificationStamp(object);
                return l == this.getSynchronizationStamp(object);
            }
            return false;
        }
        if (object instanceof FileStoreEditorInput) {
            if (this.getElementInfo(object) != null) {
                long l = this.getModificationStamp(object);
                return l == this.getSynchronizationStamp(object);
            }
            return false;
        }
        return super.isSynchronized(object);
    }

    public long getModificationStamp(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return this.computeModificationStamp((IResource)iFileEditorInput.getFile());
        }
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            return this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            return this.computeModificationStamp(new File(fileStoreEditorInput.getURI().getPath()));
        }
        return super.getModificationStamp(object);
    }

    protected long computeModificationStamp(File file) {
        long l = file.lastModified();
        return l;
    }

    public boolean isDeleted(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            IPath iPath = iFileEditorInput.getFile().getLocation();
            if (iPath == null) {
                return true;
            }
            return !iPath.toFile().exists();
        }
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            IPath iPath = oS2200FileEditorInput.getPath();
            if (iPath == null) {
                return true;
            }
            return !iPath.toFile().exists();
        }
        return super.isDeleted(object);
    }

    protected void doSynchronize(Object object, IProgressMonitor iProgressMonitor) throws CoreException {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            if (fileInfo != null) {
                if (fileInfo.fFileSynchronizer != null) {
                    fileInfo.fFileSynchronizer.uninstall();
                    this.refreshFile(iFileEditorInput.getFile(), iProgressMonitor);
                    fileInfo.fFileSynchronizer.install();
                } else {
                    this.refreshFile(iFileEditorInput.getFile(), iProgressMonitor);
                }
                this.handleElementContentChanged((IFileEditorInput)object);
            }
            return;
        }
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            this.handleElementContentChanged1(oS2200FileEditorInput);
            return;
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            this.handleElementContentChanged2(fileStoreEditorInput);
            return;
        }
    }

    public void handleElementContentChanged(IFileEditorInput iFileEditorInput) {
        super.handleElementContentChanged(iFileEditorInput);
    }

    public void handleElementContentChanged1(OS2200FileEditorInput oS2200FileEditorInput) {
        FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(oS2200FileEditorInput);
        if (!(oS2200FileEditorInput instanceof OS2200FileEditorInput) && fileInfo == null) {
            return;
        }
        IDocument iDocument = this.createEmptyDocument();
        IStatus iStatus = null;
        try {
            this.cacheEncodingState(oS2200FileEditorInput);
            this.setDocumentContent(iDocument, (IEditorInput)oS2200FileEditorInput, fileInfo.fEncoding);
        }
        catch (CoreException coreException) {
            iStatus = coreException.getStatus();
        }
        String string = iDocument.get();
        if (!string.equals(fileInfo.fDocument.get())) {
            this.fireElementContentAboutToBeReplaced(oS2200FileEditorInput);
            this.removeUnchangedElementListeners(oS2200FileEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            fileInfo.fDocument.removeDocumentListener((IDocumentListener)fileInfo);
            fileInfo.fDocument.set(string);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(oS2200FileEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            this.fireElementContentReplaced(oS2200FileEditorInput);
        } else {
            this.removeUnchangedElementListeners(oS2200FileEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(oS2200FileEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            this.fireElementDirtyStateChanged(oS2200FileEditorInput, false);
        }
    }

    public void handleElementContentChanged2(FileStoreEditorInput fileStoreEditorInput) {
        FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(fileStoreEditorInput);
        if (!(fileStoreEditorInput instanceof OS2200FileEditorInput) && fileInfo == null) {
            return;
        }
        IDocument iDocument = this.createEmptyDocument();
        IStatus iStatus = null;
        try {
            this.cacheEncodingState(fileStoreEditorInput);
            this.setDocumentContent(iDocument, (IEditorInput)fileStoreEditorInput, null);
        }
        catch (CoreException coreException) {
            iStatus = coreException.getStatus();
        }
        String string = iDocument.get();
        if (!string.equals(fileInfo.fDocument.get())) {
            this.fireElementContentAboutToBeReplaced(fileStoreEditorInput);
            this.removeUnchangedElementListeners(fileStoreEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            fileInfo.fDocument.removeDocumentListener((IDocumentListener)fileInfo);
            fileInfo.fDocument.set(string);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp(new File(fileStoreEditorInput.getURI().getPath()));
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(fileStoreEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            this.fireElementContentReplaced(fileStoreEditorInput);
        } else {
            this.removeUnchangedElementListeners(fileStoreEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp(new File(fileStoreEditorInput.getURI().getPath()));
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(fileStoreEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            this.fireElementDirtyStateChanged(fileStoreEditorInput, false);
        }
    }

    public long getSynchronizationStamp(Object object) {
        FileDocumentProvider.FileInfo fileInfo;
        if (object instanceof IFileEditorInput) {
            FileDocumentProvider.FileInfo fileInfo2 = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            if (fileInfo2 != null) {
                return fileInfo2.fModificationStamp;
            }
        } else if (object instanceof OS2200FileEditorInput) {
            FileDocumentProvider.FileInfo fileInfo3 = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            if (fileInfo3 != null) {
                return fileInfo3.fModificationStamp;
            }
        } else if (object instanceof FileStoreEditorInput && (fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object)) != null) {
            return fileInfo.fModificationStamp;
        }
        return super.getSynchronizationStamp(object);
    }

    protected void checkSynchronizationState(long l, File file) throws CoreException {
        if (l != this.computeModificationStamp(file)) {
            Status status = new Status(4, "org.eclipse.ui", 274, "Has been changed on the file system", null);
            throw new CoreException((IStatus)status);
        }
    }

    public String getPath() {
        return this.path;
    }
}

