/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.freeformat;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.ui.common.text.COBOLAbstractCodeScanner;
import org.eclipse.cobol.ui.common.text.COBOLColorManager;
import org.eclipse.cobol.ui.common.text.COBOLEndOfLineRule;
import org.eclipse.cobol.ui.common.text.COBOLSingleLineRule;
import org.eclipse.cobol.ui.common.text.COBOLWhitespaceDetector;
import org.eclipse.cobol.ui.common.text.COBOLWordDetector;
import org.eclipse.cobol.ui.common.text.COBOLWordRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public final class COBOLFreeFormatCodeScanner
extends COBOLAbstractCodeScanner {
    private static String[] fTokenProperties = new String[]{"cobol_comment", "cobol_string", "cobol_reserved_word", "cobol_in_line_comment", "cobol_figurative_constant", "cobol_special_register", "cobol_default", "cobol_data_dict_vars", "cobol_sections", "cobol_paragraphs", "ws_vars", "unreferenced_ws_vars"};

    public COBOLFreeFormatCodeScanner(COBOLColorManager cOBOLColorManager, IPreferenceStore iPreferenceStore) {
        super(cOBOLColorManager, iPreferenceStore);
        this.initialize();
    }

    @Override
    protected String[] getTokenProperties() {
        return fTokenProperties;
    }

    @Override
    protected List createRules() {
        Token token = null;
        ArrayList<COBOLSingleLineRule> arrayList = new ArrayList<COBOLSingleLineRule>();
        token = this.getToken("cobol_comment");
        COBOLEndOfLineRule cOBOLEndOfLineRule = new COBOLEndOfLineRule("*", (IToken)token, "FREE");
        cOBOLEndOfLineRule.setColumnConstraint(6);
        arrayList.add(cOBOLEndOfLineRule);
        token = this.getToken("cobol_string");
        arrayList.add(new COBOLSingleLineRule("\"", "\"", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("B\"", "\"", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("N\"", "\"", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("NC\"", "\"", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("NX\"", "\"", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("X\"", "\"", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("'", "'", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("B'", "'", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("N'", "'", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("NC'", "'", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("NX'", "'", (IToken)token));
        arrayList.add(new COBOLSingleLineRule("X'", "'", (IToken)token));
        token = this.getToken("cobol_in_line_comment");
        EndOfLineRule endOfLineRule = new EndOfLineRule("*>", (IToken)token);
        arrayList.add((COBOLSingleLineRule)endOfLineRule);
        arrayList.add((COBOLSingleLineRule)new WhitespaceRule((IWhitespaceDetector)new COBOLWhitespaceDetector()));
        WordRule wordRule = this.createWordRules();
        if (wordRule != null) {
            arrayList.add((COBOLSingleLineRule)wordRule);
        }
        this.setDefaultReturnToken((IToken)this.getToken("cobol_default"));
        return arrayList;
    }

    public void setColumnConstraint(int n) {
        if (n < 0) {
            n = -1;
        }
        this.fColumn = n;
    }

    @Override
    protected WordRule createWordRules() {
        Token token = this.getToken("cobol_default");
        COBOLWordRule cOBOLWordRule = new COBOLWordRule(new COBOLWordDetector("FREE"), (IToken)token, "FREE");
        token = this.getToken("cobol_reserved_word");
        int n = 0;
        while (n < this.fReservedWords.length) {
            cOBOLWordRule.addWord(this.fReservedWords[n], (IToken)token);
            ++n;
        }
        token = this.getToken("cobol_figurative_constant");
        n = 0;
        while (n < this.fFigurativeConstants.length) {
            cOBOLWordRule.addWord(this.fFigurativeConstants[n], (IToken)token);
            ++n;
        }
        token = this.getToken("cobol_special_register");
        n = 0;
        while (n < this.fSpecialRegisters.length) {
            cOBOLWordRule.addWord(this.fSpecialRegisters[n], (IToken)token);
            ++n;
        }
        token = this.getToken("cobol_data_dict_vars");
        if (this.fDataDictVars != null) {
            n = 0;
            while (n < this.fDataDictVars.length) {
                cOBOLWordRule.addWord(this.fDataDictVars[n], (IToken)token);
                ++n;
            }
        }
        token = this.getToken("cobol_sections");
        if (this.fSections != null) {
            n = 0;
            while (n < this.fSections.length) {
                cOBOLWordRule.addWord(this.fSections[n], (IToken)token);
                ++n;
            }
        }
        token = this.getToken("cobol_paragraphs");
        if (this.fParagraphs != null) {
            n = 0;
            while (n < this.fParagraphs.length) {
                cOBOLWordRule.addWord(this.fParagraphs[n], (IToken)token);
                ++n;
            }
        }
        token = this.getToken("ws_vars");
        if (this.fWSVars != null) {
            n = 0;
            while (n < this.fWSVars.length) {
                cOBOLWordRule.addWord(this.fWSVars[n], (IToken)token);
                ++n;
            }
        }
        token = this.getToken("unreferenced_ws_vars");
        if (this.fUnreferencedVars != null) {
            n = 0;
            while (n < this.fUnreferencedVars.length) {
                cOBOLWordRule.addWord(this.fUnreferencedVars[n], (IToken)token);
                ++n;
            }
        }
        return cOBOLWordRule;
    }
}

