/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.fixedformat;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.COBOLSequenceNumberHandler;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class COBOLSequenceNumberArea {
    private static final int APPEND = 0;
    private static final int INSERT = 1;
    private static int NUMBER_LENGTH = 6;
    private static int MIN_STEP_VALUE = 1;
    private static int DEFAULT_STEP_VALUE = 0;
    private static int MAX_NUMBER = 999999;
    private static final String END_OF_LINE = "\n";
    private static final String SPACES = "      ";
    static String START_NUMBER = "000100";
    static final String ZEROS = "000000";
    private boolean isPATTERN_B = false;
    private StyledText fSequenceNumberArea;
    private StringBuffer fSequenceNumbersBuffer;
    private IPreferenceStore fStore;
    private boolean isNewFile;
    private boolean isDirty = false;
    private String fPreservedText = "";
    private String fNewText = "";

    public String getFirstSequenceNumber() {
        try {
            return this.fSequenceNumbersBuffer.substring(0, NUMBER_LENGTH);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return ZEROS;
        }
    }

    public String getLastSequenceNumber() {
        try {
            return this.fSequenceNumbersBuffer.substring(this.fSequenceNumbersBuffer.length() - NUMBER_LENGTH, this.fSequenceNumbersBuffer.length());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return ZEROS;
        }
    }

    public COBOLSequenceNumberArea() {
        this.initialize();
    }

    public void setSequenceNumbersControl(StringBuffer stringBuffer) {
        this.fSequenceNumbersBuffer = stringBuffer;
        if (this.fSequenceNumberArea != null && this.fSequenceNumbersBuffer != null) {
            this.fSequenceNumberArea.setText(this.fSequenceNumbersBuffer.toString());
            this.fPreservedText = this.fSequenceNumberArea.getText();
            if (this.fSequenceNumbersBuffer.length() == 0) {
                this.isNewFile = true;
            }
        }
    }

    public void setPreservedText(String string) {
        this.fPreservedText = string;
    }

    public StyledText createSequenceNumberArea(Composite composite, int n) {
        try {
            this.fSequenceNumberArea = new StyledText(composite, n);
            if (!this.isNewFile && this.fSequenceNumbersBuffer != null) {
                this.fSequenceNumberArea.setText(this.fSequenceNumbersBuffer.toString());
            }
            this.fSequenceNumberArea.setEnabled(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CBDTUiPlugin.logError(illegalArgumentException);
        }
        return this.fSequenceNumberArea;
    }

    public void setFirstSequenceNumber() {
        String string = this.fSequenceNumberArea.getText();
        if ((string == null || string.length() == 0) && this.isNewFile) {
            this.insert(Integer.parseInt(START_NUMBER), -1, 1);
            this.fSequenceNumberArea.setText(this.fSequenceNumbersBuffer.toString());
        }
        if (this.fSequenceNumbersBuffer.toString().endsWith(END_OF_LINE)) {
            this.fSequenceNumbersBuffer.delete(this.fSequenceNumbersBuffer.length() - 1, this.fSequenceNumbersBuffer.length());
        }
        if (this.isNewFile) {
            this.resetNewFileFlag();
        }
    }

    public boolean isNewFile() {
        this.isNewFile = this.fSequenceNumbersBuffer != null && this.fSequenceNumbersBuffer.length() == 0;
        return this.isNewFile;
    }

    public boolean isPatternB() {
        return this.isPATTERN_B;
    }

    public StringBuffer getSequenceNumbersBuffer() {
        return this.fSequenceNumbersBuffer;
    }

    public StyledText getSequenceNumberAreaText() {
        return this.fSequenceNumberArea;
    }

    public void addNextSequenceNumber(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = NUMBER_LENGTH + 1;
        int n7 = n + 1;
        int n8 = 0;
        String string = null;
        String string2 = null;
        try {
            if (((COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor()).isEditorInputReadOnly()) {
                return;
            }
            DEFAULT_STEP_VALUE = Integer.parseInt(this.fStore.getString("Incremental Value"));
            if (this.fSequenceNumbersBuffer.length() == 0) {
                this.isNewFile = true;
            }
            n8 = (this.fSequenceNumbersBuffer.length() + 1) / n6;
            int n9 = 0;
            while (n9 < n2) {
                block27: {
                    if (!this.isPATTERN_B) {
                        try {
                            if (this.fSequenceNumbersBuffer.length() == 0) {
                                n3 = Integer.parseInt(START_NUMBER);
                                this.setFirstSequenceNumber();
                                break block27;
                            }
                            string = this.fSequenceNumbersBuffer.substring(n * n6, n * n6 + NUMBER_LENGTH);
                            n3 = Integer.parseInt(string);
                            n7 = n + 1;
                            if (this.fSequenceNumbersBuffer.length() >= n7 * n6 + NUMBER_LENGTH) {
                                string2 = this.fSequenceNumbersBuffer.substring(n7 * n6, n7 * n6 + NUMBER_LENGTH);
                                n4 = Integer.parseInt(string2);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            n4 = 0;
                            CBDTUiPlugin.logError(numberFormatException);
                        }
                        n5 = n3 + DEFAULT_STEP_VALUE;
                        this.fSequenceNumbersBuffer.append(END_OF_LINE);
                        if (n4 == 0) {
                            if (n3 == MAX_NUMBER) {
                                this.insert(-1, n, 0);
                            } else if (n5 > MAX_NUMBER) {
                                n5 = n3 + MIN_STEP_VALUE;
                                if (n5 > MAX_NUMBER) {
                                    this.insert(-1, n, 0);
                                } else {
                                    this.insert(n5, n, 0);
                                }
                            } else {
                                this.insert(n5, n, 0);
                            }
                        } else if (n5 < n4) {
                            this.insert(n5, n, 1);
                        } else {
                            n5 = n3 + MIN_STEP_VALUE;
                            if (n5 < n4) {
                                this.insert(n5, n, 1);
                            } else {
                                this.changeAllSequenceNumbers(n, n5);
                            }
                        }
                    } else {
                        this.fSequenceNumbersBuffer.append(END_OF_LINE);
                        if (n + 1 >= n8) {
                            this.insert(-1, n, 0);
                        } else {
                            this.insert(-1, n, 1);
                        }
                    }
                    ++n;
                    ++n8;
                    if (this.fSequenceNumbersBuffer.substring(this.fSequenceNumbersBuffer.length() - 1).equals(END_OF_LINE)) {
                        this.fSequenceNumbersBuffer.delete(this.fSequenceNumbersBuffer.length() - 1, this.fSequenceNumbersBuffer.length());
                    }
                }
                ++n9;
            }
            this.fSequenceNumberArea.setText(this.fSequenceNumbersBuffer.toString());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            CBDTUiPlugin.logError(stringIndexOutOfBoundsException);
        }
    }

    private void changeAllSequenceNumbers(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        block16: {
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = NUMBER_LENGTH + 1;
            n5 = ++n + 1;
            try {
                n6 = n2;
                if (this.fSequenceNumbersBuffer.length() >= n5 * n3 + NUMBER_LENGTH) {
                    n4 = Integer.parseInt(this.fSequenceNumbersBuffer.substring(n5 * n3, n5 * n3 + NUMBER_LENGTH));
                    break block16;
                }
                n4 = n6;
            }
            catch (NumberFormatException numberFormatException) {
                CBDTUiPlugin.logError(numberFormatException);
            }
        }
        while (n4 - n6 == MIN_STEP_VALUE) {
            n6 = n4;
            n5 = ++n + 1;
            try {
                if (this.fSequenceNumbersBuffer.length() < n5 * n3 + NUMBER_LENGTH) continue;
                n4 = Integer.parseInt(this.fSequenceNumbersBuffer.substring(n5 * 7, n5 * 7 + NUMBER_LENGTH));
            }
            catch (NumberFormatException numberFormatException) {
                CBDTUiPlugin.logError(numberFormatException);
                n4 = 0;
            }
        }
        if (n4 == n6) {
            if (n6 + DEFAULT_STEP_VALUE > MAX_NUMBER) {
                if (n6 + MIN_STEP_VALUE > MAX_NUMBER) {
                    this.insert(-1, n, 0);
                } else {
                    this.insert(n6 + MIN_STEP_VALUE, n, 0);
                }
            } else {
                this.insert(n6 + DEFAULT_STEP_VALUE, n, 1);
            }
        } else if (n6 + DEFAULT_STEP_VALUE >= n4) {
            if (n6 + MIN_STEP_VALUE > MAX_NUMBER) {
                this.insert(-1, n, 1);
            } else {
                this.insert(n6 + MIN_STEP_VALUE, n, 1);
            }
        } else {
            this.insert(n6 + DEFAULT_STEP_VALUE, n, 1);
        }
    }

    private void insert(int n, int n2, int n3) {
        StringBuffer stringBuffer = null;
        int n4 = NUMBER_LENGTH + 1;
        int n5 = n2 * n4 + n4;
        if (n != -1) {
            stringBuffer = new StringBuffer(String.valueOf(n));
            this.addLeadingZeroes(stringBuffer);
            if (n3 == 1) {
                this.fSequenceNumbersBuffer.insert(n5, stringBuffer.append(END_OF_LINE).toString());
            } else {
                this.fSequenceNumbersBuffer.insert(n5, stringBuffer.toString());
            }
        } else {
            if (n3 == 1) {
                this.fSequenceNumbersBuffer.insert(n5, SPACES.concat(END_OF_LINE).toString());
            } else {
                if (this.fSequenceNumbersBuffer.length() < n5) {
                    n5 = this.fSequenceNumbersBuffer.length();
                }
                this.fSequenceNumbersBuffer.insert(n5, SPACES);
            }
            if (!this.isPATTERN_B) {
                this.isPATTERN_B = true;
                ((COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor()).fireChanges();
            }
        }
    }

    public void setPatternFlag(boolean bl) {
        this.isPATTERN_B = bl;
    }

    public void resetNewFileFlag() {
        this.isNewFile = false;
    }

    private void addLeadingZeroes(StringBuffer stringBuffer) {
        int n = NUMBER_LENGTH - stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.insert(0, '0');
            ++n2;
        }
    }

    public void renumber(int n, int n2, int n3) {
        try {
            COBOLSequenceNumberHandler cOBOLSequenceNumberHandler = new COBOLSequenceNumberHandler();
            this.fSequenceNumbersBuffer = cOBOLSequenceNumberHandler.renumber(this.fSequenceNumbersBuffer, n, n2, n3);
            this.fSequenceNumberArea.setText(this.fSequenceNumbersBuffer.toString());
            int n4 = ((COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor()).getCurrentSourceViewer().getTextWidget().getTopPixel();
            this.fSequenceNumberArea.setTopPixel(n4);
            this.isDirty = true;
            if (this.isPATTERN_B) {
                this.isPATTERN_B = false;
            }
            if (this.isNewFile) {
                this.resetNewFileFlag();
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void reSetIsDirty() {
        this.isDirty = false;
    }

    public void initialize() {
        try {
            this.fStore = CBDTUiPlugin.getDefault().getPreferenceStore();
            START_NUMBER = this.fStore.getString("Initial Value");
            DEFAULT_STEP_VALUE = Integer.parseInt(this.fStore.getString("Incremental Value"));
            MAX_NUMBER = 999999;
            MIN_STEP_VALUE = 1;
            NUMBER_LENGTH = 6;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void deleteSequenceNumbers(int n, int n2) {
        try {
            if (((COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor()).isEditorInputReadOnly()) {
                return;
            }
            int n3 = NUMBER_LENGTH + 1;
            this.fSequenceNumbersBuffer.delete(n * n3, (n2 + n) * n3);
            if (this.fSequenceNumbersBuffer.substring(this.fSequenceNumbersBuffer.length() - 1).equals(END_OF_LINE)) {
                this.fSequenceNumbersBuffer.deleteCharAt(this.fSequenceNumbersBuffer.length() - 1);
            }
            this.fSequenceNumberArea.setText(this.fSequenceNumbersBuffer.toString());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void setPreservedText() {
        if (this.getSequenceNumbersBuffer() != null) {
            this.fPreservedText = this.getSequenceNumbersBuffer().toString();
        }
    }

    public void setNewText() {
        if (this.getSequenceNumbersBuffer() != null) {
            this.fNewText = this.getSequenceNumbersBuffer().toString();
        }
    }

    public String getPreservedText() {
        return this.fPreservedText;
    }

    public String getNewText() {
        StringBuffer stringBuffer = this.getSequenceNumbersBuffer();
        if (stringBuffer != null) {
            this.fNewText = stringBuffer.toString();
        }
        return this.fNewText;
    }

    public void resetSequenceNumberArea(String string) {
        try {
            this.fSequenceNumbersBuffer.delete(0, this.fSequenceNumbersBuffer.length());
            this.fSequenceNumbersBuffer.append(string);
            this.fSequenceNumberArea.setText(this.fSequenceNumbersBuffer.toString());
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void handleDispose() {
        try {
            this.fSequenceNumbersBuffer = null;
            this.fStore = null;
            if (this.fSequenceNumberArea != null) {
                this.fSequenceNumberArea.dispose();
                this.fSequenceNumberArea = null;
            }
            this.fPreservedText = null;
            this.fNewText = null;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }
}

