/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.fixedformat;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.text.COBOLColorManager;
import org.eclipse.cobol.ui.common.text.COBOLTextFactory;
import org.eclipse.cobol.ui.common.text.COBOLTextHover;
import org.eclipse.cobol.ui.contentassist.COBOLCompletionProcessor;
import org.eclipse.cobol.ui.editor.COBOLAnnotationHover;
import org.eclipse.cobol.ui.editor.COBOLSourceViewerConfiguration;
import org.eclipse.cobol.ui.fixedformat.COBOLFixedFormatUndoManager;
import org.eclipse.cobol.ui.text.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class COBOLFixedFormatSourceViewerConfiguration
extends COBOLSourceViewerConfiguration {
    private ITextEditor fTextEditor;
    private COBOLTextFactory fCOBOLTextFactory;
    private COBOLFixedFormatUndoManager fUndoManager;

    public COBOLFixedFormatSourceViewerConfiguration(COBOLTextFactory cOBOLTextFactory, ITextEditor iTextEditor) {
        this.fTextEditor = iTextEditor;
        this.fCOBOLTextFactory = cOBOLTextFactory;
    }

    protected RuleBasedScanner getCodeScanner() {
        try {
            return this.fCOBOLTextFactory.getFixedFormatCodeScanner();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
    }

    protected COBOLColorManager getColorManager() {
        try {
            return this.fCOBOLTextFactory.getColorManager();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        return presentationReconciler;
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer iSourceViewer, String string) {
        try {
            return super.getAutoIndentStrategy(iSourceViewer, string);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new COBOLCompletionProcessor(), "__dftl_partition_content_type");
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setAutoActivationDelay(500);
        contentAssistant.setProposalPopupOrientation(10);
        contentAssistant.setInformationControlCreator(this.getAssistantInformationControlCreator(iSourceViewer));
        return contentAssistant;
    }

    @Override
    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    protected IPreferenceStore getPreferenceStore() {
        try {
            return CBDTUiPlugin.getDefault().getPreferenceStore();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        try {
            return Integer.parseInt(this.getPreferenceStore().getString("Tab Width"));
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return 4;
        }
    }

    public IUndoManager getUndoManager(ISourceViewer iSourceViewer) {
        if (this.fUndoManager == null) {
            this.fUndoManager = new COBOLFixedFormatUndoManager(25);
            this.fUndoManager.setEditor(this.fTextEditor);
        }
        return this.fUndoManager;
    }

    public void handleDispose() {
        try {
            this.fTextEditor = null;
            this.fCOBOLTextFactory = null;
            if (this.fUndoManager != null) {
                this.fUndoManager.setEditor(null);
                this.fUndoManager.disconnect();
                this.fUndoManager = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        if (this.fTextEditor != null) {
            return new COBOLTextHover(iSourceViewer, this.fTextEditor.getEditorInput());
        }
        return new COBOLTextHover(iSourceViewer);
    }

    @Override
    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new COBOLAnnotationHover();
    }
}

