/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.fixedformat;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.IReferenceFormatHandler;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.editor.COBOLMarkerAnnotationModel;
import org.eclipse.cobol.ui.editor.COBOLStatusLineMessages;
import org.eclipse.cobol.ui.fixedformat.COBOLSequenceNumberArea;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class COBOLFixedFormatEventHandler
implements IReferenceFormatHandler {
    private StyledText fStyledText;
    private ISourceViewer fSourceViewer;
    private COBOLSequenceNumberArea fSequenceNumberArea;
    private boolean isDelete = false;
    private boolean isNewFile = true;
    private static final int END_COLUMN = 74;
    private String[] fDelimiters;
    private boolean fInsertFlag = true;
    private boolean isAlreadyDeleted = false;
    private COBOLStatusLineMessages fStatusLineMessage = null;
    private COBOLEditor fEditor;
    private boolean fModelUpdateFlag = true;
    private int fKeyCode;

    public COBOLFixedFormatEventHandler(ISourceViewer iSourceViewer, COBOLEditor cOBOLEditor) {
        this.fSourceViewer = iSourceViewer;
        this.fStyledText = this.fSourceViewer.getTextWidget();
        this.fEditor = cOBOLEditor;
    }

    public void setCOBOLSequenceNumberHandler(COBOLSequenceNumberArea cOBOLSequenceNumberArea, boolean bl) {
        this.fSequenceNumberArea = cOBOLSequenceNumberArea;
        this.isNewFile = bl;
    }

    public void setInsertModeFlag(boolean bl) {
        this.fInsertFlag = bl;
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        try {
            if (this.fEditor.getReferenceFormat().equals("FREE") || this.fEditor.getReferenceFormat().equals("VARIABLE")) {
                return;
            }
            if (this.fEditor.isEditorInputReadOnly()) {
                return;
            }
            this.setErrorMessage(null);
            this.fKeyCode = verifyEvent.keyCode;
            this.isNewFile = this.fSequenceNumberArea.isNewFile();
            if (this.isNewFile) {
                if (verifyEvent.keyCode >= 65536 && verifyEvent.keyCode <= 0x1000015 || verifyEvent.character == '\u007f' || verifyEvent.character == '\b' || verifyEvent.character == '\u001b') {
                    verifyEvent.doit = false;
                } else if (verifyEvent.character == '\r') {
                    this.fSequenceNumberArea.setPreservedText();
                    this.fSequenceNumberArea.setFirstSequenceNumber();
                    this.isNewFile = false;
                    this.isAlreadyDeleted = true;
                } else {
                    verifyEvent.doit = true;
                    this.fSequenceNumberArea.setPreservedText();
                    this.fSequenceNumberArea.setFirstSequenceNumber();
                    this.isNewFile = false;
                    this.isAlreadyDeleted = true;
                }
                return;
            }
            this.isAlreadyDeleted = false;
            this.isDelete = false;
            if (verifyEvent.character == '\u007f' && verifyEvent.stateMask == 0) {
                if (verifyEvent.doit) {
                    this.deleteSequenceNumbers(false, false);
                } else {
                    this.fSequenceNumberArea.setPreservedText();
                }
                this.isAlreadyDeleted = true;
            } else if (verifyEvent.character == '\b' && verifyEvent.stateMask == 0) {
                if (verifyEvent.doit) {
                    this.deleteSequenceNumbers(true, false);
                }
                this.isAlreadyDeleted = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void verifyText(VerifyEvent verifyEvent) {
        try {
            Object object;
            if (this.fEditor.getReferenceFormat().equals("FREE")) {
                return;
            }
            if (this.fEditor.getReferenceFormat().equals("VARIABLE")) {
                return;
            }
            this.isNewFile = this.fSequenceNumberArea.getSequenceNumbersBuffer().length() == 0;
            this.setErrorMessage(null);
            if (!this.isAlreadyDeleted) {
                this.fSequenceNumberArea.setPreservedText();
            }
            if (this.isAnySelection() && verifyEvent.text != null && !this.isAlreadyDeleted) {
                if (verifyEvent.doit) {
                    this.deleteSequenceNumbers(false, false);
                }
                verifyEvent.doit = true;
            }
            int n = this.fSourceViewer.getVisibleRegion().getOffset();
            int n2 = n + this.fStyledText.getCaretOffset();
            IDocument iDocument = this.fSourceViewer.getDocument();
            int n3 = -1;
            n3 = iDocument.getLineOfOffset(n2);
            int n4 = 0;
            int n5 = 0;
            while ((n5 = this.getLineDelimiterIndex(verifyEvent.text, n5)) != -1) {
                ++n5;
                ++n4;
            }
            if (this.isAnyNewLineLimiters(verifyEvent.text) && !this.isAnySelection() && n4 <= 1 && this.fKeyCode == 0) {
                if (verifyEvent.doit) {
                    this.addSequenceNumbers(n3, 1);
                }
            } else {
                if (this.isNewFile && n5 < verifyEvent.text.length()) {
                    ++n4;
                }
                if (verifyEvent.doit) {
                    if (this.isAnySelection()) {
                        int n6;
                        object = this.fStyledText.getSelection();
                        n3 = n6 = this.fSourceViewer.getDocument().getLineOfOffset(object.x);
                    }
                    if (n4 != 0) {
                        this.addSequenceNumbers(n3, n4);
                    }
                }
            }
            if (this.fModelUpdateFlag) {
                object = (COBOLMarkerAnnotationModel)this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
                if (object != null) {
                    object.setDirtyFlag(true);
                }
                this.fModelUpdateFlag = false;
            }
            try {
                object = this.fEditor.getEditorSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
                if (((IWorkbenchWindow[])object).length > 1) {
                    Display display = this.fEditor.getSite().getShell().getDisplay();
                    display.asyncExec(this.fEditor.getRunnable());
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void setModelUpdateFlag() {
        this.fModelUpdateFlag = true;
    }

    public void processCutOperation() {
        this.isAlreadyDeleted = true;
        this.deleteSequenceNumbers(false, true);
        this.fStyledText.cut();
    }

    public boolean isContentAssistantInsertionAllowed(int n) {
        int n2 = this.getCurrentColumn();
        return n2 < 66;
    }

    private boolean isAnySelection() {
        return this.fStyledText.getSelection().x != this.fStyledText.getSelection().y;
    }

    private void addSequenceNumbers(int n, int n2) {
        this.fSequenceNumberArea.addNextSequenceNumber(n, n2);
    }

    private void deleteSequenceNumbers(boolean bl, boolean bl2) {
        try {
            int n;
            int n2 = 0;
            int n3 = 0;
            this.fSequenceNumberArea.setPreservedText();
            while ((n3 = this.getLineDelimiterIndex(this.fStyledText.getSelectionText(), n3)) != -1) {
                ++n3;
                ++n2;
            }
            int n4 = this.fSourceViewer.getVisibleRegion().getOffset();
            int n5 = n4 + this.fStyledText.getCaretOffset();
            IDocument iDocument = this.fSourceViewer.getDocument();
            int n6 = -1;
            int n7 = iDocument.getLineOfOffset(n5);
            Point point = this.fStyledText.getSelection();
            if (bl && n7 == 0) {
                return;
            }
            if (!bl && n7 == iDocument.getNumberOfLines() - 1 && !this.isAnySelection()) {
                return;
            }
            if (iDocument.getLineLength(n7) - 2 == point.y - point.x && point.y != point.x) {
                return;
            }
            if (bl2 && point.y == point.x) {
                return;
            }
            n6 = iDocument.getLineOfOffset(point.x);
            if (n2 == 0) {
                String string = "";
                n = this.getCurrentColumn();
                int n8 = n5;
                if (bl) {
                    if (n - 1 < 0 && point.x == point.y) {
                        string = iDocument.get(n8 - 1, 1);
                    }
                } else if (!this.isAnySelection()) {
                    string = iDocument.get(n8, 1);
                }
                if (this.isAnyNewLineLimiters(string)) {
                    n2 = 1;
                } else {
                    return;
                }
            }
            if (n2 != 0) {
                int n9 = point.x - iDocument.getLineOffset(n6);
                if (n9 == 0) {
                    if (bl && n6 != 0 && (n = iDocument.getLineLength(n6 - 1) - this.fStyledText.getLineDelimiter().length()) == 0 && n2 == 1) {
                        --n6;
                    }
                } else {
                    ++n6;
                }
                this.fSequenceNumberArea.deleteSequenceNumbers(n6, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private int getLineDelimiterIndex(String string, int n) {
        try {
            String string2 = this.fStyledText.getLineDelimiter();
            return string.indexOf(string2, n);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CBDTUiPlugin.logError(indexOutOfBoundsException);
        }
        return -1;
    }

    private boolean isAnyNewLineLimiters(String string) {
        this.fDelimiters = this.getNewLineDelimiters();
        if (this.fDelimiters != null) {
            int n = 0;
            while (n < this.fDelimiters.length) {
                if (string.startsWith(this.fDelimiters[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private String[] getNewLineDelimiters() {
        if (this.fDelimiters == null) {
            this.fDelimiters = this.fSourceViewer.getDocument().getLegalLineDelimiters();
        }
        return this.fDelimiters;
    }

    private int getCurrentColumn() {
        int n = -1;
        int n2 = 0;
        try {
            int n3 = this.fSourceViewer.getVisibleRegion().getOffset();
            int n4 = n3 + this.fStyledText.getCaretOffset();
            IDocument iDocument = this.fSourceViewer.getDocument();
            n = iDocument.getLineOfOffset(n4);
            int n5 = iDocument.getLineOffset(n);
            int n6 = this.fStyledText.getTabs();
            int n7 = 1;
            int n8 = n5;
            while (n8 < n4) {
                if ('\t' == iDocument.getChar(n8)) {
                    while ((n2 + n7 + 6) % n6 != 0) {
                        ++n7;
                    }
                    n2 += n7;
                    n7 = 1;
                } else {
                    ++n2;
                }
                ++n8;
            }
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
            n2 = 0;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            n2 = 0;
        }
        return n2;
    }

    private void setErrorMessage(String string) {
        if (this.fStatusLineMessage == null) {
            this.fStatusLineMessage = COBOLStatusLineMessages.getInstance(null);
        }
        if (this.fStatusLineMessage != null) {
            if (string != null) {
                this.fStatusLineMessage.setErrorMessage(string);
            } else {
                this.fStatusLineMessage.clearMessage();
            }
        }
    }

    @Override
    public void handleDispose() {
        this.fStyledText = null;
        this.fSourceViewer = null;
        this.fSequenceNumberArea = null;
        this.fStatusLineMessage = null;
        this.fEditor = null;
        this.fDelimiters = null;
    }
}

