/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.fixedformat;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.COBOLBaseDocumentProvider;
import org.eclipse.cobol.ui.common.COBOLSequenceNumberHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class COBOLFixedFormatDocumentProvider
extends COBOLBaseDocumentProvider {
    private StringBuffer fSequenceNumberBuffer;
    private StringBuffer fLastSavedSequenceNumberBuffer;
    private StringBuffer fDocumentTextBuffer;
    private boolean isPATTERN_B = false;
    private InternalListener fInternalListener;
    private Map fSequenceInfoMap = new HashMap();
    protected COBOLElementInfo movedElementInfo;

    protected void setDocumentContent(IDocument iDocument, InputStream inputStream, String string) throws CoreException {
        if (string == null) {
            string = this.getDefaultEncoding();
        }
        this.setDocumentContentWithEncoding(iDocument, inputStream, string);
    }

    private void setDocumentContentWithEncoding(IDocument iDocument, InputStream inputStream, String string) throws CoreException {
        StringBuffer stringBuffer;
        Object object;
        String string2;
        String string3;
        BufferedReader bufferedReader;
        block38: {
            block39: {
                END_OF_LINE = "\n";
                this.fSequenceNumberBuffer = new StringBuffer();
                this.fDocumentTextBuffer = new StringBuffer();
                this.fLastSavedSequenceNumberBuffer = new StringBuffer();
                bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
                string3 = bufferedReader.readLine();
                string2 = null;
                object = null;
                stringBuffer = new StringBuffer();
                this.isPATTERN_B = false;
                if (string3 != null) break block38;
                if (this.movedElementInfo != null) {
                    this.fSequenceNumberBuffer = this.movedElementInfo.fSequenceBuffer;
                    this.fLastSavedSequenceNumberBuffer = this.movedElementInfo.fPreservedText;
                    this.isPATTERN_B = this.movedElementInfo.isPatternB;
                    this.movedElementInfo.reset();
                    this.movedElementInfo = null;
                }
                if (bufferedReader == null) break block39;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
        try {
            try {
                int n = 0;
                int n2 = 0;
                while (string3 != null) {
                    string2 = string3;
                    if (object == null) {
                        object = bufferedReader.readLine();
                    }
                    if (string3.length() == 0) {
                        stringBuffer.append("      ");
                    } else {
                        int n3 = 0;
                        int n4 = 6;
                        if (string3.length() < 6) {
                            n4 = string3.length();
                        }
                        while (n3 < n4) {
                            if (string3.charAt(n3) == '\t') {
                                stringBuffer.append(" ");
                            } else {
                                stringBuffer.append(string3.charAt(n3));
                            }
                            ++n3;
                        }
                        while (n3 < 6) {
                            stringBuffer.append(" ");
                            ++n3;
                        }
                        if (string3.length() > 6) {
                            String string4 = string3.substring(6, string3.length());
                            if (this.fExpandTabs) {
                                string4 = this.expandTabs(string4);
                            }
                            this.fDocumentTextBuffer.append(string4);
                        }
                    }
                    this.fSequenceNumberBuffer.append(stringBuffer);
                    try {
                        if (!this.isPATTERN_B) {
                            Integer.parseInt(stringBuffer.toString());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.updatePattern();
                    }
                    try {
                        if (!this.isPATTERN_B && !stringBuffer.equals("      ")) {
                            n = Integer.parseInt(stringBuffer.toString());
                            if (n2 >= n || n > 999999) {
                                this.updatePattern();
                            }
                            n2 = n;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.updatePattern();
                    }
                    string3 = object;
                    object = null;
                    if (string3 != null) {
                        if (string3.length() != 0 && string3.getBytes()[0] == 26 && (object = bufferedReader.readLine()) == null) break;
                        this.fSequenceNumberBuffer.append('\n');
                        this.fDocumentTextBuffer.append(END_OF_LINE);
                    } else if (stringBuffer.toString().equals("      ") && string2.length() == 0) {
                        this.fSequenceNumberBuffer.delete(this.fSequenceNumberBuffer.length() - 7, this.fSequenceNumberBuffer.length());
                        this.fDocumentTextBuffer.delete(this.fDocumentTextBuffer.length() - END_OF_LINE.length(), this.fDocumentTextBuffer.length());
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                }
            }
            catch (IOException iOException) {
                string2 = iOException.getMessage() == null ? "" : iOException.getMessage();
                object = new Status(4, CBDTUiPlugin.getPluginId(), 0, string2, (Throwable)iOException);
                throw new CoreException((IStatus)object);
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        this.fLastSavedSequenceNumberBuffer.append(this.fSequenceNumberBuffer.toString());
        iDocument.set(this.fDocumentTextBuffer.toString());
        if (this.movedElementInfo != null) {
            this.fSequenceNumberBuffer = this.movedElementInfo.fSequenceBuffer;
            this.fLastSavedSequenceNumberBuffer = this.movedElementInfo.fPreservedText;
            this.isPATTERN_B = this.movedElementInfo.isPatternB;
            this.movedElementInfo.reset();
            this.movedElementInfo = null;
        }
    }

    private void updatePattern() {
        this.isPATTERN_B = true;
    }

    public boolean isPatternB() {
        return this.isPATTERN_B;
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        Object object2;
        Object object3 = null;
        if (object instanceof IFileEditorInput) {
            FileDocumentProvider.FileInfo fileInfo;
            BufferedInputStream bufferedInputStream;
            object2 = (IFileEditorInput)object;
            object3 = this.fExpandTabs ? this.expandDoc(iDocument) : new Document(iDocument.get());
            int n = object3.getNumberOfLines();
            COBOLElementInfo cOBOLElementInfo = (COBOLElementInfo)this.fSequenceInfoMap.get(object2);
            if (cOBOLElementInfo != null) {
                this.fSequenceNumberBuffer = cOBOLElementInfo.fSequenceBuffer;
            }
            if (this.fSequenceNumberBuffer != null && this.fSequenceNumberBuffer.length() == 0) {
                n = 0;
            }
            COBOLSequenceNumberHandler cOBOLSequenceNumberHandler = new COBOLSequenceNumberHandler();
            StringBuffer stringBuffer = cOBOLSequenceNumberHandler.getCombinedBuffer((Document)object3, this.fSequenceNumberBuffer, n);
            IFile iFile = object2.getFile();
            String string = "";
            try {
                string = iFile.getCharset();
            }
            catch (CoreException coreException) {
                string = "";
            }
            try {
                bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes(string)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
            }
            if (iFile.exists()) {
                fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
                if (fileInfo != null && !bl) {
                    this.checkSynchronizationState(fileInfo.fModificationStamp, (IResource)iFile);
                }
                this.fireElementStateChanging(object);
                iFile.setContents((InputStream)bufferedInputStream, bl, true, iProgressMonitor);
                if (fileInfo != null) {
                    ResourceMarkerAnnotationModel resourceMarkerAnnotationModel = (ResourceMarkerAnnotationModel)fileInfo.fModel;
                    resourceMarkerAnnotationModel.updateMarkers(fileInfo.fDocument);
                    fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFile);
                }
            } else {
                try {
                    iProgressMonitor.beginTask("Saving File", 2000);
                    fileInfo = new ContainerGenerator(iFile.getParent().getFullPath());
                    fileInfo.generateContainer((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                    iFile.create((InputStream)bufferedInputStream, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                }
                finally {
                    iProgressMonitor.done();
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    CBDTUiPlugin.logError(iOException);
                }
            }
        } else {
            object3 = this.fExpandTabs ? this.expandDoc(iDocument) : iDocument;
            super.doSaveDocument(iProgressMonitor, object, object3, bl);
        }
        if (this.fSequenceNumberBuffer != null) {
            this.fLastSavedSequenceNumberBuffer = new StringBuffer(this.fSequenceNumberBuffer.toString());
        }
        if ((object2 = (COBOLElementInfo)this.fSequenceInfoMap.get(object)) != null) {
            object2.fPreservedText = this.fLastSavedSequenceNumberBuffer;
        }
    }

    public StringBuffer getSequenceNumberBuffer() {
        return this.fSequenceNumberBuffer;
    }

    public StringBuffer getLastSavedSequenceNumberBuffer() {
        return this.fLastSavedSequenceNumberBuffer;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (object instanceof IFileEditorInput) {
            AbstractDocumentProvider.ElementInfo elementInfo = super.createElementInfo(object);
            IFileEditorInput cfr_ignored_0 = (IFileEditorInput)object;
            COBOLElementInfo cOBOLElementInfo = new COBOLElementInfo();
            this.fSequenceInfoMap.put(object, cOBOLElementInfo);
            return elementInfo;
        }
        return super.createElementInfo(object);
    }

    protected void disposeElementInfo(Object object, AbstractDocumentProvider.ElementInfo elementInfo) {
        super.disposeElementInfo(object, elementInfo);
        if (elementInfo instanceof FileDocumentProvider.FileInfo) {
            COBOLElementInfo cOBOLElementInfo = (COBOLElementInfo)this.fSequenceInfoMap.get(object);
            if (cOBOLElementInfo != null) {
                if (this.movedElementInfo != cOBOLElementInfo) {
                    cOBOLElementInfo.reset();
                }
                cOBOLElementInfo = null;
            }
            this.fSequenceInfoMap.remove(object);
        }
    }

    public void setLatestEditorInfo(Object object) {
        COBOLElementInfo cOBOLElementInfo = (COBOLElementInfo)this.fSequenceInfoMap.get(object);
        if (cOBOLElementInfo != null) {
            this.fSequenceNumberBuffer = cOBOLElementInfo.fSequenceBuffer;
            this.fLastSavedSequenceNumberBuffer = cOBOLElementInfo.fPreservedText;
            this.isPATTERN_B = cOBOLElementInfo.isPatternB;
        }
    }

    protected void fireElementMoved(Object object, Object object2) {
        if (this.canSaveDocument(object)) {
            COBOLElementInfo cOBOLElementInfo;
            this.movedElementInfo = cOBOLElementInfo = (COBOLElementInfo)this.fSequenceInfoMap.get(object);
        }
        super.fireElementMoved(object, object2);
    }

    protected void fireElementContentAboutToBeReplaced(Object object) {
        COBOLElementInfo cOBOLElementInfo = (COBOLElementInfo)this.fSequenceInfoMap.get(object);
        cOBOLElementInfo.fSequenceBuffer = this.fSequenceNumberBuffer;
        this.fLastSavedSequenceNumberBuffer = cOBOLElementInfo.fPreservedText;
        cOBOLElementInfo.isPatternB = this.isPATTERN_B;
        cOBOLElementInfo.listener.updateSequenceBuffer();
        this.fSequenceInfoMap.put(object, cOBOLElementInfo);
        super.fireElementContentAboutToBeReplaced(object);
    }

    public void updatePattern(boolean bl, Object object) {
        this.isPATTERN_B = bl;
        COBOLElementInfo cOBOLElementInfo = (COBOLElementInfo)this.fSequenceInfoMap.get(object);
        cOBOLElementInfo.isPatternB = this.isPATTERN_B;
        this.fSequenceInfoMap.put(object, cOBOLElementInfo);
    }

    public void addDocumentChangedListener(InternalListener internalListener) {
        this.fInternalListener = internalListener;
    }

    public void removeDocumentChangedListener() {
        this.fInternalListener = null;
    }

    public void resetPattern(Object object, boolean bl) {
        if (this.fSequenceInfoMap.containsKey(object)) {
            COBOLElementInfo cOBOLElementInfo = (COBOLElementInfo)this.fSequenceInfoMap.get(object);
            cOBOLElementInfo.isPatternB = bl;
            this.isPATTERN_B = bl;
        }
    }

    public void shutdown() {
        try {
            Iterator iterator = this.getConnectedElements();
            while (iterator.hasNext()) {
                this.disconnect(iterator.next());
            }
            if (this.fSequenceInfoMap != null) {
                for (COBOLElementInfo cOBOLElementInfo : this.fSequenceInfoMap.entrySet()) {
                    cOBOLElementInfo.reset();
                    Object cOBOLElementInfo2 = null;
                }
                this.fSequenceInfoMap.clear();
                this.fSequenceInfoMap = null;
            }
            if (this.movedElementInfo != null) {
                this.movedElementInfo.reset();
                this.movedElementInfo = null;
            }
            this.fSequenceNumberBuffer = null;
            this.fDocumentTextBuffer = null;
            this.fLastSavedSequenceNumberBuffer = null;
            this.fInternalListener = null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected class COBOLElementInfo {
        StringBuffer fSequenceBuffer;
        StringBuffer fPreservedText;
        InternalListener listener;
        boolean isPatternB;

        protected COBOLElementInfo() {
            this.fSequenceBuffer = COBOLFixedFormatDocumentProvider.this.fSequenceNumberBuffer;
            this.fPreservedText = COBOLFixedFormatDocumentProvider.this.fLastSavedSequenceNumberBuffer;
            this.isPatternB = COBOLFixedFormatDocumentProvider.this.isPATTERN_B;
            this.listener = COBOLFixedFormatDocumentProvider.this.fInternalListener;
        }

        protected void reset() {
            this.fSequenceBuffer = null;
            this.fPreservedText = null;
            this.isPatternB = false;
            this.listener = null;
        }
    }

    public static interface InternalListener {
        public void updateSequenceBuffer();
    }
}

