/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.fixedformat;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.text.COBOLAbstractCodeScanner;
import org.eclipse.cobol.ui.common.text.COBOLColorManager;
import org.eclipse.cobol.ui.common.text.COBOLEndOfLineRule;
import org.eclipse.cobol.ui.common.text.COBOLPidAreaRule;
import org.eclipse.cobol.ui.common.text.COBOLSingleLineRule;
import org.eclipse.cobol.ui.common.text.COBOLWhitespaceDetector;
import org.eclipse.cobol.ui.common.text.COBOLWordDetector;
import org.eclipse.cobol.ui.common.text.COBOLWordRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public final class COBOLFixedFormatCodeScanner
extends COBOLAbstractCodeScanner {
    private static String[] fTokenProperties = new String[]{"cobol_comment", "cobol_string", "cobol_reserved_word", "cobol_in_line_comment", "cobol_figurative_constant", "cobol_special_register", "cobol_default"};

    public COBOLFixedFormatCodeScanner(COBOLColorManager cOBOLColorManager, IPreferenceStore iPreferenceStore) {
        super(cOBOLColorManager, iPreferenceStore);
        this.initialize();
    }

    @Override
    protected String[] getTokenProperties() {
        return fTokenProperties;
    }

    @Override
    protected List createRules() {
        Token token = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        token = this.getToken("cobol_comment");
        COBOLEndOfLineRule cOBOLEndOfLineRule = new COBOLEndOfLineRule("*", (IToken)token, "FIXED");
        cOBOLEndOfLineRule.setColumnConstraint(0);
        arrayList.add((Object)cOBOLEndOfLineRule);
        COBOLEndOfLineRule cOBOLEndOfLineRule2 = new COBOLEndOfLineRule("/", (IToken)token, "FIXED");
        cOBOLEndOfLineRule2.setColumnConstraint(0);
        arrayList.add((Object)cOBOLEndOfLineRule2);
        COBOLEndOfLineRule cOBOLEndOfLineRule3 = new COBOLEndOfLineRule("D", (IToken)token, "FIXED");
        cOBOLEndOfLineRule3.setColumnConstraint(0);
        arrayList.add((Object)cOBOLEndOfLineRule3);
        token = this.getToken("cobol_in_line_comment");
        COBOLEndOfLineRule cOBOLEndOfLineRule4 = new COBOLEndOfLineRule("*>", (IToken)token, "FIXED");
        arrayList.add((Object)cOBOLEndOfLineRule4);
        COBOLPidAreaRule cOBOLPidAreaRule = new COBOLPidAreaRule((IToken)token, "FIXED");
        arrayList.add(cOBOLPidAreaRule);
        token = this.getToken("cobol_string");
        arrayList.add((Object)new COBOLSingleLineRule("\"", "\"", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("B\"", "\"", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("N\"", "\"", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("NC\"", "\"", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("NX\"", "\"", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("X\"", "\"", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("'", "'", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("B'", "'", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("N'", "'", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("NC'", "'", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("NX'", "'", (IToken)token, "FIXED"));
        arrayList.add((Object)new COBOLSingleLineRule("X'", "'", (IToken)token, "FIXED"));
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new COBOLWhitespaceDetector()));
        WordRule wordRule = this.createWordRules();
        if (wordRule != null) {
            arrayList.add(wordRule);
        }
        this.setDefaultReturnToken((IToken)this.getToken("cobol_default"));
        return arrayList;
    }

    @Override
    protected WordRule createWordRules() {
        Token token = this.getToken("cobol_default");
        COBOLWordRule cOBOLWordRule = new COBOLWordRule(new COBOLWordDetector("FIXED"), (IToken)token, "FIXED");
        token = this.getToken("cobol_reserved_word");
        int n = 0;
        while (n < this.fReservedWords.length) {
            cOBOLWordRule.addWord(this.fReservedWords[n], (IToken)token);
            ++n;
        }
        token = this.getToken("cobol_figurative_constant");
        n = 0;
        while (n < this.fFigurativeConstants.length) {
            cOBOLWordRule.addWord(this.fFigurativeConstants[n], (IToken)token);
            ++n;
        }
        token = this.getToken("cobol_special_register");
        n = 0;
        while (n < this.fSpecialRegisters.length) {
            cOBOLWordRule.addWord(this.fSpecialRegisters[n], (IToken)token);
            ++n;
        }
        return cOBOLWordRule;
    }

    public int getColumn() {
        int n = 0;
        try {
            int n2 = this.fDocument.getLineOfOffset(this.fOffset);
            int n3 = this.fDocument.getLineOffset(n2);
            int n4 = CBDTUiPlugin.getDefault().getPreferenceStore().getInt("Tab Width");
            int n5 = 1;
            int n6 = n3;
            while (n6 < this.fOffset) {
                if ('\t' == this.fDocument.getChar(n6)) {
                    while ((n + n5 + 6) % n4 != 0) {
                        ++n5;
                    }
                    n += n5;
                    n5 = 1;
                } else {
                    ++n;
                }
                ++n6;
            }
            this.fColumn = n;
        }
        catch (BadLocationException badLocationException) {}
        return this.fColumn;
    }
}

