/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.editor;

import com.unisys.os2200.util.MemChecker;
import com.unisys.tde.core.EditorSourceViewer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.editor.TextBody;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class COBOLSourceViewer
extends EditorSourceViewer {
    private List fTextConverters;
    private TextBody fTextBody;
    private boolean undoing = false;

    public COBOLSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n) {
        super(composite, iVerticalRuler, iOverviewRuler, bl, n);
    }

    public void changeTextPresentation(TextPresentation textPresentation, boolean bl) {
        if (MemChecker.getInstance().hasEnoughMemory(false, true)) {
            super.changeTextPresentation(textPresentation, bl);
        } else {
            CBDTUiPlugin.logTraceMessage("Not enough memory to changeTextPresentation in COBOLEditor.");
        }
    }

    public void configure(SourceViewerConfiguration sourceViewerConfiguration) {
        super.configure(sourceViewerConfiguration);
        String[] stringArray = sourceViewerConfiguration.getConfiguredContentTypes((ISourceViewer)this);
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            this.setTextDoubleClickStrategy((ITextDoubleClickStrategy)this, string);
            ++n;
        }
    }

    protected StyledText createTextWidget(Composite composite, int n) {
        return new StyledText(composite, n);
    }

    protected void handleDispose() {
        super.handleDispose();
    }

    protected void customizeDocumentCommand(DocumentCommand documentCommand) {
        super.customizeDocumentCommand(documentCommand);
        if (this.fTextConverters != null) {
            Iterator iterator = this.fTextConverters.iterator();
            while (iterator.hasNext()) {
                ((ITextConverter)iterator.next()).customizeDocumentCommand(this.getDocument(), documentCommand);
            }
        }
    }

    public void doubleClicked(ITextViewer iTextViewer) {
        Point point = this.getSelectedRange();
        IDocument iDocument = this.getDocument();
        iDocument.get();
        int n = iDocument.getLength();
        int n2 = 0;
        try {
            char c;
            int n3;
            int n4 = 0;
            if (point.x == n) {
                return;
            }
            char c2 = iDocument.getChar(point.x);
            if (!Character.isLetterOrDigit(c2) && c2 != '-') {
                return;
            }
            n4 = point.x + 1;
            while (n4 < n) {
                n3 = iDocument.getChar(n4);
                if (!Character.isLetterOrDigit((char)n3) && n3 != 45) break;
                ++n4;
            }
            n3 = n4;
            n4 = point.x;
            while (n4 > n2) {
                c = iDocument.getChar(n4);
                if (!Character.isLetterOrDigit(c) && c != '-') break;
                --n4;
            }
            c = n4 + 1;
            this.setSelectedRange(c, n3 - c);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void addTextConverter(ITextConverter iTextConverter) {
        if (iTextConverter != null && iTextConverter instanceof AutoTag) {
            ((AutoTag)iTextConverter).setSourceViewer(this);
        }
        if (this.fTextConverters == null) {
            this.fTextConverters = new ArrayList(1);
            this.fTextConverters.add(iTextConverter);
        } else if (!this.fTextConverters.contains(iTextConverter)) {
            this.fTextConverters.add(iTextConverter);
        }
    }

    public void removeTextConverter(ITextConverter iTextConverter) {
        if (this.fTextConverters != null) {
            this.fTextConverters.remove(iTextConverter);
            if (this.fTextConverters.size() == 0) {
                this.fTextConverters = null;
            }
        }
    }

    public void addTagListener() {
        this.fTextBody = new TextBody(this);
        this.addTextListener(this.fTextBody);
    }

    public void removeTagListener() {
        if (this.fTextBody != null) {
            this.removeTextListener(this.fTextBody);
        }
        this.fTextBody = null;
    }

    public void setText(String string) {
        this.getDocument().set(string);
    }

    public void setUndoing(boolean bl) {
        this.undoing = bl;
    }

    public boolean getUndoing() {
        return this.undoing;
    }

    static class AutoTag
    implements ITextConverter {
        String tag1_6 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Tag-1-6");
        COBOLSourceViewer mySV;
        int startReplace;
        int endReplace;

        public AutoTag() {
            if (this.tag1_6.trim().length() > 0) {
                this.tag1_6 = (String.valueOf(this.tag1_6) + "     ").substring(0, 6);
            }
        }

        boolean lfWithBlanks(String string) {
            if (!string.startsWith("\n")) {
                return false;
            }
            String string2 = string.substring(1);
            if (string2.trim().length() > 7) {
                return false;
            }
            int n = 0;
            while (n < string2.length()) {
                if (string2.charAt(n) != ' ') {
                    return false;
                }
                ++n;
            }
            return true;
        }

        @Override
        public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
            if (!MemChecker.getInstance().hasEnoughMemory(false, false)) {
                return;
            }
            try {
                this.tag1_6 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Tag-1-6");
                if (this.tag1_6.length() > 0 && !this.mySV.getUndoing()) {
                    this.tag1_6 = (String.valueOf(this.tag1_6) + "      ").substring(0, 6);
                    String string = iDocument.get();
                    IRegion iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                    this.mySV.getTopIndex();
                    String string2 = documentCommand.text;
                    int n = iRegion.getOffset();
                    int n2 = iRegion.getLength();
                    int n3 = documentCommand.offset;
                    int n4 = n3 - n;
                    boolean bl = this.checkDeleteAll(documentCommand, iDocument);
                    if (bl) {
                        return;
                    }
                    if (n3 - n < 6) {
                        if (n == n3) {
                            if (string2.equals("")) {
                                n = documentCommand.offset = n + 6;
                            }
                            if (!this.lfWithBlanks(string2) && !this.multiLine(string2)) {
                                n = documentCommand.offset = n + 6;
                            }
                        } else {
                            n = documentCommand.offset = n + 6;
                        }
                    }
                    boolean bl2 = n == n3;
                    boolean bl3 = n3 == n + n2;
                    documentCommand.getCommandCount();
                    if (this.lfWithBlanks(documentCommand.text)) {
                        int n5 = this.findCurrentLineTab(iRegion, string);
                        int n6 = n5 - 6;
                        if (n4 < n5) {
                            n6 = n4 - 6;
                        }
                        String string3 = this.getPaddingBlanks(n6);
                        if (bl2) {
                            documentCommand.text = String.valueOf(this.tag1_6) + " \n";
                        } else if (bl3) {
                            documentCommand.text = "\n" + this.tag1_6 + string3;
                        } else {
                            this.updateRegion(iRegion, iDocument);
                            documentCommand.text = documentCommand.text.length() == 7 ? "\n" + this.tag1_6 + string3 : "\n" + this.tag1_6 + string3;
                        }
                    } else if (documentCommand.text.indexOf("\n", 0) < 0) {
                        this.updateRegion(iRegion, iDocument);
                    } else {
                        String string4 = "";
                        String string5 = documentCommand.text;
                        int n7 = 0;
                        if (!(bl2 || string5.startsWith("\n") && bl3)) {
                            this.updateRegion(iRegion, iDocument);
                        }
                        int n8 = n7;
                        int n9 = string5.length();
                        String string6 = "";
                        boolean bl4 = true;
                        boolean bl5 = false;
                        while (n7 >= 0) {
                            n7 = string5.indexOf("\n", n8);
                            if (n7 >= 0) {
                                string6 = string5.substring(n8, n7 + 1);
                                if (!(string6.length() >= 7 || bl4 && !bl2 || bl5)) {
                                    string6 = String.valueOf(this.tag1_6) + "\n";
                                } else if (bl4 && bl2) {
                                    string6 = string6.length() > 6 ? String.valueOf(this.tag1_6) + string6.substring(6) : String.valueOf(this.tag1_6) + "\n";
                                }
                                bl4 = false;
                                bl5 = false;
                                string4 = String.valueOf(string4) + string6;
                                if (n7 < string5.length() - 1 || string5.charAt(n7) != '\n') {
                                    bl5 = true;
                                    string4 = String.valueOf(string4) + this.tag1_6;
                                }
                                if (n7 + 7 < n9) {
                                    n8 = n7 + 7;
                                    continue;
                                }
                                n7 = -1;
                                continue;
                            }
                            if (string5.length() <= n8) continue;
                            string4 = String.valueOf(string4) + string5.substring(n8);
                        }
                        documentCommand.text = string4;
                        if (string4.endsWith(this.tag1_6)) {
                            iDocument.replace(documentCommand.offset, 6, "");
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                System.out.println("err getting line region " + badLocationException.getMessage());
            }
        }

        private int findCurrentLineTab(IRegion iRegion, String string) {
            int n = 8;
            int n2 = iRegion.getOffset();
            int n3 = iRegion.getLength();
            int n4 = n2 + 7;
            int n5 = 0;
            int n6 = n4;
            while (n6 < n2 + n3) {
                if (string.charAt(n6) != ' ') break;
                ++n5;
                ++n6;
            }
            n = n5 + 7;
            return n;
        }

        String getPaddingBlanks(int n) {
            String string = "";
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + " ";
                ++n2;
            }
            return string;
        }

        private boolean checkDeleteAll(DocumentCommand documentCommand, IDocument iDocument) {
            return documentCommand.text.equals("") && documentCommand.length == iDocument.getLength();
        }

        boolean multiLine(String string) {
            int n = string.length();
            int n2 = string.indexOf("\n");
            if (n2 >= 0) {
                if (n > n2) {
                    return true;
                }
                if (n2 > 7) {
                    return true;
                }
            }
            return false;
        }

        void updateRegion(IRegion iRegion, IDocument iDocument) {
            try {
                if (iRegion.getLength() > 6) {
                    iDocument.replace(iRegion.getOffset(), 6, this.tag1_6);
                } else {
                    iDocument.replace(iRegion.getOffset(), iRegion.getLength(), this.tag1_6);
                }
            }
            catch (BadLocationException badLocationException) {
                System.out.println("err replacing update regiin " + badLocationException.getMessage());
            }
        }

        void setSourceViewer(COBOLSourceViewer cOBOLSourceViewer) {
            this.mySV = cOBOLSourceViewer;
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    static class TabConverter
    implements ITextConverter {
        private int fTabRatio;
        private ILineTracker fLineTracker;

        TabConverter() {
        }

        public void setNumberOfSpacesPerTab(int n) {
            this.fTabRatio = n;
        }

        public void setLineTracker(ILineTracker iLineTracker) {
            this.fLineTracker = iLineTracker;
        }

        private int insertTabString(StringBuffer stringBuffer, int n) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            COBOLEditor cOBOLEditor = null;
            CBDTUiPlugin.getDefault();
            cOBOLEditor = (COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor();
            String string = cOBOLEditor.getCursorPosition();
            String[] stringArray = string.split(":");
            int n2 = Integer.parseInt(stringArray[1].trim());
            int n3 = 0;
            String string2 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Column Tab Width");
            String[] stringArray2 = new String[string2.length()];
            stringArray2 = string2.split(",");
            if (Integer.parseInt(stringArray2[stringArray2.length - 1]) < 73) {
                string2 = string2.concat(",73");
                stringArray2 = string2.split(",");
            }
            int n4 = 0;
            while (n4 < stringArray2.length) {
                int n5 = Integer.parseInt(stringArray2[n4]);
                if (n2 < n5) {
                    this.fTabRatio = n5 - n2;
                    break;
                }
                if (n2 > n5) {
                    // empty if block
                }
                ++n4;
            }
            if (n2 >= 73) {
                this.fTabRatio = 1;
            }
            n3 = this.fTabRatio;
            n4 = 0;
            while (n4 < this.fTabRatio) {
                stringBuffer.append(' ');
                ++n4;
            }
            return n3;
        }

        @Override
        public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
            String string = documentCommand.text;
            if (string == null) {
                return;
            }
            int n = string.indexOf(9);
            if (n > -1) {
                StringBuffer stringBuffer = new StringBuffer();
                this.fLineTracker.set(documentCommand.text);
                int n2 = this.fLineTracker.getNumberOfLines();
                try {
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = this.fLineTracker.getLineOffset(n3);
                        int n5 = n4 + this.fLineTracker.getLineLength(n3);
                        String string2 = string.substring(n4, n5);
                        int n6 = 0;
                        if (n3 == 0) {
                            IRegion iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                            n6 = documentCommand.offset - iRegion.getOffset();
                        }
                        int n7 = string2.length();
                        int n8 = 0;
                        while (n8 < n7) {
                            char c = string2.charAt(n8);
                            if (c == '\t') {
                                n6 += this.insertTabString(stringBuffer, n6);
                            } else {
                                stringBuffer.append(c);
                                ++n6;
                            }
                            ++n8;
                        }
                        ++n3;
                    }
                    documentCommand.text = stringBuffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }
}

