/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.EventData;
import org.eclipse.cobol.ui.common.LineReader;
import org.eclipse.cobol.ui.common.LineWrapper;
import org.eclipse.cobol.ui.views.outlineview.COBOLParser;
import org.eclipse.cobol.ui.views.outlineview.Element;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.TreeViewer;

public class COBOLElementDeltaProcessor {
    int startLine = -1;
    int endLine = -1;
    int operation = 0;
    String newText = "";
    String prevText = "";
    String deltaText = "";
    Element fRoot = null;
    ISourceViewer fSourceViewer = null;
    COBOLParser fParser = null;
    TreeViewer fTreeViewer = null;
    ArrayList affected = new ArrayList();
    HashMap fLineMap = null;
    ArrayList fUnusedEnds = null;
    ArrayList finalAffected = new ArrayList();
    int addedLines = 0;
    int deletedLines = 0;
    Element prevElement;
    Element nextElement;
    LineReader fReader = null;
    boolean isModelUpdated = false;

    public COBOLElementDeltaProcessor(ISourceViewer iSourceViewer, Element element, COBOLParser cOBOLParser, TreeViewer treeViewer) {
        this.fSourceViewer = iSourceViewer;
        this.fRoot = element;
        this.fParser = cOBOLParser;
        this.fTreeViewer = treeViewer;
    }

    public void setElementLineMap(HashMap hashMap) {
        this.fLineMap = hashMap;
    }

    public void setUnusedEndList(ArrayList arrayList) {
        this.fUnusedEnds = arrayList;
    }

    public void setEventData(EventData eventData) {
        if (eventData != null) {
            this.isModelUpdated = false;
            this.affected.clear();
            this.finalAffected.clear();
            this.startLine = eventData.getStartLine();
            this.endLine = eventData.getEndLine();
            this.newText = eventData.getText();
            this.prevText = eventData.getPrevText();
            this.deltaText = eventData.getDeltaText();
            this.operation = eventData.getOperationType();
            if (this.endLine == -1) {
                this.endLine = this.startLine;
            }
        }
    }

    public void processDelta() throws Exception {
        this.addedLines = this.findNoOfLines(this.deltaText);
        this.deletedLines = this.findNoOfLines(this.prevText);
        this.findAffectedElements(this.startLine, this.startLine + this.deletedLines);
        switch (this.operation) {
            case 1: {
                this.processPositionUpdation(this.addedLines);
                this.processSingleLine();
                break;
            }
            case 2: {
                this.processPositionUpdation(this.addedLines);
                if (this.addedLines > 0) {
                    this.processPaste();
                    break;
                }
                this.processSingleLine();
                break;
            }
            case 3: {
                if (this.deletedLines > 0) {
                    if (this.fLineMap.containsKey(new Integer(this.startLine)) && this.fLineMap.containsKey(new Integer(this.startLine + 1))) {
                        Element element = (Element)this.fLineMap.get(new Integer(this.startLine + 1));
                        this.invalidateElement(element);
                    }
                    this.processPositionUpdation(-this.deletedLines);
                    this.findAffectedElements(this.startLine, this.endLine);
                }
                this.processSingleLine();
                break;
            }
            case 4: {
                this.handleComplexProcess();
                break;
            }
            case 5: {
                this.handleComplexProcess();
                break;
            }
            case 6: {
                this.handleComplexProcess();
                break;
            }
            case 7: {
                this.handleComplexProcess();
            }
        }
        int n = 0;
        while (n < this.finalAffected.size()) {
            if (!this.isModelUpdated) {
                this.isModelUpdated = true;
            }
            this.fTreeViewer.refresh(this.finalAffected.get(n));
            ++n;
        }
        if (this.isModelAffected()) {
            this.fTreeViewer.expandAll();
        }
        this.fTreeViewer.refresh((Object)this.finalAffected.toArray(), true);
    }

    private void processPositionUpdation(int n) {
        if (n != 0) {
            this.updatePositions(this.fRoot, n);
            this.updateUnusedEnds(n);
        }
    }

    public void processSingleLine() throws Exception {
        int n;
        if (this.affected.size() == 0 && ((n = this.prevElement.getEndLine()) == -1 || n > this.startLine) && this.startLine <= this.prevElement.getLineNumber()) {
            this.affected.add(this.prevElement);
        }
        if (this.affected != null && this.affected.size() != 0) {
            this.processChangedDelta(this.affected);
        } else {
            String string = "";
            string = this.addedLines > 0 ? this.getLineContent(this.startLine, this.startLine + this.addedLines) : this.getLineContent(this.startLine, this.startLine);
            this.repairElement(null, new StringBuffer(string));
        }
    }

    private void handleComplexProcess() throws Exception {
        if (this.deletedLines > 0) {
            this.processReplace();
        } else if (this.addedLines > 0) {
            this.processPositionUpdation(this.addedLines);
            this.processPaste();
        } else {
            this.processSingleLine();
        }
    }

    public void processPaste() {
        Element element;
        String string = this.getLineContent(this.startLine, this.startLine);
        int n = this.startLine;
        int n2 = this.startLine + this.addedLines;
        if (this.affected.size() > 0) {
            element = (Element)this.affected.get(0);
            if (!this.fParser.isElementValid(element, new StringBuffer(string))) {
                element.getParent().removeChild(element);
                this.moveChilds(element, this.prevElement, this.startLine);
                this.clearElements(element);
            } else {
                this.finalAffected.add(element);
                this.prevElement = element;
                ++this.startLine;
                n = this.startLine;
            }
        }
        if ((element = this.findElementEnd(this.startLine)) != null) {
            if (!this.fParser.getEndProgramColumn(new StringBuffer(string))) {
                this.reArrangeEndOfElement(element);
            } else {
                ++n;
            }
        }
        this.insertElement(new StringBuffer(this.getLineContent(n, n2)), n, n2);
    }

    public void processReplace() {
        Element element = null;
        int n = -1;
        int n2 = -1;
        this.findAllElementEnds(this.deletedLines);
        element = this.affected != null && this.affected.size() != 0 ? this.deleteElements() : this.getParent();
        int n3 = this.addedLines - this.deletedLines;
        if (n3 != 0) {
            this.processPositionUpdation(n3);
        }
        if (this.affected.size() == 0) {
            return;
        }
        if (element != this.fRoot) {
            n = element.getStartLine();
            n2 = element.getEndLine() != -1 ? element.getEndLine() + n3 : this.fSourceViewer.getDocument().getNumberOfLines() - 1;
            element = element.getParent();
        } else {
            n = 0;
            n2 = this.deletedLines > 0 && this.addedLines > 0 || this.affected.size() > 0 ? this.fSourceViewer.getDocument().getNumberOfLines() - 1 : 0;
        }
        this.deltaParser(element, n, n2);
        this.finalAffected.add(element);
    }

    private void findAllElementEnds(int n) {
        if (this.affected != null) {
            int n2 = this.startLine;
            while (n2 <= this.startLine + n) {
                Element element = this.findElementEnd(n2);
                if (element != null && !this.affected.contains(element)) {
                    this.affected.add(element);
                }
                ++n2;
            }
        }
    }

    private void findAffectedElements(int n, int n2) {
        if (this.fLineMap != null) {
            int n3 = n;
            while (n3 <= n2) {
                Element element;
                if (this.fLineMap.containsKey(new Integer(n3)) && !this.affected.contains(element = (Element)this.fLineMap.get(new Integer(n3)))) {
                    this.affected.add(element);
                }
                ++n3;
            }
            this.prevElement = this.getPreviousElement(n - 1);
            if (this.prevElement == null) {
                this.prevElement = this.fRoot;
            }
            this.nextElement = this.getNextElement(n2 + 1);
        }
    }

    private Element getPreviousElement(int n) {
        int n2 = n;
        while (n2 >= 0) {
            if (this.fLineMap.containsKey(new Integer(n2))) {
                return (Element)this.fLineMap.get(new Integer(n2));
            }
            --n2;
        }
        return null;
    }

    private Element getNextElement(int n) {
        int n2 = n;
        if (n2 <= this.fSourceViewer.getDocument().getNumberOfLines() - 1) {
            return (Element)this.fLineMap.get(new Integer(n2));
        }
        return null;
    }

    public void processChangedDelta(ArrayList arrayList) throws Exception {
        block9: {
            if (arrayList == null || arrayList.size() == 0) break block9;
            int n = 0;
            while (n < arrayList.size()) {
                Element element = (Element)arrayList.get(n);
                int n2 = 0;
                int n3 = 0;
                try {
                    n2 = this.fSourceViewer.getDocument().getLineOffset(element.getStartLine());
                    if (this.startLine == this.endLine) {
                        int n4 = element.getLineNumber();
                        if (this.addedLines > 0) {
                            n4 += this.addedLines;
                        }
                        n3 = this.fSourceViewer.getDocument().getLineOffset(n4) + (this.fSourceViewer.getDocument().getLineLength(n4) - 1);
                    } else {
                        n3 = this.fSourceViewer.getDocument().getLineOffset(element.getLineNumber()) + (this.fSourceViewer.getDocument().getLineLength(element.getLineNumber()) - 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                String string = "";
                if (n3 >= n2) {
                    string = this.fSourceViewer.getTextWidget().getText(n2, n3);
                }
                this.fParser.setFromFile(false);
                this.repairElement(element, new StringBuffer(string));
                ++n;
            }
        }
    }

    public void repairElement(Element element, StringBuffer stringBuffer) {
        block11: {
            block12: {
                Element element2;
                block13: {
                    block14: {
                        block10: {
                            if (element == null) break block10;
                            if (!this.fParser.isElementValid(element, stringBuffer) || this.fParser.isCommentAvailableInLine(stringBuffer.toString())) {
                                this.invalidateElement(element);
                            } else {
                                this.adjustElement(element, stringBuffer);
                                this.finalAffected.add(element);
                            }
                            break block11;
                        }
                        element2 = this.findElementEnd(this.startLine);
                        if (element2 == null) break block12;
                        if (this.addedLines <= 0) break block13;
                        stringBuffer = new StringBuffer(this.getLineContent(this.startLine, this.startLine));
                        if (this.fParser.getEndProgramColumn(stringBuffer)) break block14;
                        stringBuffer = new StringBuffer(this.getLineContent(this.startLine + this.addedLines, this.startLine + this.addedLines));
                        if (this.fParser.getEndProgramColumn(stringBuffer)) {
                            element2.setEndLine(element2.getEndLine() + this.addedLines);
                        } else {
                            this.reArrangeEndOfElement(element2);
                        }
                        break block11;
                    }
                    stringBuffer = new StringBuffer(this.getLineContent(this.startLine + this.addedLines, this.startLine + this.addedLines));
                    if (!this.fParser.getProgramColumn(stringBuffer) || this.getParent().getBlockType() == 14) break block11;
                    this.insertElement(stringBuffer, this.startLine + this.addedLines, this.startLine + this.addedLines);
                    break block11;
                }
                if (this.fParser.getEndProgramColumn(stringBuffer)) break block11;
                this.reArrangeEndOfElement(element2);
                break block11;
            }
            if (this.fUnusedEnds.contains(new Integer(this.startLine))) {
                if (!this.fParser.getEndProgramColumn(stringBuffer)) {
                    this.fUnusedEnds.remove(new Integer(this.startLine));
                }
            } else if (this.addedLines > 0) {
                this.insertElement(new StringBuffer(this.getLineContent(this.startLine, this.startLine + this.addedLines)), this.startLine, this.startLine + this.addedLines);
            } else {
                int n = this.startLine;
                while (n <= this.startLine + this.addedLines) {
                    stringBuffer = new StringBuffer(this.getLineContent(n, n));
                    this.insertElement(stringBuffer, n);
                    ++n;
                }
            }
        }
    }

    private void invalidateElement(Element element) {
        element.getParent().removeChild(element);
        this.moveChilds(element, element.getParent(), this.startLine);
        this.clearElements(element);
        if (element.getEndLine() != -1) {
            this.addUnusedEnd(element.getEndLine());
        }
        this.doMethodProcessing(element);
    }

    private void doMethodProcessing(Element element) {
        if (element.getBlockType() == 14) {
            int n = element.getEndLine();
            if (n == -1) {
                n = this.fSourceViewer.getDocument().getNumberOfLines() - 1;
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.getLineContent(element.getStartLine() + 1, n));
                if (!this.fParser.getProgramColumn(stringBuffer)) {
                    this.finalAffected.add(element.getParent());
                    return;
                }
            }
            this.deltaParser(element.getParent(), element.getStartLine() + 1, n);
            this.parentProcess(element.getParent());
            this.finalAffected.add(element.getParent());
        }
    }

    private void insertElement(StringBuffer stringBuffer, int n) {
        if (this.fParser.getEndProgramColumn(stringBuffer)) {
            this.addEndOfElement(n, this.prevElement);
        } else if (this.fParser.getProgramColumn(stringBuffer) && this.getParent().getBlockType() != 14) {
            this.insertElement(stringBuffer, n, n);
        }
    }

    private void adjustElement(Element element, StringBuffer stringBuffer) {
        String string = element.getData();
        if (!this.fParser.isElementValid(element, new StringBuffer(this.getLineContent(element.getStartLine(), element.getStartLine())))) {
            int n = element.getStartLine();
            element.setStartLine(element.getStartLine() + this.addedLines);
            element.setLineNumber(element.getLineNumber() + this.addedLines);
            if (this.fLineMap.containsKey(new Integer(n))) {
                this.fLineMap.remove(new Integer(n));
                this.fLineMap.put(new Integer(element.getStartLine()), element);
            }
        } else {
            if (!element.getData().equals(string)) {
                if (element.getStartLine() == element.getLineNumber()) {
                    element.setLineNumber(element.getLineNumber() + this.addedLines);
                } else if (this.fParser.isElementValid(element, new StringBuffer(this.getLineContent(element.getStartLine(), element.getLineNumber()))) && !element.getData().equals(string)) {
                    element.setLineNumber(element.getLineNumber() + this.addedLines);
                }
                this.fParser.isElementValid(element, stringBuffer);
            } else if (element.getData().equals(string)) {
                element.setLineNumber(element.getStartLine());
                if (this.addedLines > 0) {
                    int n = this.startLine;
                    int n2 = this.startLine + this.addedLines;
                    this.finalAffected.add(element);
                    this.prevElement = element;
                    ++this.startLine;
                    n = this.startLine;
                    StringBuffer stringBuffer2 = new StringBuffer(this.getLineContent(n, n2));
                    this.insertElement(stringBuffer2, n, n2);
                }
            }
            this.setData(element);
        }
    }

    private void setData(Element element) {
        int n = element.getLineNumber();
        while (true) {
            if (element.getData().equalsIgnoreCase("end")) {
                element.setData("");
            }
            if (!element.getData().equals("") && !element.getData().equalsIgnoreCase("end") || this.fLineMap.containsKey(new Integer(++n)) || this.fUnusedEnds.contains(new Integer(n)) || n == element.getEndLine() || n > this.fSourceViewer.getDocument().getNumberOfLines() - 1) break;
            if (n == element.getEndLine()) continue;
            this.fParser.isElementValid(element, new StringBuffer(this.getLineContent(element.getStartLine(), n)));
            element.setLineNumber(n);
        }
    }

    private Element getParent() {
        int n;
        Element element;
        for (element = this.prevElement; element != this.fRoot && (n = element.getEndLine()) != -1 && this.startLine >= n; element = element.getParent()) {
        }
        return element;
    }

    private Element deleteElements() {
        Element element;
        Element element2 = null;
        Element element3 = null;
        int n = 0;
        while (n < this.affected.size()) {
            element = (Element)this.affected.get(n);
            element2 = element.getParent();
            if (element2 == this.fRoot) {
                element3 = element2;
            }
            if (element2.getParent() != null) {
                element2.getParent().removeChild(element2);
            }
            this.removeElement(element2);
            ++n;
        }
        n = 0;
        while (n < this.affected.size()) {
            element = (Element)this.affected.get(n);
            element2 = element.getParent();
            if (element2.getStartLine() <= this.startLine && (element2.getEndLine() == -1 || element2.getEndLine() >= this.endLine)) break;
            ++n;
        }
        return element3 != null ? element3 : element2;
    }

    private void removeElement(Element element) {
        ArrayList arrayList = element.getChildElements();
        if (arrayList != null && arrayList.size() != 0) {
            int n = 0;
            while (n < arrayList.size()) {
                Element element2 = (Element)arrayList.get(n);
                this.removeElement(element2);
                ++n;
            }
        }
        this.discardElement(element);
    }

    private void insertElement(StringBuffer stringBuffer, int n, int n2) {
        Element element = this.getParent();
        this.deltaParser(element, n, n2);
        this.parentProcess(element);
        this.finalAffected.add(element);
    }

    private void parentProcess(Element element) {
        ArrayList arrayList = element.getChildElements();
        if (arrayList != null && arrayList.size() != 0) {
            int n = 0;
            while (n < arrayList.size()) {
                Element element2 = (Element)arrayList.get(n);
                if (element2.getEndLine() == -1) {
                    this.reArrangeEndOfElement(element2);
                }
                if (element2.getBlockType() != 14) {
                    this.parentProcess(element2);
                }
                ++n;
            }
        }
    }

    private void deltaParser(Element element, int n, int n2) {
        Element element2;
        if (this.fReader == null) {
            this.fReader = this.fParser.getLineReader();
        }
        this.fReader.setLineCount(n - 1);
        Element element3 = element;
        Element element4 = null;
        LineWrapper lineWrapper = null;
        String string = null;
        int n3 = n;
        while ((lineWrapper = this.fReader.getNextLine()) != null) {
            Element[] elementArray;
            string = lineWrapper.line;
            n3 = lineWrapper.lineno;
            if (n2 < n3) break;
            element2 = element3;
            int n4 = element2.getEndLine();
            if (!this.fParser.isCommentLine(string)) {
                elementArray = this.fParser.createElement(new StringBuffer(string), n3, element4, element3);
                if (elementArray != null && elementArray.length == 2) {
                    element4 = elementArray[0];
                    element3 = elementArray[1];
                }
            } else if ((this.fParser.getSectionColumn(string) > 0 || this.fParser.getParaColumn(string) > 0 && string.toUpperCase().indexOf("PROGRAM-ID") < 0) && (elementArray = this.fParser.createElement(new StringBuffer(string), n3, element4, element3)) != null && elementArray.length == 2) {
                element4 = elementArray[0];
                element3 = elementArray[1];
            }
            if (n4 == element2.getEndLine()) continue;
            this.moveChilds(element2, element2.getParent(), element2.getEndLine() + 1);
        }
        if (element4 != null) {
            if (this.fLineMap.containsKey(new Integer(element4.getLineNumber()))) {
                element2 = (Element)this.fLineMap.get(new Integer(element4.getLineNumber()));
                if (element4 != element2) {
                    element4.setData("");
                    element4.setLineNumber(element2.getStartLine() - 1);
                }
            } else if (element4.getData().equalsIgnoreCase("end")) {
                element4.setData("");
            }
        }
    }

    private void updateEndOfElement(int n, Element element) {
        Element element2 = element;
        if (n != -1) {
            if (element2 == this.fRoot) {
                this.addUnusedEnd(n);
            } else if (element2.getEndLine() == -1) {
                element2.setEndLine(n);
                this.moveChilds(element2, element2.getParent(), n);
            } else if (element2.getEndLine() != -1) {
                int n2 = element2.getEndLine();
                element2.setEndLine(n);
                this.moveChilds(element2, element2.getParent(), n);
                this.updateEndOfElement(n2, element2.getParent());
            }
        }
    }

    private void addUnusedEnd(int n) {
        Integer n2 = new Integer(n);
        if (!this.fUnusedEnds.contains(n2)) {
            int n3 = 0;
            if (this.fUnusedEnds.size() > 0) {
                int n4 = 0;
                while (n4 < this.fUnusedEnds.size()) {
                    int n5 = (Integer)this.fUnusedEnds.get(n4);
                    n3 = n4;
                    if (n5 >= n) break;
                    n3 = n4 + 1;
                    ++n4;
                }
            }
            this.fUnusedEnds.add(n3, n2);
        }
    }

    private void moveChilds(Element element, Element element2, int n) {
        Element element3;
        for (element3 = element2; element3 != null; element3 = element3.getParent()) {
            if (element3.getEndLine() != -1 && element3 != element.getParent()) continue;
            if (element3.getBlockType() == 14) {
                this.clearElements(element);
                break;
            }
            this.reArrangeChilds(element3, element, n, element3.getEndLine(), false);
            break;
        }
        this.finalAffected.add(element3);
        this.finalAffected.add(element);
    }

    private void reArrangeChilds(Element element, Element element2, int n, int n2, boolean bl) {
        ArrayList arrayList = element2.getChildElements();
        if (arrayList != null && arrayList.size() != 0) {
            Element element3;
            ArrayList<Element> arrayList2 = new ArrayList<Element>();
            int n3 = 0;
            while (n3 < arrayList.size()) {
                element3 = (Element)arrayList.get(n3);
                if (element3 != element && element3.getStartLine() >= n && (n2 == -1 || element3.getStartLine() < n2)) {
                    if (!bl) {
                        element3.setParent(element);
                        element.insertChildElement(element3);
                    } else {
                        if (element3.getEndLine() != -1) {
                            int n4 = element.getEndLine();
                            element.setEndLine(element3.getEndLine());
                            this.clearElements(element3);
                            arrayList2.add(element3);
                            if (element2.getEndLine() == -1) {
                                element2.setEndLine(n4);
                                break;
                            }
                            this.addUnusedEnd(n4);
                            break;
                        }
                        this.clearElements(element3);
                    }
                    arrayList2.add(element3);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < arrayList2.size()) {
                element3 = (Element)arrayList2.get(n3);
                element2.removeChild(element3);
                ++n3;
            }
        }
    }

    private void addEndOfElement(int n, Element element) {
        block8: {
            int n2;
            Element element2 = element;
            while (true) {
                if (element2 == null) {
                    continue;
                }
                if (element2 == this.fRoot) {
                    this.addUnusedEnd(n);
                    break block8;
                }
                if (element2.getBlockType() != 14) {
                    if (element2.getEndLine() == -1) {
                        element2.setEndLine(n);
                        this.moveChilds(element2, element2.getParent(), n);
                        break block8;
                    }
                    if (element2.getEndLine() > n) {
                        n2 = element2.getEndLine();
                        element2.setEndLine(n);
                        this.moveChilds(element2, element2.getParent(), n);
                        n = n2;
                        element2 = element2.getParent();
                        continue;
                    }
                    element2 = element2.getParent();
                    continue;
                }
                if (element2.getEndLine() == -1 || n <= element2.getEndLine()) break;
                element2 = element2.getParent();
            }
            n2 = element2.getEndLine();
            if (n2 == -1) {
                n2 = this.fSourceViewer.getDocument().getNumberOfLines() - 1;
            }
            element2.setEndLine(n);
            Element element3 = element2.getParent();
            int n3 = element3.getEndLine();
            this.deltaParser(element3, n + 1, n2);
            if (n3 != element3.getEndLine()) {
                this.updateEndOfElement(n3, element3.getParent());
            }
            this.finalAffected.add(element3.getParent());
        }
    }

    private void reArrangeEndOfElement(Element element) {
        int n;
        if (element == this.fRoot) {
            return;
        }
        Element element2 = element.getParent();
        int n2 = element2.getEndLine();
        int n3 = -1;
        if (this.fUnusedEnds.size() != 0) {
            int n4 = this.fUnusedEnds.size() - 1;
            while (n4 >= 0) {
                n = (Integer)this.fUnusedEnds.get(n4);
                if (n > element.getStartLine()) {
                    n3 = n;
                    if (n2 != -1 && n > n2) {
                        n3 = -1;
                    }
                }
                --n4;
            }
        }
        if (n3 != -1) {
            element.setEndLine(n3);
            if (this.fUnusedEnds.contains(new Integer(n3))) {
                this.fUnusedEnds.remove(new Integer(n3));
            }
        } else if (n2 != -1) {
            element.setEndLine(n2);
            element2.setEndLine(-1);
        } else if (element.getEndLine() != -1) {
            element.setEndLine(-1);
        }
        if (element.getBlockType() == 14) {
            this.reArrangeChilds(element, element2, element.getStartLine(), n3, true);
        } else {
            this.reArrangeChilds(element, element2, element.getStartLine(), n3, false);
        }
        if (n2 != -1 && element2.getEndLine() == -1 && element2 != this.fRoot) {
            this.reArrangeEndOfElement(element2);
        } else {
            ArrayList arrayList = element.getChildElements();
            if (arrayList != null && arrayList.size() != 0) {
                n = 0;
                while (n < arrayList.size()) {
                    Element element3 = (Element)arrayList.get(n);
                    if (element3.getEndLine() == -1) {
                        this.reArrangeEndOfElement(element3);
                    }
                    ++n;
                }
            }
        }
        this.finalAffected.add(element);
        this.finalAffected.add(element2);
    }

    private Element findElementEnd(int n) {
        Iterator iterator = this.fLineMap.keySet().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)this.fLineMap.get(iterator.next());
            if (element.getEndLine() != n) continue;
            return element;
        }
        return null;
    }

    private void clearElements(Element element) {
        ArrayList arrayList = element.getChildElements();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                Element element2 = (Element)arrayList.get(n);
                this.discardElement(element2);
                ++n;
            }
        }
        this.discardElement(element);
    }

    private void discardElement(Element element) {
        element.clearElements();
        this.removeFromLineMap(element, element.getStartLine());
    }

    private void removeFromLineMap(Element element, int n) {
        Element element2;
        Integer n2 = new Integer(n);
        if (this.fLineMap.containsKey(n2) && (element2 = (Element)this.fLineMap.get(n2)) == element) {
            this.fLineMap.remove(n2);
        }
    }

    public void updatePositions(Element element, int n) {
        Element element2;
        if (element.getStartLine() > this.startLine) {
            Object object;
            this.isModelUpdated = true;
            if (this.fLineMap.containsKey(new Integer(element.getStartLine())) && (object = (Element)this.fLineMap.get(new Integer(element.getStartLine()))) == element) {
                this.fLineMap.remove(new Integer(element.getStartLine()));
            }
            element.setStartLine(element.getStartLine() + n);
            element.setLineNumber(element.getLineNumber() + n);
            if (element.getEndLine() != -1) {
                element.setEndLine(element.getEndLine() + n);
            }
            if (this.fLineMap.containsKey(object = new Integer(element.getStartLine())) && this.deletedLines > 0) {
                element2 = (Element)this.fLineMap.get(object);
                if (element2 == element) {
                    this.fLineMap.remove(object);
                    this.fLineMap.put(object, element);
                } else {
                    element.setStartLine(element.getStartLine() - n);
                    element.setLineNumber(element.getLineNumber() - n);
                }
            } else {
                this.fLineMap.put(object, element);
            }
        } else if (element.getStartLine() <= this.startLine) {
            this.isModelUpdated = true;
            if (element.getEndLine() > this.startLine) {
                element.setEndLine(element.getEndLine() + n);
            }
            if (element.getLineNumber() > this.startLine) {
                element.setLineNumber(element.getLineNumber() + n);
            }
        }
        int n2 = 0;
        while (n2 < element.getChildElements().size()) {
            element2 = (Element)element.getChildElements().get(n2);
            this.updatePositions(element2, n);
            ++n2;
        }
    }

    private void updateUnusedEnds(int n) {
        int n2 = 0;
        while (n2 < this.fUnusedEnds.size()) {
            int n3 = (Integer)this.fUnusedEnds.get(n2);
            if (n3 > this.startLine) {
                Integer n4 = new Integer(n3 + n);
                if (this.fUnusedEnds.contains(n4)) {
                    this.fUnusedEnds.remove(n4);
                }
                this.fUnusedEnds.remove(new Integer(n3));
                this.fUnusedEnds.add(n2, n4);
            }
            ++n2;
        }
    }

    private int findNoOfLines(String string) {
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            n = string.indexOf(this.fSourceViewer.getTextWidget().getLineDelimiter(), n);
            if (n == -1) continue;
            n += this.fSourceViewer.getTextWidget().getLineDelimiter().length();
            ++n2;
        }
        return n2;
    }

    private String getLineContent(int n, int n2) {
        if (this.fSourceViewer != null) {
            try {
                int n3 = this.fSourceViewer.getDocument().getLineOffset(n);
                int n4 = this.fSourceViewer.getDocument().getLineOffset(n2) + this.fSourceViewer.getDocument().getLineLength(n2) - n3;
                return this.fSourceViewer.getDocument().get(n3, n4);
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    public boolean isModelAffected() {
        return this.isModelUpdated;
    }

    public void setRootElement(Element element) {
        this.fRoot = element;
    }

    public void setLineReader(LineReader lineReader) {
        this.fReader = lineReader;
    }

    public void handleDispose() {
        try {
            this.fSourceViewer = null;
            this.fTreeViewer = null;
            this.fRoot = null;
            this.fParser = null;
            if (this.fReader != null) {
                this.fReader.dispose();
                this.fReader = null;
            }
            this.newText = null;
            this.prevText = null;
            this.prevElement = null;
            this.nextElement = null;
            if (this.affected != null) {
                this.affected.clear();
                this.affected = null;
            }
            if (this.finalAffected != null) {
                this.finalAffected.clear();
                this.finalAffected = null;
            }
            if (this.fLineMap != null) {
                this.fLineMap.clear();
                this.fLineMap = null;
            }
            if (this.fUnusedEnds != null) {
                this.fUnusedEnds.clear();
                this.fUnusedEnds = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }
}

