/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.editor;

import java.util.Vector;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.EventData;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.outlineview.COBOLContentOutlinePage;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;

public class COBOLElementAnalyzer
extends Thread {
    COBOLEditor fEditor;
    COBOLContentOutlinePage fOutLinePage;
    boolean operationRestart = false;
    boolean firstTime = true;
    boolean isDisposed = false;
    Runnable fRunnable = null;
    boolean isModelChanged = false;
    Vector fDataList = new Vector();

    @Override
    public void run() {
    }

    public void setEditor(COBOLEditor cOBOLEditor) {
        this.fEditor = cOBOLEditor;
    }

    public void operationRestart() {
        this.updateAllViews();
    }

    public void dispose() {
        this.isDisposed = true;
        this.fDataList.clear();
        this.interrupt();
    }

    private void updateAllViews() {
        try {
            while (this.fDataList.size() != 0) {
                int n = 0;
                while (n < this.fDataList.size()) {
                    IWorkbenchWindow[] iWorkbenchWindowArray;
                    EventData eventData = (EventData)this.fDataList.get(n);
                    boolean bl = false;
                    if (this.fOutLinePage == null) {
                        this.fOutLinePage = this.fEditor.getOutlinePage();
                    }
                    if (this.fOutLinePage != null && eventData != null) {
                        bl = this.fOutLinePage.deltaUpdate(eventData);
                    }
                    if ((bl || this.isDisposed) && (iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows()).length > 0) {
                        Display.getDefault().asyncExec(this.getRunnable());
                    }
                    this.fDataList.remove(eventData);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public Runnable getRunnable() {
        try {
            if (this.fRunnable == null) {
                this.fRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ViewsTreeModel.getInstance().refreshStructuresView();
                        IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                        int n = 0;
                        while (n < iWorkbenchWindowArray.length) {
                            IViewReference[] iViewReferenceArray = iWorkbenchWindowArray[n].getActivePage().getViewReferences();
                            IViewPart iViewPart = null;
                            int n2 = 0;
                            while (n2 < iViewReferenceArray.length) {
                                iViewPart = iViewReferenceArray[n2].getView(false);
                                if (iViewPart instanceof StructuresView) {
                                    StructuresView structuresView = (StructuresView)iViewPart;
                                    structuresView.refresh();
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                };
            }
            return this.fRunnable;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public void setOperationData(EventData eventData) {
        this.fDataList.add(eventData);
    }
}

