/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.editor;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.ExclusiveFileLockChecker;
import com.unisys.os2200.util.MemChecker;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.utils.EditorRelatedUtils;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.ICOBOLHelpContextId;
import org.eclipse.cobol.ui.actions.COBOLBreakpointActionPopup;
import org.eclipse.cobol.ui.actions.COBOLBreakpointRulerAction;
import org.eclipse.cobol.ui.actions.COBOLContentAssistantAction;
import org.eclipse.cobol.ui.actions.COBOLEditorRefreshAction;
import org.eclipse.cobol.ui.actions.COBOLPrintAction;
import org.eclipse.cobol.ui.actions.COBOLRenumberAction;
import org.eclipse.cobol.ui.actions.COBOLToggleUpdateTag;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.common.COBOLAbstractUndoManager;
import org.eclipse.cobol.ui.common.COBOLBaseDocumentProvider;
import org.eclipse.cobol.ui.common.IReferenceFormatHandler;
import org.eclipse.cobol.ui.common.text.COBOLTextFactory;
import org.eclipse.cobol.ui.editor.COBOLElementAnalyzer;
import org.eclipse.cobol.ui.editor.COBOLHyperLinkDetector;
import org.eclipse.cobol.ui.editor.COBOLMarkerAnnotationModel;
import org.eclipse.cobol.ui.editor.COBOLSourceViewer;
import org.eclipse.cobol.ui.editor.COBOLStatusLineMessages;
import org.eclipse.cobol.ui.fixedformat.COBOLFixedFormatDocumentProvider;
import org.eclipse.cobol.ui.fixedformat.COBOLSequenceNumberArea;
import org.eclipse.cobol.ui.freeformat.COBOLFreeFormatDocumentProvider;
import org.eclipse.cobol.ui.freeformat.COBOLFreeFormatSourceViewerConfiguration;
import org.eclipse.cobol.ui.freeformat.COBOLHyperLink;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferenceGeneralBlock;
import org.eclipse.cobol.ui.rulers.COBOLHorizontalRuler;
import org.eclipse.cobol.ui.views.common.RemoteFileEditorInput;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.outlineview.COBOLContentOutlinePage;
import org.eclipse.cobol.ui.views.outlineview.COBOLParser;
import org.eclipse.cobol.ui.views.outlineview.Element;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.ITextEditorHelpContextIds;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AddTaskAction;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class COBOLEditor
extends AbstractDecoratedTextEditor {
    private static final String SETTINGS = "settings";
    private static final String PREFERENCES_CONTEXT_ACTION = "Preferences.ContextAction";
    public static final String COBOL_TOGGLE_UPDATE_ACTION = "org.eclipse.cobol.COBOLToggleUpdateTag";
    private COBOLSourceViewer.TabConverter fTabConverter;
    private COBOLSourceViewer.AutoTag fAutoTag;
    private String fRefFormat;
    private String titleToolTip = null;
    private boolean showHRuler = true;
    private Composite fHRulerComposite;
    private COBOLHorizontalRuler fHRuler;
    private Label fHRulerSpacer;
    private KeyListener fkeyListener;
    private COBOLFreeFormatDocumentProvider fFreeFormatDocumentProvider = null;
    private COBOLTextFactory fTextFactory;
    private COBOLFreeFormatSourceViewerConfiguration fFreeFormatSourceViewerConfiguration;
    private COBOLContentOutlinePage fPage;
    public final int VERTICAL_RULER_WIDTH = 12;
    private final String CONTENT_ASSIST_ACTION_ID = "ContentAssistProposal";
    private final String CONTENT_ASSIST_RESOURCE_KEY_PREFIX = "ContentAssistProposal.";
    private COBOLRenumberAction renumberAction = null;
    private final char TAB = (char)9;
    private StyledText styledTextPrinter;
    private COBOLStatusLineMessages fStatusLineMsg;
    protected ISelectionChangedListener fStatusLineClearer;
    private static final String ADD_BREAKPOINT = "AddBreakpoint";
    private static final String RENUMBER = "Renumber";
    protected COBOLSequenceNumberArea fCblSequenceNumberArea;
    protected StyledText fSequenceAreaText;
    protected InternalViewPortListener fViewportListener = new InternalViewPortListener();
    private Runnable fRunnable;
    private String fRevertOSavedText;
    private static String fOpenFilePath = new String("");
    private static final String START_FORMAT = "Start_Format";
    private static final String LINE_DELIMITER = "\n";
    public static final String COBOL_EDITOR_ID = "org.eclipse.cobol.ui.editor.COBOLEditor";
    COBOLElementAnalyzer fAnalyzer = null;
    private TextEditorAction fAddVariableAction = null;
    private TextEditorAction fCOBOLBreakpointActionPopup = null;
    private Action fCOBOLBreakpointRulerAction = null;
    private TextEditorAction fContentAssistAction = null;
    private TextEditorAction fGotoLineAction = null;
    private COBOLPrintAction fPrintAction = null;
    private TextEditorAction fRuntoLineAction;
    private TextEditorAction fChangeExecutionpointAction;
    private static final String VARIABLEACTION_CLASS = "org.eclipse.cobol.debug.ui.actions.AddVariableAction";
    private static final String VARIABLEACTION_ID = "org.eclipse.cobol.debug.AddVariableAction";
    private static final String CHANGEEXECUTIONPOINT_ID = "org.eclipse.cobol.debug.COBOLChangeExecutionpoint";
    private static final String RUNTOLINE_ID = "org.eclipse.cobol.debug.COBOLRuntoLineAction";
    private static final String DEBUG_PERSPECTIVE_ID = "org.eclipse.debug.ui.DebugPerspective";
    private COBOLFixedFormatDocumentProvider.InternalListener fInternalListener = null;
    ISourceViewer svr = null;
    protected Color verticalLineColor = null;
    private static RGB VERTICAL_LINE_COLOR = null;
    MarginPainter[] marginPainter;
    ITextViewerExtension2 painter;
    private String SPACES_72 = "                                                                        ";
    private static final String LINE_NUMBER_RULER = "lineNumberRuler";
    private static final String NEW_LINE_CHAR = "\n";
    private IPropertyChangeListener fFontPropertyChangeListener = new FontPropertyChangeListener();
    private DefaultEncodingSupport fEncodingSupport;
    protected IOverviewRuler fOverviewRuler;
    public final int GAP_SIZE = 2;
    private Map<Integer, Element> divisionToLineMap = null;
    private Map<Integer, String> divisionMetaData = new HashMap<Integer, String>();
    private String strSelection = "";
    private final int F3 = 0x100000C;
    private Composite fParentComp = null;
    private TextEditorAction fToggleUpdateTag;
    private boolean fToggleUpdateTagSetting;

    public COBOLEditor() {
        try {
            this.fFreeFormatDocumentProvider = CBDTUiPlugin.getDefault().getFreeFormatDocumentProvider();
            this.setEditorContextMenuId("#CobolTextEditorContext");
            this.setRulerContextMenuId("#CobolTextRulerContext");
            this.fTextFactory = CBDTUiPlugin.getDefault().getCOBOLTextFactory();
            this.fFreeFormatSourceViewerConfiguration = new COBOLFreeFormatSourceViewerConfiguration(this.fTextFactory, (ITextEditor)this);
            this.fCblSequenceNumberArea = new COBOLSequenceNumberArea();
            this.fAnalyzer = new COBOLElementAnalyzer();
            this.fAnalyzer.setEditor(this);
            this.fAnalyzer.setPriority(3);
            this.fAnalyzer.start();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore iPreferenceStore = CBDTUiPlugin.getDefault().getPreferenceStore();
        IPreferenceStore iPreferenceStore2 = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{iPreferenceStore, iPreferenceStore2});
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(this.createCombinedPreferenceStore());
        this.setCompatibilityMode(false);
        this.setRulerContextMenuId("#TextRulerContext");
    }

    protected boolean isLineNumberRulerVisible() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore != null) {
            return iPreferenceStore.getBoolean(LINE_NUMBER_RULER);
        }
        return false;
    }

    public void addDropListner(Control control) {
        int n = 19;
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget(control, n);
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
            }

            public void dropAccept(DropTargetEvent dropTargetEvent) {
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.data == null) {
                    dropTargetEvent.detail = 0;
                    return;
                }
                Object object = dropTargetEvent.data;
                if (object != null) {
                    String string = object.toString();
                    COBOLEditor.this.pasteIntoEditor(string);
                }
            }
        });
    }

    public boolean isSaveAsAllowed() {
        this.setOpenFilePath();
        return true;
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        boolean bl;
        IEditorInput iEditorInput;
        block22: {
            Shell shell = this.getSite().getShell();
            SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
            iEditorInput = this.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                saveAsDialog.setOriginalFile(((IFileEditorInput)iEditorInput).getFile());
            } else if (iEditorInput instanceof OS2200FileEditorInput) {
                saveAsDialog.setOriginalName(((OS2200FileEditorInput)iEditorInput).getName().toUpperCase());
            } else if (iEditorInput instanceof FileStoreEditorInput) {
                saveAsDialog.setOriginalName(((FileStoreEditorInput)iEditorInput).getName().toUpperCase());
            }
            saveAsDialog.open();
            IPath iPath = saveAsDialog.getResult();
            if (iPath == null) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IFile iFile = iWorkspace.getRoot().getFile(iPath);
            FileEditorInput fileEditorInput = new FileEditorInput(iFile);
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation((IEditorInput)fileEditorInput){
                private final /* synthetic */ IEditorInput val$newInput;
                {
                    this.val$newInput = iEditorInput;
                }

                public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    IPreferenceStore iPreferenceStore = CBDTUiPlugin.getDefault().getPreferenceStore();
                    if (iPreferenceStore.getBoolean("trimTrailingSpaces")) {
                        COBOLEditor.this.trimTrailingSpaces();
                    }
                    COBOLEditor.this.getDocumentProvider().saveDocument(iProgressMonitor, (Object)this.val$newInput, COBOLEditor.this.getDocumentProvider().getDocument((Object)COBOLEditor.this.getEditorInput()), true);
                }
            };
            bl = false;
            try {
                this.getDocumentProvider().aboutToChange((Object)fileEditorInput);
                new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                this.getDocumentProvider().changed((Object)fileEditorInput);
                if (bl) {
                    this.setInput((IEditorInput)fileEditorInput);
                    if (this.fPage != null) {
                        this.fPage.update();
                    }
                }
                break block22;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    invocationTargetException.printStackTrace();
                    String string = Messages.getString((String)"Editor.error.save.title");
                    String string2 = MessageFormat.format(Messages.getString((String)"Editor.error.save.message"), invocationTargetException.getTargetException().getMessage());
                    MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.getDocumentProvider().changed((Object)fileEditorInput);
                    if (bl) {
                        this.setInput((IEditorInput)fileEditorInput);
                        if (this.fPage != null) {
                            this.fPage.update();
                        }
                    }
                }
            }
            this.getDocumentProvider().changed((Object)fileEditorInput);
            if (bl) {
                this.setInput((IEditorInput)fileEditorInput);
                if (this.fPage != null) {
                    this.fPage.update();
                }
            }
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
        this.updateStatusField("InputPosition");
        if (bl) {
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0];
            iWorkbenchPage.closeEditor(iWorkbenchPage.findEditor(iEditorInput), false);
        }
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        if (composite == null || iVerticalRuler == null) {
            return this.svr;
        }
        this.fAnnotationAccess = this.createAnnotationAccess();
        ISharedTextColors iSharedTextColors = EditorsPlugin.getDefault().getSharedTextColors();
        this.fOverviewRuler = new OverviewRuler(this.fAnnotationAccess, 12, iSharedTextColors);
        ISharedTextColors iSharedTextColors2 = this.getSharedColors();
        this.fOverviewRuler = this.createOverviewRuler(iSharedTextColors2);
        MarkerAnnotationPreferences markerAnnotationPreferences = this.getAnnotationPreferences();
        for (AnnotationPreference annotationPreference : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (!annotationPreference.contributesToHeader()) continue;
            this.fOverviewRuler.addHeaderAnnotationType(annotationPreference.getAnnotationType());
        }
        this.svr = new COBOLSourceViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n);
        this.addDropListner((Control)composite);
        this.getSourceViewerDecorationSupport(this.svr);
        this.handleListeners();
        this.fkeyListener = new keyListener();
        this.svr.getTextWidget().addKeyListener(this.fkeyListener);
        this.svr.addViewportListener((IViewportListener)this.fViewportListener);
        this.svr.addTextListener((ITextListener)this.fViewportListener);
        return this.svr;
    }

    private void handleListeners() {
        this.svr.getTextWidget().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x100000C) {
                    StyledText styledText = (StyledText)keyEvent.getSource();
                    if (COBOLEditor.this.isCopyProcDeclration(styledText)) {
                        String string = COBOLEditor.this.getCursorString(styledText);
                        if (string.endsWith(".")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        COBOLEditor.this.openCopyProcs(string);
                    } else {
                        int n = COBOLEditor.this.handleFunctionKey3(keyEvent);
                        COBOLEditor.this.processLineNo(n);
                    }
                }
            }
        });
        this.svr.getTextWidget().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                COBOLEditor.setStatusBarMessage("\t");
            }

            public void mouseDown(MouseEvent mouseEvent) {
                IHyperlinkDetector[] iHyperlinkDetectorArray = COBOLEditor.this.fFreeFormatSourceViewerConfiguration.getCOBOLHyperlinkDetector();
                int n = 0;
                while (n < iHyperlinkDetectorArray.length) {
                    if (iHyperlinkDetectorArray[n] instanceof COBOLHyperLinkDetector) {
                        COBOLHyperLink cOBOLHyperLink;
                        COBOLHyperLinkDetector cOBOLHyperLinkDetector = (COBOLHyperLinkDetector)iHyperlinkDetectorArray[n];
                        if (cOBOLHyperLinkDetector.hyperlinks != null && cOBOLHyperLinkDetector.getHyperlinks()[n] instanceof COBOLHyperLink && (cOBOLHyperLink = (COBOLHyperLink)cOBOLHyperLinkDetector.getHyperlinks()[n]).isActivated()) {
                            COBOLEditor.this.strSelection = cOBOLHyperLink.getHyperlinkText();
                            cOBOLHyperLink.open();
                            cOBOLHyperLink.setActivated(false);
                            break;
                        }
                    }
                    ++n;
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }
        });
    }

    public void processLineNo(int n) {
        if (n >= 0) {
            IDocument iDocument = this.svr.getDocument();
            try {
                int n2 = iDocument.getLineOffset(n);
                this.selectAndReveal(n2, 0);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            Status status = null;
            this.strSelection = this.strSelection != null && this.strSelection.trim().length() > 0 ? "No declaration found for " + this.strSelection + "." : "No declaration found.";
            status = new Status(2, COBOL_EDITOR_ID, this.strSelection);
            COBOLEditor.setStatusBarMessage(this.strSelection);
            CBDTUiPlugin.log((IStatus)status);
            this.strSelection = "";
        }
    }

    public static void setStatusBarMessage(final String string) {
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
                IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
                if (iWorkbenchPartSite instanceof EditorSite) {
                    EditorSite editorSite = (EditorSite)iWorkbenchPartSite;
                    IActionBars iActionBars = editorSite.getActionBars();
                    if (iActionBars == null) {
                        return;
                    }
                    IStatusLineManager iStatusLineManager = iActionBars.getStatusLineManager();
                    if (iStatusLineManager == null) {
                        return;
                    }
                    iStatusLineManager.setErrorMessage(string);
                }
            }
        });
    }

    protected int handleFunctionKey3(KeyEvent keyEvent) {
        StyledText styledText = (StyledText)keyEvent.getSource();
        return this.getInfo(styledText);
    }

    public int getInfo(StyledText styledText) {
        if (styledText != null) {
            String string = styledText.getSelectionText();
            if (string.contains(" ")) {
                return -1;
            }
            this.strSelection = this.computeSelectedWord(styledText);
            if (this.strSelection == null) {
                return -1;
            }
            if (this.fPage == null || this.isDirty()) {
                this.getAdapter(IContentOutlinePage.class);
            }
            HashMap hashMap = this.fPage.getCOBOLParser().getElementLineMap();
            Set set = hashMap.entrySet();
            for (Map.Entry entry : set) {
                Element element = (Element)entry.getValue();
                if (!this.strSelection.equalsIgnoreCase(element.getData())) continue;
                Integer n = (Integer)entry.getKey();
                return n;
            }
        }
        return -1;
    }

    private String computeSelectedWord(StyledText styledText) {
        try {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = n = styledText.getCaretOffset();
            IDocument iDocument = this.svr.getDocument();
            if (iDocument != null) {
                try {
                    char c = iDocument.getChar(n);
                    if (c == ' ') {
                        --n;
                    }
                    c = iDocument.getChar(n);
                    while (c != ' ') {
                        ++n;
                        try {
                            c = iDocument.getChar(n);
                        }
                        catch (BadLocationException badLocationException) {
                            --n;
                            break;
                        }
                    }
                    n2 = n;
                    n = n4;
                    c = iDocument.getChar(n);
                    if (c == ' ') {
                        --n;
                    }
                    c = iDocument.getChar(n);
                    while (c != ' ') {
                        c = iDocument.getChar(--n);
                    }
                    n3 = n;
                    String string = styledText.getText(n3, n2).trim();
                    if (string.contains(".")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    return string.trim();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        super.configureSourceViewerDecorationSupport(sourceViewerDecorationSupport);
        sourceViewerDecorationSupport.setMarginPainterPreferenceKeys(null, null, null);
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return super.createAnnotationAccess();
    }

    protected String decideFormat() {
        try {
            IPreferenceStore iPreferenceStore = CBDTUiPlugin.getDefault().getPreferenceStore();
            this.fRefFormat = iPreferenceStore.getString("Reference Format");
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return this.fRefFormat;
    }

    public ISourceViewer getCurrentSourceViewer() {
        return this.getSourceViewer();
    }

    public COBOLSequenceNumberArea getSequenceNumberArea() {
        try {
            return this.fCblSequenceNumberArea;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
    }

    public String getReferenceFormat() {
        return this.fRefFormat;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        int n;
        int n2;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        String string = propertyChangeEvent.getProperty();
        this.fTextFactory.adaptToPreferenceChange(propertyChangeEvent);
        if ("Use Spaces for TABS".equals(string)) {
            if (this.isTabConversionEnabled()) {
                this.startTabConversion();
            } else {
                this.stopTabConversion();
            }
            return;
        }
        if (string.equals("Reserved Word") || string.equals("cobol_data_dict_vars") || string.equals("cobol_sections") || string.equals("cobol_paragraphs") || string.equals("ws_vars")) {
            iSourceViewer.invalidateTextPresentation();
        }
        if ("Tab Width".equals(string) && (n2 = Integer.parseInt(propertyChangeEvent.getNewValue().toString())) != (n = Integer.parseInt(propertyChangeEvent.getOldValue().toString())) && this.getSourceViewer() != null) {
            this.getSourceViewer().getTextWidget().setTabs(n2);
            iSourceViewer.invalidateTextPresentation();
            this.updateStatusField("InputPosition");
        }
        if (this.showHRuler != COBOLEditorPreferenceGeneralBlock.isHorizontalRoulerShow()) {
            this.showHRuler = !this.showHRuler;
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            if (!this.showHRuler) {
                gridData.heightHint = 0;
            }
            this.fHRulerComposite.setLayoutData((Object)gridData);
            this.fHRulerComposite.getParent().layout();
        }
        if (string.equals(LINE_NUMBER_RULER)) {
            this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
        if ("org.eclipse.jface.textfont".equals(string)) {
            this.setFont();
        }
        IPreferenceStore iPreferenceStore = CBDTUiPlugin.getDefault().getPreferenceStore();
        String string2 = iPreferenceStore.getString("printMargin");
        String string3 = iPreferenceStore.getString("printMarginColor");
        String string4 = iPreferenceStore.getString("printMarginColumn");
        if (string.equals("printMargin")) {
            if (!Boolean.parseBoolean(string2)) {
                this.disposeMargins();
            } else {
                this.getColumnMarkers(string3, string4);
            }
        }
        if (string.equals("printMarginColumn") || string.equals("printMarginColor")) {
            this.disposeMargins();
            this.getColumnMarkers(string3, string4);
        }
    }

    public void createPartControl(Composite composite) {
        this.fParentComp = composite;
        this.createHorizontalRuler(this.fParentComp);
        super.createPartControl(this.fParentComp);
        Control[] controlArray = this.fParentComp.getChildren();
        controlArray = ((Composite)controlArray[1]).getChildren();
        controlArray = ((Composite)controlArray[0]).getChildren();
        Canvas canvas = (Canvas)controlArray[0];
        canvas.setLayout((Layout)new RulerLayout(2));
        this.fSequenceAreaText = this.fCblSequenceNumberArea.createSequenceNumberArea((Composite)canvas, 524328);
        this.fSequenceAreaText.setEnabled(false);
        GC gC = new GC((Drawable)this.getSourceViewer().getTextWidget());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = gC.getFontMetrics().getHeight();
        this.fHRuler.setLayoutData(gridData);
        gC.dispose();
        SourceViewer sourceViewer = (SourceViewer)this.getSourceViewer();
        Control control = sourceViewer.getControl();
        GridData gridData2 = new GridData();
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gridData2);
        control = control.getParent();
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        ((Composite)control).setLayout((Layout)gridLayout);
        gridData2 = new GridData();
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gridData2);
        control = control.getParent();
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        ((Composite)control).setLayout((Layout)gridLayout);
        gridData2 = new GridData();
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gridData2);
        this.fHRuler.setSourceViewer(this.getSourceViewer());
        this.styledTextPrinter = new StyledText(this.fParentComp, 0);
        GridData gridData3 = new GridData();
        gridData3.heightHint = 1;
        this.styledTextPrinter.setLayoutData((Object)gridData3);
        this.styledTextPrinter.setEditable(false);
        this.styledTextPrinter.setVisible(false);
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        this.setFont();
        this.getSourceViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                if (verifyEvent.character == '\b') {
                    if (COBOLEditor.this.fAutoTag != null) {
                        StyledText styledText = COBOLEditor.this.getSourceViewer().getTextWidget();
                        int n = 0;
                        n = styledText.getCaretOffset();
                        int n2 = styledText.getContent().getLineAtOffset(n);
                        int n3 = styledText.getContent().getOffsetAtLine(n2);
                        if (n > n3 && n - n3 == 6) {
                            styledText.setCaretOffset(n3);
                            styledText.getContent().replaceTextRange(n3, 6, "");
                        }
                    }
                    verifyEvent.doit = true;
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fParentComp, ICOBOLHelpContextId.COBOL_EDITOR_BOOKMARK_ACTION);
        this.updatePartControl(this.getEditorInput());
        this.getColumnMarkers(CBDTUiPlugin.getDefault().getPreferenceStore().getString("printMarginColor"), CBDTUiPlugin.getDefault().getPreferenceStore().getString("printMarginColumn"));
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
    }

    protected void getColumnMarkers(String string, String string2) {
        String string3 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("printMargin");
        if (Boolean.parseBoolean(string3) && string != null && string2 != null) {
            String[] stringArray = string2.split(",");
            this.marginPainter = new MarginPainter[stringArray.length];
            this.painter = (ITextViewerExtension2)this.svr;
            this.verticalLineColor = this.getColor(string);
            if (this.svr instanceof ITextViewerExtension2) {
                int n = 0;
                while (n < stringArray.length) {
                    this.marginPainter[n] = new MarginPainter((ITextViewer)this.svr);
                    this.marginPainter[n].setMarginRulerColumn(Integer.parseInt(stringArray[n]));
                    this.marginPainter[n].setMarginRulerColor(this.verticalLineColor);
                    this.painter.addPainter((IPainter)this.marginPainter[n]);
                    ++n;
                }
            }
        }
    }

    private Color getColor(String string) {
        String string2 = string;
        String[] stringArray = string2.split(",");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        VERTICAL_LINE_COLOR = new RGB(n, n2, n3);
        Color color = new Color(null, VERTICAL_LINE_COLOR);
        return color;
    }

    protected String getStatusHeader(IStatus iStatus) {
        String string;
        if (this.fEncodingSupport != null && (string = this.fEncodingSupport.getStatusHeader(iStatus)) != null) {
            return string;
        }
        return super.getStatusHeader(iStatus);
    }

    protected String getStatusBanner(IStatus iStatus) {
        String string;
        if (this.fEncodingSupport != null && (string = this.fEncodingSupport.getStatusBanner(iStatus)) != null) {
            return string;
        }
        return super.getStatusBanner(iStatus);
    }

    protected String getStatusMessage(IStatus iStatus) {
        String string;
        if (this.fEncodingSupport != null && (string = this.fEncodingSupport.getStatusMessage(iStatus)) != null) {
            return string;
        }
        return super.getStatusMessage(iStatus);
    }

    private void createStatusLineMessageProvider() {
        IEditorActionBarContributor iEditorActionBarContributor;
        if (this.fStatusLineMsg == null && (iEditorActionBarContributor = this.getEditorSite().getActionBarContributor()) != null) {
            IStatusLineManager iStatusLineManager = ((EditorActionBarContributor)iEditorActionBarContributor).getActionBars().getStatusLineManager();
            this.fStatusLineMsg = COBOLStatusLineMessages.getInstance(iStatusLineManager);
        }
    }

    private void createHorizontalRuler(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.fHRulerComposite = new Composite(composite, 524288);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        if (!COBOLEditorPreferenceGeneralBlock.isHorizontalRoulerShow()) {
            gridData.heightHint = 0;
            this.showHRuler = false;
        }
        this.fHRulerComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        this.fHRulerComposite.setLayout((Layout)gridLayout2);
        this.fHRulerSpacer = new Label(this.fHRulerComposite, 524288);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 32;
        gridData2.widthHint = 14;
        this.fHRulerSpacer.setLayoutData((Object)gridData2);
        this.fHRuler = new COBOLHorizontalRuler(this.fHRulerComposite, this);
        this.fHRuler.setMode(this.fRefFormat);
    }

    protected void createActions() {
        try {
            super.createActions();
            IEditorInput iEditorInput = this.getEditorInput();
            if (!(iEditorInput instanceof IFileEditorInput) && !(iEditorInput instanceof IPathEditorInput)) {
                this.applyNewTextFactory();
            }
            Object object = new AddTaskAction(Messages.getResourceBundle(), "Editor.AddTask.", (ITextEditor)this);
            object.setHelpContextId(ITextEditorHelpContextIds.ADD_TASK_ACTION);
            object.setActionDefinitionId("org.eclipse.ui.edit.addTask");
            this.setAction(IDEActionFactory.ADD_TASK.getId(), (IAction)object);
            this.fContentAssistAction = new COBOLContentAssistantAction(Messages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
            this.fContentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
            this.setAction("ContentAssistProposal", (IAction)this.fContentAssistAction);
            this.markAsStateDependentAction("ContentAssistProposal", true);
            this.fCOBOLBreakpointRulerAction = new COBOLBreakpointRulerAction(this.getVerticalRuler(), (ITextEditor)this);
            this.setAction("ManageCobolBreakpoints", (IAction)this.fCOBOLBreakpointRulerAction);
            this.setAction("RulerDoubleClick", this.getAction("ManageCobolBreakpoints"));
            object = new ResourceAction(Messages.getResourceBundle(), "CobolEditor.ToggleLineNumbersAction.", 2){

                public void run() {
                    COBOLEditor.this.toggleLineNumberRuler();
                }
            };
            object.setActionDefinitionId("org.eclipse.ui.editors.lineNumberToggle");
            this.setAction("Linenumbers.Toggle", (IAction)object);
            if (SWT.getPlatform().equalsIgnoreCase("motif") || SWT.getPlatform().equalsIgnoreCase("gtk")) {
                this.setAction(ITextEditorActionConstants.PRINT, null);
            } else {
                this.fPrintAction = new COBOLPrintAction(Messages.getString((String)"Print"), this);
                this.setAction(ITextEditorActionConstants.PRINT, (IAction)this.fPrintAction);
            }
            this.fCOBOLBreakpointActionPopup = new COBOLBreakpointActionPopup(this);
            this.setAction(ADD_BREAKPOINT, (IAction)this.fCOBOLBreakpointActionPopup);
            this.renumberAction = new COBOLRenumberAction(Messages.getString((String)"renumberMenuItem"));
            this.renumberAction.setEditor((IEditorPart)this);
            this.setAction(RENUMBER, (IAction)this.renumberAction);
            this.createStatusLineMessageProvider();
            try {
                ClassLoader classLoader = Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.cobol.debug.ui").getPluginClassLoader();
                if (classLoader != null) {
                    this.fAddVariableAction = (TextEditorAction)classLoader.loadClass(VARIABLEACTION_CLASS).newInstance();
                    this.fAddVariableAction.setText(Messages.getString((String)"AddWatch.label"));
                    this.fAddVariableAction.setId(VARIABLEACTION_ID);
                    this.fAddVariableAction.setEnabled(true);
                    this.fAddVariableAction.setEditor((ITextEditor)this);
                    this.fAddVariableAction.setImageDescriptor(COBOLPluginImages.DESC_IMG_ADD_WATCH);
                    ((IEditorActionDelegate)this.fAddVariableAction).setActiveEditor((IAction)this.fAddVariableAction, (IEditorPart)this);
                    this.setAction(VARIABLEACTION_ID, (IAction)this.fAddVariableAction);
                    String string = COBOLToggleUpdateTag.class.getName();
                    this.fToggleUpdateTag = (TextEditorAction)classLoader.loadClass(string).newInstance();
                    this.fToggleUpdateTag.setText("Toggle Update Tag");
                    this.fToggleUpdateTag.setId(COBOL_TOGGLE_UPDATE_ACTION);
                    this.fToggleUpdateTag.setEditor((ITextEditor)this);
                    this.fToggleUpdateTag.setChecked(false);
                    ((IEditorActionDelegate)this.fToggleUpdateTag).setActiveEditor((IAction)this.fToggleUpdateTag, (IEditorPart)this);
                    this.setAction(COBOL_TOGGLE_UPDATE_ACTION, (IAction)this.fToggleUpdateTag);
                    COBOLEditorRefreshAction cOBOLEditorRefreshAction = new COBOLEditorRefreshAction((IShellProvider)this.getSite());
                    cOBOLEditorRefreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
                    this.markAsStateDependentAction("org.eclipse.ui.file.refresh", true);
                    this.setAction("org.eclipse.ui.file.refresh", (IAction)cOBOLEditorRefreshAction);
                    this.applyNewTextFactory();
                }
                this.fEncodingSupport = new DefaultEncodingSupport();
                this.fEncodingSupport.initialize((StatusTextEditor)this);
            }
            catch (InstantiationException instantiationException) {
                CBDTUiPlugin.logError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                CBDTUiPlugin.logError(illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                CBDTUiPlugin.logError(classNotFoundException);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private void toggleLineNumberRuler() {
        IPreferenceStore iPreferenceStore = CBDTUiPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(LINE_NUMBER_RULER, !this.isLineNumberRulerVisible());
    }

    public void gotoMarker(IMarker iMarker) {
        try {
            if (iMarker == null) {
                return;
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        try {
            IVerticalRuler iVerticalRuler;
            super.gotoMarker(iMarker);
            this.superGotoMarker(iMarker);
            if (!this.fRefFormat.equalsIgnoreCase("FREE")) {
                int n = this.getSourceViewer().getTextWidget().getTopPixel();
                int n2 = this.fCblSequenceNumberArea.getSequenceNumberAreaText().getTopPixel();
                if (n2 > 0 && n != n2) {
                    this.getSourceViewer().getTextWidget().setTopPixel(this.fCblSequenceNumberArea.getSequenceNumberAreaText().getTopPixel());
                } else if (n2 == 0) {
                    this.fCblSequenceNumberArea.getSequenceNumberAreaText().setTopPixel(n);
                }
            }
            if ((iVerticalRuler = this.getVerticalRuler()) != null) {
                iVerticalRuler.update();
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void setFocus() {
        this.setOpenFilePath();
        super.setFocus();
        this.updateStatusField("InputPosition");
        if (this.fStatusLineMsg != null) {
            this.fStatusLineMsg.setErrorMessageText("");
        }
    }

    public StyledText getPrinterStyledText() {
        return this.styledTextPrinter;
    }

    void superGotoMarker(IMarker iMarker) {
        int n;
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel;
        if (this.fIsUpdatingMarkerViews) {
            return;
        }
        if (this.getSourceViewer() == null) {
            return;
        }
        int n2 = MarkerUtilities.getCharStart((IMarker)iMarker);
        int n3 = MarkerUtilities.getCharEnd((IMarker)iMarker);
        boolean bl = n2 < 0 || n3 < 0;
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            abstractMarkerAnnotationModel = (AbstractMarkerAnnotationModel)iAnnotationModel;
            Position position = abstractMarkerAnnotationModel.getMarkerPosition(iMarker);
            if (position != null && !position.isDeleted()) {
                n2 = position.getOffset();
                n3 = position.getOffset() + position.getLength();
            }
            if (position != null && position.isDeleted()) {
                return;
            }
        }
        abstractMarkerAnnotationModel = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (bl) {
            try {
                int n4;
                if (n2 >= 0) {
                    n4 = abstractMarkerAnnotationModel.getLineOfOffset(n2);
                } else {
                    n4 = MarkerUtilities.getLineNumber((IMarker)iMarker);
                    n2 = abstractMarkerAnnotationModel.getLineOffset(--n4);
                }
                n3 = n2 + abstractMarkerAnnotationModel.getLineLength(n4) - 1;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
        if (n3 - 1 < (n = abstractMarkerAnnotationModel.getLength()) && n2 < n) {
            this.selectAndReveal(n2, n3 - n2);
        }
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        String string;
        MarkerSet markerSet;
        MarkerSet markerSet2;
        IResource iResource;
        Object object;
        OS2200FileEditorInput oS2200FileEditorInput;
        COBOLMarkerAnnotationModel cOBOLMarkerAnnotationModel = (COBOLMarkerAnnotationModel)this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (cOBOLMarkerAnnotationModel != null) {
            cOBOLMarkerAnnotationModel.setDirtyFlag(false);
        }
        IEditorInput iEditorInput = this.getEditorInput();
        IPath iPath = null;
        String string2 = null;
        if (iEditorInput instanceof OS2200FileEditorInput) {
            oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
            iPath = oS2200FileEditorInput.getPath();
        } else if (iEditorInput instanceof FileStoreEditorInput) {
            oS2200FileEditorInput = (FileStoreEditorInput)iEditorInput;
            iPath = new Path(oS2200FileEditorInput.getURI().getPath());
        } else {
            oS2200FileEditorInput = (IFileEditorInput)this.getEditorInput();
            iPath = oS2200FileEditorInput.getFile().getFullPath();
            object = null;
            try {
                try {
                    iResource = oS2200FileEditorInput.getFile().getProject().findMember(iPath.segment(1));
                    if (iResource instanceof IFile) {
                        markerSet2 = ((IFile)iResource).getRawLocation();
                        if (markerSet2 != null) {
                            object = new FileInputStream(markerSet2.toOSString());
                        }
                        string2 = this.getworkFile((IFile)iResource);
                    }
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                    String string3 = exception.getMessage();
                    ExclusiveFileLockChecker.HandleForExclusiveFileHold((String)string3, string2, (String)string3);
                    try {
                        if (object != null) {
                            object.close();
                            object = null;
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    return;
                }
            }
            finally {
                try {
                    if (object != null) {
                        object.close();
                        object = null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        oS2200FileEditorInput = CBDTUiPlugin.getWorkspace();
        if (oS2200FileEditorInput != null && oS2200FileEditorInput instanceof Workspace && iPath != null && (iResource = (object = (Workspace)oS2200FileEditorInput).getResourceInfo(iPath, false, false)) != null && (markerSet2 = iResource.getMarkers()) != null) {
            markerSet = markerSet2.elements();
            int n = 0;
            while (n < ((IMarkerSetElement[])markerSet).length) {
                MarkerInfo markerInfo = (MarkerInfo)markerSet[n];
                string = markerInfo.getType();
                if (string.equals("org.eclipse.search.searchmarker")) {
                    markerInfo.setAttribute("Save", (Object)new Boolean(true), true);
                }
                ++n;
            }
        }
        try {
            object = CBDTUiPlugin.getDefault().getPreferenceStore();
            if (object.getBoolean("trimTrailingSpaces")) {
                this.trimTrailingSpaces();
            }
            super.doSave(iProgressMonitor);
            if (oS2200FileEditorInput != null && oS2200FileEditorInput instanceof Workspace && (markerSet2 = (iResource = (Workspace)oS2200FileEditorInput).getResourceInfo(iPath, false, false)) != null && (markerSet = markerSet2.getMarkers()) != null) {
                IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements();
                int n = 0;
                while (n < iMarkerSetElementArray.length) {
                    string = (MarkerInfo)iMarkerSetElementArray[n];
                    String string4 = string.getType();
                    if (string4.equals("org.eclipse.search.searchmarker")) {
                        string.setAttribute("Save", (Object)new Boolean(false), true);
                    }
                    ++n;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public COBOLContentOutlinePage getOutlinePage() {
        return this.fPage;
    }

    private String getworkFile(IFile iFile) throws CoreException {
        IProject iProject = iFile.getProject();
        Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
        String string = properties.getProperty("workFile");
        return string;
    }

    public void fireChanges() {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getEditorSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
        if (iWorkbenchWindowArray.length > 1) {
            Display display = this.getSite().getShell().getDisplay();
            display.asyncExec(this.getRunnable());
        }
        this.firePropertyChange(257);
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
    }

    public Object getAdapter(Class clazz) {
        if (IEncodingSupport.class.equals((Object)clazz)) {
            return this.fEncodingSupport;
        }
        if (clazz.equals(IContentOutlinePage.class)) {
            IEditorInput iEditorInput = this.getEditorInput();
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iEditorInput instanceof IFileEditorInput) {
                this.fPage = new COBOLContentOutlinePage(((IFileEditorInput)iEditorInput).getFile(), this, iSourceViewer);
                return this.fPage;
            }
            if (iEditorInput instanceof IStorageEditorInput) {
                this.fPage = new COBOLContentOutlinePage(iSourceViewer.getDocument(), this, iSourceViewer);
                return this.fPage;
            }
            if (iEditorInput instanceof OS2200FileEditorInput) {
                this.fPage = new COBOLContentOutlinePage(iSourceViewer.getDocument(), this, iSourceViewer);
                return this.fPage;
            }
            if (iEditorInput instanceof FileStoreEditorInput) {
                this.fPage = new COBOLContentOutlinePage(iSourceViewer.getDocument(), this, iSourceViewer);
                return this.fPage;
            }
        }
        return super.getAdapter(clazz);
    }

    protected void setFont() {
        try {
            this.fHRuler.setFont(this.getSourceViewer().getTextWidget().getFont());
            this.styledTextPrinter.setBackground(this.getSourceViewer().getTextWidget().getBackground());
            this.styledTextPrinter.setForeground(this.getSourceViewer().getTextWidget().getForeground());
            this.reLayout();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    protected void setFont(Font font) {
        try {
            this.fHRuler.setFont(font);
            this.reLayout();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    protected void reLayout() {
        GC gC = new GC((Drawable)this.getSourceViewer().getTextWidget());
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = fontMetrics.getHeight();
        gC.dispose();
        ((GridData)this.fHRuler.getLayoutData()).heightHint = n + 2;
        this.fParentComp.layout(true);
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        try {
            if (iEditorInput == null) {
                super.doSetInput(iEditorInput);
            } else {
                String string = this.fRefFormat;
                this.fRefFormat = this.decideFormat();
                IEditorInput iEditorInput2 = this.getEditorInput();
                if (iEditorInput2 != null) {
                    boolean bl = true;
                    if (string != null) {
                        boolean bl2 = bl = !string.equalsIgnoreCase(this.fRefFormat);
                    }
                    if (bl) {
                        this.getDocumentProvider().disconnect((Object)iEditorInput2);
                        iEditorInput2 = null;
                        this.fTextFactory.setFormat(this.fRefFormat);
                        if (this.fRefFormat.equals("FREE")) {
                            String[] stringArray;
                            String[] stringArray2 = stringArray = this.fFreeFormatSourceViewerConfiguration.getConfiguredContentTypes(this.getCurrentSourceViewer());
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String string2 = stringArray2[n2];
                                ISourceViewer iSourceViewer = this.getSourceViewer();
                                if (iSourceViewer instanceof ITextViewerExtension2) {
                                    ((ITextViewerExtension2)iSourceViewer).removeTextHovers(string2);
                                    int[] nArray = this.fFreeFormatSourceViewerConfiguration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), string2);
                                    if (nArray != null) {
                                        int[] nArray2 = nArray;
                                        int n3 = nArray.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            int n5 = nArray2[n4];
                                            ITextHover iTextHover = this.fFreeFormatSourceViewerConfiguration.getTextHover(iSourceViewer, string2, n5);
                                            IAnnotationHover iAnnotationHover = this.fFreeFormatSourceViewerConfiguration.getAnnotationHover(this.getCurrentSourceViewer());
                                            ((ITextViewerExtension2)iSourceViewer).setTextHover(iTextHover, string2, n5);
                                            iSourceViewer.setAnnotationHover(iAnnotationHover);
                                            ++n4;
                                        }
                                    } else {
                                        ITextHover iTextHover = this.fFreeFormatSourceViewerConfiguration.getTextHover(iSourceViewer, string2);
                                        IAnnotationHover iAnnotationHover = this.fFreeFormatSourceViewerConfiguration.getAnnotationHover(this.getCurrentSourceViewer());
                                        ((ITextViewerExtension2)iSourceViewer).setTextHover(iTextHover, string2, 255);
                                        iSourceViewer.setAnnotationHover(iAnnotationHover);
                                    }
                                } else {
                                    iSourceViewer.setTextHover(this.fFreeFormatSourceViewerConfiguration.getTextHover(iSourceViewer, string2), string2);
                                }
                                ++n2;
                            }
                            this.getSourceViewer().configure((SourceViewerConfiguration)this.fFreeFormatSourceViewerConfiguration);
                            this.setDocumentProvider((IDocumentProvider)this.fFreeFormatDocumentProvider);
                            super.doSetInput(iEditorInput);
                            this.fHRuler.setMode(this.fRefFormat);
                            try {
                                this.getSourceViewer().getTextWidget().setCaretOffset(0);
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    this.fTextFactory.setFormat(this.fRefFormat);
                    if (this.fRefFormat.equals("FREE")) {
                        this.setDocumentProvider((IDocumentProvider)this.fFreeFormatDocumentProvider);
                        this.setSourceViewerConfiguration(this.fFreeFormatSourceViewerConfiguration);
                    }
                    super.doSetInput(iEditorInput);
                }
            }
            if (this.fEncodingSupport != null) {
                this.fEncodingSupport.reset();
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public IReferenceFormatHandler getReferenceFormatHandler() {
        return null;
    }

    protected boolean isInInsertMode() {
        return super.isInInsertMode();
    }

    public void updateStatusField(String string) {
        try {
            if ("InputPosition".equals(string)) {
                IStatusField iStatusField;
                IStatusField iStatusField2 = this.getStatusField("InputPosition");
                if (iStatusField2 != null) {
                    iStatusField2.setText(this.getCursorPosition());
                }
                if ((iStatusField = this.getStatusField("TextSelect")) != null) {
                    if (this.getHighlightedtextLength() > 0) {
                        iStatusField.setText("Length:" + this.getHighlightedtextLength());
                    } else {
                        iStatusField.setText("");
                    }
                }
            } else {
                super.updateStatusField(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public int getHighlightedtextLength() {
        if (!MemChecker.getInstance().hasEnoughMemory(false, false)) {
            return 0;
        }
        new Integer(0);
        try {
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer != null) {
                StyledText styledText = iSourceViewer.getTextWidget();
                if (styledText.getSelectionText().length() > 0) {
                    return styledText.getSelectionText().length();
                }
                return 0;
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return 0;
    }

    public void tagHighlightedText() {
        int n;
        String[] stringArray;
        IPreferenceStore iPreferenceStore = CBDTUiPlugin.getDefault().getPreferenceStore();
        String string = "";
        if (iPreferenceStore != null) {
            string = iPreferenceStore.getString("CurrentAutoTag").toUpperCase();
        }
        if (string == null || string.trim().length() <= 0) {
            CBDTUiPlugin.logTraceMessage("tagHighlightedtext: The tag has not been set in the preferences.");
            return;
        }
        StyledText styledText = this.getSourceViewer().getTextWidget();
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (iDocument == null) {
            CBDTUiPlugin.logTraceMessage("tagHighlightedtext(): Document retrieved as NULL");
            return;
        }
        String string2 = String.valueOf(iDocument.get()) + " \n";
        String[] stringArray2 = string2.split("\n");
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = this.getHighlightedtextLength();
        if (n4 == 0) {
            bl = true;
            stringArray = this.getCursorPosition().split(":");
            n2 = Integer.parseInt(stringArray[0].trim()) - 1;
            n3 = styledText.getCaretOffset();
            int n5 = 0;
            int n6 = 0;
            try {
                n5 = iDocument.getLineLength(n2);
                n6 = iDocument.getLineOffset(n2);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError(Messages.getString((String)"LengthOffset"), (Exception)((Object)badLocationException));
            }
            n4 = stringArray2.length - 1 == n2 ? n5 : n5 - 1;
            n = n6 + n4;
            styledText.setSelection(n6, n);
        }
        if (n4 >= 0) {
            int n7;
            stringArray = styledText.getSelectionText();
            String[] stringArray3 = stringArray.split("\n");
            ITextSelection iTextSelection = (ITextSelection)this.getSelectionProvider().getSelection();
            n = iTextSelection.getStartLine();
            String[] stringArray4 = this.getIndices(iDocument, n, n7 = iTextSelection.getEndLine()).split(":");
            if (stringArray4.length != 2 || stringArray4[0].trim().equals("??") || stringArray4[1].trim().equals("??")) {
                CBDTUiPlugin.logTraceMessage("tagHighlightedtext: Couldn't retrieve the offsets");
                return;
            }
            int n8 = Integer.parseInt(stringArray4[0].trim());
            int n9 = Integer.parseInt(stringArray4[1].trim());
            int n10 = 0;
            int n11 = 0;
            boolean bl2 = true;
            if (stringArray3.length > n7 - n) {
                bl2 = false;
            }
            String string3 = "";
            int n12 = 0;
            int n13 = 0;
            boolean bl3 = false;
            if (stringArray3[stringArray3.length - 1].equals(stringArray2[n7])) {
                n13 = n7;
                bl3 = true;
            } else {
                n13 = n7 - 1;
                bl3 = false;
            }
            n10 = n;
            while (n10 <= n7) {
                n12 = stringArray2[n10].length();
                stringArray2[n10] = (String.valueOf(stringArray2[n10]) + this.SPACES_72).substring(0, 72);
                if (n10 <= n13) {
                    n4 += stringArray2[n10].length() - n12;
                }
                if (bl2) {
                    string3 = String.valueOf(string3) + stringArray2[n10] + "\n";
                } else {
                    stringArray3[n11] = stringArray2[n10];
                    ++n11;
                }
                ++n10;
            }
            if (bl2) {
                stringArray3 = string3.split("\n");
            }
            String string4 = "";
            n13 = bl3 ? stringArray3.length : stringArray3.length - 1;
            n10 = 0;
            while (n10 < stringArray3.length) {
                stringArray3[n10] = String.valueOf(this.getFirstSix(stringArray3[n10])) + stringArray3[n10].substring(6) + string + "\n";
                if (n10 < n13) {
                    n4 += string.length();
                }
                string4 = String.valueOf(string4) + stringArray3[n10];
                ++n10;
            }
            try {
                iDocument.replace(n8, n9 - n8, string4);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError(Messages.getString((String)"ReplaceError"), (Exception)((Object)badLocationException));
            }
            if (!bl) {
                int n14 = string2.indexOf((String)stringArray, n8);
                this.selectAndReveal(n14, n4);
            } else {
                styledText.setCaretOffset(n3);
            }
        }
    }

    public void commentHighlightedtext() {
        int n;
        String[] stringArray;
        StyledText styledText = this.getSourceViewer().getTextWidget();
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (iDocument == null) {
            return;
        }
        String string = String.valueOf(iDocument.get()) + " \n";
        String[] stringArray2 = string.split("\n");
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = this.getHighlightedtextLength();
        if (n4 == 0) {
            bl = true;
            stringArray = this.getCursorPosition().split(":");
            n2 = Integer.parseInt(stringArray[0].trim()) - 1;
            n3 = styledText.getCaretOffset();
            int n5 = 0;
            int n6 = 0;
            try {
                n5 = iDocument.getLineLength(n2);
                n6 = iDocument.getLineOffset(n2);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError(Messages.getString((String)"LengthOffset"), (Exception)((Object)badLocationException));
            }
            n4 = stringArray2.length - 1 == n2 ? n5 : n5 - 1;
            n = n6 + n4;
            styledText.setSelection(n6, n);
        }
        if (n4 >= 0) {
            stringArray = styledText.getSelectionText();
            String[] stringArray3 = stringArray.split("\n");
            ITextSelection iTextSelection = (ITextSelection)this.getSelectionProvider().getSelection();
            n = iTextSelection.getStartLine();
            int n7 = iTextSelection.getEndLine();
            String[] stringArray4 = this.getIndices(iDocument, n, n7).split(":");
            int n8 = Integer.parseInt(stringArray4[0].trim());
            int n9 = Integer.parseInt(stringArray4[1].trim());
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            boolean bl2 = true;
            if (stringArray3.length > n7 - n) {
                bl2 = false;
            }
            String string2 = "";
            n10 = n;
            while (n10 <= n7) {
                if (stringArray2[n10].length() <= 8) {
                    n11 = stringArray2[n10].length();
                    while (n11 <= 8) {
                        int n13 = n10;
                        stringArray2[n13] = String.valueOf(stringArray2[n13]) + " ";
                        ++n4;
                        ++n11;
                    }
                }
                if (bl2) {
                    string2 = String.valueOf(string2) + stringArray2[n10] + "\n";
                } else {
                    stringArray3[n12] = stringArray2[n10];
                    ++n12;
                }
                ++n10;
            }
            if (bl2) {
                stringArray3 = string2.split("\n");
            }
            boolean bl3 = true;
            n10 = 0;
            while (n10 < stringArray3.length) {
                if (stringArray3[n10].charAt(6) != '*') {
                    bl3 = false;
                    break;
                }
                ++n10;
            }
            String string3 = " ";
            String string4 = "*";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            n10 = 0;
            while (n10 < stringArray3.length) {
                stringArray3[n10].substring(0, 6);
                string5 = stringArray3[n10].substring(6, 7);
                string6 = stringArray3[n10].substring(7, 8);
                string7 = stringArray3[n10].substring(8, 9);
                string8 = stringArray3[n10].substring(7);
                if (!string5.equals(" ")) {
                    if (bl3) {
                        if (string6.equals("*") || string6.equalsIgnoreCase("D") || string6.equals("/") || string6.equals("-")) {
                            if (string6.equalsIgnoreCase("D") && !string7.equals(" ")) {
                                stringArray3[n10] = String.valueOf(this.getFirstSix(stringArray3[n10])) + string3 + string8 + "\n";
                            } else {
                                stringArray3[n10] = String.valueOf(this.getFirstSix(stringArray3[n10])) + string8 + "\n";
                                --n4;
                            }
                        } else {
                            stringArray3[n10] = String.valueOf(this.getFirstSix(stringArray3[n10])) + string3 + string8 + "\n";
                        }
                    } else {
                        stringArray3[n10] = String.valueOf(this.getFirstSix(stringArray3[n10])) + string4 + string5 + string8 + "\n";
                        ++n4;
                    }
                } else {
                    stringArray3[n10] = String.valueOf(this.getFirstSix(stringArray3[n10])) + string4 + string8 + "\n";
                }
                ++n10;
            }
            String string9 = "";
            n10 = 0;
            while (n10 < stringArray3.length) {
                string9 = String.valueOf(string9) + stringArray3[n10];
                ++n10;
            }
            try {
                iDocument.replace(n8, n9 - n8, string9);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError(Messages.getString((String)"ReplaceError"), (Exception)((Object)badLocationException));
            }
            if (!bl) {
                int n14 = string.indexOf((String)stringArray, n8);
                this.selectAndReveal(n14, n4);
            } else {
                styledText.setCaretOffset(n3);
            }
        }
    }

    public void trimTrailingSpaces() {
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (iDocument == null || iDocument.getLength() == 0) {
            return;
        }
        String string = iDocument.get();
        String[] stringArray = string.split("\n");
        String[] stringArray2 = string.split("\n");
        String[] stringArray3 = this.getCursorPosition().split(":");
        int n = 0;
        int n2 = 0;
        if (stringArray3.length > 0) {
            n = Integer.parseInt(stringArray3[0].trim()) - 1;
            n2 = Integer.parseInt(stringArray3[1].trim()) - 1;
        }
        boolean bl = false;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < stringArray.length) {
            String string2 = "";
            string2 = this.trimSpacesAtEnd(stringArray[n5]);
            if (!string2.equals(stringArray[n5])) {
                if (!bl) {
                    bl = true;
                    n3 = n5;
                }
                n4 = n5;
            }
            stringArray2[n5] = String.valueOf(string2) + "\n";
            ++n5;
        }
        if (n3 > -1 && n4 > -1) {
            String[] stringArray4 = this.getIndices(iDocument, n3, n4).split(":");
            if (stringArray4 == null || stringArray4.length == 0) {
                return;
            }
            int n6 = Integer.parseInt(stringArray4[0].trim());
            int n7 = Integer.parseInt(stringArray4[1].trim());
            String string3 = "";
            int n8 = n3;
            while (n8 <= n4) {
                string3 = String.valueOf(string3) + stringArray2[n8];
                ++n8;
            }
            try {
                iDocument.replace(n6, n7 - n6, string3);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError(Messages.getString((String)"ReplaceError"), (Exception)((Object)badLocationException));
            }
            StyledText styledText = this.getSourceViewer().getTextWidget();
            int n9 = 0;
            int n10 = 0;
            try {
                n9 = iDocument.getLineOffset(n);
                n10 = iDocument.getLineLength(n);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError(Messages.getString((String)"LengthOffset"), (Exception)((Object)badLocationException));
            }
            if (n2 <= n10) {
                styledText.setCaretOffset(n9 + n2);
            } else {
                styledText.setCaretOffset(n9 + n10 - 1);
            }
        }
    }

    public String trimSpacesAtEnd(String string) {
        if (string.trim().length() == 0) {
            return "";
        }
        int n = 0;
        int n2 = string.length() - 1;
        char c = string.charAt(n2);
        while (' ' == c || '\t' == c || '\r' == c || '\n' == c) {
            ++n;
            c = string.charAt(--n2);
        }
        if (string.contains("\t")) {
            string = string.replaceAll("\t", "    ");
        }
        return string.substring(0, string.length() - n);
    }

    public String getIndices(IDocument iDocument, int n, int n2) {
        String string = String.valueOf(iDocument.get()) + " \n";
        String[] stringArray = string.split("\n");
        int n3 = 0;
        try {
            n3 = iDocument.getLineOffset(n);
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError(Messages.getString((String)"StartIndexError"), (Exception)((Object)badLocationException));
            return "??";
        }
        int n4 = 0;
        if (stringArray.length - n2 > 1) {
            try {
                n4 = iDocument.getLineOffset(n2 + 1);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError(Messages.getString((String)"EndIndexError"), (Exception)((Object)badLocationException));
                return "??";
            }
        }
        try {
            n4 = iDocument.getLineOffset(n2) + stringArray[n2].length() - 1;
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError(Messages.getString((String)"EndIndexError"), (Exception)((Object)badLocationException));
            return "??";
        }
        return String.valueOf(n3) + ":" + n4;
    }

    protected String getCursorPosition() {
        return super.getCursorPosition();
    }

    public void gotoError(boolean bl) {
        try {
            ITextSelection iTextSelection;
            IMarker iMarker;
            ISelectionProvider iSelectionProvider = this.getSelectionProvider();
            if (this.fStatusLineClearer != null) {
                iSelectionProvider.removeSelectionChangedListener(this.fStatusLineClearer);
                this.fStatusLineClearer = null;
            }
            if ((iMarker = this.getNextError((iTextSelection = (ITextSelection)iSelectionProvider.getSelection()).getOffset(), bl)) != null) {
                this.gotoMarker(iMarker);
                this.fStatusLineMsg.setErrorMessageText(iMarker.getAttribute("message", ""));
                this.fStatusLineClearer = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        COBOLEditor.this.getSelectionProvider().removeSelectionChangedListener(COBOLEditor.this.fStatusLineClearer);
                        COBOLEditor.this.fStatusLineClearer = null;
                        COBOLEditor.this.fStatusLineMsg.setErrorMessageText("");
                    }
                };
                iSelectionProvider.addSelectionChangedListener(this.fStatusLineClearer);
            } else {
                this.fStatusLineMsg.setErrorMessageText("");
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    String getFirstSix(String string) {
        if (this.getToggleUpdateTagSetting()) {
            String string2 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Tag-1-6");
            if (string2.trim().length() != 0) {
                string2 = (String.valueOf(string2) + "     ").substring(0, 6);
                return string2;
            }
        } else {
            return string.substring(0, 6);
        }
        string.substring(0, 6);
        return string.substring(0, 6);
    }

    private IMarker getNextError(int n, boolean bl) {
        IMarker iMarker = null;
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int n2 = iDocument.getLength();
        int n3 = 0;
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            MarkerAnnotation markerAnnotation;
            IMarker iMarker2;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof MarkerAnnotation) || !MarkerUtilities.isMarkerType((IMarker)(iMarker2 = (markerAnnotation = (MarkerAnnotation)annotation).getMarker()), (String)"org.eclipse.core.resources.problemmarker") || (position = iAnnotationModel.getPosition(annotation)).includes(n)) continue;
            int n4 = 0;
            if (bl) {
                n4 = position.getOffset() - n;
                if (n4 < 0) {
                    n4 = n2 - n + position.getOffset();
                }
            } else {
                n4 = n - position.getOffset();
                if (n4 < 0) {
                    n4 = n + n2 - position.getOffset();
                }
            }
            if (iMarker != null && n4 >= n3) continue;
            n3 = n4;
            iMarker = iMarker2;
        }
        return iMarker;
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator("group.debug"));
        this.addAction(iMenuManager, "group.debug", VARIABLEACTION_ID);
        this.addAction(iMenuManager, "group.debug", CHANGEEXECUTIONPOINT_ID);
        this.addAction(iMenuManager, "group.debug", RUNTOLINE_ID);
        IAction iAction = this.getAction(VARIABLEACTION_ID);
        if (iAction != null && iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
        if ((iAction = this.getAction(CHANGEEXECUTIONPOINT_ID)) != null && iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
        if ((iAction = this.getAction(RUNTOLINE_ID)) != null && iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
        iMenuManager.add((IContributionItem)new Separator("group.autotag"));
        this.addAction(iMenuManager, "group.autotag", COBOL_TOGGLE_UPDATE_ACTION);
        try {
            IWorkbenchPage iWorkbenchPage;
            boolean bl = this.isEditorInputReadOnly();
            IContributionItem[] iContributionItemArray = iMenuManager.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                if (iContributionItemArray[n].getId() != null && "group.add".equals(iContributionItemArray[n].getId())) {
                    iWorkbenchPage = (MenuManager)iMenuManager.findMenuUsingPath(iContributionItemArray[n].getId());
                    if (iWorkbenchPage == null) break;
                    iWorkbenchPage.add((IContributionItem)new Separator("group.add"));
                    this.addAction((IMenuManager)iWorkbenchPage, ADD_BREAKPOINT);
                    break;
                }
                ++n;
            }
            String string = "group.debug";
            iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IPerspectiveDescriptor iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
            if (!iPerspectiveDescriptor.getId().equalsIgnoreCase(DEBUG_PERSPECTIVE_ID)) {
                ArrayList<IContributionItem> arrayList = new ArrayList<IContributionItem>();
                int n2 = 0;
                while (n2 < iContributionItemArray.length) {
                    if (!(iContributionItemArray[n2].getId() == null || string.equals(iContributionItemArray[n2].getId()) || iContributionItemArray[n2].getId().equals("revert") || iContributionItemArray[n2].getId().equals("save") || iContributionItemArray[n2].getId().equals("open") || iContributionItemArray[n2].getId().equals("cut") || iContributionItemArray[n2].getId().equals("copy") || iContributionItemArray[n2].getId().equals("undo") || iContributionItemArray[n2].getId().equals("paste") || VARIABLEACTION_ID.equals(iContributionItemArray[n2].getId()) || PREFERENCES_CONTEXT_ACTION.equals(iContributionItemArray[n2].getId()) || SETTINGS.equals(iContributionItemArray[n2].getId()))) {
                        arrayList.add(iContributionItemArray[n2]);
                    }
                    ++n2;
                }
                iMenuManager.removeAll();
                for (IContributionItem iContributionItem : arrayList) {
                    iMenuManager.add(iContributionItem);
                }
                super.editorContextMenuAboutToShow(iMenuManager);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public boolean isEditorInputReadOnly() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
            File file = new File(oS2200FileEditorInput.getPath().toOSString());
            return !file.canWrite();
        }
        boolean bl = super.isEditorInputReadOnly();
        return bl;
    }

    public void dispose() {
        try {
            this.resetMarkers(this.fRefFormat, true);
            IWorkbenchPage iWorkbenchPage = CBDTUiPlugin.getActivePage();
            if (iWorkbenchPage != null && this.isDirty()) {
                Object object;
                IViewPart iViewPart = iWorkbenchPage.findView(Messages.getString((String)"StructuredView.label"));
                if (iViewPart != null && (object = ((IFileEditorInput)this.getEditorInput()).getFile()) != null) {
                    CBDTUiPlugin.getDefault().getCOBOLParserRegistry().remove((IFile)object);
                    ViewsTreeModel.getInstance().refreshStructuresViewAndUpdateModel((IFile)object);
                }
                if (iViewPart != null) {
                    object = (StructuresView)iViewPart;
                    ((StructuresView)((Object)object)).refresh();
                }
            }
            if (this.getSourceViewer() != null) {
                this.getSourceViewer().getTextWidget();
            }
            if (this.fViewportListener != null && this.getSourceViewer() != null) {
                this.getSourceViewer().removeViewportListener((IViewportListener)this.fViewportListener);
                this.getSourceViewer().removeTextListener((ITextListener)this.fViewportListener);
                this.fViewportListener = null;
            }
            if (this.fHRuler != null) {
                this.fHRuler.handleDispose();
                this.fHRuler.dispose();
                this.fHRuler = null;
            }
            if (this.fTextFactory != null) {
                this.fTextFactory.dispose();
                this.fTextFactory = null;
            }
            if (this.styledTextPrinter != null) {
                this.styledTextPrinter.dispose();
                this.styledTextPrinter = null;
            }
            if (this.fStatusLineMsg != null) {
                this.fStatusLineMsg.handleDispose();
                this.fStatusLineMsg = null;
            }
            if (this.fAnalyzer != null) {
                this.fAnalyzer.dispose();
                this.fAnalyzer = null;
            }
            if (this.fPage != null) {
                this.fPage.dispose();
                this.fPage = null;
            }
            if (this.fFreeFormatSourceViewerConfiguration != null) {
                this.fFreeFormatSourceViewerConfiguration.handleDispose();
                this.fFreeFormatSourceViewerConfiguration = null;
            }
            this.fStatusLineClearer = null;
            this.fRunnable = null;
            if (this.fAddVariableAction != null) {
                this.fAddVariableAction.setEditor(null);
                this.fAddVariableAction = null;
            }
            if (this.fChangeExecutionpointAction != null) {
                this.fChangeExecutionpointAction.setEditor(null);
                this.fChangeExecutionpointAction = null;
            }
            if (this.fRuntoLineAction != null) {
                this.fRuntoLineAction.setEditor(null);
                this.fRuntoLineAction = null;
            }
            if (this.fCOBOLBreakpointActionPopup != null) {
                this.fCOBOLBreakpointActionPopup.setEditor(null);
                this.fCOBOLBreakpointActionPopup = null;
            }
            if (this.fCOBOLBreakpointRulerAction != null) {
                ((COBOLBreakpointRulerAction)this.fCOBOLBreakpointRulerAction).dispose();
                this.fCOBOLBreakpointRulerAction = null;
            }
            if (this.renumberAction != null) {
                this.renumberAction.setEditor(null);
                this.renumberAction = null;
            }
            if (this.fPrintAction != null) {
                this.fPrintAction.cleanUp();
                this.fPrintAction = null;
            }
            if (this.fContentAssistAction != null) {
                this.fContentAssistAction.setEditor(null);
                this.fContentAssistAction = null;
            }
            if (this.fGotoLineAction != null) {
                this.fGotoLineAction.setEditor(null);
                this.fGotoLineAction = null;
            }
            if (this.fSequenceAreaText != null) {
                this.fSequenceAreaText.dispose();
                this.fSequenceAreaText = null;
            }
            if (this.fCblSequenceNumberArea != null) {
                this.fCblSequenceNumberArea.handleDispose();
                this.fCblSequenceNumberArea = null;
            }
            if (this.fFreeFormatDocumentProvider != null) {
                this.fFreeFormatDocumentProvider.disconnect((Object)this);
            }
            if (this.fFontPropertyChangeListener != null) {
                JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
                this.fFontPropertyChangeListener = null;
            }
            if (this.fEncodingSupport != null) {
                this.fEncodingSupport.dispose();
                this.fEncodingSupport = null;
            }
            this.disposeMargins();
            super.dispose();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void disposeMargins() {
        if (this.marginPainter != null) {
            int n = 0;
            while (n < this.marginPainter.length) {
                this.painter.removePainter((IPainter)this.marginPainter[n]);
                this.marginPainter[n].deactivate(true);
                this.marginPainter[n].dispose();
                ++n;
            }
            this.marginPainter = null;
        }
    }

    public void resetFormat(String string, boolean bl) {
        try {
            if (bl && this.isDirty()) {
                this.doSave(null);
            }
            if (!string.equals(this.fRefFormat)) {
                IEditorInput iEditorInput = this.getEditorInput();
                this.resetMarkers(string, false);
                this.resetMarkers(string, true);
                this.doSetInput(iEditorInput);
                this.getSourceViewer().getTextWidget().setTopPixel(0);
                if (!string.equalsIgnoreCase("FREE")) {
                    this.fCblSequenceNumberArea.getSequenceNumberAreaText().setTopPixel(0);
                }
                this.reLayout();
                if (this.fPage != null) {
                    this.fPage.update();
                }
                ViewsTreeModel.getInstance().refreshStructuresView();
                IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                if (iWorkbenchWindowArray.length > 0) {
                    Display.getDefault().asyncExec(this.getRunnableForViews());
                }
                this.updateStatusField("InputPosition");
                COBOLAbstractUndoManager cOBOLAbstractUndoManager = (COBOLAbstractUndoManager)this.fFreeFormatSourceViewerConfiguration.getUndoManager(this.getSourceViewer());
                cOBOLAbstractUndoManager.setCurrentFormat(string);
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private void resetMarkers(String string, boolean bl) {
        MarkerSet markerSet;
        Workspace workspace;
        ResourceInfo resourceInfo;
        IEditorInput iEditorInput = this.getEditorInput();
        if (!(iEditorInput instanceof IFileEditorInput)) {
            return;
        }
        IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
        IPath iPath = iFileEditorInput.getFile().getFullPath();
        IWorkspace iWorkspace = CBDTUiPlugin.getWorkspace();
        if (iWorkspace != null && iWorkspace instanceof Workspace && (resourceInfo = (workspace = (Workspace)iWorkspace).getResourceInfo(iPath, false, false)) != null && (markerSet = resourceInfo.getMarkers()) != null) {
            IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements();
            if (bl) {
                this.resetSearchMarkers(iMarkerSetElementArray);
            } else {
                this.resetTextMarkers(iMarkerSetElementArray, string);
            }
        }
    }

    public int getSequenceAreaWidth() {
        int n = 0;
        n = 0;
        return n;
    }

    private void resetTextMarkers(IMarkerSetElement[] iMarkerSetElementArray, String string) {
        if (iMarkerSetElementArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < iMarkerSetElementArray.length) {
            block6: {
                MarkerInfo markerInfo = (MarkerInfo)iMarkerSetElementArray[n];
                String string2 = markerInfo.getType();
                if (!string2.equals("org.eclipse.search.searchmarker")) {
                    Object object = ((MarkerInfo)iMarkerSetElementArray[n]).getAttribute("charStart");
                    Object object2 = ((MarkerInfo)iMarkerSetElementArray[n]).getAttribute("lineNumber");
                    Object object3 = ((MarkerInfo)iMarkerSetElementArray[n]).getAttribute("charEnd");
                    int n2 = (Integer)object2;
                    String string3 = (String)((MarkerInfo)iMarkerSetElementArray[n]).getAttribute(START_FORMAT);
                    if (string3 == null) {
                        string3 = this.fRefFormat;
                        ((MarkerInfo)iMarkerSetElementArray[n]).setAttribute(START_FORMAT, (Object)string3, true);
                    }
                    int n3 = 0;
                    int n4 = 0;
                    try {
                        n3 = this.getSourceViewer().getDocument().getLineLength(n2 - 1);
                        n4 = this.getSourceViewer().getDocument().getLineOffset(n2 - 1);
                        n3 = n4 + n3;
                    }
                    catch (BadLocationException badLocationException) {
                        break block6;
                    }
                    object = new Integer(n4);
                    ((MarkerInfo)iMarkerSetElementArray[n]).setAttribute("charStart", object, true);
                    object3 = new Integer(n3);
                    ((MarkerInfo)iMarkerSetElementArray[n]).setAttribute("charEnd", object3, true);
                    ((MarkerInfo)iMarkerSetElementArray[n]).setAttribute(START_FORMAT, (Object)string, true);
                }
            }
            ++n;
        }
    }

    private void resetSearchMarkers(IMarkerSetElement[] iMarkerSetElementArray) {
        if (iMarkerSetElementArray.length == 0) {
            return;
        }
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        COBOLMarkerAnnotationModel cOBOLMarkerAnnotationModel = (COBOLMarkerAnnotationModel)iAnnotationModel;
        if (cOBOLMarkerAnnotationModel == null) {
            return;
        }
        boolean bl = cOBOLMarkerAnnotationModel.getIsMarkerPropertyChanged();
        int n = 0;
        while (n < iMarkerSetElementArray.length) {
            MarkerInfo markerInfo = (MarkerInfo)iMarkerSetElementArray[n];
            Object object = markerInfo.getAttribute("lineNumber");
            if (object == null) {
                return;
            }
            int n2 = (Integer)object;
            String string = markerInfo.getType();
            int n3 = 6;
            if (string.equals("org.eclipse.search.searchmarker") && bl) {
                Object object2 = markerInfo.getAttribute("charStart");
                Object object3 = markerInfo.getAttribute("charEnd");
                int n4 = (Integer)object2;
                object2 = new Integer(n4 += n2 * n3);
                markerInfo.setAttribute("charStart", object2, true);
                int n5 = (Integer)object3;
                object3 = new Integer(n5 += n2 * n3);
                markerInfo.setAttribute("charEnd", object3, true);
            }
            ++n;
        }
    }

    public Runnable getRunnable() {
        if (this.fRunnable == null) {
            this.fRunnable = new Runnable(){

                @Override
                public void run() {
                    boolean bl = false;
                    IWorkbenchWindow[] iWorkbenchWindowArray = COBOLEditor.this.getEditorSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
                    IWorkbenchWindow iWorkbenchWindow = COBOLEditor.this.getEditorSite().getWorkbenchWindow();
                    int n = 0;
                    while (n < iWorkbenchWindowArray.length) {
                        if (iWorkbenchWindow != iWorkbenchWindowArray[n]) {
                            IEditorReference[] iEditorReferenceArray = iWorkbenchWindowArray[n].getActivePage().getEditorReferences();
                            bl = false;
                            IEditorPart iEditorPart = null;
                            int n2 = 0;
                            while (n2 < iEditorReferenceArray.length) {
                                iEditorPart = iEditorReferenceArray[n2].getEditor(false);
                                if (iEditorPart instanceof COBOLEditor) {
                                    COBOLEditor cOBOLEditor = (COBOLEditor)iEditorPart;
                                    if (COBOLEditor.this.getEditorInput().equals(cOBOLEditor.getEditorInput())) {
                                        bl = true;
                                        StringBuffer stringBuffer = cOBOLEditor.getSequenceNumberArea().getSequenceNumbersBuffer();
                                        if (stringBuffer != null) {
                                            cOBOLEditor.getSequenceNumberArea().setSequenceNumbersControl(stringBuffer);
                                        }
                                        cOBOLEditor.getSequenceNumberArea().setPreservedText(COBOLEditor.this.fCblSequenceNumberArea.getPreservedText());
                                        cOBOLEditor.getSequenceNumberArea().setPatternFlag(COBOLEditor.this.fCblSequenceNumberArea.isPatternB());
                                    }
                                }
                                if (bl) break;
                                ++n2;
                            }
                        }
                        ++n;
                    }
                }
            };
        }
        return this.fRunnable;
    }

    public Runnable getRunnableForViews() {
        try {
            if (this.fRunnable == null) {
                this.fRunnable = new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                        int n = 0;
                        while (n < iWorkbenchWindowArray.length) {
                            IViewReference[] iViewReferenceArray = iWorkbenchWindowArray[n].getActivePage().getViewReferences();
                            IViewPart iViewPart = null;
                            int n2 = 0;
                            while (n2 < iViewReferenceArray.length) {
                                iViewPart = iViewReferenceArray[n2].getView(false);
                                if (iViewPart instanceof StructuresView) {
                                    StructuresView structuresView = (StructuresView)iViewPart;
                                    structuresView.refresh();
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                };
            }
            return this.fRunnable;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public void pasteIntoEditor(String string) {
        try {
            int n = 0;
            StyledText styledText = this.getCurrentSourceViewer().getTextWidget();
            IDocument iDocument = this.getCurrentSourceViewer().getDocument();
            int n2 = this.getCurrentSourceViewer().getVisibleRegion().getOffset();
            n = n2 + this.getCurrentSourceViewer().getTextWidget().getCaretOffset();
            int n3 = 0;
            String string2 = styledText.getLineDelimiter();
            int n4 = iDocument.getLineOffset(iDocument.getLineOfOffset(n));
            if (n4 != n) {
                string = this.findEndOfWhiteSpaceString(iDocument, styledText, n4, n, new StringBuffer(string));
            }
            String string3 = this.addDelimiter(string2, string);
            while ((n3 = string.indexOf("\n", n3)) != -1) {
                ++n3;
            }
            if (styledText != null && string3 != null && !string3.equals("")) {
                Point point = styledText.getSelection();
                int n5 = 0;
                if (point.x != point.y) {
                    n = point.x;
                    n5 = point.y - point.x;
                }
                styledText.replaceTextRange(n, n5, string3);
                this.setFocus();
                styledText.setCaretOffset(n + string3.length());
                string = "";
                string3 = "";
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CBDTUiPlugin.logError(indexOutOfBoundsException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public String addDelimiter(String string, String string2) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string2);
        n = stringBuffer.toString().indexOf(string, n);
        if (n != -1) {
            return stringBuffer.toString();
        }
        n = 0;
        while ((n = stringBuffer.toString().indexOf("\n", n)) != -1) {
            stringBuffer.deleteCharAt(n);
            stringBuffer.insert(n, string);
            n += 2;
        }
        return stringBuffer.toString();
    }

    public String findEndOfWhiteSpaceString(IDocument iDocument, StyledText styledText, int n, int n2, StringBuffer stringBuffer) throws BadLocationException {
        block5: {
            int n3 = 0;
            String string = "";
            try {
                int n4;
                n3 = n;
                while (n3 < n2) {
                    n4 = iDocument.getChar(n3);
                    if (n4 != 32 && n4 != 9) break;
                    ++n3;
                }
                if (n3 == n) break block5;
                string = iDocument.get(n, n3 - n);
                n4 = 0;
                while (n4 != -1) {
                    n4 = stringBuffer.toString().indexOf("\n", n4);
                    if (n4 != -1) {
                        stringBuffer.insert(++n4, string);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
        return stringBuffer.toString();
    }

    public COBOLElementAnalyzer getElementAnalyzer() {
        return this.fAnalyzer;
    }

    private void setOpenFilePath() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof RemoteFileEditorInput) {
            fOpenFilePath = ((RemoteFileEditorInput)iEditorInput).getFile().getFullPath().toString();
        } else if (iEditorInput instanceof IStorageEditorInput) {
            try {
                fOpenFilePath = ((IStorageEditorInput)iEditorInput).getStorage().getFullPath().toString();
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
        } else if (iEditorInput instanceof IPathEditorInput) {
            fOpenFilePath = ((IPathEditorInput)iEditorInput).getPath().toPortableString();
        } else if (iEditorInput instanceof FileStoreEditorInput) {
            fOpenFilePath = ((FileStoreEditorInput)iEditorInput).getURI().getPath();
        } else {
            FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
            IFile iFile = fileEditorInput.getFile();
            fOpenFilePath = iFile.getFullPath().toString();
        }
    }

    public void selectAndReveal(int n, int n2) {
        super.selectAndReveal(n, n2);
        if (!this.fRefFormat.equals("FREE")) {
            int n3 = this.getSourceViewer().getTextWidget().getTopPixel();
            this.fCblSequenceNumberArea.getSequenceNumberAreaText().setTopPixel(n3);
        }
    }

    public void setTitleImage(Image image) {
        Image image2 = null;
        image2 = this.getProblemMarker();
        if (image2 != null) {
            image = image2;
        }
        super.setTitleImage(image);
    }

    private Image getProblemMarker() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            TreeElement treeElement;
            IFile iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            IProject iProject = iFile.getProject();
            String string = iProject != null ? iProject.getName() : iFile.getName();
            String string2 = iFile.getFullPath().toString();
            if ('/' == string2.charAt(0)) {
                string2 = string2.substring(1);
            }
            if ((treeElement = ViewsTreeModel.getInstance().getProjectNode(string)) != null) {
                TreeElement treeElement2 = treeElement.getChildFromType("SOURCE_FOLDER");
                TreeElement treeElement3 = null;
                if (treeElement2 != null && BuildUtil.isCobolFileExtn(iFile.getName()) && (treeElement3 = treeElement2.getChildFromLocation(string2)) != null) {
                    if (2 == treeElement3.getMarker()) {
                        return COBOLPluginImages.get("org.eclipse.cobol.ui.problem_cobol_file_icon.gif");
                    }
                    if (1 == treeElement3.getMarker()) {
                        return COBOLPluginImages.get("org.eclipse.cobol.ui.warning_cobol_file_icon.gif");
                    }
                }
            }
        }
        return null;
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    public void showOverviewRuler() {
        if (this.getSourceViewer() instanceof ISourceViewerExtension) {
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(true);
            this.fSourceViewerDecorationSupport.updateOverviewDecorations();
        }
    }

    public void hideOverviewRuler() {
        if (this.getSourceViewer() instanceof ISourceViewerExtension) {
            this.fSourceViewerDecorationSupport.hideAnnotationOverview();
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(false);
        }
    }

    public boolean isOverviewRulerVisible() {
        return super.isOverviewRulerVisible();
    }

    public IOverviewRuler getOverviewRuler() {
        return this.fOverviewRuler;
    }

    private void configureTabConverter() {
        if (this.fTabConverter != null) {
            IDocumentProvider iDocumentProvider = this.getDocumentProvider();
            if (iDocumentProvider instanceof COBOLBaseDocumentProvider) {
                this.fTabConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            } else {
                this.fTabConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            }
        }
    }

    private void startAutoTag() {
        COBOLSourceViewer cOBOLSourceViewer = (COBOLSourceViewer)this.getSourceViewer();
        this.fAutoTag = new COBOLSourceViewer.AutoTag();
        this.fAutoTag.setSourceViewer(cOBOLSourceViewer);
        cOBOLSourceViewer.addTextConverter(this.fAutoTag);
    }

    private void stopAutoTag() {
        COBOLSourceViewer cOBOLSourceViewer = (COBOLSourceViewer)this.getSourceViewer();
        if (this.fAutoTag != null) {
            cOBOLSourceViewer.removeTextConverter(this.fAutoTag);
        }
        this.fAutoTag = null;
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new COBOLSourceViewer.TabConverter();
            this.configureTabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("Tab Width"));
            COBOLSourceViewer cOBOLSourceViewer = (COBOLSourceViewer)this.getSourceViewer();
            cOBOLSourceViewer.addTextConverter(this.fTabConverter);
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            COBOLSourceViewer cOBOLSourceViewer = (COBOLSourceViewer)this.getSourceViewer();
            cOBOLSourceViewer.removeTextConverter(this.fTabConverter);
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = iPreferenceStore.getString("Use Spaces for TABS");
        return string.compareToIgnoreCase("true") == 0;
    }

    public void applyNewTextFactory() {
        COBOLParser cOBOLParser = new COBOLParser();
        cOBOLParser.initialize();
        cOBOLParser.parseDocument(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
        COBOLSourceViewer cOBOLSourceViewer = (COBOLSourceViewer)this.getSourceViewer();
        if (cOBOLSourceViewer != null) {
            cOBOLSourceViewer.unconfigure();
            this.fFreeFormatSourceViewerConfiguration = null;
            this.fFreeFormatSourceViewerConfiguration = new COBOLFreeFormatSourceViewerConfiguration(CBDTUiPlugin.getDefault().getCOBOLTextFactory(), (ITextEditor)this);
            cOBOLSourceViewer.configure(this.fFreeFormatSourceViewerConfiguration);
        }
        if (cOBOLParser != null) {
            cOBOLParser.disposeElements();
            cOBOLParser.dispose();
            cOBOLParser = null;
        }
    }

    private void backSpaceEvent() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = "";
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String[] stringArray = iPreferenceStore.getString("Column Tab Width").split(",");
        StyledText styledText = this.getSourceViewer().getTextWidget();
        String string2 = this.getCursorPosition();
        if (!string2.equals("??")) {
            String[] stringArray2 = string2.split(":");
            n = Integer.parseInt(stringArray2[0].trim()) - 1;
            n2 = Integer.parseInt(stringArray2[1].trim());
            if (n2 < Integer.parseInt(stringArray[0].trim())) {
                n3 = 0;
            } else {
                int n4 = stringArray.length - 1;
                while (n4 >= 0) {
                    if (n2 >= Integer.parseInt(stringArray[n4].trim())) {
                        n3 = Integer.parseInt(stringArray[n4].trim()) - 1;
                        break;
                    }
                    --n4;
                }
            }
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int n5 = iDocument.getNumberOfLines();
            string = styledText.getLine(n);
            string = String.valueOf(string.substring(0, n3)) + "\n";
            String string3 = this.getIndices(iDocument, n, n);
            if (!string3.equals("??") && n < n5 - 1) {
                String[] stringArray3 = string3.split(":");
                int n6 = Integer.parseInt(stringArray3[0].trim());
                int n7 = Integer.parseInt(stringArray3[1].trim());
                try {
                    iDocument.replace(n6, n7 - n6, string);
                    styledText.setCaretOffset(n6 + n3);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public boolean getToggleUpdateTagSetting() {
        return this.fToggleUpdateTagSetting;
    }

    public void setToggleUpdateTagSetting(boolean bl) {
        this.fToggleUpdateTagSetting = bl;
        if (this.fToggleUpdateTagSetting) {
            this.startAutoTag();
        } else {
            this.stopAutoTag();
        }
    }

    public IDocumentProvider getDocumentProvider() {
        return super.getDocumentProvider();
    }

    public final Map<Integer, String> getDivisionMetaData() {
        return this.divisionMetaData;
    }

    public void openCopyProcs(String string) {
        Object object;
        Object object2;
        Object object3;
        string = string.toUpperCase();
        HashMap hashMap = null;
        String string2 = null;
        LoginAccount loginAccount = null;
        String string3 = null;
        OS2200ProjectUpdate.Share share = null;
        if (this.getEditorInput() instanceof IFileEditorInput) {
            object3 = ((IFileEditorInput)this.getEditorInput()).getFile();
            try {
                string2 = object3.getPersistentProperty(OS2200ArchitectureConstant.TRANS_WRITTEN);
                object2 = object3.getProject();
                object = OS2200ProjectUpdate.getProperties((IProject)object2);
                string3 = OS2200ProjectUpdate.getShareName((IProject)object2);
                share = OS2200ProjectUpdate.getShareState((IProject)object2);
                String string4 = ((Properties)object).getProperty("hostID");
                loginAccount = OS2200FileInterface.getLoginAccount((String)string4);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
            hashMap = OS2200FileInterface.getCopyProcMap((IFile)object3);
        }
        if (this.getEditorInput() instanceof OS2200FileEditorInput) {
            COBOLEditor.setStatusBarMessage("Copy procedure can't be opened if its not associated with a project");
            return;
        }
        if (hashMap != null && !hashMap.isEmpty() && hashMap.get(string) != null) {
            object3 = new File((String)((ArrayList)hashMap.get(string)).get(0));
            if (((File)object3).exists()) {
                COBOLEditor cOBOLEditor;
                int n;
                object2 = ((File)object3).getName();
                object = "";
                int n2 = ((File)object3).getName().lastIndexOf(46);
                object2 = n2 > 0 ? (((String)(object = ((File)object3).getName().substring(n2 + 1))).equalsIgnoreCase("cob") || ((String)object).equalsIgnoreCase("cobp") ? ((File)object3).getName() : String.valueOf(((File)object3).getName().replace(".", "-")) + ".cob") : String.valueOf(((File)object3).getName()) + ".cob";
                IFileStore iFileStore = null;
                try {
                    iFileStore = EFS.getStore((URI)((File)object3).toURI());
                }
                catch (Exception exception) {}
                OS2200FileEditorInput oS2200FileEditorInput = new OS2200FileEditorInput(iFileStore, loginAccount, share, string3, string2, COBOL_EDITOR_ID, (String)object2);
                IEditorPart iEditorPart = OS2200FileInterface.openFileInEditor((File)object3, (OS2200FileEditorInput)oS2200FileEditorInput);
                if (iEditorPart == null) {
                    COBOLEditor.setStatusBarMessage(Messages.getString((String)"OS2200FileInterface.201"));
                } else if (iEditorPart instanceof COBOLEditor && (n = (cOBOLEditor = (COBOLEditor)iEditorPart).getSourceViewer().getTextWidget().getText().indexOf(string)) >= 0) {
                    cOBOLEditor.getSourceViewer().getTextWidget().setCaretOffset(n);
                }
            } else {
                COBOLEditor.setStatusBarMessage("Copy procs file doesn't exist");
            }
        } else {
            COBOLEditor.setStatusBarMessage("No copy procedure map found.Please configure.");
        }
    }

    String getCursorPreviousString(StyledText styledText) {
        String string = null;
        int n = styledText.getCaretOffset();
        int n2 = 0;
        int n3 = 0;
        IDocument iDocument = this.svr.getDocument();
        if (iDocument != null) {
            try {
                char c = iDocument.getChar(n);
                if (c == ' ') {
                    c = iDocument.getChar(--n);
                }
                while (c != ' ') {
                    c = iDocument.getChar(--n);
                }
                c = iDocument.getChar(n);
                while (c == ' ' || c == '\n' || c == '\t') {
                    c = iDocument.getChar(--n);
                }
                n3 = n;
                c = iDocument.getChar(n);
                while (c != ' ') {
                    c = iDocument.getChar(--n);
                }
                n2 = n;
                string = styledText.getText(n2, n3).trim();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return string;
    }

    public String getCursorString(StyledText styledText) {
        int n;
        String string = null;
        int n2 = n = styledText.getCaretOffset();
        int n3 = 0;
        int n4 = 0;
        IDocument iDocument = this.svr.getDocument();
        if (iDocument != null) {
            try {
                char c = iDocument.getChar(n);
                if (c == ' ') {
                    c = iDocument.getChar(--n);
                }
                while (c != ' ') {
                    c = iDocument.getChar(--n);
                }
                n3 = n;
                n = n2;
                c = iDocument.getChar(n);
                while (c != ' ') {
                    c = iDocument.getChar(++n);
                }
                n4 = n;
                string = styledText.getText(n3, n4).trim();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return string;
    }

    public boolean isCopyProcDeclration(StyledText styledText) {
        String string = this.getCursorPreviousString(styledText);
        return string != null && string.equalsIgnoreCase("copy");
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"org.eclipse.cobol.ui.preferences.COBOLEditorPreferencePage", "org.eclipse.cobol.ui.preferences.COBOLTemplatePreferencePage", "org.eclipse.ui.preferencePages.GeneralTextEditor"};
    }

    public String getPartName() {
        return super.getPartName().toUpperCase();
    }

    protected void setPartName(String string) {
        super.setPartName(string.toUpperCase());
    }

    public String getTitleToolTip() {
        if (this.titleToolTip == null) {
            this.titleToolTip = EditorRelatedUtils.getPathIn2200Format((IEditorInput)this.getEditorInput(), null);
        }
        return this.titleToolTip;
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        return false;
    }

    class FontPropertyChangeListener
    implements IPropertyChangeListener {
        FontPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FontData fontData = null;
            Font font = null;
            IPreferenceStore iPreferenceStore = COBOLEditor.this.getPreferenceStore();
            if (iPreferenceStore.contains("org.eclipse.jface.textfont")) {
                fontData = PreferenceConverter.getFontData((IPreferenceStore)iPreferenceStore, (String)"org.eclipse.jface.textfont");
                if (fontData != null) {
                    font = new Font((Device)COBOLEditor.this.getSourceViewer().getTextWidget().getDisplay(), fontData);
                }
                if (font == null) {
                    font = JFaceResources.getTextFont();
                }
                COBOLEditor.this.setFont(font);
            }
        }
    }

    private class InternalViewPortListener
    implements IViewportListener,
    ITextListener {
        private InternalViewPortListener() {
        }

        public void viewportChanged(int n) {
            StyledText styledText = COBOLEditor.this.getSourceViewer().getTextWidget();
            if (styledText != null) {
                // empty if block
            }
        }

        public void textChanged(TextEvent textEvent) {
        }
    }

    private class RulerLayout
    extends Layout {
        protected int fGap;

        protected RulerLayout(int n) {
            this.fGap = n;
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Control[] controlArray = composite.getChildren();
            Point point = controlArray[controlArray.length - 1].computeSize(-1, -1, bl);
            IVerticalRuler iVerticalRuler = COBOLEditor.this.getVerticalRuler();
            if (iVerticalRuler != null) {
                point.x += iVerticalRuler.getWidth() + this.fGap;
            }
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            IVerticalRuler iVerticalRuler = COBOLEditor.this.getVerticalRuler();
            if (iVerticalRuler != null) {
                Rectangle rectangle2 = COBOLEditor.this.getSourceViewer().getTextWidget().computeTrim(0, 0, 0, 0);
                int n = rectangle2.height;
                int n2 = iVerticalRuler.getWidth();
                int n3 = 0;
                if (COBOLEditor.this.fOverviewRuler != null && COBOLEditor.this.isOverviewRulerVisible()) {
                    n3 = COBOLEditor.this.fOverviewRuler.getWidth();
                    COBOLEditor.this.fOverviewRuler.getControl().setBounds(rectangle.width - n3 - 1, n, n3, rectangle.height - 3 * n);
                    COBOLEditor.this.fOverviewRuler.getHeaderControl().setBounds(rectangle.width - n3 - 1, 0, n3, n);
                }
                int n4 = COBOLEditor.this.getSequenceAreaWidth();
                iVerticalRuler.getControl().setBounds(0, 0, n2, rectangle.height - n - 0);
                try {
                    if (COBOLEditor.this.fHRulerSpacer != null && COBOLEditor.this.fHRulerSpacer.getDisplay() != null) {
                        GridData gridData = new GridData();
                        gridData.horizontalAlignment = 32;
                        gridData.widthHint = n2 + this.fGap;
                        COBOLEditor.this.fHRulerSpacer.setLayoutData((Object)gridData);
                        COBOLEditor.this.fHRulerSpacer.getParent().layout();
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
                try {
                    if (COBOLEditor.this.fHRuler != null && COBOLEditor.this.fHRuler.getDisplay() != null) {
                        COBOLEditor.this.fHRuler.redraw();
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
                COBOLEditor.this.getSourceViewer().getTextWidget().setBounds(n2 + n4 + this.fGap, 0, rectangle.width - n2 - n4 - n3 - 2 * this.fGap, rectangle.height);
            } else {
                COBOLEditor.this.getSourceViewer().getTextWidget().setBounds(0, 0, rectangle.width, rectangle.height);
            }
        }
    }

    public class keyListener
    implements KeyListener {
        boolean isShiftBackspace = false;

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 47 && keyEvent.stateMask == 262144) {
                COBOLEditor.this.commentHighlightedtext();
            }
            if (keyEvent.stateMask == 131072 && keyEvent.keyCode == 8) {
                COBOLEditor.this.backSpaceEvent();
            }
            if (keyEvent.keyCode == 116 && keyEvent.stateMask == 262144) {
                CBDTUiPlugin.logTraceMessage("Processing tagHighlightedText");
                COBOLEditor.this.tagHighlightedText();
            }
            if (keyEvent.keyCode == 0x100000D) {
                COBOLEditor.this.applyNewTextFactory();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

