/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.editor;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AutoTagDialog
extends TrayDialog {
    private Combo autoTagCb;
    private String currentAutoTag;
    private String autoTagList;
    IPreferenceStore store = null;
    private final int MAX_SIZE = 8;
    private final String SPACE_STR = "          ";
    private String REG_EX = "";
    private VerifyListener convertUpperCase = new VerifyListener(){

        public void verifyText(VerifyEvent verifyEvent) {
            verifyEvent.text = verifyEvent.text.toUpperCase();
        }
    };

    public AutoTagDialog(Shell shell) {
        super(shell);
        this.store = CBDTUiPlugin.getDefault().getPreferenceStore();
        String string = "";
        string = this.store != null && this.store.getString("CurrentAutoTag") != null ? this.store.getString("CurrentAutoTag").toUpperCase() : "";
        this.currentAutoTag = string;
        this.setBlockOnOpen(false);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.getShell().setText("Tagging");
        this.setHelpAvailable(true);
        try {
            GridLayout gridLayout = new GridLayout(4, false);
            composite2.setLayout((Layout)gridLayout);
            this.createComponents(composite2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return composite2;
    }

    private void createComponents(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Label label = new Label(composite, 0);
        label.setText("Tag in Columns 73-80");
        this.autoTagCb = new Combo(composite, 2048);
        this.autoTagCb.setTextLimit(8);
        this.autoTagCb.setToolTipText("Max. 8 characters");
        this.autoTagCb.addVerifyListener(this.convertUpperCase);
        if (this.store != null && this.store.getString("autoTagList") != null && this.store.getString("autoTagList").length() > 0) {
            this.REG_EX = "";
            int n = 0;
            while (n < 8) {
                this.REG_EX = String.valueOf(this.REG_EX) + ".";
                ++n;
            }
            this.REG_EX = "(?<=\\G" + this.REG_EX + ")";
            String[] stringArray = this.store.getString("autoTagList").toUpperCase().split(this.REG_EX);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.autoTagCb.add(stringArray[n2]);
                ++n2;
            }
        }
        if (this.autoTagCb.getItemCount() > 0) {
            int n = 0;
            String string = this.store.getString("CurrentAutoTag").toUpperCase();
            n = 0;
            while (n < this.autoTagCb.getItemCount()) {
                if (string.equalsIgnoreCase(this.autoTagCb.getItem(n))) break;
                ++n;
            }
            this.autoTagCb.select(n);
        }
        this.autoTagCb.setLayoutData((Object)gridData);
        this.setHelpAvailable(false);
    }

    private void saveInput() {
        this.currentAutoTag = this.autoTagCb.getText();
        String string = "";
        if (this.currentAutoTag.trim().length() > 0) {
            this.currentAutoTag = (String.valueOf(this.currentAutoTag) + "          ").substring(0, 8).toUpperCase();
        }
        boolean bl = false;
        if (this.store != null && this.store.getString("autoTagList") != null) {
            this.autoTagList = this.store.getString("autoTagList").toUpperCase();
            this.REG_EX = "";
            int n = 0;
            while (n < 8) {
                this.REG_EX = String.valueOf(this.REG_EX) + ".";
                ++n;
            }
            this.REG_EX = "(?<=\\G" + this.REG_EX + ")";
            String[] stringArray = this.autoTagList.split(this.REG_EX);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].trim().length() > 0) {
                    if (stringArray[n2].trim().equalsIgnoreCase(this.autoTagCb.getText().trim())) {
                        bl = true;
                        string = String.valueOf(this.currentAutoTag) + string;
                    } else {
                        string = String.valueOf(string) + (String.valueOf(stringArray[n2]) + "          ").substring(0, 8).toUpperCase();
                    }
                }
                ++n2;
            }
            if (!bl) {
                if (string.length() >= 80) {
                    string = string.substring(0, 72);
                }
                string = String.valueOf(this.currentAutoTag) + string;
                this.store.setValue("autoTagList", string.toUpperCase());
            } else {
                this.store.setValue("autoTagList", string.toUpperCase());
            }
        }
        this.store.setValue("CurrentAutoTag", this.currentAutoTag.toUpperCase());
    }

    public String getAutoTagList() {
        return this.autoTagList;
    }

    public String getCurrentAutoTag() {
        return this.currentAutoTag;
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public boolean close() {
        return super.close();
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.getButton(0).setText("OK");
        this.getButton(1).setText("Cancel");
        this.getButton(0).setEnabled(this.autoTagCb.getText().trim().length() > 0);
        this.autoTagCb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AutoTagDialog.this.getButton(0).setEnabled(AutoTagDialog.this.autoTagCb.getText().trim().length() > 0);
            }
        });
        return control;
    }
}

