/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.dialogs;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.fixedformat.COBOLSequenceNumberArea;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;

public class RenumberDialog
extends Dialog {
    private Text fInitialValueText;
    private Text fIncrementValueText;
    private Button fRenumberButton;
    private Button fCancelButton;
    private Label fErrorMessageLabel;
    private IEditorPart fEditorPart;
    private static final int LABEL_WIDTH = 180;
    private static final int TEXT_WIDTH = 80;
    private static final int DIALOG_WIDTH = 1800;
    private static final int DIALOG_HEIGHT = 1600;
    private static final String RENUMBER_ERROR = "renumber_error";

    public RenumberDialog(Shell shell, IEditorPart iEditorPart) {
        super(shell);
        this.fEditorPart = iEditorPart;
    }

    public Control createContents(Composite composite) {
        RenumberDialog.applyDialogFont((Control)composite);
        Composite composite2 = null;
        try {
            composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 7;
            gridLayout.marginWidth = 7;
            gridLayout.numColumns = 1;
            composite2.setLayout((Layout)gridLayout);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setFont(composite2.getFont());
            composite3.setSize(1800, 1600);
            gridLayout = new GridLayout();
            gridLayout.makeColumnsEqualWidth = true;
            gridLayout.numColumns = 2;
            GridData gridData = new GridData(1808);
            composite3.setLayout((Layout)gridLayout);
            composite3.setLayoutData((Object)gridData);
            Composite composite4 = new Composite(composite2, 0);
            composite4.setFont(composite2.getFont());
            gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            GridData gridData2 = new GridData(1);
            composite4.setLayout((Layout)gridLayout);
            composite4.setLayoutData((Object)gridData2);
            Composite composite5 = new Composite(composite2, 0);
            composite5.setFont(composite2.getFont());
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            GridData gridData3 = new GridData(136);
            composite5.setLayout((Layout)gridLayout);
            composite5.setLayoutData((Object)gridData3);
            this.fInitialValueText = this.addTextControl(composite3, Messages.getString((String)"renumberInitialValueLabel"));
            this.fInitialValueText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyEvent) {
                    RenumberDialog.this.validate(verifyEvent);
                }
            });
            this.fIncrementValueText = this.addTextControl(composite3, Messages.getString((String)"renumberIncrementalValueLabel"));
            this.fIncrementValueText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyEvent) {
                    RenumberDialog.this.validate(verifyEvent);
                }
            });
            this.fRenumberButton = this.addButton(composite5, Messages.getString((String)"renumberButtonCaption"), true, true);
            this.fRenumberButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RenumberDialog.this.renumber();
                }
            });
            this.fCancelButton = this.addButton(composite5, Messages.getString((String)"cancelButtonCaption"), false, true);
            this.fCancelButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RenumberDialog.this.closeDialog();
                }
            });
            this.fErrorMessageLabel = this.addLabel(composite4);
            this.initialize();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CBDTUiPlugin.logError(illegalArgumentException);
        }
        return composite2;
    }

    private void initialize() {
        this.fInitialValueText.setText(Messages.getString((String)"initialValueText"));
        this.fIncrementValueText.setText(Messages.getString((String)"incrementValueText"));
    }

    private void closeDialog() {
        this.close();
    }

    private void renumber() {
        int n;
        int n2;
        if (this.fInitialValueText.getText().equals("") || Integer.parseInt(this.fInitialValueText.getText()) == 0) {
            this.fInitialValueText.setFocus();
            this.fErrorMessageLabel.setText(Messages.getString((String)"invalidNumber"));
            Display.getDefault().beep();
            return;
        }
        if (this.fIncrementValueText.getText().equals("") || Integer.parseInt(this.fIncrementValueText.getText()) == 0) {
            this.fErrorMessageLabel.setText(Messages.getString((String)"invalidNumber"));
            this.fIncrementValueText.setFocus();
            Display.getDefault().beep();
            return;
        }
        COBOLEditor cOBOLEditor = (COBOLEditor)this.fEditorPart;
        COBOLSequenceNumberArea cOBOLSequenceNumberArea = cOBOLEditor.getSequenceNumberArea();
        int n3 = Integer.parseInt(this.fInitialValueText.getText());
        if (n3 + (n2 = Integer.parseInt(this.fIncrementValueText.getText())) * ((n = cOBOLEditor.getCurrentSourceViewer().getDocument().getNumberOfLines()) - 1) > 999999) {
            this.fInitialValueText.setFocus();
            this.fErrorMessageLabel.setText(Messages.getString((String)RENUMBER_ERROR));
            Display.getCurrent().beep();
            return;
        }
        cOBOLSequenceNumberArea.renumber(n3, n2, n);
        cOBOLEditor.fireChanges();
        this.closeDialog();
    }

    private Text addTextControl(Composite composite, String string) {
        Label label = new Label(composite, 4);
        label.setFont(composite.getFont());
        label.setText(string);
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        Text text = new Text(composite, 2048);
        text.setFont(composite.getFont());
        text.setTextLimit(6);
        text.setLayoutData((Object)gridData);
        return text;
    }

    private Button addButton(Composite composite, String string, boolean bl, boolean bl2) {
        Shell shell;
        GridData gridData = bl2 ? new GridData() : new GridData(256);
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(string);
        if (!bl2) {
            gridData.widthHint = 61;
        }
        button.setLayoutData((Object)gridData);
        if (bl && (shell = composite.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        return button;
    }

    private Label addLabel(Composite composite) {
        GridData gridData = new GridData();
        Label label = new Label(composite, 0);
        gridData.widthHint = 180;
        label.setLayoutData((Object)gridData);
        label.setForeground(new Color((Device)label.getDisplay(), 0, 0, 0));
        return label;
    }

    private void validate(VerifyEvent verifyEvent) {
        if (verifyEvent.character == '\u007f' || verifyEvent.character == '\b') {
            return;
        }
        try {
            Integer.parseInt(verifyEvent.text);
            this.fErrorMessageLabel.setText("");
        }
        catch (NumberFormatException numberFormatException) {
            this.fErrorMessageLabel.setText(Messages.getString((String)"nonNumericValue"));
            verifyEvent.doit = false;
            Display.getDefault().beep();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString((String)"renumberDialogTitle"));
    }
}

