/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.dialogs;

import com.unisys.os2200.i18nSupport.Messages;
import java.text.MessageFormat;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GotoLineDialog
extends InputDialog {
    private String fLineNumberMessage;
    private Label fTopMessage;
    private COBOLEditor fCOBOLEditor;
    private boolean fBasedOnLine = false;
    private int fLastLine;
    private static final String BLANK = "";
    private static final String PREFIX = "Editor.GotoLine.";
    private static final String RADIO_LINE_LABEL = "dialog.line_number";
    private static final String RADIO_SEQUENCE_LABEL = "dialog.sequence_number";
    private static final String DIALOG_SEQUENCE_MESSAGE = "dialog.message2";
    private static final String DIALOG_LINE_MESSAGE = "dialog.message1";
    private static final String DIALOG_NO_SEQUENCE_NUMBER = "dialog.No_Seq_Numbers";

    public GotoLineDialog(Shell shell, String string, String string2, String string3, int n, IInputValidator iInputValidator, COBOLEditor cOBOLEditor) {
        super(shell, string, string2, string3, iInputValidator);
        this.fLastLine = n;
        this.fCOBOLEditor = cOBOLEditor;
    }

    protected Control createDialogArea(Composite composite) {
        try {
            super.createDialogArea(composite);
            this.getText().setFocus();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return composite;
    }

    private Label findTopMessageLabel(Composite composite) {
        Control[] controlArray = composite.getChildren();
        Composite composite2 = (Composite)controlArray[1];
        Control[] controlArray2 = composite2.getChildren();
        Label label = (Label)controlArray2[0];
        return label;
    }

    private void createRadioButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.verticalSpacing = 4;
        gridLayout.horizontalSpacing = 7;
        gridLayout.marginWidth = 7;
        composite2.setLayout((Layout)gridLayout);
        Button button = this.addRadioButton(composite2, Messages.getString((String)"Editor.GotoLine.dialog.sequence_number"));
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GotoLineDialog.this.isBasedOnLine()) {
                    String string = null;
                    if (GotoLineDialog.this.fCOBOLEditor.getSequenceNumberArea().getSequenceNumbersBuffer().length() == 0) {
                        GotoLineDialog.this.disableSequenceRadio();
                    } else {
                        string = MessageFormat.format(Messages.getString((String)"Editor.GotoLine.dialog.message2"), GotoLineDialog.this.fCOBOLEditor.getSequenceNumberArea().getFirstSequenceNumber(), GotoLineDialog.this.fCOBOLEditor.getSequenceNumberArea().getLastSequenceNumber());
                        GotoLineDialog.this.fTopMessage.setText(string);
                        GotoLineDialog.this.getText().setEditable(true);
                        GotoLineDialog.this.getText().setText(GotoLineDialog.BLANK);
                        GotoLineDialog.this.getText().setFocus();
                    }
                    GotoLineDialog.this.setBasedOnSequence();
                }
            }
        });
        Button button2 = this.addRadioButton(composite2, Messages.getString((String)"Editor.GotoLine.dialog.line_number"));
        button2.setSelection(false);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!GotoLineDialog.this.isBasedOnLine()) {
                    GotoLineDialog.this.setBasedOnLine();
                    GotoLineDialog.this.fLineNumberMessage = MessageFormat.format(Messages.getString((String)"Editor.GotoLine.dialog.message1"), new Integer(GotoLineDialog.this.fLastLine));
                    if (GotoLineDialog.this.fTopMessage != null) {
                        GotoLineDialog.this.fTopMessage.setText(GotoLineDialog.this.fLineNumberMessage);
                    }
                    GotoLineDialog.this.getText().setEditable(true);
                    GotoLineDialog.this.getText().setText(GotoLineDialog.BLANK);
                    GotoLineDialog.this.getText().setFocus();
                }
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
    }

    private Button addRadioButton(Composite composite, String string) {
        GridData gridData = new GridData(256);
        Button button = new Button(composite, 16);
        button.setFont(composite.getFont());
        button.setText(string);
        button.setLayoutData((Object)gridData);
        return button;
    }

    public void setBasedOnSequence() {
        this.fBasedOnLine = false;
    }

    public void setBasedOnLine() {
        this.fBasedOnLine = true;
    }

    public boolean isBasedOnLine() {
        return this.fBasedOnLine;
    }

    public void disableSequenceRadio() {
        String string = Messages.getString((String)"Editor.GotoLine.dialog.No_Seq_Numbers");
        this.fTopMessage.setText(string);
        this.getText().setEditable(false);
    }
}

