/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.dialogs;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.ICOBOLHelpContextId;
import org.eclipse.cobol.ui.templates.COBOLTemplate;
import org.eclipse.cobol.ui.templates.Category;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddTemplateDialog
extends Dialog {
    private Category category;
    private COBOLTemplate template;
    private Text fNameText;
    private Text fDescriptionText;
    private Text fKeywordText;
    private Text fPatternText;
    private String fName;
    private String fDescription;
    private String fKeyword;
    private String fPattern;
    private String fName_old = "";
    private Button categoryRadio;
    private Button templateRadio;
    private int type;
    private Label fErrorMessageLabel;
    private final int ERROR_LABEL_HSPAN = 2;
    private final int LAYOUT_COLUMNS = 2;
    private final int COLOR_RED = 255;
    private final int TEXT_WIDTH = 300;
    private final int HEIGHT_HINT = 70;
    private final int LABEL_WIDTH = 300;
    private final int LABEL_HEIGHT = 30;
    private final String CATEGORY_TYPE = "Category";
    private final String TEMPLATE_TYPE = "Template";
    private boolean blnStatus;
    private boolean categoryRadioIsSelected;
    private boolean templateIsRadioSelected;

    public AddTemplateDialog(Shell shell, Object object, int n) {
        super(shell);
        if (object instanceof Category) {
            this.category = (Category)object;
        } else if (object instanceof COBOLTemplate) {
            this.template = (COBOLTemplate)object;
            this.category = this.template.getParent();
        }
        this.type = n;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = null;
        try {
            if (this.type == 1) {
                this.getShell().setText(Messages.getString((String)"AddTemplateDialog.title.categoryadd"));
            } else if (this.type == 2) {
                this.getShell().setText(Messages.getString((String)"AddTemplateDialog.title.edit.category"));
            } else {
                this.getShell().setText(Messages.getString((String)"AddTemplateDialog.title.edit.template"));
            }
            composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 10;
            gridLayout.marginHeight = 10;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setFont(composite2.getFont());
            label.setText(Messages.getString((String)"AddTemplateDialog.label.parent"));
            Text text = this.createTextControl(composite2);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setFont(composite2.getFont());
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.marginWidth = 0;
            composite3.setLayout((Layout)gridLayout2);
            this.categoryRadio = this.addRadioButton(composite3, Messages.getString((String)"AddTemplateDialog.radio.label.category"), "Category", "Cat");
            this.categoryRadio.setSelection(true);
            this.categoryRadioIsSelected = true;
            this.templateIsRadioSelected = false;
            this.templateRadio = this.addRadioButton(composite3, Messages.getString((String)"AddTemplateDialog.radio.label.template"), "Template", "Tpl");
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            composite3.setLayoutData((Object)gridData);
            label = new Label(composite2, 0);
            label.setFont(composite2.getFont());
            label.setText(Messages.getString((String)"AddTemplateDialog.label.name"));
            this.fNameText = this.createTextControl(composite2);
            label = new Label(composite2, 0);
            label.setFont(composite2.getFont());
            label.setText(Messages.getString((String)"AddTemplateDialog.label.descrition"));
            GridData gridData2 = new GridData(2);
            this.fDescriptionText = this.createTextControl(composite2);
            label = new Label(composite2, 0);
            label.setFont(composite2.getFont());
            label.setText(Messages.getString((String)"COBOLTemplatePreferencePage.label.keyword"));
            this.fKeywordText = this.createTextControl(composite2);
            label = new Label(composite2, 0);
            label.setFont(composite2.getFont());
            label.setText(Messages.getString((String)"AddTemplateDialog.label.pattern"));
            gridData2 = new GridData(2);
            label.setLayoutData((Object)gridData2);
            this.fPatternText = new Text(composite2, 2818);
            this.fPatternText.setFont(composite2.getFont());
            GridData gridData3 = new GridData(1808);
            gridData3.widthHint = 300;
            gridData3.heightHint = 70;
            this.fPatternText.setLayoutData((Object)gridData3);
            this.fErrorMessageLabel = new Label(composite2, 16448);
            this.fErrorMessageLabel.setFont(composite2.getFont());
            GridData gridData4 = new GridData();
            gridData4.horizontalSpan = 2;
            gridData4.grabExcessVerticalSpace = true;
            gridData4.grabExcessHorizontalSpace = true;
            gridData4.widthHint = 300;
            gridData4.heightHint = 30;
            this.fErrorMessageLabel.setLayoutData((Object)gridData4);
            this.fErrorMessageLabel.setForeground(new Color((Device)this.fErrorMessageLabel.getDisplay(), 255, 0, 0));
            text.setEditable(false);
            this.fNameText.setFocus();
            this.fNameText.setEditable(true);
            this.fDescriptionText.setEditable(true);
            this.fKeywordText.setEnabled(false);
            this.fPatternText.setEnabled(false);
            text.setText(this.category.getName());
            if (this.type == 2) {
                this.categoryRadio.setEnabled(true);
                this.categoryRadio.setSelection(true);
                this.templateRadio.setEnabled(false);
                this.templateRadio.setSelection(false);
                this.fKeywordText.setEnabled(false);
                this.fPatternText.setEnabled(false);
                this.fNameText.setText(this.category.getName());
                this.fDescriptionText.setText(this.category.getDescription());
                text.setText(this.category.getParent().getName());
                this.fName_old = this.category.getName();
            } else if (this.type == 3) {
                this.categoryRadio.setSelection(false);
                this.categoryRadio.setEnabled(false);
                this.templateRadio.setSelection(true);
                this.templateRadio.setEnabled(true);
                this.fKeywordText.setEnabled(true);
                this.fPatternText.setEnabled(true);
                this.fNameText.setText(this.template.getName());
                this.fDescriptionText.setText(this.template.getDescription());
                this.fKeywordText.setText(this.template.getKeyword());
                this.fPatternText.setText(this.template.getPattern());
            }
            this.fNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    AddTemplateDialog.this.updateOK();
                }
            });
            this.fDescriptionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    AddTemplateDialog.this.updateOK();
                }
            });
            this.fKeywordText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    AddTemplateDialog.this.updateOK();
                }
            });
            this.fPatternText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    AddTemplateDialog.this.updateOK();
                }
            });
            this.fPatternText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    AddTemplateDialog.this.blnStatus = AddTemplateDialog.this.checkParametersInTemplate(AddTemplateDialog.this.fPatternText.getText());
                    if (AddTemplateDialog.this.blnStatus) {
                        AddTemplateDialog.this.fErrorMessageLabel.setText("");
                    } else if (keyEvent.character == '{' || keyEvent.character == '$') {
                        AddTemplateDialog.this.getButton(0).setEnabled(false);
                    }
                }
            });
            this.categoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AddTemplateDialog.this.categoryRadioIsSelected = true;
                    AddTemplateDialog.this.templateIsRadioSelected = false;
                    AddTemplateDialog.this.getShell().setText(Messages.getString((String)"AddTemplateDialog.title.categoryadd"));
                    AddTemplateDialog.this.fKeywordText.setEnabled(false);
                    AddTemplateDialog.this.fPatternText.setEnabled(false);
                    AddTemplateDialog.this.fNameText.setFocus();
                    AddTemplateDialog.this.updateOK();
                }
            });
            this.templateRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AddTemplateDialog.this.templateIsRadioSelected = true;
                    AddTemplateDialog.this.categoryRadioIsSelected = false;
                    AddTemplateDialog.this.getShell().setText(Messages.getString((String)"AddTemplateDialog.title.templateadd"));
                    AddTemplateDialog.this.fKeywordText.setEnabled(true);
                    AddTemplateDialog.this.fPatternText.setEnabled(true);
                    AddTemplateDialog.this.fNameText.setFocus();
                    AddTemplateDialog.this.updateOK();
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        if (this.type == 1) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(composite2, ICOBOLHelpContextId.COBOL_TEMPLATE_PREF_PAGE_ADD);
        } else if (this.type == 2) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, ICOBOLHelpContextId.COBOL_TEMPLATE_PREF_EDIT_CATEGORY);
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, ICOBOLHelpContextId.COBOL_TEMPLATE_PREF_EDIT_TEMPLATE);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.updateOK();
    }

    private void updateOK() {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            if (this.categoryRadioIsSelected) {
                button.setEnabled(this.fNameText.getText().trim().length() != 0);
            } else {
                button.setEnabled(this.fNameText.getText().trim().length() != 0 && this.fKeywordText.getText().trim().length() != 0 && this.fPatternText.getText().trim().length() != 0);
            }
        }
    }

    private Button addRadioButton(Composite composite, String string, String string2, String string3) {
        GridData gridData = new GridData(256);
        Button button = new Button(composite, 16);
        button.setFont(composite.getFont());
        button.setText(string);
        button.setData((Object)new String[]{string2, string3});
        button.setLayoutData((Object)gridData);
        if (string.equals("Category")) {
            button.setSelection(true);
        } else {
            button.setSelection(false);
        }
        return button;
    }

    private Text createTextControl(Composite composite) {
        GridData gridData = new GridData();
        gridData.widthHint = 300;
        gridData.grabExcessHorizontalSpace = true;
        Text text = new Text(composite, 2048);
        text.setFont(composite.getFont());
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void okPressed() {
        this.fName = this.fNameText.getText().trim();
        this.fDescription = this.fDescriptionText.getText().trim();
        if (this.fName.equals("")) {
            this.fErrorMessageLabel.setText(Messages.getString((String)"AddTemplateDialog.error.message.empty"));
            this.fNameText.setFocus();
            Display.getDefault().beep();
            return;
        }
        if (this.categoryRadio.getSelection()) {
            if (this.type == 1) {
                if (this.checkCategoryDetails(this.fName, this.category)) {
                    this.fErrorMessageLabel.setText(Messages.getString((String)"AddTemplateDialog.error.message.rule1"));
                    this.fNameText.setFocus();
                    Display.getDefault().beep();
                    return;
                }
                Category category = new Category(this.fName, this.fDescription, this.category);
                this.category.addCategoryChild(category);
                this.category = category;
            } else if (this.type == 2) {
                if (!this.fName_old.equalsIgnoreCase(this.fName) && this.checkCategoryDetails(this.fName, this.category.getParent())) {
                    this.fErrorMessageLabel.setText(Messages.getString((String)"AddTemplateDialog.error.message.rule1"));
                    this.fNameText.setFocus();
                    Display.getDefault().beep();
                    return;
                }
                this.category.setName(this.fName);
                this.category.setDescription(this.fDescription);
            }
        } else if (this.templateRadio.getSelection()) {
            this.fKeyword = this.fKeywordText.getText().trim();
            this.fPattern = this.fPatternText.getText();
            COBOLTemplate cOBOLTemplate = null;
            if (this.type == 1) {
                cOBOLTemplate = new COBOLTemplate(this.fName, this.fDescription, this.fKeyword, this.fPattern, this.category);
                this.category.addTemplateChild(cOBOLTemplate);
                this.template = cOBOLTemplate;
            } else if (this.type == 3) {
                COBOLTemplate cOBOLTemplate2 = this.template;
                cOBOLTemplate = new COBOLTemplate(this.fName, this.fDescription, this.fKeyword, this.fPattern, this.category);
                this.category.removeTemplate(cOBOLTemplate2);
                this.category.addTemplateChild(cOBOLTemplate);
                this.template = cOBOLTemplate;
            }
        }
        super.okPressed();
    }

    public Category getCategory() {
        return this.category;
    }

    public COBOLTemplate getTemplate() {
        return this.template;
    }

    private boolean checkCategoryDetails(String string, Category category) {
        Category[] categoryArray = category.getCategoryChildren();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase(categoryArray[n2].getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkParametersInTemplate(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = string;
        while (string2.indexOf("$") != -1) {
            n = string2.indexOf("$");
            String string3 = string2.substring(n + 1);
            n2 = string3.indexOf("}");
            if (n2 == -1) {
                this.getButton(0).setEnabled(false);
                this.fErrorMessageLabel.setText(Messages.getString((String)"AddTemplateDialog.error.message.pattern"));
                return false;
            }
            String string4 = string3.substring(0, n2);
            if (string4 == null || string4.trim().equals("")) {
                this.fErrorMessageLabel.setText(Messages.getString((String)"AddTemplateDialog.error.message.pattern"));
                this.getButton(0).setEnabled(false);
                return false;
            }
            if (string4.indexOf("{") != 0) {
                this.fErrorMessageLabel.setText(Messages.getString((String)"AddTemplateDialog.error.message.pattern"));
                this.getButton(0).setEnabled(false);
                return false;
            }
            String string5 = string4.substring(1);
            if (string5 != null && !string5.trim().equals("") && string5.indexOf("{") == -1 && string5.indexOf("$") == -1 && string5.indexOf("\n") == -1) {
                this.fErrorMessageLabel.setText("");
                string2 = string3.substring(n2 + 1);
                continue;
            }
            this.fErrorMessageLabel.setText(Messages.getString((String)"AddTemplateDialog.error.message.pattern"));
            this.getButton(0).setEnabled(false);
            return false;
        }
        return true;
    }
}

