/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class PositionBasedCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2 {
    protected String fDisplayString;
    protected String fReplacementString;
    protected Position fReplacementPosition;
    protected int fCursorPosition;
    protected Image fImage;
    protected IContextInformation fContextInformation;
    protected String fAdditionalProposalInfo;

    public PositionBasedCompletionProposal(String string, Position position, int n) {
        this(string, position, n, null, null, null, null);
    }

    public PositionBasedCompletionProposal(String string, Position position, int n, Image image, String string2, IContextInformation iContextInformation, String string3) {
        Assert.isNotNull((Object)string);
        Assert.isTrue((position != null ? 1 : 0) != 0);
        this.fReplacementString = string;
        this.fReplacementPosition = position;
        this.fCursorPosition = n;
        this.fImage = image;
        this.fDisplayString = string2;
        this.fContextInformation = iContextInformation;
        this.fAdditionalProposalInfo = string3;
    }

    public void apply(IDocument iDocument) {
        try {
            iDocument.replace(this.fReplacementPosition.getOffset(), this.fReplacementPosition.getLength(), this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fReplacementPosition.getOffset() + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        this.apply(iTextViewer.getDocument());
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        try {
            String string = iDocument.get(this.fReplacementPosition.getOffset(), n - this.fReplacementPosition.getOffset());
            if (this.fReplacementString.startsWith(string)) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }
}

