/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.contentassist;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.contentassist.InclusivePositionUpdater;
import org.eclipse.cobol.ui.contentassist.PositionBasedCompletionProposal;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class COBOLTemplateProposal
extends TemplateProposal {
    private Template fTemplate;
    private TemplateContext fContext;
    private InclusivePositionUpdater fUpdater;
    private IRegion fSelectedRegion;

    public COBOLTemplateProposal(Template template, TemplateContext templateContext, IRegion iRegion, Image image, int n) {
        super(template, templateContext, iRegion, image, n);
        this.fTemplate = template;
        this.fContext = templateContext;
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        Region[] regionArray = null;
        IDocument iDocument = iTextViewer.getDocument();
        try {
            int n3;
            int n4;
            Object object;
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            int n5 = this.getReplaceOffset();
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                return;
            }
            int n6 = this.getReplaceOffset();
            int n7 = n6 - n5;
            int n8 = Math.max(this.getReplaceEndOffset(), n2 + n7);
            String string = templateBuffer.getString();
            String string2 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Tag-1-6");
            int n9 = string2.length();
            Object object2 = null;
            int n10 = 0;
            if (n9 > 0) {
                object = CBDTUiPlugin.getActivePage();
                if (object != null) {
                    object2 = object.getActiveEditor();
                }
                if (object2 != null && object2 instanceof COBOLEditor) {
                    n10 = ((COBOLEditor)((Object)object2)).getToggleUpdateTagSetting();
                }
            }
            if (string.indexOf("\n") >= 0 && (n4 = n6 - (n3 = (object = iDocument.getLineInformationOfOffset(n6)).getOffset())) > 0 && n4 < 70) {
                Region region;
                String[] stringArray = string.split("\n");
                regionArray = new Region[stringArray.length];
                String string3 = "                                                                   ";
                string = String.valueOf(stringArray[0]) + "\n";
                regionArray[0] = region = new Region(0, 0);
                int n11 = stringArray[0].length() + 1;
                int n12 = 0;
                String string4 = null;
                if (n9 > 0 && n10 != 0) {
                    string4 = string3.replaceFirst(string3.substring(0, n9), string2);
                }
                int n13 = 1;
                while (n13 < stringArray.length) {
                    if (stringArray[n13].startsWith("*")) {
                        string = n9 > 0 && n10 != 0 ? String.valueOf(string) + string4.substring(0, 6) + stringArray[n13] + "\n" : String.valueOf(string) + string3.substring(0, 6) + stringArray[n13] + "\n";
                        regionArray[n13] = new Region(n11, n12 += 6);
                        n11 += stringArray[n13].length() + 1;
                    } else {
                        string = n9 > 0 && n10 != 0 ? String.valueOf(string) + string4.substring(0, n4) + stringArray[n13] + "\n" : String.valueOf(string) + string3.substring(0, n4) + stringArray[n13] + "\n";
                        regionArray[n13] = new Region(n11, n12 += n4);
                        n11 += stringArray[n13].length() + 1;
                    }
                    ++n13;
                }
            }
            iDocument.replace(n6, n8 - n6, string);
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
            n8 = 0;
            int n14 = 0;
            while (n14 != templateVariableArray.length) {
                string2 = templateVariableArray[n14];
                if (!string2.isUnambiguous()) {
                    LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
                    object2 = string2.getOffsets();
                    n10 = string2.getLength();
                    String[] stringArray = string2.getValues();
                    ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[stringArray.length];
                    Object object3 = object2[0];
                    int n15 = this.findShift(regionArray, (int)object3);
                    int n16 = 0;
                    while (n16 < stringArray.length) {
                        this.ensurePositionCategoryInstalled(iDocument, linkedModeModel);
                        Position position = new Position((int)(object2[0] + n6 + n15), n10);
                        iDocument.addPosition(this.getCategory(), position);
                        iCompletionProposalArray[n16] = new PositionBasedCompletionProposal(stringArray[n16], position, n10);
                        ++n16;
                    }
                    object = iCompletionProposalArray.length > 1 ? new ProposalPosition(iDocument, (int)(object2[0] + n6 + n15), n10, iCompletionProposalArray) : new LinkedPosition(iDocument, (int)(object2[0] + n6 + n15), n10);
                    n3 = 0;
                    while (n3 != ((IEditorPart)object2).length) {
                        if (n3 == 0) {
                            linkedPositionGroup.addPosition((LinkedPosition)object);
                        } else {
                            IEditorPart iEditorPart = object2[n3];
                            object3 = this.findShift(regionArray, (int)iEditorPart);
                            linkedPositionGroup.addPosition(new LinkedPosition(iDocument, (int)(object2[n3] + n6 + object3), n10));
                        }
                        ++n3;
                    }
                    linkedModeModel.addGroup(linkedPositionGroup);
                    n8 = 1;
                }
                ++n14;
            }
            if (n8 != 0) {
                linkedModeModel.forceInstall();
                LinkedModeUI linkedModeUI = new LinkedModeUI(linkedModeModel, iTextViewer);
                linkedModeUI.setExitPosition(iTextViewer, this.getCaretOffset(templateBuffer) + n6, 0, Integer.MAX_VALUE);
                linkedModeUI.enter();
                this.fSelectedRegion = linkedModeUI.getSelectedRegion();
            } else {
                this.ensurePositionCategoryRemoved(iDocument);
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + n6, 0);
            }
        }
        catch (BadLocationException badLocationException) {
            this.openErrorDialog(iTextViewer.getTextWidget().getShell(), (Exception)((Object)badLocationException));
            this.ensurePositionCategoryRemoved(iDocument);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            this.openErrorDialog(iTextViewer.getTextWidget().getShell(), (Exception)((Object)badPositionCategoryException));
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + ((Object)((Object)this)).toString();
    }

    private int getCaretOffset(TemplateBuffer templateBuffer) {
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        int n = 0;
        while (n != templateVariableArray.length) {
            TemplateVariable templateVariable = templateVariableArray[n];
            if (templateVariable.getType().equals("cursor")) {
                return templateVariable.getOffsets()[0];
            }
            ++n;
        }
        return templateBuffer.getString().length();
    }

    private void ensurePositionCategoryRemoved(IDocument iDocument) {
        if (iDocument.containsPositionCategory(this.getCategory())) {
            try {
                iDocument.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            iDocument.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
    }

    private void openErrorDialog(Shell shell, Exception exception) {
        MessageDialog.openError((Shell)shell, (String)"Cannot open COBOL Template.", (String)exception.getMessage());
    }

    private void ensurePositionCategoryInstalled(final IDocument iDocument, LinkedModeModel linkedModeModel) {
        if (!iDocument.containsPositionCategory(this.getCategory())) {
            iDocument.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            iDocument.addPositionUpdater((IPositionUpdater)this.fUpdater);
            linkedModeModel.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel linkedModeModel, int n) {
                    COBOLTemplateProposal.this.ensurePositionCategoryRemoved(iDocument);
                }

                public void suspend(LinkedModeModel linkedModeModel) {
                }

                public void resume(LinkedModeModel linkedModeModel, int n) {
                }
            });
        }
    }

    private int findShift(Region[] regionArray, int n) {
        if (regionArray != null) {
            int n2 = 0;
            while (n2 < regionArray.length - 1) {
                if (n >= regionArray[n2].getOffset() && n < regionArray[n2 + 1].getOffset()) {
                    return regionArray[n2].getLength();
                }
                ++n2;
            }
            return regionArray[regionArray.length - 1].getLength();
        }
        return 0;
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }
}

