/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.contentassist;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class COBOLCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private String fProposalInfo = null;
    private StyledText styledText;
    private int start = -1;
    private int end = -1;

    public COBOLCompletionProposal() {
    }

    public COBOLCompletionProposal(String string, int n, int n2, Image image, String string2, String string3) {
        this.fReplacementString = string != null ? string : "";
        this.fReplacementOffset = n >= 0 ? n : 0;
        this.fReplacementLength = n2;
        this.fImage = image;
        this.fDisplayString = string2 != null ? string2 : string;
        this.fCursorPosition = string.length();
        this.fProposalInfo = string3;
        this.styledText = ((COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor()).getCurrentSourceViewer().getTextWidget();
    }

    private void replace(int n, int n2, String string) throws BadLocationException {
        String string2 = this.indentText((COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor(), n, string);
        this.styledText.replaceTextRange(n, n2, string2);
        if (this.start != -1 && this.end != -1) {
            this.styledText.setSelectionRange(n + this.start, this.end - this.start);
        } else {
            this.fCursorPosition = string2.length();
        }
    }

    public void apply(IDocument iDocument, char c, int n) {
        try {
            int n2 = n - (this.fReplacementOffset + this.fReplacementLength);
            if (n2 > 0) {
                this.fReplacementLength += n2;
            }
            if (c == '\u0000') {
                this.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
    }

    public void apply(IDocument iDocument) {
        this.apply(iDocument, '\u0000', this.fReplacementOffset + this.fReplacementLength);
    }

    public Point getSelection(IDocument iDocument) {
        if (this.start != -1 && this.end != -1) {
            return new Point(this.fReplacementOffset + this.start, this.end - this.start);
        }
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        return this.fProposalInfo;
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return -1;
    }

    public boolean isValidFor(IDocument iDocument, int n) {
        if (n < this.fReplacementOffset) {
            return false;
        }
        int n2 = 0;
        int n3 = n2 = this.fReplacementString == null ? 0 : this.fReplacementString.length();
        if (n >= this.fReplacementOffset + n2) {
            return false;
        }
        try {
            int n4 = n - this.fReplacementOffset;
            String string = iDocument.get(this.fReplacementOffset, n4);
            if (this.fDisplayString.length() >= n4) {
                return this.fDisplayString.substring(0, n4).equalsIgnoreCase(string);
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
            return false;
        }
    }

    private String indentText(COBOLEditor cOBOLEditor, int n, String string) {
        String string2 = string;
        try {
            IDocument iDocument = cOBOLEditor.getCurrentSourceViewer().getDocument();
            StyledText styledText = cOBOLEditor.getCurrentSourceViewer().getTextWidget();
            String string3 = styledText.getLineDelimiter();
            int n2 = iDocument.getLineOffset(iDocument.getLineOfOffset(n));
            if (n2 != n) {
                string2 = cOBOLEditor.findEndOfWhiteSpaceString(iDocument, styledText, n2, n, new StringBuffer(string2));
            }
            string2 = cOBOLEditor.addDelimiter(string3, string2);
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
        string2 = this.removeUnusedChars(string2);
        return string2;
    }

    private String removeUnusedChars(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                int n;
                if ((n = string.indexOf("{")) == -1 && (n = string.indexOf("$")) != -1 && this.start == -1) {
                    this.start = n;
                }
                if (n == -1 && (n = string.indexOf("}")) != -1 && this.end == -1) {
                    this.end = n;
                }
                if (n == -1) break;
                string = stringBuffer.deleteCharAt(n).toString();
                string = stringBuffer.toString();
            }
        }
        return string;
    }
}

