/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.common.COBOLLanguageModel;
import org.eclipse.cobol.ui.contentassist.COBOLCompletionProposal;
import org.eclipse.cobol.ui.contentassist.COBOLDataNameProposal;
import org.eclipse.cobol.ui.contentassist.COBOLTemplateContextType;
import org.eclipse.cobol.ui.contentassist.COBOLTemplateProposal;
import org.eclipse.cobol.ui.contentassist.DataNameCompletionContext;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.editor.COBOLStatusLineMessages;
import org.eclipse.cobol.ui.intfc.IDataDictonary;
import org.eclipse.cobol.ui.templates.COBOLTemplate;
import org.eclipse.cobol.ui.views.outlineview.COBOLParser;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class COBOLCompletionProcessor
extends TemplateCompletionProcessor {
    private COBOLLanguageModel fCOBOLLanguageModel = new COBOLLanguageModel();
    private Comparator fComparator;
    private final String KWD_INVOKE_SPACE = "INVOKE ";
    private final String KWD_CALL_SPACE = "CALL ";
    private final String KWD_INVOKE_TAB = "INVOKE\t";
    private final String KWD_CALL_TAB = "CALL\t";
    private static final String LINE_DELIMITER = "\n";
    private static final char[] separators = new char[]{'-', ' ', '\t', ',', ';', ':', '(', ')', '=', '>', '<', '&', '+', '*', '/', '\"', '\'', '.'};
    private static final char[] specificSeparators = new char[]{' ', ',', ';', ':', '(', ')', '=', '>', '<', '&', '+', '*', '/', '.', '\t'};
    private static final String NO_DATA_CONTENT_ASSIST = "COBOLContentAssist.NoData_Available";
    private COBOLStatusLineMessages fStatusLineMessage = null;
    private COBOLParser fCobolParser = new COBOLParser();
    private COBOLEditor fEditor;
    private ITextViewer textViewer;
    private static IDataDictonary dataDicParser = null;
    private static Template[] templates;
    private static final String[] DIVISIONS;
    private static Map<String, Template[]> proposalCacheMap;
    private Template[] proposalTemplate = null;
    private static final Comparator fgProposalComparator;

    static {
        DIVISIONS = new String[]{"IDENTIFICATION DIVISION", "ENVIRONMENT DIVISION", "DATA DIVISION", "PROCEDURE DIVISION"};
        proposalCacheMap = new HashMap<String, Template[]>();
        fgProposalComparator = new ProposalComparator();
    }

    public COBOLCompletionProcessor() {
        this.createTemplateProposalCache();
        this.proposalTemplate = null;
        if (proposalCacheMap != null && proposalCacheMap.size() > 0) {
            int n = 0;
            while (n < DIVISIONS.length) {
                this.proposalTemplate = proposalCacheMap.get(DIVISIONS[n]);
                ++n;
            }
        }
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        int n2;
        ITextSelection iTextSelection = (ITextSelection)iTextViewer.getSelectionProvider().getSelection();
        if (iTextSelection.getOffset() == n) {
            n = iTextSelection.getOffset() + iTextSelection.getLength();
        }
        String string = this.extractPrefix(iTextViewer, n);
        StyledText styledText = iTextViewer.getTextWidget();
        String string2 = styledText.getLine(n2 = styledText.getLineAtOffset(n));
        if (string2.length() > 6 && string2.charAt(6) == '*') {
            return new ICompletionProposal[0];
        }
        Region region = new Region(n - string.length(), string.length());
        TemplateContext templateContext = this.createContext(iTextViewer, (IRegion)region);
        if (templateContext == null) {
            return new ICompletionProposal[0];
        }
        templateContext.setVariable("selection", iTextSelection.getText());
        ArrayList<ICompletionProposal> arrayList = new ArrayList<ICompletionProposal>();
        this.fEditor = (COBOLEditor)CBDTUiPlugin.getActivePage().getActiveEditor();
        String string3 = this.fEditor.getCurrentSourceViewer().getDocument().get().trim();
        String string4 = this.getDivisionFromRequestedLine(styledText, n2);
        ArrayList arrayList2 = null;
        ArrayList<ICompletionProposal> arrayList3 = null;
        if (dataDicParser != null) {
            arrayList3 = dataDicParser.getXMLDataTypes(iTextViewer, n, string, templateContext);
        }
        if (string4 != null && string4.toUpperCase().contains("PROCEDURE DIVISION")) {
            arrayList2 = this.getDataNameList(iTextViewer, n, string, templateContext);
        }
        if (string.length() > 0) {
            templates = this.getTemplates(templateContext.getContextType().getId());
        } else if (string3.length() > 0) {
            if (string4.length() == 0) {
                string4 = "IDENTIFICATION DIVISION";
            }
            if (string.length() == 0 && proposalCacheMap != null && proposalCacheMap.size() > 0) {
                templates = proposalCacheMap.get(string4);
            }
        } else {
            templates = proposalCacheMap.get("IDENTIFICATION DIVISION");
        }
        if (templates != null) {
            int n3 = 0;
            while (n3 < templates.length) {
                block18: {
                    Template template = templates[n3];
                    try {
                        templateContext.getContextType().validate(template.getPattern());
                    }
                    catch (TemplateException templateException) {
                        break block18;
                    }
                    if (template.matches(string, templateContext.getContextType().getId())) {
                        arrayList.add(this.createProposal(template, templateContext, (IRegion)region, this.getRelevance(template, string)));
                    }
                }
                ++n3;
            }
        }
        Collections.sort(arrayList, fgProposalComparator);
        if (arrayList2 != null && arrayList2.size() > 0) {
            arrayList.addAll(arrayList2);
        }
        if (arrayList3 != null && arrayList3.size() > 0) {
            arrayList.addAll(arrayList3);
        }
        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[arrayList.size()];
        iCompletionProposalArray = arrayList.toArray(iCompletionProposalArray);
        return iCompletionProposalArray;
    }

    private void setErrorMessage(String string) {
        if (this.fStatusLineMessage == null) {
            this.fStatusLineMessage = COBOLStatusLineMessages.getInstance(null);
        }
        if (this.fStatusLineMessage != null) {
            if (string != null) {
                this.fStatusLineMessage.setErrorMessage(string);
            } else {
                this.fStatusLineMessage.clearMessage();
            }
        }
    }

    private int getIndex(String string) {
        int n = 0;
        while (n < separators.length) {
            char c = string.charAt(string.length() - 1);
            if (c == separators[n]) {
                return string.lastIndexOf(separators[n]);
            }
            ++n;
        }
        return -1;
    }

    private boolean getCharacterCheck(String string) {
        int n = 0;
        while (n < separators.length) {
            if (string.indexOf(separators[n]) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String getCharType(String string, String string2) {
        int n = separators.length - 1;
        while (n >= 0) {
            if (string.lastIndexOf(separators[n]) != -1) {
                if (separators[n] == '\'' || separators[n] == '\"') {
                    return this.checkRuleForQuotes(string, string2, separators[n]);
                }
                if (separators[n] == '-') {
                    return this.checkRuleForHypen(string, string2);
                }
                string = this.getCharType(string.substring(string.lastIndexOf(separators[n]) + 1), string2);
            }
            --n;
        }
        return this.fCobolParser.trim(string);
    }

    private int getNoOfCharacters(String string, char c) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == c) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private String checkRuleForQuotes(String string, String string2, char c) {
        string = this.fCobolParser.trim(string);
        string2 = this.fCobolParser.trim(string2);
        String string3 = string;
        string = string.trim();
        string2 = string2.trim();
        int n = string.indexOf(c);
        int n2 = string.lastIndexOf(c);
        int n3 = this.getNoOfCharacters(string, c);
        int n4 = this.getNoOfCharacters(string2, c);
        if (n == n2) {
            return null;
        }
        if (n3 != n4) {
            return null;
        }
        String string4 = string3.substring(n2 + 1);
        string4 = this.fCobolParser.trim(string4);
        boolean bl = false;
        int n5 = 0;
        while (n5 < specificSeparators.length) {
            if (string4.endsWith(String.valueOf(specificSeparators[n5]))) {
                bl = true;
                break;
            }
            ++n5;
        }
        if (bl) {
            return "";
        }
        if (string4.startsWith("-")) {
            return this.checkRuleForHypen(string4, string2);
        }
        return string4;
    }

    private String checkRuleForHypen(String string, String string2) {
        string = this.removeInitialSpaces(string);
        int n = string.lastIndexOf(32);
        int n2 = string.lastIndexOf("\t");
        int n3 = string.lastIndexOf("-");
        if (string.startsWith("-")) {
            return string.substring(string.indexOf("-") + 1);
        }
        if (n != -1 && n > n3) {
            return this.checkEndsWith(string, " ", n);
        }
        if (n2 != -1 && n2 > n3) {
            return this.checkEndsWith(string, "\t", n2);
        }
        if (n != -1 && n < n3) {
            return this.resultString(string, string2, n3, " ");
        }
        if (n2 != -1 && n2 < n3) {
            return this.resultString(string, string2, n3, "\t");
        }
        if (string.startsWith("\"")) {
            return this.checkRuleForQuotes(string, string2, '\"');
        }
        if (string.startsWith("'")) {
            return this.checkRuleForQuotes(string, string2, '\'');
        }
        if (n == -1) {
            return string;
        }
        if (n2 == -1) {
            return string;
        }
        return "";
    }

    private String removeInitialSpaces(String string) {
        if (string != null && string.length() > 1) {
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                if (!this.fCobolParser.isSpace(string.charAt(n = n2++))) break;
            }
            if (n >= 0 && n < string.length()) {
                return string.substring(n, string.length());
            }
        }
        return string;
    }

    private String resultString(String string, String string2, int n, String string3) {
        if (string.lastIndexOf(string3) != string.length()) {
            String string4 = this.fCobolParser.trim(string.substring(string.lastIndexOf(" ") + 1));
            String string5 = String.valueOf(string4.charAt(0));
            if (string5.equals("\"")) {
                return this.checkRuleForQuotes(string, string2, '\"');
            }
            if (string5.equals("'")) {
                return this.checkRuleForQuotes(string, string2, '\'');
            }
            return this.fCobolParser.trim(string.substring(string.lastIndexOf(string3) + 1));
        }
        return this.fCobolParser.trim(string.substring(n + 1));
    }

    private String checkEndsWith(String string, String string2, int n) {
        if (string.endsWith(string2)) {
            return "";
        }
        return string.substring(n + 1, string.length());
    }

    private ArrayList getSortedList(ArrayList arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = 0;
        int n2 = arrayList.size();
        this.fComparator = new CompletionProposalComparator();
        Object[] objectArray = null;
        int n3 = 0;
        while (n3 < n2) {
            ArrayList arrayList3 = (ArrayList)arrayList.get(n3);
            n = arrayList3.size();
            if (n == 1) {
                arrayList2.add(arrayList3.get(0));
            } else if (n > 1) {
                objectArray = new Object[n];
                arrayList3.toArray(objectArray);
                int n4 = 0;
                while (n4 < objectArray.length) {
                    arrayList2.add(objectArray[n4]);
                    ++n4;
                }
            }
            ++n3;
        }
        n = arrayList2.size();
        objectArray = new Object[n];
        arrayList2.toArray(objectArray);
        Arrays.sort(objectArray, this.fComparator);
        arrayList2 = new ArrayList();
        n3 = 0;
        while (n3 < objectArray.length) {
            arrayList2.add(objectArray[n3]);
            ++n3;
        }
        return arrayList2;
    }

    private ArrayList getProposalListOfClasses(String string, boolean bl, String string2, int n, String[] stringArray) {
        ArrayList<COBOLCompletionProposal> arrayList = new ArrayList<COBOLCompletionProposal>();
        boolean bl2 = true;
        if (stringArray == null) {
            stringArray = this.fCOBOLLanguageModel.getClassIDs(string);
        }
        Image image = COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre16.gif");
        COBOLCompletionProposal cOBOLCompletionProposal = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            bl2 = true;
            if (!bl && !stringArray[n2].toUpperCase().startsWith(string2.toUpperCase())) {
                bl2 = false;
            }
            if (bl2) {
                cOBOLCompletionProposal = this.createCOBOLCompletionProposal(stringArray[n2], n, 0, image, stringArray[n2], null);
                arrayList.add(cOBOLCompletionProposal);
            }
            ++n2;
        }
        return arrayList;
    }

    private ArrayList getClassAndMethodProposalList(String string, boolean bl, String string2, int n) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<COBOLCompletionProposal> arrayList3 = new ArrayList<COBOLCompletionProposal>();
        ArrayList arrayList4 = null;
        boolean bl2 = true;
        int n2 = 0;
        Image image = null;
        Image image2 = null;
        Image image3 = null;
        String string32 = "";
        image = COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre18.gif");
        image2 = COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre17.gif");
        HashMap hashMap = this.fCOBOLLanguageModel.getClassAndMethodIDs(string);
        for (String string32 : hashMap.keySet()) {
            Cloneable cloneable;
            if (string32.equalsIgnoreCase("OM") || string32.equalsIgnoreCase("FM")) {
                cloneable = (HashMap)hashMap.get(string32);
                if (string32.equalsIgnoreCase("OM")) {
                    image3 = image;
                } else if (string32.equalsIgnoreCase("FM")) {
                    image3 = image2;
                }
                for (String string4 : ((HashMap)cloneable).keySet()) {
                    arrayList4 = (ArrayList)((HashMap)cloneable).get(string4);
                    n2 = arrayList4.size();
                    String string5 = "";
                    COBOLCompletionProposal cOBOLCompletionProposal = null;
                    int n3 = 0;
                    while (n3 < n2) {
                        bl2 = true;
                        string5 = (String)arrayList4.get(n3);
                        if (!bl && !string5.toUpperCase().startsWith(string2.toUpperCase())) {
                            bl2 = false;
                        }
                        if (bl2) {
                            cOBOLCompletionProposal = this.createCOBOLCompletionProposal(string5, n, 0, image3, String.valueOf(string5) + " : " + string4, null);
                            arrayList3.add(cOBOLCompletionProposal);
                        }
                        ++n3;
                    }
                }
                continue;
            }
            cloneable = (ArrayList)hashMap.get(string32);
            String[] stringArray = new String[((ArrayList)cloneable).size()];
            int n4 = ((ArrayList)cloneable).size();
            int n5 = 0;
            while (n5 < n4) {
                stringArray[n5] = (String)((ArrayList)cloneable).get(n5);
                ++n5;
            }
            arrayList2 = this.getProposalListOfClasses(string, bl, string2, n, stringArray);
        }
        arrayList.add(arrayList3);
        arrayList.add(arrayList2);
        return arrayList;
    }

    private ArrayList getProposalListOfPrograms(String string, boolean bl, String string2, int n) {
        ArrayList<COBOLCompletionProposal> arrayList = new ArrayList<COBOLCompletionProposal>();
        boolean bl2 = true;
        String[] stringArray = this.fCOBOLLanguageModel.getProgramIDs(string);
        Image image = COBOLPluginImages.get("org.eclipse.cobol.ui.ap5tre15.gif");
        COBOLCompletionProposal cOBOLCompletionProposal = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            bl2 = true;
            if (!bl && !stringArray[n2].toUpperCase().startsWith(string2.toUpperCase())) {
                bl2 = false;
            }
            if (bl2) {
                cOBOLCompletionProposal = this.createCOBOLCompletionProposal(stringArray[n2], n, 0, image, stringArray[n2], null);
                arrayList.add(cOBOLCompletionProposal);
            }
            ++n2;
        }
        return arrayList;
    }

    public ArrayList getProposalListOfTemplates(boolean bl, String string, int n) {
        ArrayList<COBOLCompletionProposal> arrayList = new ArrayList<COBOLCompletionProposal>();
        boolean bl2 = true;
        ArrayList arrayList2 = this.fCOBOLLanguageModel.getAllTemplates();
        if (arrayList2 == null || arrayList2.size() < 1) {
            return arrayList;
        }
        Image image = COBOLPluginImages.get("org.eclipse.cobol.ui.apwtre06.gif");
        COBOLCompletionProposal cOBOLCompletionProposal = null;
        int n2 = arrayList2.size();
        String string2 = null;
        String[] stringArray = null;
        int n3 = 0;
        while (n3 < n2) {
            bl2 = true;
            COBOLTemplate cOBOLTemplate = (COBOLTemplate)arrayList2.get(n3);
            stringArray = new String[]{cOBOLTemplate.getName(), cOBOLTemplate.getKeyword(), cOBOLTemplate.getDescription(), cOBOLTemplate.getPattern()};
            if (stringArray != null && stringArray[1] != null && !stringArray[1].equals("")) {
                if (!bl && !stringArray[1].toUpperCase().startsWith(string.toUpperCase())) {
                    bl2 = false;
                }
                if (bl2) {
                    if (stringArray[3] != null) {
                        string2 = this.addDelimiter(stringArray[3]);
                    }
                    String string3 = stringArray[1];
                    if (stringArray[2] != null && !stringArray[2].equals("")) {
                        string3 = String.valueOf(stringArray[1]) + " - " + stringArray[2];
                    }
                    cOBOLCompletionProposal = this.createCOBOLCompletionProposal(string2, n, 0, image, string3, string2);
                    arrayList.add(cOBOLCompletionProposal);
                }
            }
            ++n3;
        }
        return arrayList;
    }

    public String addDelimiter(String string) {
        int n = 0;
        StyledText styledText = this.fEditor.getCurrentSourceViewer().getTextWidget();
        String string2 = styledText.getLineDelimiter();
        StringBuffer stringBuffer = new StringBuffer(string);
        n = stringBuffer.toString().indexOf(string2, n);
        if (n != -1) {
            return stringBuffer.toString();
        }
        n = 0;
        while ((n = stringBuffer.toString().indexOf(LINE_DELIMITER, n)) != -1) {
            stringBuffer.deleteCharAt(n);
            stringBuffer.insert(n, string2);
            n += 2;
        }
        return stringBuffer.toString();
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private COBOLCompletionProposal createCOBOLCompletionProposal(String string, int n, int n2, Image image, String string2, String string3) {
        if (this.textViewer == null) {
            return new COBOLCompletionProposal(string, n, n2, image, string2, string3);
        }
        Point point = this.textViewer.getSelectedRange();
        n2 = point.x + point.y - n;
        return new COBOLCompletionProposal(string, n, n2, image, string2, string3);
    }

    public ArrayList getProposalListOfReservedWords(boolean bl, String string, int n) {
        Object object;
        ArrayList<COBOLCompletionProposal> arrayList = new ArrayList<COBOLCompletionProposal>();
        boolean bl2 = true;
        String[] stringArray = null;
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor != null) {
            object = iCOBOLContributor.getCOBOLLanguageModel();
            stringArray = object.getReservedWords();
        } else {
            object = new COBOLLanguageModel();
            stringArray = ((COBOLLanguageModel)object).getReservedWords();
        }
        object = COBOLPluginImages.get("org.eclipse.cobol.ui.word_obj.gif");
        COBOLCompletionProposal cOBOLCompletionProposal = null;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                bl2 = true;
                if (!bl && !stringArray[n2].toUpperCase().startsWith(string.toUpperCase())) {
                    bl2 = false;
                }
                if (bl2) {
                    cOBOLCompletionProposal = new COBOLCompletionProposal(stringArray[n2], n, 0, (Image)object, stringArray[n2], null);
                    arrayList.add(cOBOLCompletionProposal);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext templateContext, IRegion iRegion, int n) {
        return new COBOLTemplateProposal(template, templateContext, iRegion, this.getImage(template), n);
    }

    public Image getImage(Template template) {
        return null;
    }

    public TemplateContextType getContextType(ITextViewer iTextViewer, IRegion iRegion) {
        return COBOLTemplateContextType.getDefault();
    }

    public Template[] getTemplates() {
        return this.getTemplates("org.eclipse.cobol.ui.contentassist.COBOLTemplateContextType");
    }

    public ArrayList getDataNameList(ITextViewer iTextViewer, int n, String string, TemplateContext templateContext) {
        int n2 = 0;
        StyledText styledText = iTextViewer.getTextWidget();
        iTextViewer.getDocument();
        String string2 = string.toUpperCase();
        DataNameCompletionContext dataNameCompletionContext = new DataNameCompletionContext(templateContext);
        ArrayList<COBOLDataNameProposal> arrayList = new ArrayList<COBOLDataNameProposal>();
        Position position = new Position(n - string2.length(), string2.length());
        int n3 = styledText.getLineCount();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            String string3 = styledText.getLine(n4).toUpperCase();
            if (string3.indexOf("DATA DIVISION") >= 0) {
                n2 = ++n4;
                break;
            }
            ++n4;
        }
        n4 = n2;
        while (n4 < n3) {
            String string4 = styledText.getLine(n4);
            if (string4.trim().length() >= 10) {
                if ((string4 = string4.substring(7).trim()).toUpperCase().indexOf("PROCEDURE DIVISION") >= 0) {
                    bl = true;
                    break;
                }
                if (Character.isDigit(string4.charAt(0))) {
                    String string5;
                    int n5 = -1;
                    int n6 = 0;
                    while (n6 < string4.length()) {
                        if (string4.charAt(n6) == ' ') {
                            n5 = n6;
                            break;
                        }
                        ++n6;
                    }
                    if (n5 != -1 && (string5 = string4.substring(n5).trim()).toUpperCase().startsWith(string2)) {
                        int n7 = -1;
                        int n8 = 0;
                        while (n8 < string5.length()) {
                            if (string5.charAt(n8) == ' ') {
                                n7 = n8;
                                break;
                            }
                            ++n8;
                        }
                        if (n7 != -1) {
                            String string6 = string5.substring(0, n7);
                            COBOLDataNameProposal cOBOLDataNameProposal = new COBOLDataNameProposal(string6, position, string4, dataNameCompletionContext);
                            arrayList.add(cOBOLDataNameProposal);
                        }
                    }
                }
            }
            ++n4;
        }
        if (bl) {
            return arrayList;
        }
        return new ArrayList();
    }

    private boolean isFileEmpty(StyledText styledText) {
        int n = styledText.getLineCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if ((n2 += styledText.getLine(n3).trim().length()) > 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public Template[] getTemplates(String string) {
        try {
            ArrayList arrayList = this.fCOBOLLanguageModel.getAllTemplates();
            Template[] templateArray = new Template[arrayList.size()];
            templateArray = arrayList.toArray(templateArray);
            return templateArray;
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            string2 = String.valueOf(string2);
            return new Template[0];
        }
    }

    public Template[] getSpecificTemplates(String string) {
        try {
            List<Template> list = this.fCOBOLLanguageModel.getTemplateByName(string);
            Template[] templateArray = new Template[list.size()];
            templateArray = list.toArray(templateArray);
            return templateArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Template[0];
        }
    }

    private void createTemplateProposalCache() {
        Template[] templateArray = null;
        if (proposalCacheMap.size() == 0) {
            int n = 0;
            while (n < DIVISIONS.length) {
                templateArray = this.getSpecificTemplates(DIVISIONS[n]);
                if (templateArray != null && templateArray.length > 0) {
                    proposalCacheMap.put(DIVISIONS[n], templateArray);
                }
                ++n;
            }
        }
    }

    private String getDivisionFromRequestedLine(StyledText styledText, int n) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = n;
        while (n2 >= 0) {
            string = String.valueOf(styledText.getLine(n2)) + LINE_DELIMITER;
            if (string != null && string.length() > 0 && this.isValidDivisionStmt(string, stringBuffer)) {
                if (string.toUpperCase().contains("PROCEDURE") && stringBuffer.toString().trim().length() == 0) {
                    String string2 = null;
                    if (string.toUpperCase().indexOf("DIVISION") == -1) {
                        int n3 = n2 + 1;
                        while (n3 < n) {
                            string2 = styledText.getLine(n3);
                            if (string2 != null && string2.trim().length() > 0) {
                                if (string2.trim().toUpperCase().startsWith("DIVISION")) {
                                    stringBuffer.append("PROCEDURE DIVISION");
                                    break;
                                }
                                if (string2.indexOf("*") == 6) {
                                    System.out.println("Line is comment");
                                } else if (this.trimRight(string2).length() < 8) {
                                    System.out.println("Line is will be ignored by compiler");
                                } else {
                                    if (string2.length() <= 7 || !string2.substring(7).trim().toUpperCase().startsWith("DIVISION")) break;
                                    stringBuffer.append("PROCEDURE DIVISION");
                                    break;
                                }
                            }
                            ++n3;
                        }
                    }
                }
                return stringBuffer.toString();
            }
            --n2;
        }
        return "IDENTIFICATION DIVISION";
    }

    public String trimRight(String string) {
        if (string != null) {
            int n = string.length() - 1;
            while (n > 0 && string.charAt(n) <= ' ') {
                --n;
            }
            return string.substring(0, n + 1);
        }
        return " ";
    }

    private boolean isValidDivisionStmt(String string, StringBuffer stringBuffer) {
        String string2 = null;
        if (string.toUpperCase().contains("IDENTIFICATION")) {
            string2 = "IDENTIFICATION";
        } else if (string.toUpperCase().contains("ENVIRONMENT")) {
            string2 = "ENVIRONMENT";
        } else if (string.toUpperCase().contains("DATA")) {
            string2 = "DATA";
        } else {
            if (string.toUpperCase().contains("PROCEDURE")) {
                if (string.substring(6, 7).equals("*")) {
                    return false;
                }
                string2 = "PROCEDURE";
                if (string.substring(6, 7).equals("*")) {
                    return false;
                }
                if (string.indexOf("PROCEDURE") < 7 || string.indexOf("PROCEDURE") > 11) {
                    return false;
                }
                int n = string.toUpperCase().indexOf("PROCEDURE") + 9;
                String[] stringArray = null;
                stringArray = string.substring(n).split(" ");
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].trim().toUpperCase().equals("DIVISION.") || stringArray[n2].trim().toUpperCase().equals("DIVISION")) {
                        stringBuffer.append("PROCEDURE DIVISION");
                        break;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string != null && string.toUpperCase().contains("DIVISION")) {
            string3 = string.substring(0, string.toUpperCase().indexOf(string2)).trim();
            string4 = string.substring(string.toUpperCase().indexOf(string2), string.toUpperCase().indexOf("DIVISION")).trim();
            string5 = string.contains(".") ? string.substring(string.toUpperCase().indexOf("DIVISION"), string.toUpperCase().lastIndexOf(".")).trim() : string.substring(string.toUpperCase().indexOf("DIVISION"), string.indexOf(LINE_DELIMITER)).trim();
            if (string3.length() == 0 && string4.equalsIgnoreCase(string2) && (string5.equalsIgnoreCase("DIVISION") || string5.toUpperCase().contains("DIVISION") && string5.toUpperCase().contains("USING"))) {
                stringBuffer.append(String.valueOf(string2) + " DIVISION");
                return true;
            }
        }
        return false;
    }

    public static IDataDictonary getDataDicParser() {
        return dataDicParser;
    }

    public static void setDataDicParser(IDataDictonary iDataDictonary) {
        dataDicParser = iDataDictonary;
    }

    private static class CompletionProposalComparator
    implements Comparator {
        private CompletionProposalComparator() {
        }

        public int compare(Object object, Object object2) {
            ICompletionProposal iCompletionProposal = (ICompletionProposal)object;
            ICompletionProposal iCompletionProposal2 = (ICompletionProposal)object2;
            return iCompletionProposal.getDisplayString().compareToIgnoreCase(iCompletionProposal2.getDisplayString());
        }
    }

    private static final class ProposalComparator
    implements Comparator {
        private ProposalComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((TemplateProposal)object2).getRelevance() - ((TemplateProposal)object).getRelevance();
        }
    }
}

