/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.compare.COBOLFileState;
import org.eclipse.cobol.ui.compare.COBOLHistoryItem;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.FileState;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class COBOLEditionAction
implements IActionDelegate {
    private static final String LINE_SEPARATOR = "line.separator";
    private COBOLEditor fEditor;
    private ISelection fSelection;
    private String fBundleName;
    private boolean fReplaceMode;
    protected boolean fPrevious = false;

    public COBOLEditionAction(boolean bl, String string) {
        this.fReplaceMode = bl;
        this.fBundleName = string;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fSelection = iSelection;
    }

    public void run(IAction iAction) {
        Object object;
        IResource[] iResourceArray = Utilities.getResources((ISelection)this.fSelection);
        int n = 0;
        while (n < iResourceArray.length) {
            IAdaptable iAdaptable;
            Object object2;
            object = iResourceArray[n];
            if (object instanceof IFile) {
                this.doFromHistory((IFile)object);
            } else if (object instanceof IAdaptable && (object2 = (iAdaptable = (IAdaptable)object).getAdapter(IResource.class)) instanceof IFile) {
                this.doFromHistory((IFile)object2);
            }
            ++n;
        }
        try {
            IPath iPath = CBDTUiPlugin.getWorkspace().getRoot().getLocation().append("Temp.txt");
            object = iPath.toFile();
            if (object != null && ((java.io.File)object).exists()) {
                ((java.io.File)object).delete();
            }
        }
        catch (Exception exception) {}
    }

    private void doFromHistory(IFile iFile) {
        block12: {
            COBOLFileState cOBOLFileState;
            File file;
            FileState fileState;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.fBundleName);
            String string = Utilities.getString((ResourceBundle)resourceBundle, (String)"title");
            Shell shell = CompareUIPlugin.getShell();
            IFileState[] iFileStateArray = null;
            try {
                iFileStateArray = iFile.getHistory(null);
            }
            catch (CoreException coreException) {
                MessageDialog.openError((Shell)shell, (String)string, (String)coreException.getMessage());
                return;
            }
            if (iFileStateArray == null || iFileStateArray.length <= 0) {
                String string2 = Utilities.getString((ResourceBundle)resourceBundle, (String)"noLocalHistoryError");
                MessageDialog.openInformation((Shell)shell, (String)string, (String)string2);
                return;
            }
            ResourceNode resourceNode = new ResourceNode((IResource)iFile);
            IDocument iDocument = this.getEditorDocument(iFile);
            Object object = resourceNode;
            if (iDocument != null) {
                object = new DocumentBufferNode(iDocument, iFile);
            }
            ITypedElement[] iTypedElementArray = new ITypedElement[iFileStateArray.length];
            int n = 0;
            while (n < iFileStateArray.length) {
                fileState = (FileState)iFileStateArray[n];
                file = (File)iFile;
                cOBOLFileState = new COBOLFileState(file.getLocalManager().getHistoryStore(), fileState.getFullPath(), fileState.getModificationTime(), fileState.getUUID());
                iTypedElementArray[n] = new COBOLHistoryItem((ITypedElement)resourceNode, cOBOLFileState);
                ++n;
            }
            EditionSelectionDialog editionSelectionDialog = new EditionSelectionDialog(shell, resourceBundle);
            editionSelectionDialog.setEditionTitleArgument(iFile.getName());
            editionSelectionDialog.setEditionTitleImage(CompareUIPlugin.getImage((IAdaptable)iFile));
            if (this.fReplaceMode) {
                fileState = this.getDocument(iFile);
                file = null;
                file = this.fPrevious ? editionSelectionDialog.selectPreviousEdition((ITypedElement)object, iTypedElementArray, null) : editionSelectionDialog.selectEdition((ITypedElement)object, iTypedElementArray, null);
                if (file instanceof IStreamContentAccessor) {
                    cOBOLFileState = (IStreamContentAccessor)file;
                    try {
                        if (fileState != null) {
                            this.updateDocument((IDocument)fileState, (IStreamContentAccessor)cOBOLFileState);
                            break block12;
                        }
                        this.updateWorkspace(resourceBundle, shell, (IStreamContentAccessor)cOBOLFileState, iFile);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string3 = invocationTargetException.getTargetException().getMessage();
                        MessageDialog.openError((Shell)shell, (String)string, (String)Utilities.getFormattedString((ResourceBundle)resourceBundle, (String)"replaceError", (String)string3));
                    }
                }
            } else {
                editionSelectionDialog.setCompareMode(true);
                editionSelectionDialog.selectEdition((ITypedElement)object, iTypedElementArray, null);
            }
        }
    }

    private void updateWorkspace(final ResourceBundle resourceBundle, Shell shell, final IStreamContentAccessor iStreamContentAccessor, final IFile iFile) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        String string = Utilities.getString((ResourceBundle)resourceBundle, (String)"taskName");
                        iProgressMonitor.beginTask(string, -1);
                        if (iStreamContentAccessor instanceof COBOLHistoryItem) {
                            iFile.setContents(((COBOLHistoryItem)iStreamContentAccessor).getOriginalContents(), false, true, iProgressMonitor);
                        } else {
                            iFile.setContents(iStreamContentAccessor.getContents(), false, true, iProgressMonitor);
                        }
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        progressMonitorDialog.run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
    }

    private void updateDocument(IDocument iDocument, IStreamContentAccessor iStreamContentAccessor) throws InvocationTargetException {
        try {
            CBDTUiPlugin.getDefault().getPreferenceStore().getString("Reference Format");
            InputStream inputStream = null;
            if (iStreamContentAccessor instanceof COBOLHistoryItem) {
                inputStream = ((COBOLHistoryItem)iStreamContentAccessor).getOriginalContents();
            }
            String string = Utilities.readString(inputStream, (String)ResourcesPlugin.getEncoding());
            iDocument.replace(0, iDocument.getLength(), string);
            this.fEditor.doSave((IProgressMonitor)new NullProgressMonitor());
            inputStream.close();
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
        catch (BadLocationException badLocationException) {
            throw new InvocationTargetException(badLocationException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private IDocument getEditorDocument(IFile iFile) {
        CBDTUiPlugin.getDefault().getPreferenceStore().getString("Reference Format");
        IDocument iDocument = null;
        iDocument = this.getDocument(iFile);
        return iDocument;
    }

    private IDocument getDocument(IFile iFile) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        if (iWorkbenchWindowArray == null) {
            return null;
        }
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
            if (iWorkbenchPageArray != null) {
                int n2 = 0;
                while (n2 < iWorkbenchPageArray.length) {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n2];
                    IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                    if (iEditorReferenceArray != null) {
                        IEditorPart iEditorPart = null;
                        int n3 = 0;
                        while (n3 < iEditorReferenceArray.length) {
                            ITextEditor iTextEditor;
                            IDocumentProvider iDocumentProvider;
                            IEditorInput iEditorInput;
                            iEditorPart = iEditorReferenceArray[n3].getEditor(false);
                            if (iEditorPart instanceof COBOLEditor && fileEditorInput.equals((Object)(iEditorInput = iEditorPart.getEditorInput())) && iEditorPart instanceof ITextEditor && (iDocumentProvider = (iTextEditor = (ITextEditor)iEditorPart).getDocumentProvider()) != null) {
                                this.fEditor = (COBOLEditor)iEditorPart;
                                IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
                                if (iDocument != null) {
                                    return iDocument;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    private void split(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2, String string2) {
        if (string == null) {
            return;
        }
        String string3 = string2;
        int n = string3.length();
        int n2 = 0;
        String string4 = "";
        try {
            int n3 = 0;
            while (n3 < string.length()) {
                stringBuffer.append(string.substring(n3, n3 + 6));
                stringBuffer.append('\n');
                n2 = string.indexOf(string3, n3 + 6);
                if (n2 != -1) {
                    string4 = string.substring(n3 + 6, n2 + n);
                    stringBuffer2.append(string4);
                    n3 = n3 + 6 + string4.length();
                    continue;
                }
                if (n3 + 6 < string.length()) {
                    string4 = string.substring(n3 + 6, string.length());
                    stringBuffer2.append(string4);
                    n3 = n3 + 6 + string4.length();
                    continue;
                }
                n3 += 6;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            CBDTUiPlugin.logError(stringIndexOutOfBoundsException);
        }
    }

    class DocumentBufferNode
    implements ITypedElement,
    IStreamContentAccessor {
        private IDocument fDocument;
        private IFile fFile;

        DocumentBufferNode(IDocument iDocument, IFile iFile) {
            this.fDocument = iDocument;
            this.fFile = iFile;
        }

        public String getName() {
            return this.fFile.getName();
        }

        public String getType() {
            return this.fFile.getFileExtension();
        }

        public Image getImage() {
            return null;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.fDocument.get().getBytes());
        }
    }
}

