/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common.text;

import com.unisys.os2200.util.MemChecker;
import org.eclipse.cobol.ui.common.text.ICOBOLWordDetector;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class COBOLWordRule
extends WordRule {
    protected ICOBOLWordDetector fDetector;
    private StringBuffer fBuffer = new StringBuffer();
    private String fFormatType = new String("");

    public COBOLWordRule(ICOBOLWordDetector iCOBOLWordDetector) {
        super((IWordDetector)iCOBOLWordDetector);
        this.fDetector = iCOBOLWordDetector;
    }

    public COBOLWordRule(ICOBOLWordDetector iCOBOLWordDetector, IToken iToken) {
        super((IWordDetector)iCOBOLWordDetector, iToken);
        this.fDetector = iCOBOLWordDetector;
    }

    public COBOLWordRule(ICOBOLWordDetector iCOBOLWordDetector, IToken iToken, String string) {
        super((IWordDetector)iCOBOLWordDetector, iToken);
        this.fDetector = iCOBOLWordDetector;
        this.fFormatType = string;
    }

    public void addWord(String string, IToken iToken) {
        super.addWord(string.toUpperCase(), iToken);
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        return this.evaluateForFree(iCharacterScanner);
    }

    public IToken evaluateForFixed(ICharacterScanner iCharacterScanner) {
        int n;
        char c = (char)iCharacterScanner.read();
        if (this.fDetector.isWordStart(c, n = iCharacterScanner.getColumn())) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append(c);
            } while ((c = (char)iCharacterScanner.read()) != '\uffffffff' && this.fDetector.isWordPart(c, n++));
            iCharacterScanner.unread();
            IToken iToken = (IToken)this.fWords.get(this.fBuffer.toString().toUpperCase());
            if (iToken != null) {
                return iToken;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(iCharacterScanner);
            }
            return this.fDefaultToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    public IToken evaluateForFree(ICharacterScanner iCharacterScanner) {
        if (!MemChecker.getInstance().hasEnoughMemory(false, false)) {
            return Token.UNDEFINED;
        }
        char c = (char)iCharacterScanner.read();
        int n = iCharacterScanner.getColumn();
        if (this.fDetector.isWordStart(c) && n > 6) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append(c);
            } while ((c = (char)iCharacterScanner.read()) != '\uffffffff' && this.fDetector.isWordPart(c));
            iCharacterScanner.unread();
            IToken iToken = (IToken)this.fWords.get(this.fBuffer.toString().toUpperCase());
            if (iToken != null) {
                return iToken;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(iCharacterScanner);
            }
            return this.fDefaultToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }
}

