/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common.text;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Scanner;
import org.eclipse.cobol.core.debug.model.ICOBOLEvent;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.events.COBOLTextHoverEvent;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.text.COBOLWordFinder;
import org.eclipse.cobol.ui.contentassist.COBOLCompletionProcessor;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.SourceViewerInformationControl;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public class COBOLTextHover
extends AbstractJavaEditorTextHover {
    private boolean fNotified = true;
    private IEditorInput editorInput = null;
    private IEditorPart editorPart;
    private IWorkbenchSite site;
    private IInformationControlCreator fPresenterControlCreator;
    private IInformationControlCreator fHoverControlCreator;
    private static String mouseHoverStr = null;
    public static boolean isCopyProc = false;

    public COBOLTextHover() {
    }

    public COBOLTextHover(ISourceViewer iSourceViewer) {
    }

    public COBOLTextHover(ISourceViewer iSourceViewer, IEditorInput iEditorInput) {
        this.editorInput = iEditorInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        Object object2;
        Object object3;
        Object object4;
        COBOLEditor.setStatusBarMessage("");
        int n = -1;
        if (iTextViewer == null) return "";
        if (iRegion == null) {
            return "";
        }
        try {
            n = iTextViewer.getDocument().getLineOfOffset(iRegion.getOffset());
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
        isCopyProc = false;
        String string = "";
        if (iTextViewer.getDocument() != null) {
            try {
                string = iTextViewer.getDocument().get(iRegion.getOffset(), iRegion.getLength());
                iTextViewer.getDocument().computeNumberOfLines(string);
                object4 = this.getCursorPreviousString(iRegion, iTextViewer);
                try {
                    if (string.equalsIgnoreCase("FILLER")) {
                        return "COBOL KEYWORD";
                    }
                    if (string != null && string.trim().length() > 0 && (object3 = COBOLCompletionProcessor.getDataDicParser()) != null && (object2 = object3.getVariableInformation(iTextViewer, string)) != null && ((String)object2).trim().length() != 0) {
                        return object2;
                    }
                    if (object4 != null && ((String)object4).trim().equalsIgnoreCase("copy")) {
                        if (this.editorInput instanceof OS2200FileEditorInput) {
                            COBOLEditor.setStatusBarMessage("Copy procedure can't be opened if the element is not associated with a project");
                            return "";
                        }
                        isCopyProc = true;
                        mouseHoverStr = string;
                        object3 = (IFileEditorInput)this.editorInput;
                        object2 = object3.getFile();
                        OS2200ProjectUpdate.getProperties((IProject)object2.getProject()).getProperty("hostID");
                        HashMap object = OS2200FileInterface.getCopyProcMap((IFile)object2);
                        if (object == null) {
                            COBOLEditor.setStatusBarMessage("No copy procedure map found.Please configure the copy procedures for this connection.");
                            return "";
                        }
                        if (object.isEmpty()) {
                            COBOLEditor.setStatusBarMessage("No copy procedure map found.");
                            return "";
                        }
                        StringBuffer iLaunch = new StringBuffer();
                        ArrayList arrayList = (ArrayList)object.get(string.toUpperCase());
                        if (arrayList == null) {
                            COBOLEditor.setStatusBarMessage("No copy procedure found.");
                            return "";
                        }
                        Iterator iterator = arrayList.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                return iLaunch.toString();
                            }
                            String string2 = (String)iterator.next();
                            String string3 = OS2200FileInterface.getOS2200PathForCopyProc((String)string2);
                            String string4 = JavaElementLinks.createLink((String)string2, (String)string3);
                            iLaunch.append(string4);
                            iLaunch.append("<br>");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError((Exception)((Object)badLocationException));
            }
        }
        object4 = COBOLDebugPlugin.getDefault();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                COBOLTextHover.this.editorPart = CBDTUiPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
        });
        object3 = "";
        if (this.editorPart != null && this.editorPart instanceof COBOLEditor) {
            if (!(this.editorPart.getEditorInput() instanceof IFileEditorInput)) {
                return "";
            }
            object3 = ((IFileEditorInput)this.editorPart.getEditorInput()).getFile().getProjectRelativePath().toOSString();
        }
        if (string == null) return "";
        if (string.trim().length() <= 0) return "";
        object2 = new COBOLTextHoverEvent((Object)this, true, (String)object3, string, n + 1, null);
        if (object4 == null) return "";
        if (!object4.isDebugging()) return "";
        try {
            COBOLTextHover interruptedException = this;
            synchronized (interruptedException) {
                ILaunch iLaunch = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getActiveLaunch();
                if (!this.fireDebugTextHoverEvent((COBOLTextHoverEvent)object2)) return "";
                this.fNotified = false;
                this.startTimeout((Object)this, 3000);
                ((Object)((Object)this)).wait();
                this.fNotified = true;
                return COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getDebugModel(iLaunch).getTextHover();
            }
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError(interruptedException);
            return "";
        }
    }

    public static int nthIndexOf(String string, String string2, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if ((n2 = string.indexOf(string2, n2 + 1)) == -1) break;
            ++n3;
        }
        return n2;
    }

    String getCursorPreviousString(IRegion iRegion, ITextViewer iTextViewer) {
        String string = "";
        int n = iRegion.getOffset();
        int n2 = 0;
        int n3 = 0;
        IDocument iDocument = iTextViewer.getDocument();
        if (iDocument != null) {
            try {
                char c = iDocument.getChar(n);
                if (c == ' ') {
                    c = iDocument.getChar(--n);
                }
                while (c != ' ') {
                    c = iDocument.getChar(--n);
                }
                c = iDocument.getChar(n);
                while (c == ' ' || c == '\n' || c == '\t') {
                    c = iDocument.getChar(--n);
                }
                n3 = n;
                c = iDocument.getChar(n);
                while (c != ' ') {
                    c = iDocument.getChar(--n);
                }
                n2 = n;
                string = iTextViewer.getDocument().get(n2, n3 - n2 + 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        return string.trim();
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        try {
            IRegion iRegion = iTextViewer.getDocument().getLineInformationOfOffset(n);
            Point point = iTextViewer.getSelectedRange();
            int n2 = -1;
            try {
                n2 = iTextViewer.getDocument().getLineOfOffset(n);
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError((Exception)((Object)badLocationException));
            }
            int n3 = iTextViewer.getDocument().getLineLength(n2);
            if (n3 == point.y + 2) {
                return COBOLWordFinder.findWord(iTextViewer.getDocument(), n);
            }
            if (n >= point.x && n < point.x + point.y && point.x >= iRegion.getOffset() && point.y < iRegion.getOffset() + iRegion.getLength() && point.y != iRegion.getLength() + 1) {
                return new Region(point.x, point.y);
            }
            return COBOLWordFinder.findWord(iTextViewer.getDocument(), n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized boolean fireDebugTextHoverEvent(COBOLTextHoverEvent cOBOLTextHoverEvent) {
        if (cOBOLTextHoverEvent != null) {
            COBOLDebugPlugin cOBOLDebugPlugin = COBOLDebugPlugin.getDefault();
            ILaunch iLaunch = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getActiveLaunch();
            if (cOBOLDebugPlugin != null && cOBOLDebugPlugin.isDebugging() && COBOLDebugPlugin.getEventDispatcher((ILaunch)iLaunch) != null) {
                return COBOLDebugPlugin.getEventDispatcher((ILaunch)iLaunch).fireTextHoverEvent((ICOBOLEvent)cOBOLTextHoverEvent);
            }
        }
        return false;
    }

    public synchronized void startTimeout(final Object object, final int n) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    2.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    CBDTUiPlugin.logError(interruptedException);
                }
                if (!COBOLTextHover.this.fNotified && object != null) {
                    Object object2 = object;
                    synchronized (object2) {
                        object.notifyAll();
                    }
                }
            }
        };
        thread.start();
    }

    public Object getHoverInfo2(ITextViewer iTextViewer, IRegion iRegion) {
        return this.getHoverInfo(iTextViewer, iRegion);
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (isCopyProc) {
            if (this.fHoverControlCreator == null) {
                this.fHoverControlCreator = new HoverControlCreator1(this.getInformationPresenterControlCreator());
            }
            return this.fHoverControlCreator;
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                IEditorPart iEditorPart = COBOLTextHover.this.getEditor();
                int n = 0;
                if (iEditorPart instanceof IWorkbenchPartOrientation) {
                    n = ((IWorkbenchPartOrientation)iEditorPart).getOrientation();
                }
                return new SourceViewerInformationControl(shell, false, n, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (isCopyProc) {
            if (this.fPresenterControlCreator == null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        COBOLTextHover.this.site = (IWorkbenchSite)CBDTUiPlugin.getActivePage().getActiveEditor().getSite();
                    }
                });
                if (this.site != null) {
                    this.fPresenterControlCreator = new PresenterControlCreator1(this.site);
                }
            }
            return this.fPresenterControlCreator;
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                IEditorPart iEditorPart = COBOLTextHover.this.getEditor();
                int n = 0;
                if (iEditorPart instanceof IWorkbenchPartOrientation) {
                    n = ((IWorkbenchPartOrientation)iEditorPart).getOrientation();
                }
                return new SourceViewerInformationControl(shell, true, n, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        return EditorsUI.getTooltipAffordanceString();
    }

    public static void addLinkListener1(final BrowserInformationControl browserInformationControl) {
        browserInformationControl.addLocationListener(new LocationListener(){

            public void changing(LocationEvent locationEvent) {
                block11: {
                    String string = locationEvent.location;
                    if ("about:blank".equals(string)) {
                        return;
                    }
                    browserInformationControl.dispose();
                    File file = new File(string);
                    if (file.exists()) {
                        String string2 = file.getName();
                        String string3 = "";
                        int n = file.getName().lastIndexOf(46);
                        string2 = n > 0 ? ((string3 = file.getName().substring(n + 1)).equalsIgnoreCase("cob") || string3.equalsIgnoreCase("cobp") ? file.getName() : String.valueOf(file.getName().replace(".", "-")) + ".cob") : String.valueOf(file.getName()) + ".cob";
                        IFileStore iFileStore = null;
                        try {
                            iFileStore = EFS.getStore((URI)file.toURI());
                        }
                        catch (Exception exception) {
                            CBDTUiPlugin.logError(exception);
                        }
                        IEditorPart iEditorPart = null;
                        iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        IFileEditorInput iFileEditorInput = null;
                        if (iEditorPart == null || !(iEditorPart.getEditorInput() instanceof IFileEditorInput)) {
                            return;
                        }
                        iFileEditorInput = (IFileEditorInput)iEditorPart.getEditorInput();
                        IFile iFile = iFileEditorInput.getFile();
                        IProject iProject = iFile.getProject();
                        try {
                            String string4 = iFile.getPersistentProperty(new QualifiedName("com.unisys.tde.core", "TranslationWritten"));
                            Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                            String string5 = OS2200ProjectUpdate.getShareName((IProject)iProject);
                            OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState((IProject)iProject);
                            String string6 = properties.getProperty("hostID");
                            LoginAccount loginAccount = OS2200FileInterface.getLoginAccount((String)string6);
                            OS2200FileEditorInput oS2200FileEditorInput = new OS2200FileEditorInput(iFileStore, loginAccount, share, string5, string4, "org.eclipse.cobol.ui.editor.COBOLEditor", string2);
                            IEditorPart iEditorPart2 = OS2200FileInterface.openFileInEditor((File)file, (OS2200FileEditorInput)oS2200FileEditorInput);
                            if (iEditorPart2 == null) {
                                COBOLEditor.setStatusBarMessage(Messages.getString((String)"OS2200FileInterface.201"));
                                break block11;
                            }
                            if (!(iEditorPart2 instanceof COBOLEditor)) break block11;
                            String string7 = null;
                            COBOLEditor cOBOLEditor = (COBOLEditor)iEditorPart2;
                            Scanner scanner = new Scanner(cOBOLEditor.getCurrentSourceViewer().getTextWidget().getText());
                            int n2 = 0;
                            while (scanner.hasNextLine()) {
                                string7 = scanner.nextLine();
                                if (!string7.startsWith(" ") && string7.contains(mouseHoverStr)) {
                                    cOBOLEditor.getCurrentSourceViewer().getTextWidget().setTopIndex(n2);
                                    cOBOLEditor.getCurrentSourceViewer().getTextWidget().setSelection(cOBOLEditor.getCurrentSourceViewer().getTextWidget().getOffsetAtLine(n2));
                                    cOBOLEditor.getCurrentSourceViewer().getTextWidget().setCaretOffset(cOBOLEditor.getCurrentSourceViewer().getTextWidget().getOffsetAtLine(n2));
                                    break;
                                }
                                ++n2;
                            }
                        }
                        catch (CoreException coreException) {
                            CBDTUiPlugin.logError((Exception)((Object)coreException));
                        }
                    } else {
                        COBOLEditor.setStatusBarMessage("Copy procs file doesn't exist");
                    }
                }
            }

            public void changed(LocationEvent locationEvent) {
            }
        });
    }

    public static final class HoverControlCreator1
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;
        private final boolean fAdditionalInfoAffordance;

        public HoverControlCreator1(IInformationControlCreator iInformationControlCreator) {
            this(iInformationControlCreator, false);
        }

        public HoverControlCreator1(IInformationControlCreator iInformationControlCreator, boolean bl) {
            this.fInformationPresenterControlCreator = iInformationControlCreator;
            this.fAdditionalInfoAffordance = bl;
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            String string;
            String string2 = string = this.fAdditionalInfoAffordance ? JavaPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)shell) && isCopyProc) {
                String string3 = "org.eclipse.jface.textfont";
                BrowserInformationControl browserInformationControl = new BrowserInformationControl(shell, string3, string){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return fInformationPresenterControlCreator;
                    }
                };
                COBOLTextHover.addLinkListener1(browserInformationControl);
                browserInformationControl.setStatusText("Select the desired copy procedure");
                return browserInformationControl;
            }
            DefaultInformationControl defaultInformationControl = new DefaultInformationControl(shell, string);
            defaultInformationControl.setBackgroundColor(shell.getDisplay().getSystemColor(1));
            defaultInformationControl.setSizeConstraints(-1, -1);
            return defaultInformationControl;
        }

        public boolean canReuse(IInformationControl iInformationControl) {
            if (!super.canReuse(iInformationControl)) {
                return false;
            }
            if (iInformationControl instanceof IInformationControlExtension4) {
                String string;
                String string2 = string = this.fAdditionalInfoAffordance ? JavaPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
                if (isCopyProc) {
                    ((IInformationControlExtension4)iInformationControl).setStatusText("Select the desired copy procedure");
                } else {
                    ((IInformationControlExtension4)iInformationControl).setStatusText(string);
                }
            }
            return false;
        }
    }

    public static final class PresenterControlCreator1
    extends AbstractReusableInformationControlCreator {
        private IWorkbenchSite fSite;

        public PresenterControlCreator1(IWorkbenchSite iWorkbenchSite) {
            this.fSite = iWorkbenchSite;
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            if (BrowserInformationControl.isAvailable((Composite)shell) && isCopyProc) {
                String string = "org.eclipse.jface.textfont";
                ToolBarManager toolBarManager = new ToolBarManager(0x800000);
                BrowserInformationControl browserInformationControl = new BrowserInformationControl(shell, string, toolBarManager);
                COBOLTextHover.addLinkListener1(browserInformationControl);
                return browserInformationControl;
            }
            DefaultInformationControl defaultInformationControl = new DefaultInformationControl(shell, true);
            defaultInformationControl.setBackgroundColor(shell.getDisplay().getSystemColor(1));
            defaultInformationControl.setSizeConstraints(-1, -1);
            return defaultInformationControl;
        }
    }
}

