/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common.text;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.text.COBOLColorManager;
import org.eclipse.cobol.ui.fixedformat.COBOLFixedFormatCodeScanner;
import org.eclipse.cobol.ui.freeformat.COBOLFreeFormatCodeScanner;
import org.eclipse.cobol.ui.variableformat.COBOLVariableFormatCodeScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class COBOLTextFactory {
    private COBOLColorManager fColorManager;
    private COBOLFixedFormatCodeScanner fCOBOLFixedFormatCodeScanner;
    private COBOLFreeFormatCodeScanner fCOBOLFreeFormatCodeScanner;
    private COBOLVariableFormatCodeScanner fCOBOLVariableFormatCodeScanner;
    private IPreferenceStore fPreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();
    private String fRefFormat = "";

    public COBOLTextFactory(IPreferenceStore iPreferenceStore) {
        this.fPreferenceStore = iPreferenceStore;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fColorManager = new COBOLColorManager();
        this.fCOBOLFreeFormatCodeScanner = new COBOLFreeFormatCodeScanner(this.fColorManager, this.fPreferenceStore);
    }

    public void setFormat(String string) {
        this.fRefFormat = string;
    }

    public void dispose() {
        try {
            if (this.fCOBOLFixedFormatCodeScanner != null) {
                this.fCOBOLFixedFormatCodeScanner.handleDispose();
                this.fCOBOLFixedFormatCodeScanner = null;
            }
            if (this.fCOBOLFreeFormatCodeScanner != null) {
                this.fCOBOLFreeFormatCodeScanner.handleDispose();
                this.fCOBOLFreeFormatCodeScanner = null;
            }
            if (this.fCOBOLVariableFormatCodeScanner != null) {
                this.fCOBOLVariableFormatCodeScanner.handleDispose();
                this.fCOBOLVariableFormatCodeScanner = null;
            }
            if (this.fColorManager != null) {
                this.fColorManager.handleDispose();
                this.fColorManager = null;
            }
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
                this.fPreferenceStore = null;
                this.fPreferenceListener = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public COBOLColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getFreeFormatCodeScanner() {
        return this.fCOBOLFreeFormatCodeScanner;
    }

    public RuleBasedScanner getFixedFormatCodeScanner() {
        return this.fCOBOLFixedFormatCodeScanner;
    }

    public RuleBasedScanner getVariableFormatCodeScanner() {
        return this.fCOBOLVariableFormatCodeScanner;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fCOBOLFreeFormatCodeScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCOBOLFreeFormatCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    private class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            COBOLTextFactory.this.adaptToPreferenceChange(propertyChangeEvent);
        }
    }
}

