/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common.text;

import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.Token;

public class COBOLSingleLineRule
extends PatternRule {
    private String fFormatType = "";

    public COBOLSingleLineRule(String string, String string2, IToken iToken) {
        this(string, string2, iToken, '\u0000');
    }

    public COBOLSingleLineRule(String string, String string2, IToken iToken, char c) {
        super(string, string2, iToken, c, true);
    }

    public COBOLSingleLineRule(String string, String string2, IToken iToken, String string3) {
        this(string, string2, iToken, '\u0000', string3);
    }

    public COBOLSingleLineRule(String string, String string2, IToken iToken, char c, String string3) {
        super(string, string2, iToken, c, true);
        this.fFormatType = string3;
    }

    protected IToken doEvaluateForFixed(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if ((n == Character.toUpperCase(this.fStartSequence[0]) || n == Character.toLowerCase(this.fStartSequence[0])) && iCharacterScanner.getColumn() < 66 && this.sequenceDetectedForFixed(iCharacterScanner, this.fStartSequence, false) && this.endSequenceDetectedForFixed(iCharacterScanner)) {
            return this.fToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    protected IToken doEvaluateForVariable(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if ((n == Character.toUpperCase(this.fStartSequence[0]) || n == Character.toLowerCase(this.fStartSequence[0])) && iCharacterScanner.getColumn() < 245 && this.sequenceDetectedForVariable(iCharacterScanner, this.fStartSequence, false) && this.endSequenceDetectedForVariable(iCharacterScanner)) {
            return this.fToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    protected IToken doEvaluate(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if ((n == Character.toUpperCase(this.fStartSequence[0]) || n == Character.toLowerCase(this.fStartSequence[0])) && this.sequenceDetected(iCharacterScanner, this.fStartSequence, false) && this.endSequenceDetected(iCharacterScanner)) {
            return this.fToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        try {
            if (this.fColumn == -1) {
                return this.doEvaluate(iCharacterScanner);
            }
            int n = iCharacterScanner.read();
            iCharacterScanner.unread();
            if ((n == Character.toUpperCase(this.fStartSequence[0]) || n == Character.toLowerCase(this.fStartSequence[0])) && this.fColumn == iCharacterScanner.getColumn()) {
                return this.doEvaluate(iCharacterScanner);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return Token.UNDEFINED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean endSequenceDetectedForFixed(ICharacterScanner iCharacterScanner) {
        char c = '\uffffffff';
        char[][] cArray = iCharacterScanner.getLegalLineDelimiters();
        try {
            while ((c = iCharacterScanner.read()) != '\uffffffff') {
                if (c == this.fEscapeCharacter) {
                    iCharacterScanner.read();
                    continue;
                }
                if (this.fEndSequence.length > 0 && (c == Character.toUpperCase(this.fEndSequence[0]) || c == Character.toLowerCase(this.fEndSequence[0]))) {
                    if (!this.sequenceDetectedForFixed(iCharacterScanner, this.fEndSequence, true)) continue;
                    return true;
                }
                if (iCharacterScanner.getColumn() >= 66) {
                    return true;
                }
                if (!this.fBreaksOnEOL) continue;
                int n = 0;
                while (n < cArray.length) {
                    if (c == cArray[n][0] && this.sequenceDetectedForFixed(iCharacterScanner, cArray[n], false)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            CBDTUiPlugin.logError(arrayIndexOutOfBoundsException);
        }
        iCharacterScanner.unread();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean endSequenceDetectedForVariable(ICharacterScanner iCharacterScanner) {
        char c = '\uffffffff';
        char[][] cArray = iCharacterScanner.getLegalLineDelimiters();
        try {
            while ((c = iCharacterScanner.read()) != '\uffffffff') {
                if (c == this.fEscapeCharacter) {
                    iCharacterScanner.read();
                    continue;
                }
                if (this.fEndSequence.length > 0 && (c == Character.toUpperCase(this.fEndSequence[0]) || c == Character.toLowerCase(this.fEndSequence[0]))) {
                    if (!this.sequenceDetectedForVariable(iCharacterScanner, this.fEndSequence, true)) continue;
                    return true;
                }
                if (iCharacterScanner.getColumn() >= 245) {
                    return true;
                }
                if (!this.fBreaksOnEOL) continue;
                int n = 0;
                while (n < cArray.length) {
                    if (c == cArray[n][0] && this.sequenceDetectedForVariable(iCharacterScanner, cArray[n], false)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            CBDTUiPlugin.logError(arrayIndexOutOfBoundsException);
        }
        iCharacterScanner.unread();
        return true;
    }

    protected boolean sequenceDetectedForFixed(ICharacterScanner iCharacterScanner, char[] cArray, boolean bl) {
        int c = -1;
        int n = 1;
        while (n < cArray.length) {
            int n2 = iCharacterScanner.read();
            if (n2 == -1 && bl) {
                return true;
            }
            if (iCharacterScanner.getColumn() >= 66) {
                return false;
            }
            if (n2 != Character.toUpperCase(cArray[n]) && n2 != Character.toLowerCase(cArray[n])) {
                iCharacterScanner.unread();
                int n3 = n - 1;
                while (n3 > 0) {
                    iCharacterScanner.unread();
                    --n3;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean sequenceDetectedForVariable(ICharacterScanner iCharacterScanner, char[] cArray, boolean bl) {
        int c = -1;
        int n = 1;
        while (n < cArray.length) {
            int n2 = iCharacterScanner.read();
            if (n2 == -1 && bl) {
                return true;
            }
            if (iCharacterScanner.getColumn() >= 245) {
                return false;
            }
            if (n2 != Character.toUpperCase(cArray[n]) && n2 != Character.toLowerCase(cArray[n])) {
                iCharacterScanner.unread();
                int n3 = n - 1;
                while (n3 > 0) {
                    iCharacterScanner.unread();
                    --n3;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean endSequenceDetected(ICharacterScanner iCharacterScanner) {
        char c = '\uffffffff';
        char[][] cArray = iCharacterScanner.getLegalLineDelimiters();
        try {
            while ((c = iCharacterScanner.read()) != '\uffffffff') {
                if (c == this.fEscapeCharacter) {
                    iCharacterScanner.read();
                    continue;
                }
                if (this.fEndSequence.length > 0 && (c == Character.toUpperCase(this.fEndSequence[0]) || c == Character.toLowerCase(this.fEndSequence[0]))) {
                    if (!this.sequenceDetected(iCharacterScanner, this.fEndSequence, true)) continue;
                    return true;
                }
                if (!this.fBreaksOnEOL) continue;
                int n = 0;
                while (n < cArray.length) {
                    if (c == cArray[n][0] && this.sequenceDetected(iCharacterScanner, cArray[n], false)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            CBDTUiPlugin.logError(arrayIndexOutOfBoundsException);
        }
        iCharacterScanner.unread();
        return true;
    }

    protected boolean sequenceDetected(ICharacterScanner iCharacterScanner, char[] cArray, boolean bl) {
        int c = -1;
        int n = 1;
        while (n < cArray.length) {
            int n2 = iCharacterScanner.read();
            if (n2 == -1 && bl) {
                return true;
            }
            if (n2 != Character.toUpperCase(cArray[n]) && n2 != Character.toLowerCase(cArray[n])) {
                iCharacterScanner.unread();
                int n3 = n - 1;
                while (n3 > 0) {
                    iCharacterScanner.unread();
                    --n3;
                }
                return false;
            }
            ++n;
        }
        return true;
    }
}

