/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class COBOLColorManager {
    private Map fKeyTable = new HashMap();
    private Map fColorTable = new HashMap();

    private void dispose() {
        if (this.fColorTable != null && !this.fColorTable.isEmpty()) {
            Iterator iterator = this.fColorTable.values().iterator();
            while (iterator.hasNext()) {
                ((Color)iterator.next()).dispose();
            }
        }
    }

    public Color getColor(RGB rGB) {
        Color color;
        block4: {
            color = null;
            if (rGB != null) break block4;
            return null;
        }
        try {
            color = (Color)this.fColorTable.get(rGB);
            if (color == null) {
                color = new Color((Device)Display.getCurrent(), rGB);
                this.fColorTable.put(rGB, color);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return color;
    }

    public Color getColor(String string) {
        Color color;
        block3: {
            color = null;
            if (string != null) break block3;
            return null;
        }
        try {
            RGB rGB = (RGB)this.fKeyTable.get(string);
            color = this.getColor(rGB);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return color;
    }

    public void bindColor(String string, RGB rGB) {
        this.fKeyTable.remove(string);
        Object v = this.fKeyTable.get(string);
        if (v == null) {
            this.fKeyTable.put(string, rGB);
        }
    }

    public void handleDispose() {
        this.dispose();
        if (this.fKeyTable != null) {
            this.fKeyTable.clear();
        }
        if (this.fColorTable != null) {
            this.fColorTable.clear();
        }
    }
}

