/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.core.common.ICOBOLLanguageModel;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.COBOLLanguageModel;
import org.eclipse.cobol.ui.common.text.COBOLColorManager;
import org.eclipse.cobol.ui.views.outlineview.COBOLParser;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public abstract class COBOLAbstractCodeScanner
extends BufferedRuleBasedScanner {
    private COBOLColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map fTokenMap = new HashMap();
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesStyle;
    protected String[] fSpecialRegisters;
    protected String[] fFigurativeConstants;
    protected String[] fReservedWords;
    protected String[] fDataDictVars;
    protected String[] fSections;
    protected String[] fParagraphs;
    protected String[] fWSVars;
    protected String[] fUnreferencedVars;
    private final String COMMA = ",";
    private static final String STYLE = "_bold";

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    protected abstract WordRule createWordRules();

    public COBOLAbstractCodeScanner(COBOLColorManager cOBOLColorManager, IPreferenceStore iPreferenceStore) {
        this.fColorManager = cOBOLColorManager;
        this.fPreferenceStore = iPreferenceStore;
        this.initReservedWord();
    }

    private void initReservedWord() {
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor != null) {
            ICOBOLLanguageModel iCOBOLLanguageModel = iCOBOLContributor.getCOBOLLanguageModel();
            this.fReservedWords = iCOBOLLanguageModel.getReservedWords();
            this.fFigurativeConstants = iCOBOLLanguageModel.getFigurativeConstants();
            this.fSpecialRegisters = iCOBOLLanguageModel.getSpecialRegisters();
            this.fDataDictVars = this.getVars();
            this.fSections = this.getSect();
            this.fParagraphs = this.getPara();
            this.fWSVars = this.getWSVars();
            this.fUnreferencedVars = this.getUnreferencedWSVars();
        } else {
            COBOLLanguageModel cOBOLLanguageModel = new COBOLLanguageModel();
            this.fReservedWords = cOBOLLanguageModel.getReservedWords();
            this.fFigurativeConstants = cOBOLLanguageModel.getFigurativeConstants();
            this.fSpecialRegisters = cOBOLLanguageModel.getSpecialRegisters();
            this.fDataDictVars = this.getVars();
            this.fSections = this.getSect();
            this.fParagraphs = this.getPara();
            this.fWSVars = this.getWSVars();
            this.fUnreferencedVars = this.getUnreferencedWSVars();
        }
    }

    private String[] getVars() {
        String string = "\\Local Settings\\Application Data\\Unisys\\os2200\\dd\\AllVars.txt";
        String string2 = "";
        string2 = System.getProperty("user.home");
        String string3 = String.valueOf(string2) + string;
        File file = new File(string3);
        if (file.exists()) {
            String string4 = "";
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                FileChannel fileChannel = fileInputStream.getChannel();
                fileChannel.read(byteBuffer);
                string4 = new String(byteBuffer.array());
                String[] stringArray = string4.split(",");
                return stringArray;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private String[] getSect() {
        if (COBOLParser.sectionArr != null) {
            return COBOLParser.sectionArr.toString().split(",");
        }
        return null;
    }

    private String[] getPara() {
        if (COBOLParser.paraArr != null) {
            return COBOLParser.paraArr.toString().split(",");
        }
        return null;
    }

    private String[] getWSVars() {
        if (COBOLParser.varArr != null) {
            return COBOLParser.varArr.toString().split(",");
        }
        return null;
    }

    private String[] getUnreferencedWSVars() {
        if (COBOLParser.unreferencedVarArr != null) {
            return COBOLParser.unreferencedVarArr.toString().split(",");
        }
        return null;
    }

    public final void initialize() {
        try {
            this.fPropertyNamesColor = this.getTokenProperties();
            int n = this.fPropertyNamesColor.length;
            this.fPropertyNamesStyle = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.fPropertyNamesStyle[n2] = String.valueOf(this.fPropertyNamesColor[n2]) + STYLE;
                this.addToken(this.fPropertyNamesColor[n2], this.fPropertyNamesStyle[n2]);
                ++n2;
            }
            this.initializeRules();
        }
        catch (NoSuchElementException noSuchElementException) {
            CBDTUiPlugin.logError(noSuchElementException);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private void addToken(String string, String string2) {
        try {
            boolean bl = false;
            RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)string);
            this.fColorManager.bindColor(string, rGB);
            bl = this.fPreferenceStore.getBoolean(string2);
            this.fTokenMap.put(string, new Token((Object)new TextAttribute(this.fColorManager.getColor(string), null, bl ? 1 : 0)));
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    protected Token getToken(String string) {
        return (Token)this.fTokenMap.get(string);
    }

    private void initializeRules() {
        List list = this.createRules();
        if (list != null) {
            IRule[] iRuleArray = new IRule[list.size()];
            list.toArray(iRuleArray);
            this.setRules(iRuleArray);
        }
    }

    private int indexOf(String string) {
        try {
            if (string != null) {
                int n = this.fPropertyNamesColor.length;
                int n2 = 0;
                while (n2 < n) {
                    if (string.equals(this.fPropertyNamesColor[n2]) || string.equals(this.fPropertyNamesStyle[n2])) {
                        return n2;
                    }
                    ++n2;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return -1;
    }

    private boolean affectsRreservedWord(String string) {
        return string.equals("Reserved Word");
    }

    private boolean affectsUserDefinedStuff(String string) {
        return string.equals("cobol_data_dict_vars") || string.equals("cobol_sections") || string.equals("cobol_paragraphs") || string.equals("ws_vars");
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        if (this.affectsRreservedWord(propertyChangeEvent.getProperty())) {
            return true;
        }
        if (this.affectsUserDefinedStuff(propertyChangeEvent.getProperty())) {
            return true;
        }
        return this.indexOf(propertyChangeEvent.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        String string = "";
        int n = 0;
        try {
            string = propertyChangeEvent.getProperty();
            if (this.affectsRreservedWord(string)) {
                this.adaptToReservedWordChange();
            } else {
                n = this.indexOf(string);
                if (n >= 0) {
                    Token token = this.getToken(this.fPropertyNamesColor[n]);
                    if (this.fPropertyNamesColor[n].equals(string)) {
                        this.adaptToColorChange(token, propertyChangeEvent);
                    } else {
                        this.adaptToStyleChange(token, propertyChangeEvent);
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (NoSuchElementException noSuchElementException) {
            CBDTUiPlugin.logError(noSuchElementException);
        }
    }

    private void adaptToReservedWordChange() {
        this.initReservedWord();
        WordRule wordRule = this.createWordRules();
        int n = 0;
        while (n < this.fRules.length) {
            if (this.fRules[n] instanceof WordRule) {
                this.fRules[n] = wordRule;
                break;
            }
            ++n;
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        RGB rGB = null;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof RGB) {
            rGB = (RGB)object;
        } else if (object instanceof String) {
            rGB = StringConverter.asRGB((String)((String)object));
        }
        if (rGB != null) {
            String string = propertyChangeEvent.getProperty();
            this.fColorManager.bindColor(string, rGB);
            Object object2 = token.getData();
            if (object2 instanceof TextAttribute) {
                TextAttribute textAttribute = (TextAttribute)object2;
                token.setData((Object)new TextAttribute(this.fColorManager.getColor(string), textAttribute.getBackground(), textAttribute.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        Object object;
        boolean bl = false;
        Object object2 = propertyChangeEvent.getNewValue();
        if (object2 instanceof Boolean) {
            bl = (Boolean)object2;
        } else if (object2 instanceof String) {
            object = (String)object2;
            if ("true".equals(object)) {
                bl = true;
            } else if ("false".equals(object)) {
                bl = false;
            }
        }
        object = token.getData();
        if (object instanceof TextAttribute) {
            boolean bl2;
            TextAttribute textAttribute = (TextAttribute)object;
            boolean bl3 = bl2 = textAttribute.getStyle() == 1;
            if (bl2 != bl) {
                token.setData((Object)new TextAttribute(textAttribute.getForeground(), textAttribute.getBackground(), bl ? 1 : 0));
            }
        }
    }

    public void handleDispose() {
        this.fColorManager = null;
        this.fDefaultReturnToken = null;
        this.fDocument = null;
        this.fFigurativeConstants = null;
        this.fPreferenceStore = null;
        this.fPropertyNamesColor = null;
        this.fPropertyNamesStyle = null;
        this.fReservedWords = null;
        this.fDataDictVars = null;
        this.fSections = null;
        this.fParagraphs = null;
        this.fWSVars = null;
        this.fUnreferencedVars = null;
        if (this.fRules != null) {
            this.fRules = null;
        }
        if (this.fTokenMap != null) {
            this.fTokenMap.clear();
            this.fTokenMap = null;
        }
    }
}

