/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common;

import java.io.BufferedReader;
import java.io.IOException;
import org.eclipse.cobol.ui.common.LineWrapper;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class LineReader {
    BufferedReader fBufferedReader = null;
    IDocument fDocument = null;
    int lineCount = -1;

    public LineReader(Object object) {
        if (object instanceof BufferedReader) {
            this.fBufferedReader = (BufferedReader)object;
        } else if (object instanceof IDocument) {
            this.fDocument = (IDocument)object;
        }
    }

    public void setLineCount(int n) {
        this.lineCount = n;
    }

    public LineWrapper getNextLine() {
        LineWrapper lineWrapper = null;
        if (this.fBufferedReader != null) {
            String string;
            block9: {
                try {
                    string = this.fBufferedReader.readLine();
                    if (string != null) break block9;
                    return null;
                }
                catch (IOException iOException) {}
            }
            ++this.lineCount;
            lineWrapper = new LineWrapper(string, this.lineCount);
        } else if (this.fDocument != null) {
            block10: {
                try {
                    if (this.lineCount < this.fDocument.getNumberOfLines() - 1) break block10;
                    return null;
                }
                catch (BadLocationException badLocationException) {}
            }
            ++this.lineCount;
            String string = this.fDocument.get(this.fDocument.getLineOffset(this.lineCount), this.fDocument.getLineLength(this.lineCount));
            lineWrapper = new LineWrapper(string, this.lineCount);
        }
        return lineWrapper;
    }

    public int getCurrentLineNumber() {
        return this.lineCount;
    }

    public void dispose() {
        if (this.fBufferedReader != null) {
            try {
                this.fBufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        this.fDocument = null;
    }
}

