/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common;

import com.unisys.os2200.i18nSupport.Messages;
import java.text.MessageFormat;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.core.common.ICOBOLLanguageModel;
import org.eclipse.cobol.core.util.ValidationManager;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.COBOLLanguageModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class COBOLValidationManager {
    private static String COBOL_RESERVED_WORD_ERROR = "Invalid.value.COBOL.reservedword.ErrorMessage";
    private static String COBOL_USER_WORD_ERROR = "Invalid.value.COBOL.userWord.ErrorMessage";
    private ICOBOLLanguageModel languageModel;
    private static COBOLValidationManager instance = null;

    public COBOLValidationManager() {
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        this.languageModel = iCOBOLContributor.getCOBOLLanguageModel();
    }

    public static COBOLValidationManager getInstrance() {
        if (instance == null) {
            instance = new COBOLValidationManager();
        }
        return instance;
    }

    public boolean isCOBOLReservedWord(String string) {
        String[] stringArray;
        boolean bl = false;
        if (this.languageModel != null) {
            stringArray = this.languageModel.getReservedWords();
        } else {
            COBOLLanguageModel cOBOLLanguageModel = new COBOLLanguageModel();
            stringArray = cOBOLLanguageModel.getReservedWords();
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase(stringArray[n2])) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public IStatus validateCOBOLReservedWord(String string, String string2) {
        Status status = new Status(0, CBDTUiPlugin.getPluginId(), -1, "", null);
        String string3 = "";
        if (this.isCOBOLReservedWord(string)) {
            string3 = MessageFormat.format(Messages.getString((String)COBOL_RESERVED_WORD_ERROR), string2, string);
            status = new Status(4, CBDTUiPlugin.getPluginId(), -1, string3, null);
        }
        return status;
    }

    public IStatus validateCOBOLUserWord(boolean bl, boolean bl2, String string, String string2) {
        Status status = new Status(0, CBDTUiPlugin.getPluginId(), -1, "", null);
        boolean bl3 = true;
        if (bl2) {
            return status;
        }
        Status status2 = new Status(0, CBDTUiPlugin.getPluginId(), -1, "", null);
        if (bl) {
            status2 = ValidationManager.validateForBlankString((String)string);
        }
        if (status2.isOK()) {
            bl3 = this.checkForMixCharacters(string);
        }
        if (status2.isOK() && bl3) {
            if (string.length() > 0 && string.substring(0, 1).getBytes().length == 1) {
                int n = 32;
                int n2 = 0;
                while (n2 < string.length()) {
                    n = string.charAt(n2);
                    if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95 || n == 45 || n >= 48 && n <= 57) {
                        bl3 = true;
                    } else if (!this.isValidKatakana1ByteChar(string.substring(n2, n2 + 1))) {
                        bl3 = false;
                        break;
                    }
                    ++n2;
                }
                if (bl3) {
                    n2 = string.charAt(0);
                    char c = string.charAt(string.length() - 1);
                    bl3 = n2 == 45 || n2 == 95 || c == '-' || c == '_' ? false : (string.length() > 30 ? false : (this.isCOBOLReservedWord(string) ? false : (!this.hasAll_1ByteKanas(string) && !this.hasOneAlphabet(string) ? false : !this.hasConsecutiveUnderScores(string))));
                }
            } else if (string.length() > 0 && string.substring(0, 1).getBytes().length == 2) {
                bl3 = this.validateForJapaneseUserWord(string);
            }
            if (!bl3) {
                String string3 = "";
                string3 = this.isCOBOLReservedWord(string) ? this.validateCOBOLReservedWord(string, string2).getMessage() : MessageFormat.format(Messages.getString((String)COBOL_USER_WORD_ERROR), string, string2);
                status = new Status(4, CBDTUiPlugin.getPluginId(), -1, string3, null);
            }
        } else {
            if (!status2.isOK()) {
                status = new Status(4, CBDTUiPlugin.getPluginId(), -1, status2.getMessage().concat(":").concat(string2), null);
            }
            if (!bl3) {
                String string4 = MessageFormat.format(Messages.getString((String)COBOL_USER_WORD_ERROR), string, string2);
                status = new Status(4, CBDTUiPlugin.getPluginId(), -1, string4, null);
            }
        }
        return status;
    }

    private boolean hasOneAlphabet(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isValidKatakana1ByteChar(String string) {
        byte by = string.getBytes()[0];
        byte by2 = string.getBytes()[0];
        byte by3 = string.getBytes()[0];
        return by >= by2 && by <= by3;
    }

    private boolean hasConsecutiveUnderScores(String string) {
        char c;
        int n = string.indexOf("_");
        return n > -1 && (c = string.charAt(n + 1)) == '_';
    }

    private boolean validateForJapaneseUserWord(String string) {
        boolean bl = true;
        bl = string.length() > 30 ? false : this.isValidJapaneseCharacter(string);
        return bl;
    }

    private boolean checkForMixCharacters(String string) {
        int n = string.length();
        if (n > 0) {
            int n2 = string.substring(0, 1).getBytes().length;
            int n3 = 0;
            while (n3 < n) {
                if (string.substring(n3, n3 + 1).getBytes().length != n2) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    private boolean isValidJapaneseCharacter(String string) {
        boolean bl = true;
        byte[] byArray = "?@".getBytes();
        byte[] byArray2 = "?[".getBytes();
        byte[] byArray3 = "?Q".getBytes();
        if (string.length() > 0) {
            byte[] byArray4 = string.substring(0, 1).getBytes();
            byte[] byArray5 = string.substring(string.length() - 1, string.length()).getBytes();
            if (this.ifByteArraysSame(byArray4, byArray2) || this.ifByteArraysSame(byArray4, byArray3) || this.ifByteArraysSame(byArray5, byArray2) || this.ifByteArraysSame(byArray5, byArray3)) {
                bl = false;
            }
            if (bl) {
                int n = string.length();
                int n2 = 0;
                while (n2 < n) {
                    byte[] byArray6 = string.substring(n2, n2 + 1).getBytes();
                    if (this.ifByteArraysSame(byArray6, byArray)) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return bl;
    }

    private boolean ifByteArraysSame(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < 2) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean hasAll_1ByteKanas(String string) {
        int n = string.length();
        byte by = string.getBytes()[0];
        byte by2 = string.getBytes()[0];
        int n2 = 0;
        while (n2 < n) {
            string.substring(n2, n2 + 1);
            byte by3 = string.getBytes()[0];
            if (by3 < by || by3 > by2) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

