/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class COBOLSequenceNumberHandler {
    private static final String SPACES = "      ";
    private static final String SPACE = " ";
    private IPreferenceStore fStore;
    private static int DEFAULT_STEP_VALUE = 0;
    private boolean isPATTERN_B = false;
    private static final char TAB = '\t';
    private static final char NEW_LINE = '\n';
    private static final int MAXIMUM_NUMBER = 999999;
    static String START_NUMBER = "000100";
    private static int MAX_NUMBER = 999999;
    private static int MIN_STEP_VALUE = 1;
    private static int NUMBER_LENGTH = 6;
    private static final String END_OF_LINE = "\n";
    StringBuffer fSequenceNumberBuffer = null;
    StringBuffer fDocumentTextBuffer = null;
    StringBuffer fLastSavedSequenceNumberBuffer = null;
    int noOfLines = 0;

    public COBOLSequenceNumberHandler() {
        this.initialize();
    }

    public void rewriteSequenceNumbers(IProject iProject, File[] fileArray) {
        String string = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Reference Format");
        if (!string.equals("FREE") && fileArray.length != 0) {
            int n = 0;
            while (n < fileArray.length) {
                String string2 = fileArray[n].getName();
                if (BuildUtil.isCobolFileExtn(string2)) {
                    IFile iFile = iProject.getFile(string2);
                    String string3 = null;
                    this.parseFile(iFile, string3);
                    StringBuffer stringBuffer = this.getSequenceNumberBuffer();
                    StringBuffer stringBuffer2 = this.getDocumentTextBuffer();
                    Document document = new Document();
                    document.set(stringBuffer2.toString());
                    stringBuffer = this.renumber(stringBuffer, Integer.parseInt(COBOLSequenceNumberHandler.getStartNumber()), COBOLSequenceNumberHandler.getDefaultStepValue(), this.getNoOfLines());
                    StringBuffer stringBuffer3 = this.getCombinedBuffer(document, stringBuffer, this.getNoOfLines());
                    String string4 = iFile.getLocation().toOSString();
                    new File(string4).delete();
                    fileArray[n] = new File(string4);
                    try {
                        COBOLSequenceNumberHandler.writeContentsToFile(fileArray[n], stringBuffer3);
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                }
                ++n;
            }
        }
    }

    public void parseFile(IFile iFile, String string) {
        InputStream inputStream = null;
        try {
            inputStream = iFile.getContents();
            this.parseFile(inputStream, string);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void parseFile(InputStream inputStream, String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        this.fSequenceNumberBuffer = new StringBuffer();
        this.fDocumentTextBuffer = new StringBuffer();
        this.fLastSavedSequenceNumberBuffer = new StringBuffer();
        try {
            String string2 = bufferedReader.readLine();
            String string3 = null;
            String string4 = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (string2 == null) {
                return;
            }
            try {
                this.isPATTERN_B = false;
                int n = 0;
                int n2 = 0;
                this.noOfLines = 0;
                while (string2 != null) {
                    ++this.noOfLines;
                    string3 = string2;
                    string4 = bufferedReader.readLine();
                    if (string2.length() == 0) {
                        stringBuffer.append(SPACES);
                    } else {
                        int n3 = 0;
                        int n4 = 6;
                        if (string2.length() < 6) {
                            n4 = string2.length();
                        }
                        while (n3 < n4) {
                            if (string2.charAt(n3) == '\t') {
                                stringBuffer.append(SPACE);
                            } else {
                                stringBuffer.append(string2.charAt(n3));
                            }
                            ++n3;
                        }
                        while (n3 < 6) {
                            stringBuffer.append(SPACE);
                            ++n3;
                        }
                        if (string2.length() > 6) {
                            this.fDocumentTextBuffer.append(string2.substring(6, string2.length()));
                        }
                    }
                    this.fSequenceNumberBuffer.append(stringBuffer);
                    try {
                        Integer.parseInt(stringBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.updatePattern();
                    }
                    try {
                        if (!stringBuffer.equals(SPACES)) {
                            n = Integer.parseInt(stringBuffer.toString());
                            if (n2 >= n || n > 999999) {
                                this.updatePattern();
                            }
                            n2 = n;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.updatePattern();
                    }
                    if ((string2 = string4) != null) {
                        this.fSequenceNumberBuffer.append('\n');
                        this.fDocumentTextBuffer.append(END_OF_LINE);
                    } else {
                        if (stringBuffer.toString().equals(SPACES) && string3.length() == 0) {
                            this.fSequenceNumberBuffer.delete(this.fSequenceNumberBuffer.length() - 7, this.fSequenceNumberBuffer.length());
                            this.fDocumentTextBuffer.delete(this.fDocumentTextBuffer.length() - END_OF_LINE.length(), this.fDocumentTextBuffer.length());
                        }
                        this.fDocumentTextBuffer.append(END_OF_LINE);
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                }
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                CBDTUiPlugin.logError(iOException);
            }
        }
    }

    public static void writeContentsToFile(File file, StringBuffer stringBuffer) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray = stringBuffer.toString().getBytes();
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.close();
    }

    public StringBuffer getCombinedBuffer(Document document, StringBuffer stringBuffer, int n) {
        int n2 = 6;
        int n3 = n2 + 1;
        int n4 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            int n5 = 0;
            while (n5 < n) {
                n4 = document.getLineOffset(n5);
                stringBuffer2.append(stringBuffer.substring(n5 * n3, n5 * n3 + n2)).append(document.get(n4, document.getLineLength(n5)));
                ++n5;
            }
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return stringBuffer2;
    }

    public void initialize() {
        try {
            this.fStore = CBDTUiPlugin.getDefault().getPreferenceStore();
            START_NUMBER = this.fStore.getString("Initial Value");
            DEFAULT_STEP_VALUE = Integer.parseInt(this.fStore.getString("Incremental Value"));
            MAX_NUMBER = 999999;
            MIN_STEP_VALUE = 1;
            NUMBER_LENGTH = 6;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    private void updatePattern() {
        this.isPATTERN_B = true;
    }

    public StringBuffer renumber(StringBuffer stringBuffer, int n, int n2, int n3) {
        try {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer2.append(n);
            this.addLeadingZeroes(stringBuffer2);
            stringBuffer.append(stringBuffer2).append(END_OF_LINE);
            int n4 = n;
            int n5 = 0;
            while (n5 < n3 - 1) {
                stringBuffer2.delete(0, stringBuffer2.length());
                if ((n4 += n2) > MAX_NUMBER) {
                    stringBuffer2.append(SPACES);
                } else {
                    stringBuffer2.append(n4);
                }
                this.addLeadingZeroes(stringBuffer2);
                stringBuffer.append(stringBuffer2).append(END_OF_LINE);
                ++n5;
            }
            if (stringBuffer.substring(stringBuffer.length() - END_OF_LINE.length(), stringBuffer.length()).equals(END_OF_LINE)) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return stringBuffer;
    }

    private void addLeadingZeroes(StringBuffer stringBuffer) {
        int n = NUMBER_LENGTH - stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.insert(0, '0');
            ++n2;
        }
    }

    public StringBuffer getSequenceNumberBuffer() {
        return this.fSequenceNumberBuffer;
    }

    public void setSequenceNumberBuffer(StringBuffer stringBuffer) {
        this.fSequenceNumberBuffer = stringBuffer;
    }

    public StringBuffer getDocumentTextBuffer() {
        return this.fDocumentTextBuffer;
    }

    public void setDocumentTextBuffer(StringBuffer stringBuffer) {
        this.fDocumentTextBuffer = stringBuffer;
    }

    public int getNoOfLines() {
        return this.noOfLines;
    }

    public void setNoOfLines(int n) {
        this.noOfLines = n;
    }

    public static int getDefaultStepValue() {
        return DEFAULT_STEP_VALUE;
    }

    public static int getMaxNumber() {
        return MAX_NUMBER;
    }

    public static int getMinStepValue() {
        return MIN_STEP_VALUE;
    }

    public static String getStartNumber() {
        return START_NUMBER;
    }
}

