/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cobol.ui.common.COBOLKeywordAnsi74;
import org.eclipse.cobol.ui.common.COBOLKeywordAnsi85;
import org.eclipse.cobol.ui.templates.COBOLTemplateManager;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.jface.text.templates.Template;

public class COBOLLanguageModel {
    protected int reservedWordSelection = 0;
    protected String[] reservedWordSets = new String[]{COBOLKeywordAnsi85.getName(), COBOLKeywordAnsi74.getName()};
    protected String[][] reservedWordModel = new String[][]{COBOLKeywordAnsi85.getReservedWords(), COBOLKeywordAnsi74.getReservedWords()};
    protected String[][] figurativeConstantModel = new String[][]{COBOLKeywordAnsi85.getFigurativeConstants(), COBOLKeywordAnsi74.getFigurativeConstants()};
    protected String[][] specialRegistorModel = new String[][]{COBOLKeywordAnsi85.getSpecialRegisters(), COBOLKeywordAnsi74.getSpecialRegisters()};

    public String[] getFigurativeConstants() {
        return this.figurativeConstantModel[this.reservedWordSelection];
    }

    public String[] getSpecialRegisters() {
        return this.specialRegistorModel[this.reservedWordSelection];
    }

    public String[] getReservedWords() {
        return this.reservedWordModel[this.reservedWordSelection];
    }

    public String[] getReservedSets() {
        return this.reservedWordSets;
    }

    public String getCurrentReservedSet() {
        return this.reservedWordSets[this.reservedWordSelection];
    }

    public boolean setReservedSet(String string) {
        if (string == null || string.length() <= 0) {
            this.reservedWordSelection = 0;
            return true;
        }
        int n = 0;
        while (n < this.reservedWordSets.length) {
            if (this.reservedWordSets[n].equals(string)) {
                this.reservedWordSelection = n;
                return true;
            }
            ++n;
        }
        return false;
    }

    public ArrayList getAllTemplates() {
        COBOLTemplateManager cOBOLTemplateManager = COBOLTemplateManager.getInstance();
        return cOBOLTemplateManager.getAllTemplates();
    }

    public String[] getClassIDs(String string) {
        ViewsTreeModel viewsTreeModel = ViewsTreeModel.getInstance();
        if (!viewsTreeModel.getRoot().hasChildren()) {
            viewsTreeModel.refreshStructuresView();
        }
        ArrayList arrayList = viewsTreeModel.getClassNames(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public HashMap getClassAndMethodIDs(String string) {
        HashMap hashMap = null;
        ViewsTreeModel viewsTreeModel = ViewsTreeModel.getInstance();
        if (!viewsTreeModel.getRoot().hasChildren()) {
            viewsTreeModel.refreshStructuresView();
        }
        hashMap = viewsTreeModel.getClassAndMethodIDs(string);
        return hashMap;
    }

    public String[] getProgramIDs(String string) {
        ViewsTreeModel viewsTreeModel = ViewsTreeModel.getInstance();
        if (!viewsTreeModel.getRoot().hasChildren()) {
            viewsTreeModel.refreshStructuresView();
        }
        ArrayList arrayList = viewsTreeModel.getProgramIds(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public List<Template> getTemplateByName(String string) {
        COBOLTemplateManager cOBOLTemplateManager = COBOLTemplateManager.getInstance();
        return cOBOLTemplateManager.getTemplateByName(string);
    }
}

