/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common;

import com.unisys.tde.core.OS2200FileEditorInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLMarkerAnnotationModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class COBOLBaseDocumentProvider
extends FileDocumentProvider {
    protected static final String LINE_SEPARATOR = "line.separator";
    protected static String END_OF_LINE = "\n";
    protected static final char TAB = '\t';
    protected static final char NEW_LINE = '\n';
    protected static final int MAXIMUM_NUMBER = 999999;
    protected static final String SPACES = "      ";
    protected static final String SPACE = " ";
    protected static final int TICK_A = 2000;
    protected static final int TICK_B = 1000;
    protected static final String SAVING_FILE = "Saving File";
    protected final byte EOF = (byte)26;
    protected int fTabRatio = 0;
    protected boolean fExpandTabs = false;

    protected IAnnotationModel createAnnotationModel(Object object) throws CoreException {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return new COBOLMarkerAnnotationModel((IResource)iFileEditorInput.getFile());
        }
        return super.createAnnotationModel(object);
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof IStorageEditorInput) {
            Object object;
            String string2 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Use Spaces for TABS");
            if (string2.compareToIgnoreCase("true") == 0) {
                this.fTabRatio = CBDTUiPlugin.getDefault().getPreferenceStore().getInt("Tab Width");
                this.fExpandTabs = true;
            } else {
                this.fTabRatio = 0;
                this.fExpandTabs = false;
            }
            IFile iFile = null;
            if (iDocument instanceof IDocumentExtension4 && (object = this.getLineDelimiterPreference(iFile = ((IFileEditorInput)iEditorInput).getFile())) != null) {
                ((IDocumentExtension4)iDocument).setInitialLineDelimiter((String)object);
            }
            object = ((IStorageEditorInput)iEditorInput).getStorage();
            InputStream inputStream = object.getContents();
            try {
                this.setDocumentContent(iDocument, inputStream, string);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return true;
        }
        if (iEditorInput instanceof IPathEditorInput) {
            String string3 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Use Spaces for TABS");
            if (string3.compareToIgnoreCase("true") == 0) {
                this.fTabRatio = CBDTUiPlugin.getDefault().getPreferenceStore().getInt("Tab Width");
                this.fExpandTabs = true;
            } else {
                this.fTabRatio = 0;
                this.fExpandTabs = false;
            }
            IPathEditorInput iPathEditorInput = (IPathEditorInput)iEditorInput;
            File file = new File(iPathEditorInput.getPath().toPortableString());
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            try {
                this.setDocumentContent(iDocument, fileInputStream, string);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
            return true;
        }
        if (iEditorInput instanceof FileStoreEditorInput) {
            block37: {
                String string4 = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Use Spaces for TABS");
                if (string4.compareToIgnoreCase("true") == 0) {
                    this.fTabRatio = CBDTUiPlugin.getDefault().getPreferenceStore().getInt("Tab Width");
                    this.fExpandTabs = true;
                } else {
                    this.fTabRatio = 0;
                    this.fExpandTabs = false;
                }
                URI uRI = ((FileStoreEditorInput)iEditorInput).getURI();
                try {
                    FileInputStream fileInputStream = new FileInputStream(new File(uRI.getPath()));
                    try {
                        try {
                            this.setDocumentContent(iDocument, fileInputStream, string);
                        }
                        catch (Exception exception) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException) {}
                            break block37;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public boolean isReadOnly(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            File file = new File(oS2200FileEditorInput.getPath().toOSString());
            return !file.canWrite();
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            File file = new File(fileStoreEditorInput.getURI().getPath());
            return !file.canWrite();
        }
        boolean bl = super.isReadOnly(object);
        return bl;
    }

    public boolean isModifiable(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            File file = new File(oS2200FileEditorInput.getPath().toOSString());
            return file.canWrite();
        }
        if (object instanceof IPathEditorInput) {
            IPathEditorInput iPathEditorInput = (IPathEditorInput)object;
            File file = new File(iPathEditorInput.getPath().toOSString());
            return file.canWrite();
        }
        boolean bl = super.isReadOnly(object);
        return bl;
    }

    protected String getLineDelimiterPreference(IFile iFile) {
        IScopeContext[] iScopeContextArray;
        if (iFile != null && iFile.getProject() != null) {
            iScopeContextArray = new IScopeContext[]{new ProjectScope(iFile.getProject())};
            String string = Platform.getPreferencesService().getString("org.eclipse.core.runtime", LINE_SEPARATOR, null, iScopeContextArray);
            if (string != null) {
                return string;
            }
        }
        iScopeContextArray = new IScopeContext[]{new InstanceScope()};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", LINE_SEPARATOR, null, iScopeContextArray);
    }

    private int insertTabString(StringBuffer stringBuffer, int n) {
        int n2 = n % this.fTabRatio;
        n2 = this.fTabRatio - n2;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        return n2;
    }

    protected String expandTabs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.fExpandTabs) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '\t') {
                n += this.insertTabString(stringBuffer, n);
            } else {
                stringBuffer.append(c);
                ++n;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected Document expandDoc(IDocument iDocument) {
        int n = iDocument.getNumberOfLines();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            try {
                int n3 = iDocument.getLineOffset(n2);
                int n4 = iDocument.getLineLength(n2);
                String string = iDocument.get(n3, n4);
                string = this.expandTabs(string);
                stringBuffer.append(string);
            }
            catch (BadLocationException badLocationException) {}
            ++n2;
        }
        return new Document(stringBuffer.toString());
    }
}

