/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.ui.common.EventData;
import org.eclipse.cobol.ui.common.TextUtilities;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class COBOLAbstractUndoManager
implements IUndoManager {
    protected ITextViewer fTextViewer;
    protected int fOperationType = 0;
    protected ITextListener fTextListener;
    protected List fCommandStack;
    private KeyAndMouseListener fKeyAndMouseListener;
    protected int fUndoLevel;
    private Runnable fRunnable = null;
    protected String fCurrentFormat = "";
    protected ITextEditor fEditor = null;

    public void connect(ITextViewer iTextViewer) {
        if (this.fTextViewer == null) {
            this.fTextViewer = iTextViewer;
            this.fCommandStack = new ArrayList();
            this.addListeners();
        }
    }

    public void disconnect() {
        if (this.fTextViewer != null) {
            this.removeListeners();
            if (this.fCommandStack != null) {
                this.fCommandStack.clear();
                this.fCommandStack = null;
            }
            this.fKeyAndMouseListener = null;
            this.fTextListener = null;
            this.fTextViewer = null;
            this.fRunnable = null;
        }
    }

    public void beginCompoundChange() {
    }

    public void endCompoundChange() {
    }

    public void reset() {
    }

    public void setMaximalUndoLevel(int n) {
        this.fUndoLevel = n;
    }

    public boolean undoable() {
        return false;
    }

    public boolean redoable() {
        return false;
    }

    public void undo() {
    }

    public void redo() {
    }

    protected void processTextEvent(TextEvent textEvent) {
        this.updateAllViews();
    }

    private void addListeners() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            this.fKeyAndMouseListener = new KeyAndMouseListener();
            styledText.addMouseListener((MouseListener)this.fKeyAndMouseListener);
            styledText.addKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.listenToTextChanges(true);
        }
    }

    private void removeListeners() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null && this.fKeyAndMouseListener != null) {
            styledText.removeMouseListener((MouseListener)this.fKeyAndMouseListener);
            styledText.removeKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.listenToTextChanges(false);
        }
    }

    public abstract void commit();

    public abstract int getStartPosition();

    public abstract int getEndPosition();

    public abstract String getCurrentText();

    public abstract String getPrevText();

    public abstract String getDeltaText();

    public void updateAllViews() {
        if (this.fEditor instanceof COBOLEditor) {
            COBOLEditor cOBOLEditor = (COBOLEditor)this.fEditor;
            EventData eventData = new EventData();
            eventData.setStart(this.getStartPosition());
            eventData.setEnd(this.getEndPosition());
            eventData.setText(this.getCurrentText());
            eventData.setPrevText(this.getPrevText());
            eventData.setDeltaText(this.getDeltaText());
            eventData.setOperationType(this.fOperationType);
            try {
                eventData.setStartLine(this.fTextViewer.getDocument().getLineOfOffset(this.getStartPosition()));
                eventData.setEndLine(this.fTextViewer.getDocument().getLineOfOffset(this.getEndPosition()));
            }
            catch (BadLocationException badLocationException) {}
            cOBOLEditor.getElementAnalyzer().setOperationData(eventData);
            cOBOLEditor.getElementAnalyzer().operationRestart();
        }
    }

    protected void listenToTextChanges(boolean bl) {
        if (bl && this.fTextListener == null) {
            this.fTextListener = new TextListener();
            this.fTextViewer.addTextListener(this.fTextListener);
        } else if (!bl && this.fTextListener != null) {
            this.fTextViewer.removeTextListener(this.fTextListener);
            this.fTextListener = null;
        }
    }

    public void updateInsertOperationType(String string, int n) {
        String[] stringArray;
        int n2;
        int n3;
        this.fOperationType = n > 1 ? ((n3 = TextUtilities.findNoOfLines(string, this.fTextViewer.getTextWidget().getLineDelimiter())) == 1 ? ((n2 = TextUtilities.startsWith(stringArray = this.fTextViewer.getDocument().getLegalLineDelimiters(), string)) == -1 ? EventData.PASTE : EventData.INSERT) : EventData.PASTE) : EventData.INSERT;
    }

    public void setCurrentFormat(String string) {
        this.fCurrentFormat = string;
    }

    public void setEditor(ITextEditor iTextEditor) {
        this.fEditor = iTextEditor;
    }

    private class KeyAndMouseListener
    implements MouseListener,
    KeyListener {
        private KeyAndMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                COBOLAbstractUndoManager.this.commit();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    COBOLAbstractUndoManager.this.commit();
                }
            }
        }
    }

    private class TextListener
    implements ITextListener {
        private TextListener() {
        }

        public void textChanged(TextEvent textEvent) {
            COBOLAbstractUndoManager.this.processTextEvent(textEvent);
        }
    }
}

