/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.build;

import com.unisys.os2200.util.MemChecker;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.BuildController;
import org.eclipse.cobol.core.build.ant.AntScriptGenerator;
import org.eclipse.cobol.core.ui.build.BuildUiUtil;
import org.eclipse.cobol.core.util.ValidateThreadUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.build.BuildUtil;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BuildAction;

public class DependencyModelManipulation {
    private static final String FIX_OPTION = "FIX";
    private static final String FREE_OPTION = "FREE";
    private static final String VARIABLE_OPTION = "VAR";
    public static final String XNOCALL = "-Xnocall";
    public static final String COMPILE_ONLY = "-c";

    public static String[] getSourceFiles(String string, boolean bl) {
        ViewsTreeModel viewsTreeModel = null;
        TreeElement treeElement = null;
        TreeElement treeElement2 = null;
        try {
            viewsTreeModel = ViewsTreeModel.getInstance();
            treeElement = viewsTreeModel.getRoot();
            treeElement2 = treeElement.getChildFromLocation(string);
            if (treeElement2 != null) {
                return DependencyModelManipulation.getSourceFiles(treeElement2, bl);
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getSourceFiles(TreeElement treeElement, boolean bl) {
        String string = null;
        TreeElement treeElement2 = null;
        TreeElement treeElement3 = null;
        ArrayList arrayList = null;
        int n = 0;
        String string2 = null;
        try {
            if (treeElement == null) return null;
            if (!treeElement.hasChildren()) return null;
            string = treeElement.getAttribute("LOCATION");
            if (treeElement.getAttribute("TYPE").equals("SOURCE_FOLDER")) {
                string = treeElement.getProject().getAttribute("LOCATION");
                treeElement2 = treeElement.getProject().getChildFromType("SOURCE_FOLDER");
            } else {
                treeElement2 = treeElement.getChildFromType("SOURCE_FOLDER");
            }
            if (treeElement2 != null) {
                arrayList = treeElement2.getChildren();
            }
            if (arrayList == null) return null;
            n = arrayList.size();
            ArrayList<String> arrayList2 = new ArrayList<String>(10);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return arrayList2.toArray(new String[arrayList2.size()]);
                }
                treeElement3 = (TreeElement)arrayList.get(n2);
                if (treeElement3 == null) return null;
                if (BuildUtil.isCobolFileExtn(treeElement3.getName())) {
                    string2 = new String(treeElement3.getAbsolutePath());
                    if (string2.toLowerCase().indexOf(string.toLowerCase()) == -1) {
                        return null;
                    }
                    if (!bl) {
                        string2 = string2.substring(string.length() + 1);
                    }
                    arrayList2.add(string2);
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CBDTUiPlugin.logError(indexOutOfBoundsException);
        }
        return null;
    }

    public static void cleanTargets(IProject iProject, Shell shell) {
        try {
            if (iProject == null || !iProject.exists() || iProject.getLocation() == null) {
                return;
            }
            IRunnableWithProgress iRunnableWithProgress = null;
            final IProject iProject2 = iProject;
            shell = DependencyModelManipulation.getActiveShell();
            iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    if (!iProject2.isOpen()) {
                        return;
                    }
                    BuildController buildController = new BuildController(iProject2, iProgressMonitor);
                    buildController.clean();
                    try {
                        iProject2.refreshLocal(0, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        CBDTUiPlugin.logError((Exception)((Object)coreException));
                    }
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(true, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                CBDTUiPlugin.logError(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void cleanTargets(TreeElement[] treeElementArray, Shell shell) {
        IProject iProject = null;
        ArrayList<IProject> arrayList = null;
        try {
            arrayList = new ArrayList<IProject>();
            int n = 0;
            while (treeElementArray != null && n < treeElementArray.length) {
                if (treeElementArray[n] != null && !arrayList.contains(iProject = treeElementArray[n].getIProject())) {
                    DependencyModelManipulation.cleanTargets(iProject, shell);
                    arrayList.add(iProject);
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void generateAntFile(IProject iProject) {
        block8: {
            try {
                if (iProject == null) break block8;
                IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
                boolean bl = iWorkspaceDescription.isAutoBuilding();
                if (bl) {
                    iWorkspaceDescription.setAutoBuilding(false);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
                    }
                    catch (CoreException coreException) {
                        CorePlugin.logError((Exception)((Object)coreException));
                    }
                }
                AntScriptGenerator antScriptGenerator = new AntScriptGenerator(iProject);
                antScriptGenerator.run();
                BuildUiUtil.refreshFromLocal((IProject)iProject);
                if (bl) {
                    iWorkspaceDescription.setAutoBuilding(true);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
                    }
                    catch (CoreException coreException) {
                        CorePlugin.logError((Exception)((Object)coreException));
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
        }
    }

    public static void generateAntFile(TreeElement[] treeElementArray) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = null;
            int n = 0;
            while (treeElementArray != null && n < treeElementArray.length) {
                string = treeElementArray[n].getIProject().getName();
                if (treeElementArray[n] != null && !arrayList.contains(string)) {
                    DependencyModelManipulation.generateAntFile(treeElementArray[n]);
                    arrayList.add(string);
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public static void generateAntFile(TreeElement treeElement) {
        TreeElement treeElement2 = null;
        IProject iProject = null;
        try {
            treeElement2 = treeElement.getProject();
            if (treeElement2 == null) {
                return;
            }
            iProject = treeElement2.getIProject();
            if (iProject == null || !iProject.exists() || iProject.getLocation() == null) {
                return;
            }
            DependencyModelManipulation.generateAntFile(iProject);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CBDTUiPlugin.logError(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void updateSkippedFiles(String string, IProject iProject) {
        QualifiedName qualifiedName = null;
        try {
            qualifiedName = new QualifiedName("org.eclipse.cobol.ui.build", "SkipFiles");
            iProject.setPersistentProperty(qualifiedName, string);
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public static void doBuild(final TreeElement[] treeElementArray, Shell shell, final int n) {
        IRunnableWithProgress iRunnableWithProgress = null;
        final Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * Exception decompiling
             */
            public void run(IProgressMonitor var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 22[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void refreshFromLocal(TreeElement treeElement, Shell shell) {
        String string = null;
        String string2 = null;
        IWorkspace iWorkspace = null;
        IProject iProject = null;
        try {
            string = treeElement.getAttribute("TYPE");
            string2 = treeElement.getName();
            if (string.equals(IViewConstants.PROJECT_NAME)) {
                iWorkspace = ResourcesPlugin.getWorkspace();
                iProject = iWorkspace.getRoot().getProject(string2);
                DependencyModelManipulation.refreshFromLocal(shell, iProject);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public static void refreshFromLocal(Shell shell, IProject iProject) {
        if (!ValidateThreadUtil.isValidThread()) {
            try {
                iProject.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            return;
        }
        final IProject iProject2 = iProject;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                try {
                    if (iProject2.getLocation().toFile().exists()) {
                        iProject2.refreshLocal(0, iProgressMonitor);
                    }
                }
                catch (CoreException coreException) {
                    CBDTUiPlugin.logError((Exception)((Object)coreException));
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static String getRelativePathForTargetDependents(String string, String string2) {
        StringBuffer stringBuffer = null;
        StringTokenizer stringTokenizer = null;
        String string3 = null;
        try {
            if (string2 != null) {
                stringTokenizer = new StringTokenizer(string2, "\n");
                stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (string3.startsWith(string)) {
                        stringBuffer.append(String.valueOf(string3.substring(string.length() + 1)) + "\n");
                        continue;
                    }
                    stringBuffer.append(String.valueOf(string3) + "\n");
                }
                return stringBuffer.toString();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            CBDTUiPlugin.logError(indexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        return null;
    }

    public static void initializeProblemMarkers() {
        block16: {
            if (!MemChecker.getInstance().hasEnoughMemory(false, false)) {
                return;
            }
            IDocument iDocument = null;
            IEditorPart iEditorPart = null;
            IFileEditorInput iFileEditorInput = null;
            IMarker[] iMarkerArray = null;
            IFile iFile = null;
            IWorkbenchPage iWorkbenchPage = null;
            int n = 0;
            int n2 = 0;
            try {
                iWorkbenchPage = CBDTUiPlugin.getActivePage();
                if (iWorkbenchPage != null) {
                    iEditorPart = iWorkbenchPage.getActiveEditor();
                }
                if (iEditorPart == null || !(iEditorPart instanceof COBOLEditor)) break block16;
                if (!(iEditorPart.getEditorInput() instanceof IFileEditorInput)) {
                    return;
                }
                iDocument = ((COBOLEditor)iEditorPart).getCurrentSourceViewer().getDocument();
                iFileEditorInput = (IFileEditorInput)iEditorPart.getEditorInput();
                iFile = iFileEditorInput.getFile();
                if (!iFile.exists()) {
                    return;
                }
                iMarkerArray = iFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n3 = 0;
                while (n3 < iMarkerArray.length) {
                    if (!iMarkerArray[n3].exists()) {
                        iMarkerArray[n3].delete();
                    }
                    if (iMarkerArray[n3].getAttribute("charStart") == null && (Integer)iMarkerArray[n3].getAttribute("lineNumber") != null && (Integer)iMarkerArray[n3].getAttribute("lineNumber") != 0) {
                        n = iDocument.getLineOffset((Integer)iMarkerArray[n3].getAttribute("lineNumber") - 1);
                        n2 = n + iDocument.getLineLength((Integer)iMarkerArray[n3].getAttribute("lineNumber") - 1);
                        while (n < n2 && iDocument.getChar(n) == ' ') {
                            ++n;
                        }
                        iMarkerArray[n3].setAttribute("charStart", n);
                        if (iDocument.getNumberOfLines() == ((Integer)iMarkerArray[n3].getAttribute("lineNumber")).intValue()) {
                            iMarkerArray[n3].setAttribute("charEnd", n2);
                        } else {
                            iMarkerArray[n3].setAttribute("charEnd", n2 - 1);
                        }
                    } else if (iMarkerArray[n3].getAttribute("lineNumber") == null || (Integer)iMarkerArray[n3].getAttribute("lineNumber") != 0) break;
                    ++n3;
                }
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
            catch (BadLocationException badLocationException) {
                CBDTUiPlugin.logError((Exception)((Object)badLocationException));
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
        }
    }

    public static String getEditorSrf() {
        String string = null;
        try {
            string = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Reference Format");
            if (string.equalsIgnoreCase("FIXED")) {
                string = FIX_OPTION;
            } else if (string.equalsIgnoreCase(FREE_OPTION)) {
                string = FREE_OPTION;
            } else if (string.equalsIgnoreCase("VARIABLE")) {
                string = VARIABLE_OPTION;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return string;
    }

    public static String getEditorTab() {
        String string = null;
        try {
            string = CBDTUiPlugin.getDefault().getPreferenceStore().getString("Tab Width");
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return string;
    }

    private static Shell getActiveShell() {
        if (Display.getCurrent() != null) {
            return Display.getCurrent().getActiveShell();
        }
        if (Display.getDefault() != null) {
            try {
                return Display.getDefault().getActiveShell();
            }
            catch (Exception exception) {
                return ValidateThreadUtil.getActiveShell();
            }
        }
        return new Shell();
    }

    private static void saveAllResources(IProject iProject) {
        if (iProject == null) {
            return;
        }
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n2];
                IEditorPart[] iEditorPartArray = iWorkbenchPage.getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IFile iFile;
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput instanceof IFileEditorInput && iProject == (iFile = ((IFileEditorInput)iEditorInput).getFile()).getProject()) {
                        iWorkbenchPage.saveEditor(iEditorPart, false);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    static /* synthetic */ void access$0(IProject iProject) {
        DependencyModelManipulation.saveAllResources(iProject);
    }
}

