/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.cobol.core.ICommonConstants;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class BuildUtil {
    public static final String START_MACRO = "${";
    public static final String END_MACRO = "}";
    private static String strQualifier = "org.eclipse.cobol.core.ui.properties";

    public static void setNameOptionInFilePersistance(IResource iResource, boolean bl) {
    }

    public static boolean getNameOptionFromResourcePersistance(IResource iResource) {
        boolean bl = false;
        return bl;
    }

    public static void updateINIFileWithCobolBuildOptions(IProject iProject) {
        try {
            if (iProject == null) {
                return;
            }
            String string = iProject.getLocation().toOSString().concat(File.separator);
            string = string.concat(".CobolOptions");
            BuildUtil.updateINIFileWithVersionInfo(string);
            Hashtable hashtable = BuildUtil.getCobolCompilerOptionsFromPersistance(iProject);
            String string2 = "CobolCompilerOptions";
            if (hashtable != null && hashtable.size() > 0) {
                CommonBuildUtil.updateINIFile((String)string2, null, (String)string, (Hashtable)hashtable);
            } else {
                CommonBuildUtil.deleteEntriesUnderSection((String)string2, (String)string);
            }
            Hashtable hashtable2 = BuildUtil.getCobolLibraryNameOptionsFromPersistance(iProject);
            string2 = "LibraryOptions";
            if (hashtable2 != null && hashtable2.size() > 0) {
                CommonBuildUtil.updateINIFile((String)string2, (String)"LibraryNameCount", (String)string, (Hashtable)hashtable2);
            } else {
                CommonBuildUtil.deleteEntriesUnderSection((String)string2, (String)string);
            }
            Hashtable hashtable3 = BuildUtil.getCobolLinkerOptionsFromPersistance(iProject);
            string2 = "LinkerOptions";
            if (hashtable3 != null && hashtable3.size() > 0) {
                CommonBuildUtil.updateINIFile((String)string2, (String)"LibraryFileCount", (String)string, (Hashtable)hashtable3);
            } else {
                CommonBuildUtil.deleteEntriesUnderSection((String)string2, (String)string);
            }
            String string3 = "LinkerOtherOptions";
            String string4 = BuildUtil.getLinkerOtherOptionsFromPersistance(iProject);
            if (string4 != null && string4.length() > 0) {
                CommonBuildUtil.writeToINIFile((String)string2, (String)string3, (String)string4, (String)string);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static Hashtable getCobolCompilerOptionsFromPersistance(IProject iProject) {
        return null;
    }

    private static String getOptionFromINIFile(String string, String string2, String string3) throws IOException {
        String string4 = CommonBuildUtil.readFromINIFile((String)string, (String)string3, (String)string2);
        return string4;
    }

    private static Hashtable getCobolLibraryNameOptionsFromPersistance(IProject iProject) {
        Hashtable<String, String> hashtable = null;
        try {
            QualifiedName qualifiedName = new QualifiedName(strQualifier, "LibraryNamesProperty");
            hashtable = new Hashtable<String, String>();
            if (iProject == null) {
                return hashtable;
            }
            String string = iProject.getPersistentProperty(qualifiedName);
            String[] stringArray = BuildUtil.getSeperatorElements(string, ICommonConstants.EOL);
            if (stringArray != null && stringArray.length > 0) {
                int n = stringArray.length;
                int n2 = -1;
                String string2 = "";
                int n3 = 0;
                while (n3 < n) {
                    n2 = stringArray[n3].indexOf("=");
                    if (n2 != -1) {
                        string2 = "LibraryName" + (n3 + 1);
                        string = string.concat(stringArray[n3].substring(n2 + 1, stringArray[n3].length()));
                        hashtable.put(string2, string);
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return hashtable;
    }

    private static Hashtable getCobolLinkerOptionsFromPersistance(IProject iProject) {
        Hashtable<String, String> hashtable = null;
        try {
            QualifiedName qualifiedName = new QualifiedName(strQualifier, "LinkerOptions");
            hashtable = new Hashtable<String, String>();
            if (iProject == null) {
                return hashtable;
            }
            String string = iProject.getPersistentProperty(qualifiedName);
            String[] stringArray = BuildUtil.getSeperatorElements(string, ICommonConstants.EOL);
            if (stringArray != null && stringArray.length > 0) {
                int n = stringArray.length;
                String string2 = "";
                int n2 = 0;
                while (n2 < n) {
                    string2 = "LibraryFile" + (n2 + 1);
                    hashtable.put(string2, stringArray[n2]);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return hashtable;
    }

    private static String getLinkerOtherOptionsFromPersistance(IProject iProject) {
        String string = "";
        return string;
    }

    public static void updateINIFileWithCobolTargetOptions(IProject iProject) {
        try {
            if (iProject == null) {
                return;
            }
            String string = iProject.getLocation().toOSString().concat(File.separator);
            string = string.concat(".CobolOptions");
            BuildUtil.updateINIFileWithVersionInfo(string);
            Hashtable hashtable = BuildUtil.getCobolTargetOptionsFromPersistance(iProject);
            if (hashtable != null && hashtable.size() > 0) {
                String string2 = "TargetOptions";
                CommonBuildUtil.updateINIFile((String)string2, null, (String)string, (Hashtable)hashtable);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static Hashtable getCobolTargetOptionsFromPersistance(IProject iProject) {
        return BuildUtil.getCobolTargetOptions(iProject, false);
    }

    private static Hashtable getCobolTargetOptions(IProject iProject, boolean bl) {
        Hashtable<String, String> hashtable = null;
        try {
            String string;
            String string2;
            String string3;
            QualifiedName qualifiedName;
            hashtable = new Hashtable<String, String>();
            if (iProject == null) {
                return hashtable;
            }
            String string4 = iProject.getLocation().toOSString().concat(File.separator);
            String string5 = BuildUtil.getOptionValue(iProject, string4 = string4.concat(".CobolOptions"), qualifiedName = null, string3 = "TargetOptions", string2 = "TargetName", bl);
            if (string5 != null && string5.length() > 0) {
                string = string2;
                if (bl) {
                    string = qualifiedName;
                }
                hashtable.put(string, string5);
            }
            string2 = "TargetType";
            string5 = BuildUtil.getOptionValue(iProject, string4, qualifiedName, string3, string2, bl);
            string = string2;
            hashtable.put(string, string5);
            string2 = "BuildMode";
            string5 = BuildUtil.getOptionValue(iProject, string4, qualifiedName, string3, string2, bl);
            string = string2;
            if (bl) {
                string = qualifiedName;
                string5 = string5 == null || string5.equalsIgnoreCase("Release") ? "false" : "true";
            } else if (string5 == null || string5.equalsIgnoreCase("false")) {
                string5 = "Release";
            } else if (string5.equalsIgnoreCase("true")) {
                string5 = "Debug";
            }
            hashtable.put(string, string5);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return hashtable;
    }

    public static void updateINIFileWithRCOptions(IProject iProject) {
        try {
            if (iProject == null) {
                return;
            }
            if (ViewsTreeModel.getInstance().getProjectNode(iProject.getName()) != null) {
                String string = iProject.getLocation().toOSString().concat(File.separator);
                string = string.concat(".CobolOptions");
                BuildUtil.updateINIFileWithVersionInfo(string);
                QualifiedName qualifiedName = null;
                String string2 = iProject.getPersistentProperty(qualifiedName);
                if (string2 != null && string2.length() > 0) {
                    String string3 = "TargetOptions";
                    CommonBuildUtil.writeToINIFile((String)string3, (String)"ResourceCompilerOptions", (String)string2, (String)string);
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void updateINIFileWithSourceFilesInfo(IProject iProject) {
        try {
            if (iProject == null) {
                return;
            }
            String string = iProject.getLocation().toOSString().concat(File.separator);
            string = string.concat(".CobolOptions");
            BuildUtil.updateINIFileWithVersionInfo(string);
            String[] stringArray = BuildUtil.getSourceFileListFromDependencyView(iProject);
            BuildUtil.updateINIFileWithSourceFiles(string, stringArray);
            String string2 = BuildUtil.getMainFileFromDependencyView(iProject);
            BuildUtil.updateINIFileWithMainFile(string, string2);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static void updateINIFileWithSourceFiles(String string, String[] stringArray) {
        String string2 = "DependencyViewSourceFiles";
        String string3 = "CobolSourceFileCount";
        String string4 = "CobolSourceFile";
        BuildUtil.updateINIFileWithFileInfo(string, string2, string3, string4, stringArray);
    }

    private static void updateINIFileWithMainFile(String string, String string2) {
        try {
            if (string == null || string != null && string.length() == 0) {
                return;
            }
            if (string2 != null && string2.length() > 0) {
                String string3 = "DependencyViewSourceFiles";
                CommonBuildUtil.writeToINIFile((String)string3, (String)"MainFile", (String)string2, (String)string);
            }
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
    }

    private static String[] getSourceFileListFromDependencyView(IProject iProject) {
        ArrayList arrayList = new ArrayList(5);
        if (iProject != null) {
            arrayList = ViewsUtil.getSourceFileNamesList(iProject.getName());
        }
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    private static String getMainFileFromDependencyView(IProject iProject) {
        String string = "";
        if (iProject != null) {
            string = ViewsUtil.getMainSourceFileName(iProject.getName());
        }
        return string;
    }

    private static String[] getLinkingFileListFromDependencyView(IProject iProject) {
        ArrayList arrayList = new ArrayList(5);
        if (iProject != null) {
            arrayList = ViewsUtil.getLinkingFileNamesList(iProject.getName());
        }
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    private static String[] getSrcFileListWithNameOptionFromDependencyView(IProject iProject) {
        ArrayList arrayList = new ArrayList(5);
        if (iProject != null) {
            arrayList = ViewsUtil.getSourceFilesWithNameOption(iProject.getName());
        }
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    public static void updateINIFileWithLinkingFilesInfo(IProject iProject) {
        try {
            if (iProject == null) {
                return;
            }
            String string = iProject.getLocation().toOSString().concat(File.separator);
            string = string.concat(".CobolOptions");
            BuildUtil.updateINIFileWithVersionInfo(string);
            String[] stringArray = BuildUtil.getLinkingFileListFromDependencyView(iProject);
            BuildUtil.updateINIFileWithLinkingFiles(string, stringArray);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static void updateINIFileWithLinkingFiles(String string, String[] stringArray) {
        String string2 = "DependencyViewLinkingFiles";
        String string3 = "LinkingFileCount";
        String string4 = "LinkingFile";
        BuildUtil.updateINIFileWithFileInfo(string, string2, string3, string4, stringArray);
    }

    public static void updateINIFileWithSourceFilesInfoWithNameOption(IProject iProject) {
        try {
            if (iProject == null) {
                return;
            }
            String string = iProject.getLocation().toOSString().concat(File.separator);
            string = string.concat(".CobolOptions");
            BuildUtil.updateINIFileWithVersionInfo(string);
            String[] stringArray = BuildUtil.getSrcFileListWithNameOptionFromDependencyView(iProject);
            BuildUtil.updateINIFileWithSrcNameOptionFiles(string, stringArray);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static void updateINIFileWithSrcNameOptionFiles(String string, String[] stringArray) {
        String string2 = "DependencyViewSourceFilesWithNameOption";
        String string3 = "CobolSourceFileCountWithNameOption";
        String string4 = "CobolSourceFileWithNameOption";
        BuildUtil.updateINIFileWithFileInfo(string, string2, string3, string4, stringArray);
    }

    private static void updateINIFileWithFileInfo(String string, String string2, String string3, String string4, String[] stringArray) {
        try {
            if (string == null || string != null && string.length() == 0) {
                return;
            }
            if (stringArray != null && stringArray.length > 0) {
                int n = stringArray.length;
                String string5 = "";
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                int n2 = 0;
                while (n2 < n) {
                    string5 = String.valueOf(string4) + (n2 + 1);
                    hashtable.put(string5, stringArray[n2]);
                    ++n2;
                }
                CommonBuildUtil.updateINIFile((String)string2, (String)string3, (String)string, hashtable);
            } else {
                CommonBuildUtil.deleteEntriesUnderSection((String)string2, (String)string);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static String[] getSeperatorElements(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add((String)stringTokenizer.nextElement());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void updateCobolOptionsINIFile(IProject iProject) {
        if (ViewsTreeModel.getInstance().getProjectNode(iProject.getName()) != null) {
            BuildUtil.updateINIFileWithCobolBuildOptions(iProject);
            BuildUtil.updateINIFileWithCobolTargetOptions(iProject);
            BuildUtil.updateINIFileWithSourceFilesInfo(iProject);
            BuildUtil.updateINIFileWithSourceFilesInfoWithNameOption(iProject);
            BuildUtil.updateINIFileWithLinkingFilesInfo(iProject);
        }
    }

    public static void updateProjectPersistanceWithRCOptions(IProject iProject) {
        try {
            if (iProject == null) {
                return;
            }
            String string = iProject.getLocation().toOSString().concat(File.separator);
            String string2 = "TargetOptions";
            String string3 = "ResourceCompilerOptions";
            String string4 = CommonBuildUtil.readFromINIFile((String)string2, (String)string3, (String)(string = string.concat(".CobolOptions")));
            if (string4 != null && string4.length() > 0) {
                QualifiedName qualifiedName = null;
                BuildUtil.setProjectPersistance(iProject, qualifiedName, string4);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public static void updateProjectPersistanceWithCobolBuildOptions(IProject iProject) {
        Hashtable hashtable;
        String string;
        String string2;
        if (iProject == null) {
            return;
        }
        try {
            if (iProject.isOpen() && iProject.getLocation().toFile().exists() && !CBDTUiPlugin.getWorkspace().isTreeLocked()) {
                iProject.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        String string3 = iProject.getLocation().toOSString().concat(File.separator);
        string3 = string3.concat(".CobolOptions");
        Hashtable hashtable2 = BuildUtil.getCobolCompilerOptionsFromINIFile(iProject);
        if (hashtable2 != null && hashtable2.size() > 0) {
            BuildUtil.updatePersistance(hashtable2, iProject);
        }
        if ((string2 = BuildUtil.getCobolLibraryOptionsFromINIFile(string3)) != null && string2.length() > 0) {
            string = new QualifiedName(strQualifier, "LibraryNamesProperty");
            BuildUtil.setProjectPersistance(iProject, (QualifiedName)string, string2);
        }
        if ((string = BuildUtil.getCobolLinkerOptionsFromINIFile(string3)) != null && string.length() > 0) {
            hashtable = new QualifiedName(strQualifier, "LinkerOptions");
            BuildUtil.setProjectPersistance(iProject, (QualifiedName)hashtable, string);
        }
        if ((string = BuildUtil.getLinkerOtherOptionsFromINIFile(string3)) != null && string.length() > 0) {
            hashtable = null;
            BuildUtil.setProjectPersistance(iProject, (QualifiedName)hashtable, string);
        }
        if ((hashtable = BuildUtil.getCobolTargetOptionsFromINIFile(iProject)) != null && hashtable.size() > 0) {
            BuildUtil.updatePersistance(hashtable, iProject);
        }
        BuildUtil.updateDependencyViewFromINIFile(iProject);
    }

    public static void updateDependencyViewFromINIFile(IProject iProject) {
        if (iProject == null) {
            return;
        }
        ViewsUtil.checkAndAddProjectNodeOnImport(iProject);
        String string = iProject.getLocation().toOSString().concat(File.separator);
        string = string.concat(".CobolOptions");
        String[] stringArray = BuildUtil.getCobolSourceFileNamesFromINIFile(string);
        ViewsUtil.addSourceFilesToDepView(iProject, stringArray);
        String[] stringArray2 = BuildUtil.getCobolLinkingFileNamesFromINIFile(string);
        ViewsUtil.addLinkingFiles(iProject, stringArray2);
        String string2 = BuildUtil.getCobolMainFileNameFromINIFile(string);
        if (string2 != null) {
            BuildUtil.updateProjectPersistanceWithMainFile(iProject, string2);
        }
        String[] stringArray3 = BuildUtil.getCobolSourceFileNamesWithNameOptionFromINIFile(string);
        ViewsUtil.updateSourceFilesWithNameOption(iProject.getName(), stringArray3);
        ViewsUtil.refreshDependencyView(iProject);
    }

    public static void updateProjectPersistanceWithMainFile(IProject iProject, String string) {
        try {
            if (iProject == null) {
                return;
            }
            if (string != null) {
                iProject.setPersistentProperty(ViewsUtil.fMainKey, string);
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
    }

    private static Hashtable getCobolCompilerOptionsFromINIFile(IProject iProject) {
        return null;
    }

    private static Hashtable getCobolTargetOptionsFromINIFile(IProject iProject) {
        return BuildUtil.getCobolTargetOptions(iProject, true);
    }

    private static String getCobolLibraryOptionsFromINIFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (string == null || string != null && string.length() == 0) {
                return stringBuffer.toString();
            }
            String string2 = "LibraryOptions";
            String string3 = CommonBuildUtil.readFromINIFile((String)string2, (String)"LibraryNameCount", (String)string);
            if (string3 != null && string3.length() > 0) {
                string3 = string3.trim();
                int n = Integer.parseInt(string3);
                String string4 = "";
                String string5 = "";
                String string6 = "";
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    string4 = "LibraryName" + (n2 + 1);
                    string6 = CommonBuildUtil.readFromINIFile((String)string2, (String)string4, (String)string);
                    if (string6 != null && string6.length() > 0 && (n3 = -1) != -1) {
                        string5 = string6.substring(0, n3).concat("=");
                        string5 = string5.concat(string6.substring(n3 + 1, string6.length()));
                        stringBuffer.append(string5);
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(ICommonConstants.EOL);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return stringBuffer.toString();
    }

    private static String getLinkerOtherOptionsFromINIFile(String string) {
        String string2 = "";
        try {
            if (string == null || string != null && string.length() == 0) {
                return string2;
            }
            string2 = CommonBuildUtil.readFromINIFile((String)"LinkerOptions", (String)"LinkerOtherOptions", (String)string);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return string2;
    }

    private static String getCobolLinkerOptionsFromINIFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (string == null || string != null && string.length() == 0) {
                return stringBuffer.toString();
            }
            String string2 = "LinkerOptions";
            String string3 = CommonBuildUtil.readFromINIFile((String)string2, (String)"LibraryFileCount", (String)string);
            if (string3 != null && string3.length() > 0) {
                string3 = string3.trim();
                int n = Integer.parseInt(string3);
                String string4 = "";
                String string5 = "";
                int n2 = 0;
                while (n2 < n) {
                    string4 = "LibraryFile" + (n2 + 1);
                    string5 = CommonBuildUtil.readFromINIFile((String)string2, (String)string4, (String)string);
                    if (string5 != null && string5.length() > 0) {
                        stringBuffer.append(string5);
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(ICommonConstants.EOL);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return stringBuffer.toString();
    }

    private static String getOptionValue(IProject iProject, String string, QualifiedName qualifiedName, String string2, String string3, boolean bl) {
        String string4 = "";
        if (string == null || string != null && string.length() == 0) {
            return string4;
        }
        try {
            string4 = bl ? BuildUtil.getOptionFromINIFile(string2, string, string3) : iProject.getPersistentProperty(qualifiedName);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return string4;
    }

    public static void updatePersistance(Hashtable hashtable, IProject iProject) {
        try {
            if (hashtable == null) {
                return;
            }
            if (iProject == null) {
                return;
            }
            Enumeration enumeration = hashtable.keys();
            if (enumeration == null) {
                return;
            }
            QualifiedName qualifiedName = null;
            String string = "";
            while (enumeration.hasMoreElements()) {
                qualifiedName = (QualifiedName)enumeration.nextElement();
                string = (String)hashtable.get(qualifiedName);
                BuildUtil.setProjectPersistance(iProject, qualifiedName, string);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private static void setProjectPersistance(IProject iProject, QualifiedName qualifiedName, String string) {
        try {
            if (iProject == null || qualifiedName == null) {
                return;
            }
            if (string != null && string.length() > 0) {
                iProject.setPersistentProperty(qualifiedName, string);
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
    }

    public static void updateINIFileWithVersionInfo(String string) {
        try {
            if (string != null && string.length() > 0) {
                File file = new File(string);
                boolean bl = false;
                if (!file.exists()) {
                    bl = true;
                } else {
                    String string2 = CommonBuildUtil.readFromINIFile((String)"Apdesigner Version Information", (String)"Version No", (String)string);
                    if (string2 == null || string2 != null && string2.length() == 0) {
                        bl = true;
                    } else if (!string2.equalsIgnoreCase("6.0")) {
                        bl = true;
                    }
                }
                if (bl) {
                    CommonBuildUtil.writeToINIFile((String)"Apdesigner Version Information", (String)"Version No", (String)"6.0", (String)string);
                }
            }
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
    }

    public static String getCobolMainFileNameFromINIFile(String string) {
        String string2 = "";
        try {
            if (string == null || string != null && string.length() == 0) {
                return string2;
            }
            String string3 = "DependencyViewSourceFiles";
            String string4 = "MainFile";
            string2 = CommonBuildUtil.readFromINIFile((String)string3, (String)string4, (String)string);
        }
        catch (IOException iOException) {
            CBDTUiPlugin.logError(iOException);
        }
        return string2;
    }

    public static String[] getCobolSourceFileNamesFromINIFile(String string) {
        String string2 = "DependencyViewSourceFiles";
        String string3 = "CobolSourceFileCount";
        String string4 = "CobolSourceFile";
        return BuildUtil.getEntriesFromINIFile(string, string2, string3, string4);
    }

    public static String[] getCobolLinkingFileNamesFromINIFile(String string) {
        String string2 = "DependencyViewLinkingFiles";
        String string3 = "LinkingFileCount";
        String string4 = "LinkingFile";
        return BuildUtil.getEntriesFromINIFile(string, string2, string3, string4);
    }

    public static String[] getCobolSourceFileNamesWithNameOptionFromINIFile(String string) {
        String string2 = "DependencyViewSourceFilesWithNameOption";
        String string3 = "CobolSourceFileCountWithNameOption";
        String string4 = "CobolSourceFileWithNameOption";
        return BuildUtil.getEntriesFromINIFile(string, string2, string3, string4);
    }

    private static String[] getEntriesFromINIFile(String string, String string2, String string3, String string4) {
        ArrayList<String> arrayList;
        block6: {
            arrayList = new ArrayList<String>();
            if (string != null && (string == null || string.length() != 0)) break block6;
            return null;
        }
        try {
            String string5 = CommonBuildUtil.readFromINIFile((String)string2, (String)string3, (String)string);
            if (string5 != null && string5.length() > 0) {
                string5 = string5.trim();
                int n = Integer.parseInt(string5);
                String string6 = "";
                String string7 = "";
                int n2 = 0;
                while (n2 < n) {
                    string6 = String.valueOf(string4) + (n2 + 1);
                    string7 = CommonBuildUtil.readFromINIFile((String)string2, (String)string6, (String)string);
                    if (string7 != null && string7.length() > 0) {
                        arrayList.add(string7);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isCobolFileExtn(String string) {
        ArrayList arrayList = new ArrayList();
        arrayList = CommonBuildUtil.getCobolEditorFiles();
        Path path = null;
        String string2 = "";
        boolean bl = false;
        if (string != null) {
            path = new Path(string);
            string2 = path.getFileExtension();
        }
        if (string2 != null && string2.length() > 0 && arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                String string3 = arrayList.get(n).toString();
                if (string2.equalsIgnoreCase(string3)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public static String getApplicationTargetType(IProject iProject) {
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.cobol.ui.common", "ITargetType");
            return iProject.getPersistentProperty(qualifiedName);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static boolean isDLLTargetApplicationType(IProject iProject) {
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.cobol.ui.common", "ITargetType");
            String string = iProject.getPersistentProperty(qualifiedName);
            return string != null && string.length() > 0 && string.equals("true");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isEXETargetApplicationType(IProject iProject) {
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.cobol.ui.common", "ITargetType");
            String string = iProject.getPersistentProperty(qualifiedName);
            return string != null && string.length() > 0 && string.equals("false");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

