/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.ui.actions.CleanAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.part.IPage;

public class ProjectActionGroup
extends ActionGroup {
    private ISelectionProvider fSelectionProvider;
    private CloseResourceAction fCloseAction;
    private BuildAction fBuildAction;
    private BuildAction fFullBuildAction;
    private CleanAction fCleanAction;
    public static String CLEAN_PROJECT_ID = "org.eclipse.cobol.core.build.action.menubar.CleanAction";

    public ProjectActionGroup(IViewPart iViewPart) {
        IWorkbenchPartSite iWorkbenchPartSite = iViewPart.getSite();
        Shell shell = iWorkbenchPartSite.getShell();
        this.fSelectionProvider = iWorkbenchPartSite.getSelectionProvider();
        ISelection iSelection = this.fSelectionProvider.getSelection();
        this.createGlobalActions(shell, this.fSelectionProvider, iSelection);
    }

    public ProjectActionGroup(IPage iPage, ISelectionProvider iSelectionProvider) {
        Shell shell = iPage.getControl().getShell();
        this.fSelectionProvider = iSelectionProvider;
        ISelection iSelection = this.fSelectionProvider.getSelection();
        this.createGlobalActions(shell, this.fSelectionProvider, iSelection);
    }

    private void createGlobalActions(Shell shell, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        this.fBuildAction = new BuildAction(shell, 10);
        this.fFullBuildAction = new BuildAction(shell, 6);
        this.fCloseAction = new CloseResourceAction(shell);
        this.fCleanAction = new CleanAction(CLEAN_PROJECT_ID, Messages.getString((String)"CleanAction.label"));
        if (iSelection instanceof IStructuredSelection) {
            this.fCloseAction.selectionChanged((IStructuredSelection)iSelection);
            this.fBuildAction.selectionChanged((IStructuredSelection)iSelection);
            this.fFullBuildAction.selectionChanged((IStructuredSelection)iSelection);
        }
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fBuildAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fFullBuildAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fCleanAction);
        CorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.fCleanAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler("closeProject", (IAction)this.fCloseAction);
        iActionBars.setGlobalActionHandler("buildProject", (IAction)this.fBuildAction);
        iActionBars.setGlobalActionHandler("rebuildProject", (IAction)this.fFullBuildAction);
    }

    public void dispose() {
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
            this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fBuildAction);
            this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fFullBuildAction);
        }
        super.dispose();
    }
}

