/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.actions;

import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.common.COBOLSequenceNumberHandler;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class COBOLPrintAction
extends Action {
    private COBOLEditor editor;
    private ITextOperationTarget fOperationTarget;
    private static final String PRINT = "Printing";

    public COBOLPrintAction(String string, COBOLEditor cOBOLEditor) {
        super(string);
        this.editor = cOBOLEditor;
        this.fOperationTarget = (ITextOperationTarget)cOBOLEditor.getAdapter(ITextOperationTarget.class);
    }

    public void run() {
        block6: {
            try {
                new COBOLSequenceNumberHandler();
                Document document = new Document(this.editor.getCurrentSourceViewer().getDocument().get());
                if (document.get().length() != 0) {
                    document.getNumberOfLines();
                }
                StringBuffer stringBuffer = null;
                try {
                    String string = this.editor.getCurrentSourceViewer().getTextWidget().getSelectionText();
                    if (string != null && !string.equals("")) {
                        stringBuffer = new StringBuffer(string);
                        this.print(stringBuffer);
                        break block6;
                    }
                    this.fOperationTarget.doOperation(10);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    CBDTUiPlugin.logError(stringIndexOutOfBoundsException);
                }
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
        }
    }

    private void print(StringBuffer stringBuffer) {
        StyledText styledText = this.editor.getPrinterStyledText();
        styledText.setText(stringBuffer.toString());
        styledText.setFont(this.editor.getCurrentSourceViewer().getTextWidget().getFont());
        PrintDialog printDialog = new PrintDialog(styledText.getShell(), 0);
        PrinterData printerData = printDialog.open();
        if (printerData != null) {
            StyleRange[] styleRangeArray = this.editor.getCurrentSourceViewer().getTextWidget().getStyleRanges();
            StyleRange[] styleRangeArray2 = null;
            styleRangeArray2 = this.editor.getCurrentSourceViewer().getTextWidget().getSelectionText().length() > 0 ? this.getFormattedRangesForSelectedText() : this.getFormattedRanges(styleRangeArray);
            if (styleRangeArray2 != null && styleRangeArray2.length > 0) {
                styledText.setStyleRanges(styleRangeArray2);
            }
            final Printer printer = new Printer(printerData);
            final Runnable runnable = styledText.print(printer);
            Thread thread = new Thread(PRINT){

                @Override
                public void run() {
                    runnable.run();
                    printer.dispose();
                }
            };
            thread.start();
        }
    }

    private StyleRange[] getFormattedRanges(StyleRange[] styleRangeArray) {
        StyleRange[] styleRangeArray2 = null;
        try {
            if (styleRangeArray != null) {
                styleRangeArray2 = new StyleRange[styleRangeArray.length];
                int n = 0;
                while (n < styleRangeArray.length) {
                    StyleRange styleRange = (StyleRange)styleRangeArray[n].clone();
                    int n2 = this.editor.getCurrentSourceViewer().getDocument().getLineOfOffset(styleRange.start);
                    styleRange.start = (n2 + 1) * 6 + styleRange.start;
                    styleRangeArray2[n] = styleRange;
                    ++n;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return styleRangeArray2;
    }

    private StyleRange[] getFormattedRangesForSelectedText() {
        int n = this.editor.getCurrentSourceViewer().getTextWidget().getSelectionText().length();
        int n2 = this.editor.getCurrentSourceViewer().getTextWidget().getCaretOffset();
        int n3 = n2 - n;
        int n4 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        try {
            while (n3 < n2) {
                StyleRange styleRange = this.editor.getCurrentSourceViewer().getTextWidget().getStyleRangeAtOffset(n3);
                if (styleRange != null) {
                    styleRange.start = n4;
                    n4 = styleRange.start + styleRange.length;
                    arrayList.add(styleRange.clone());
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return arrayList.toArray(new StyleRange[arrayList.size()]);
    }

    public void cleanUp() {
        this.editor = null;
        this.fOperationTarget = null;
    }
}

