/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.dialogs.GotoLineDialog;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.fixedformat.COBOLSequenceNumberArea;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class COBOLGotoLineAction
extends TextEditorAction {
    private int fLastLine;
    private static final String PREFIX = "Editor.GotoLine.";
    private COBOLSequenceNumberArea fCblSequenceNumberArea;
    private StringBuffer fSequenceNumbersBuffer;
    private int fSequenceLineNumber;
    private GotoLineDialog fGotoLineDialog;
    private static StringBuffer ftempBuffer = null;
    private static final String SPACE = " ";
    private static final String BLANK = "";
    private static final String NULL = null;
    private static final String INVALID_RANGE = "dialog.invalid_range";
    private static final String INVALID_INPUT = "dialog.invalid_input";
    private static final String INVALID_SEQUENCE_NUMBER = "dialog.invalid_sequence_number";
    private static final String DIALOG_TITLE1 = "dialog.title1";
    private static final String DIALOG_TITLE2 = "dialog.title2";
    private static final String DIALOG_SEQUENCE_MESSAGE = "dialog.message2";
    private COBOLEditor fCOBOLEditor;
    private static final String DIALOG_NO_SEQUENCE_NUMBER = "dialog.No_Seq_Numbers";
    private static final String DIALOG_LINE_MESSAGE = "dialog.message1";

    public COBOLGotoLineAction(ResourceBundle resourceBundle, COBOLEditor cOBOLEditor) {
        super(resourceBundle, PREFIX, (ITextEditor)cOBOLEditor);
        this.fCOBOLEditor = cOBOLEditor;
        this.fCblSequenceNumberArea = this.fCOBOLEditor.getSequenceNumberArea();
        if (ftempBuffer == null) {
            ftempBuffer = new StringBuffer();
        }
    }

    private void gotoLine(int n) {
        ITextEditor iTextEditor = this.getTextEditor();
        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
        IDocument iDocument = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
        try {
            int n2 = iDocument.getLineOffset(n);
            iTextEditor.selectAndReveal(n2, 0);
            IWorkbenchPage iWorkbenchPage = iTextEditor.getSite().getPage();
            iWorkbenchPage.activate((IWorkbenchPart)iTextEditor);
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
        }
    }

    public void run() {
        try {
            ITextEditor iTextEditor = this.getTextEditor();
            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
            IDocument iDocument = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
            this.fLastLine = iDocument.getLineOfOffset(iDocument.getLength()) + 1;
            ((COBOLEditor)iTextEditor).getReferenceFormat();
            String string = null;
            string = Messages.getString((String)"Editor.GotoLine.dialog.title2");
            String string2 = null;
            String string3 = null;
            string2 = MessageFormat.format(Messages.getString((String)"Editor.GotoLine.dialog.message1"), new Integer(this.fLastLine));
            string3 = BLANK;
            this.fGotoLineDialog = new GotoLineDialog(iTextEditor.getSite().getShell(), string, string2, string3, this.fLastLine, new NumberValidator(), this.fCOBOLEditor);
            if (this.fCOBOLEditor.getReferenceFormat().equals("FREE")) {
                this.fGotoLineDialog.setBasedOnLine();
            }
            this.fGotoLineDialog.setBlockOnOpen(true);
            int n = this.fGotoLineDialog.open();
            try {
                if (n == 0) {
                    int n2 = 1;
                    if (this.fGotoLineDialog.isBasedOnLine()) {
                        if (this.fGotoLineDialog.getValue() != null) {
                            n2 = Integer.parseInt(this.fGotoLineDialog.getValue());
                        }
                        this.gotoLine(n2 - 1);
                    } else {
                        if (this.fSequenceLineNumber == 0) {
                            this.fSequenceLineNumber = 1;
                        }
                        this.gotoLine(this.fSequenceLineNumber - 1);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                CBDTUiPlugin.logError(numberFormatException);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            CBDTUiPlugin.logError((Exception)((Object)badLocationException));
            return;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return;
        }
    }

    private String addLeadingZeroes(StringBuffer stringBuffer) {
        int n = 6 - stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.insert(0, '0');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private class NumberValidator
    implements IInputValidator {
        private NumberValidator() {
        }

        public String isValid(String string) {
            block12: {
                if (string == null || string.length() == 0) {
                    return COBOLGotoLineAction.SPACE;
                }
                if (COBOLGotoLineAction.this.fGotoLineDialog.isBasedOnLine()) {
                    try {
                        int n = Integer.parseInt(string);
                        if (n <= 0 || COBOLGotoLineAction.this.fLastLine < n) {
                            return Messages.getString((String)"Editor.GotoLine.dialog.invalid_range");
                        }
                        break block12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Messages.getString((String)"Editor.GotoLine.dialog.invalid_input");
                    }
                }
                if (!COBOLGotoLineAction.this.fCblSequenceNumberArea.isPatternB()) {
                    try {
                        Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Messages.getString((String)"Editor.GotoLine.dialog.invalid_input");
                    }
                }
                if (string.length() < 6) {
                    string = COBOLGotoLineAction.this.addLeadingZeroes(ftempBuffer.append(string));
                    ftempBuffer.delete(0, ftempBuffer.length());
                }
                if (string.length() == 6) {
                    COBOLGotoLineAction.this.fSequenceNumbersBuffer = COBOLGotoLineAction.this.fCblSequenceNumberArea.getSequenceNumbersBuffer();
                    COBOLGotoLineAction.this.fSequenceLineNumber = 0;
                    int n = COBOLGotoLineAction.this.fSequenceNumbersBuffer.length();
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = COBOLGotoLineAction.this.fSequenceNumbersBuffer.substring(n2, n2 + 6);
                        COBOLGotoLineAction cOBOLGotoLineAction = COBOLGotoLineAction.this;
                        cOBOLGotoLineAction.fSequenceLineNumber = cOBOLGotoLineAction.fSequenceLineNumber + 1;
                        if (string.equals(string2)) {
                            return NULL;
                        }
                        n2 = n2 + 6 + 1;
                    }
                    return Messages.getString((String)"Editor.GotoLine.dialog.invalid_sequence_number");
                }
                return Messages.getString((String)"Editor.GotoLine.dialog.invalid_input");
            }
            return NULL;
        }
    }
}

