/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class COBOLContentAssistantAction
extends TextEditorAction {
    COBOLEditor fEditor;
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;

    public COBOLContentAssistantAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor, int n) {
        super(resourceBundle, string, iTextEditor);
        this.fEditor = (COBOLEditor)iTextEditor;
        this.fOperationCode = n;
        this.update();
    }

    public void run() {
        if (this.fOperationCode != -1 && this.fOperationTarget != null) {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    public void update() {
        if (this.fOperationTarget == null && this.getTextEditor() != null && this.fOperationCode != -1) {
            this.fOperationTarget = (ITextOperationTarget)this.getTextEditor().getAdapter(ITextOperationTarget.class);
        }
        boolean bl = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(bl);
    }

    public void setEditor(ITextEditor iTextEditor) {
        super.setEditor(iTextEditor);
        this.fOperationTarget = null;
    }

    public boolean isEnabled() {
        IEditorInput iEditorInput = this.fEditor.getEditorInput();
        boolean bl = false;
        if (iEditorInput instanceof IFileEditorInput) {
            bl = ((IFileEditorInput)iEditorInput).getFile().isReadOnly();
        } else if (iEditorInput instanceof IStorageEditorInput) {
            try {
                bl = ((IStorageEditorInput)iEditorInput).getStorage().isReadOnly();
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
        }
        if (!bl) {
            return iEditorInput.exists();
        }
        return !bl;
    }
}

