/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.HashMap;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class COBOLBreakpointActionPopup
extends TextEditorAction {
    private int fLineNumber = 0;

    public COBOLBreakpointActionPopup(COBOLEditor cOBOLEditor) {
        super(Messages.getResourceBundle(), "AddBreakpoint.", (ITextEditor)cOBOLEditor);
        this.setText(Messages.getString((String)"AddBreakpoint.label"));
    }

    public void run() {
        if (this.getTextEditor() != null) {
            this.createBreakpoint();
        }
    }

    protected IBreakpoint createBreakpoint() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        try {
            ISelection iSelection;
            HashMap hashMap = new HashMap(10);
            ISelectionProvider iSelectionProvider = this.getTextEditor().getSelectionProvider();
            IDocument iDocument = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
            if (iSelectionProvider != null && (iSelection = iSelectionProvider.getSelection()) != null && !iSelection.isEmpty() && iSelection instanceof ITextSelection) {
                n = ((ITextSelection)iSelection).getStartLine();
                try {
                    n2 = iDocument.getLineOffset(n);
                    int n4 = 0;
                    n4 = iDocument.getLineLength(n);
                    n3 = n2 + iDocument.getLineLength(n);
                    if (iDocument.getNumberOfLines() != n && n4 != 1 && n4 != 0) {
                        n3 -= 2;
                    }
                    this.fLineNumber = n + 1;
                }
                catch (BadLocationException badLocationException) {
                    CBDTUiPlugin.logError((Exception)((Object)badLocationException));
                }
            }
            if (!COBOLDebugUtil.lineBreakpointExists((String)((IFile)this.getResource()).getFullPath().toOSString(), (int)this.getLineNumber())) {
                iSelection = COBOLDebugUtil.createLineBreakpoint((IResource)this.getResource(), (String)((IFile)this.getResource()).getFullPath().toOSString(), (int)this.getLineNumber(), (int)n2, (int)n3, (boolean)true, hashMap);
                return iSelection;
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        return null;
    }

    protected int getLineNumber() {
        return this.fLineNumber;
    }

    protected void setLineNumber(int n) {
        this.fLineNumber = n;
    }

    protected int computeLineNumber() {
        ISelection iSelection;
        int n = -1;
        if (this.getTextEditor() == null) {
            return n;
        }
        ISelectionProvider iSelectionProvider = this.getTextEditor().getSelectionProvider();
        if (iSelectionProvider != null && (iSelection = iSelectionProvider.getSelection()) != null && !iSelection.isEmpty() && iSelection instanceof ITextSelection) {
            n = ((ITextSelection)iSelection).getStartLine() + 1;
        }
        return n;
    }

    protected IResource getResource() {
        IEditorInput iEditorInput = this.getTextEditor().getEditorInput();
        Object object = iEditorInput.getAdapter(IResource.class);
        if (object == null) {
            return null;
        }
        return (IResource)object;
    }

    public void update() {
        this.setLineNumber(this.computeLineNumber());
        try {
            IResource iResource = this.getResource();
            if (iResource == null) {
                return;
            }
            if (!COBOLDebugUtil.lineBreakpointExists((String)((IFile)this.getResource()).getFullPath().toOSString(), (int)this.getLineNumber())) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
    }
}

