/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.actions.COBOLGotoErrorAction;
import org.eclipse.cobol.ui.actions.COBOLRenumberAction;
import org.eclipse.cobol.ui.actions.COBOLShiftAction;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EncodingActionGroup;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.eclipse.ui.texteditor.TextEditorAction;

public class COBOLActionContributor
extends BasicTextEditorActionContributor {
    private RetargetTextEditorAction fContentAssistProposal = new RetargetTextEditorAction(Messages.getResourceBundle(), "ContentAssistProposal.");
    private Action fRenumberAction;
    private TextEditorAction fShiftRightAction;
    private TextEditorAction fShiftLeftAction;
    private RetargetTextEditorAction fCutAction;
    private RetargetTextEditorAction fCopyAction;
    private RetargetTextEditorAction fPasteAction;
    private RetargetTextEditorAction fUndoAction;
    private RetargetTextEditorAction fRedoAction;
    private final String CUT_PREFIX = "Cut.";
    private final String COPY_PREFIX = "Copy.";
    private final String PASTE_PREFIX = "Paste.";
    private final String UNDO_PREFIX = "Undo.";
    private final String REDO_PREFIX = "Redo.";
    private COBOLGotoErrorAction fGotoNextErrorAction;
    private COBOLGotoErrorAction fGotoPreviousErrorAction;
    private RetargetTextEditorAction findAction;
    private EncodingActionGroup fEncodingActionGroup;
    private Map fStatusFields;
    private IEditorPart fActiveEditorPart;
    private static final StatusFieldDef[] STATUS_FIELD_DEFS = new StatusFieldDef[]{new StatusFieldDef("TextSelect", null, true, 14)};

    public COBOLActionContributor() {
        this.fContentAssistProposal.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fShiftRightAction = new COBOLShiftAction("ShiftRight.", 8);
        this.fShiftLeftAction = new COBOLShiftAction("ShiftLeft.", 9);
        this.fShiftRightAction.setAccelerator(0);
        this.fShiftLeftAction.setAccelerator(0);
        this.fRenumberAction = new COBOLRenumberAction(Messages.getString((String)"renumberMenuItem"));
        this.fCutAction = new RetargetTextEditorAction(Messages.getResourceBundle(), "Cut.");
        this.fCopyAction = new RetargetTextEditorAction(Messages.getResourceBundle(), "Copy.");
        this.fPasteAction = new RetargetTextEditorAction(Messages.getResourceBundle(), "Paste.");
        this.fUndoAction = new RetargetTextEditorAction(Messages.getResourceBundle(), "Undo.");
        this.fRedoAction = new RetargetTextEditorAction(Messages.getResourceBundle(), "Redo.");
        this.fGotoNextErrorAction = new COBOLGotoErrorAction(true);
        this.fGotoPreviousErrorAction = new COBOLGotoErrorAction(false);
        this.findAction = new RetargetTextEditorAction(Messages.getResourceBundle(), "Find.");
        this.fEncodingActionGroup = new EncodingActionGroup();
        this.fStatusFields = new HashMap(1);
        int n = 0;
        while (n < STATUS_FIELD_DEFS.length) {
            StatusFieldDef statusFieldDef = STATUS_FIELD_DEFS[n];
            this.fStatusFields.put(statusFieldDef, new StatusLineContributionItem(statusFieldDef.category, statusFieldDef.visible, statusFieldDef.widthInChars));
            ++n;
        }
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        try {
            IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
            if (iMenuManager2 != null) {
                iMenuManager2.add((IContributionItem)new Separator());
                iMenuManager2.add((IAction)this.fContentAssistProposal);
                iMenuManager2.add((IAction)this.fRenumberAction);
                iMenuManager2.add((IAction)this.fShiftRightAction);
                iMenuManager2.add((IAction)this.fShiftLeftAction);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        super.contributeToToolBar(iToolBarManager);
        try {
            COBOLPluginImages.setToolImageDescriptors((IAction)this.fGotoNextErrorAction, "next_error_nav");
            COBOLPluginImages.setToolImageDescriptors((IAction)this.fGotoPreviousErrorAction, "prev_error_nav");
            COBOLPluginImages.setToolImageDescriptors((IAction)this.findAction, "search");
            iToolBarManager.add((IAction)this.fGotoNextErrorAction);
            iToolBarManager.add((IAction)this.fGotoPreviousErrorAction);
            iToolBarManager.add((IAction)this.findAction);
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        ITextEditor iTextEditor = null;
        if (iEditorPart instanceof ITextEditor) {
            iTextEditor = (ITextEditor)iEditorPart;
        }
        this.fContentAssistProposal.setAction(this.getAction(iTextEditor, "ContentAssistProposal"));
        this.fShiftRightAction.setEditor(iTextEditor);
        this.fShiftLeftAction.setEditor(iTextEditor);
        if (iEditorPart instanceof COBOLEditor) {
            ((COBOLEditor)iEditorPart).getReferenceFormat();
            ((COBOLRenumberAction)this.fRenumberAction).setEnabled(false);
        }
        this.fCutAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.CUT));
        this.fCopyAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.COPY));
        this.fPasteAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.PASTE));
        this.fUndoAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.UNDO));
        this.fRedoAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.REDO));
        this.fCutAction.setToolTipText(ITextEditorActionConstants.CUT);
        this.fGotoNextErrorAction.setEditor(iTextEditor);
        this.fGotoNextErrorAction.setToolTipText(Messages.getString((String)"Editor.GotoNextProblem"));
        this.fGotoPreviousErrorAction.setEditor(iTextEditor);
        this.fGotoPreviousErrorAction.setToolTipText(Messages.getString((String)"Editor.GotoPreviousProblem"));
        this.findAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.FIND));
        this.fEncodingActionGroup.retarget(iTextEditor);
        this.doSetActiveEditor(iEditorPart);
    }

    private void doSetActiveEditor(IEditorPart iEditorPart) {
        int n;
        ITextEditorExtension iTextEditorExtension;
        if (this.fActiveEditorPart == iEditorPart) {
            return;
        }
        if (this.fActiveEditorPart instanceof ITextEditorExtension) {
            iTextEditorExtension = (ITextEditorExtension)this.fActiveEditorPart;
            n = 0;
            while (n < STATUS_FIELD_DEFS.length) {
                iTextEditorExtension.setStatusField(null, STATUS_FIELD_DEFS[n].category);
                ++n;
            }
        }
        this.fActiveEditorPart = iEditorPart;
        iTextEditorExtension = iEditorPart instanceof ITextEditor ? (ITextEditor)iEditorPart : null;
        n = 0;
        while (n < STATUS_FIELD_DEFS.length) {
            Object object;
            if (this.fActiveEditorPart instanceof ITextEditorExtension) {
                object = (StatusLineContributionItem)this.fStatusFields.get(STATUS_FIELD_DEFS[n]);
                object.setActionHandler(this.getAction((ITextEditor)iTextEditorExtension, STATUS_FIELD_DEFS[n].actionId));
                ITextEditorExtension iTextEditorExtension2 = (ITextEditorExtension)this.fActiveEditorPart;
                iTextEditorExtension2.setStatusField((IStatusField)object, STATUS_FIELD_DEFS[n].category);
            }
            if (this.fActiveEditorPart instanceof COBOLEditor) {
                object = (COBOLEditor)this.fActiveEditorPart;
                ((COBOLEditor)((Object)object)).updateStatusField("InputPosition");
            }
            ++n;
        }
    }

    public void contributeToStatusLine(IStatusLineManager iStatusLineManager) {
        super.contributeToStatusLine(iStatusLineManager);
        int n = 0;
        while (n < STATUS_FIELD_DEFS.length) {
            iStatusLineManager.add((IContributionItem)this.fStatusFields.get(STATUS_FIELD_DEFS[n]));
            ++n;
        }
    }

    public void dispose() {
        if (this.fContentAssistProposal != null) {
            this.fContentAssistProposal = null;
        }
        if (this.fGotoNextErrorAction != null) {
            this.fGotoNextErrorAction.setEditor(null);
            this.fGotoNextErrorAction = null;
        }
        if (this.fGotoPreviousErrorAction != null) {
            this.fGotoPreviousErrorAction.setEditor(null);
            this.fGotoPreviousErrorAction = null;
        }
        if (this.fShiftLeftAction != null) {
            this.fShiftLeftAction.setEditor(null);
            this.fShiftLeftAction = null;
        }
        if (this.fShiftRightAction != null) {
            this.fShiftRightAction.setEditor(null);
            this.fShiftRightAction = null;
        }
        if (this.fRenumberAction != null) {
            ((COBOLRenumberAction)this.fRenumberAction).setEditor(null);
            this.fRenumberAction = null;
        }
        super.dispose();
    }

    public void init(IActionBars iActionBars) {
        super.init(iActionBars);
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
        iMenuManager2.add((IContributionItem)new Separator());
        this.fEncodingActionGroup.fillActionBars(iActionBars);
    }

    private static class StatusFieldDef {
        private String category;
        private String actionId;
        private boolean visible;
        private int widthInChars;

        private StatusFieldDef(String string, String string2, boolean bl, int n) {
            Assert.isNotNull((Object)string);
            this.category = string;
            this.actionId = string2;
            this.visible = bl;
            this.widthInChars = n;
        }
    }
}

